	logical function gaslst()
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gaslst.f,v 2.12 2005/03/02 16:10:47 friedrich Exp friedrich $
c  this function reads a list of peaks and makes a guess for the
c  starting parameters
c  a value of .true. is returned if peaks are in the analyzing
c  region defined, .false. otherwise
c  format of the peak list:
c  any number of header lines up to one line with at least
c  10 @'s
c  optional: followed by one empty line, one more text line
c  and again one empty line
c  and:  each new  entry must start a new line)
c  each line may contain
c
c        peak_position
c  or:   peak_position and peak_width
c  or:   peak_position position_error and peak_width
c  or:   peak_position position_error peak_area area_error and peak_width
c
c  and optional: 
c  fitregions (and a degree of the background polynomial in this region)
c     these lines must start with the symbol r  and the following 
c     peak_positions must fit into the fit region
c
c  if there is doubt about the format look at a GASPAN output file
c
c  if the error of a peak_position is 0 or negativ: these peak position
c      will allways be fixed
c
c  if the error of a peak_area is 0 or negaiv: these peak position
c      will allways be fixed
c  if the value of a width is negativ and the option
c     set width -list
c    has been set, the width is taken from the absolut value and
c    is kept fixed in the fitting procedure
c
c  VAX version: 13.10.86 
c  first version: 
c
c---------------------------------------------------------------------------
	implicit none
	character*(*) FLSTLOV
	parameter (FLSTLOV = '('' *** list overflow at channel''f10.1
	1''  input stopped'')')
	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspea.icl'
	include 'gasspe.icl'
	include 'gastxt.icl'

	character lowercase
	integer addcomma, istext, ltext, gasspc
	real*8 poly
	integer firstpeak, i, iostatus, j, linepoi, lowerlimit, lowerregion,
	1 mintmp, maxtmp, ncback, npeak, region, upperlimit, upperregion, uppersave
	real*8 sumampl, errampl, sumback, errback, sumpeak, tmpvar(5)

c
	if(lpa) then
	  write(3,'(//1x,60a//)')('@',j=1,60)
	  write(3,'(10x,a,5x,''file: '',a)') version,files(:ltext(files))
	  write(3,'(50x,''ENTRY ''i3)') nroute
	  call fdate (texta)
          write(3,'(10x,''created at '',a)') texta(:ltext(texta))
	  write(3,'(//1x,60a)')('@',j=1,60)
	  write(3,'(/'' option set:''/)')
	  call gasopt(' ',3)
	end if
	maxlin=0
        minsp = minch
        maxsp = min(maxch, lastch)
        mintmp = minsp
        maxtmp = maxsp
c  open list file and read it
	if(lpa) write(3,'(''GASLST: list of peaks from file: ''a)') filepeak
	1  (1:max(1, ltext(filepeak)))
	open (unit=1, file=filepeak, status='old')
	texta=' '
	iostatus = 1
c  skip over header: first nospace character should not be a +, -
c  or digit
c  but be aware of region lines!
        region = 0
        firstpeak = -1
	do while (iostatus.gt.0)
	  read(1,'(a)', IOSTAT=iostatus) texta
	  if(iostatus.eq.0) then
	    j = 1
	    if(texta(1:1).eq.' ') j = 2
	    if(lowercase(texta(j:j)).eq.'r') j = j + 1
	    iostatus = istext(texta(j:))
	    if(iostatus.gt.0 .and. lpa) write (3,'(3x'': ''a)') texta(1:max(1, ltext(texta)))
	  end if
	end do
	do while (iostatus.eq.0 .and. maxlin.lt.TOTALPEAKS)
	  j = -1
	  if (texta.ne.' ')  j = addcomma(texta)
	  if(j.eq.(-1)) then
	    iostatus = 1
c  case:  only peak positions
	  else if (j.eq.0) then
	    read (texta, *, IOSTAT=iostatus) tmpvar(1)
	    tmpvar(2)=1.
	    tmpvar(3)=0.
	    tmpvar(4)=1.
	    tmpvar(5)=0.
	    if (widthlist) widthlist=.false.
c  case: peak position + width (in channels)
	  else if (j.eq.1) then
	    read (texta, *, IOSTAT=iostatus) tmpvar(1), tmpvar(5)
	    tmpvar(2)=1.
	    tmpvar(3)=0.
	    tmpvar(4)=1.
c  case: peak position, position error, width
c    or  region: minimum channel, maximum channel
	  else if (j.eq.2) then
	    if (lowercase(texta(1:1)).eq.'r') then
	      read (texta(3:), *, IOSTAT=iostatus) tmpvar(1), tmpvar(2)
	      tmpvar(1)=-tmpvar(1)
	      tmpvar(5)=0.
	      tmpvar(4)=0.
	      tmpvar(3)=tmpvar(2)
	    else
	      read (texta, *, IOSTAT=iostatus) tmpvar(1), tmpvar(2), tmpvar(5)
	      tmpvar(3)=0.
	      tmpvar(4)=1.
	    endif
c  case region: minimum, maximum channel, degree of background polynomial
	  else if (j.eq.3) then
	    if (lowercase(texta(1:1)).eq.'r') then
	      read (texta(3:), *, IOSTAT=iostatus) (tmpvar(i), i=1,3)
	      tmpvar(1)=-tmpvar(1)
	      tmpvar(5)=tmpvar(3)
	      tmpvar(4)=0.
	      tmpvar(3)=tmpvar(2)
	    else
	      iostatus=1
	    end if
c  case: standard gaspan output
	  else if (j.ge.4) then
	    if (lowercase(texta(1:1)).eq.'r') then
	      read (texta(3:), *, IOSTAT=iostatus) (tmpvar(i), i=1,5)
	      tmpvar(1)=-tmpvar(1)
	      tmpvar(5)=tmpvar(3)
	      tmpvar(3)=tmpvar(2)
c ignore lines beginning with T or t (tailparameters)
	    else if(lowercase(texta(1:1)).ne.'t') then
	      read (texta, *, IOSTAT=iostatus) (tmpvar(i), i=1,5)
            else
              tmpvar(1) = 0.
	    end if
	  end if
	  i=int(abs(tmpvar(1)))
          j = i
          if(tmpvar(1).lt.0.) then
            mintmp = minch
            maxtmp = maxsp
            j = int(tmpvar(2))
            region = j - i + 1 - FITREG
            firstpeak = -1
          endif
	  if(iostatus.eq.0) then
	    if(i.ge.mintmp .and. i.le.maxtmp .and. i.gt.firstpeak .and. j.le.maxtmp .and. region.le.0) then
	      maxlin=maxlin+1
	      peak(maxlin)=tmpvar(1)
	      dpeak(maxlin)=tmpvar(2)
	      area(maxlin)=tmpvar(3)
	      darea(maxlin)=tmpvar(4)
	      width(maxlin)=tmpvar(5)
              if(tmpvar(1).gt.0) firstpeak = tmpvar(1)
	    else
              if(lpa) then
                if(region.gt.0) then
                  if(tmpvar(1).lt.0.) then
                    write(3,'(''   -->  region larger than '',i6'' :   ''$)') FITREG
                  else if(j.ge.mintmp .and. j.le.maxtmp) then
                    write(3,'(''   -->  inside invalid region     :     ''$)')
                  else
                    write(3,'(''   -->  outside invalid region    :     ''$)')
                  endif
                else  if(i.gt.firstpeak) then
                  write(3,'(''   -->  outside of analysing region (''i6''-''i6'') :   ''$)') mintmp, maxtmp
                else
                  write(3,'(''   -->  peaks must be in ascending order, dropping: ''$)')
                endif 
                write(3,'(a)') texta(:ltext(texta))
              endif
	    end if
            if(tmpvar(1).lt.0.) then
              mintmp = max(i, minch)
              maxtmp = min(j, maxch)
c            else
c              firstpeak = tmpvar(1)
            endif
	  end if
	  if(iostatus.ne.(-1)) read(1,'(a)', IOSTAT=iostatus) texta
	end do
	if (maxlin.eq.TOTALPEAKS .and. iostatus.ge.0) then
          if (lpa) write (3,FLSTLOV) abs(peak(maxlin))
	  if (peak(maxlin).le.0.) maxlin = maxlin-1
	end if
	close (unit=1)
	if (maxlin.eq.0) then
	  gaslst=.false.
	else
	  gaslst=.true.
c  run through the spectrum and get an estimate for the peak area
c  by estimating a background, subtracting it from the peak area
c  and splitting the peak area to the peaks according to the
c  channel contents at the peak position
c
c  because the spectrum can only be searched in units of SPELEN
c  channels, this is done in a loop
	  mintmp = minch
	  minsp = 0
	  maxsp = 0
	  linepoi = 0
	  lowerregion = minsp
	  uppersave = 0
	  do while(mintmp.lt.maxch .and. linepoi.le.maxlin)
	    if(minsp.ne.mintmp) then
c  read spectrum into spek
	      minsp = mintmp
	      maxsp = min(maxch, minsp+SPELEN-1, lastch)
	      i = gasspc(minsp, maxsp, files, spek)
	      if(i.gt.0) then 
	        maxsp=i
	      else
	        gaslst=.false.
	        return
	      end if
	    end if
	    firstpeak=0
	    upperregion=0
	    do while (upperregion.eq.0)
	      linepoi=linepoi+1
	      if(linepoi.le.maxlin) then
	        j = nint(peak(linepoi))
	        if(j.lt.0) then
	          if (firstpeak.eq.0) then
	            lowerregion = -peak(linepoi)
	            uppersave = area(linepoi)
	          else
	              upperregion=uppersave
	              if (upperregion.eq.0) upperregion = upperlimit + region
	              linepoi=linepoi-1
	          end if
	        else ! if(j.gt.minsp .and. j.lt.maxsp) then
c  define a peak region
	          if (widthlist) then
	            region=nint(1.3*abs(width(linepoi)))
	          else
                    sumampl = poly(peak(linepoi),ndw,aws)
                    if(sumampl.lt.0.5) then
                      write(*,'('' GASLST: line width too small (''f10.2,'')') sumampl
                      return
                    endif
	            region = nint(1.3*sumampl)
	          end if
	          if (firstpeak.eq.0) then
                    i = min(region, (j - minch)/2)
	            lowerlimit = j - i
                    lowerregion = lowerlimit - i
                    if(lowerlimit.gt.maxch .and. lowerregion.lt.maxch) lowerregion = maxch
c	            lowerregion = max(lowerregion, i)
c	            lowerregion = max(lowerregion, lowerlimit-region)
	            firstpeak = linepoi
	            region = min(region, (maxch - j)/2)
                    upperlimit = j+region
	          else
	            region = min(region, (maxch - j)/2)
	            if (upperlimit.gt.j-region) then
	              upperlimit=j+region
	            else
	              upperregion=min(j-region, upperlimit+region)
	              linepoi=linepoi-1
	            end if
	          end if
	        end if  ! j.lt.0
	      else
                lowerregion = maxch + 1
                upperregion = maxch
c	        upperregion = upperlimit + region
c	        if (uppersave.gt.0) upperregion = min(uppersave, upperregion)
	        linepoi=linepoi-1
	      end if   ! if(linepoi.le.maxlin)
	    enddo   ! while(upperregion.eq.0)
c  a region has been found
c	    upperregion= min(upperregion, maxsp)
	    upperlimit=min(upperlimit, upperregion)
	    if (upperregion.le.maxsp) then
c  calculate peak area
	      ncback=0
	      npeak=0
	      sumampl = 0.
              errampl = 0.
	      sumback = 0.
              errback = 0.
	      do i=lowerregion, upperregion
	        j=i-minsp+1
	        if (j.ge.1) then
	          if (i.gt.lowerlimit .and. i.lt.upperlimit) then
	            npeak=npeak+1
	            sumampl=sumampl+spek(j)
                    errampl=errampl+spekerr(j)*spekerr(j)
	          else
	            ncback=ncback+1
	            sumback=sumback+spek(j)
                    errback=errback+spekerr(j)*spekerr(j)
	          end if
	        end if
	      end do
	      if (ncback.gt.1) then
                sumback=sumback/ncback
                errback=errback/(ncback*ncback)
              endif
	      sumpeak = max (sumampl-npeak*sumback, 3.*sqrt(abs(errampl+npeak*npeak*errback)+10.))
	      sumampl=0.
	      i=firstpeak
	      do while (i.le.linepoi)
	        j=nint(peak(i))
	        if (j.gt.0) then
	          if (j.le.upperlimit) then
	            if(darea(i).gt.0.) area(i) = max (spek(j-minsp+1)-sumback,
	1             3.*sqrt (spekerr(j-minsp+1)*spekerr(j-minsp+1) + errback + 10.))
	            sumampl=sumampl+area(i)
	          else
	            linepoi=i
	          end if
	        end if
	        i=i+1
	      end do
	      if (sumampl.gt.0.) sumpeak=sumpeak/sumampl
	      do i=firstpeak, linepoi
	        j=nint(peak(i))
	        if (j.gt.0) then
	          if (sumpeak.gt.0. .and. darea(i).gt.0.) area(i)=area(i)*sumpeak
	        end if
	      end do
	      lowerregion=upperlimit
	      if (linepoi.eq.maxlin) linepoi=linepoi+1
	    else
	      mintmp = lowerregion
c              linepoi = linepoi - 1
	    end if
	  end do
	end if
	maxlin=min(maxlin, linepoi)
	if (maxlin.eq.0) write(*,'('' --> peak list empty in the region defined'')')
 	if(lpa) then
	  write(3,'(/''  result of the peak list in the region'',i6'' -''i6/)') minch, maxsp
	  call gasslp
	end if
	return
	end

