	real*8 function gasstp(nfree, count, silent, dchimin)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasstp.f,v 5.25 2005/03/11 06:12:19 friedrich Exp friedrich $
c  this routine makes the fitting process by 
c  slowly adding parameters to the fitting procedure
c  it is seperated from the older version of gasfit.f
c  nfree: number of degree of freedom, return value
c  count: number of loops, return value
c  silent: no output if .true., input
c  dchimin: lower limit for change in chisquare, input value
c          the function returns the unnormalized chisquare
c  f. Riess
c------------------------------------------------------------------
	implicit none
c if true: will write parameter of intermediate fits into
c parameter fil. Obsolete because displays can be saved directly
        integer KANAL
        parameter (KANAL = 3)
        logical AFTERSTEP
        parameter (AFTERSTEP = .TRUE.)
        logical OUTPAR
        parameter (OUTPAR = .false.)
	integer STEPCOUNT, MAXSTEP
	parameter (STEPCOUNT = 1000)
        parameter (MAXSTEP = 10)
	real*8 DCHISTEP
	parameter (DCHISTEP = 10.d+00)
        real*8 LIMIT
	parameter (LIMIT = 1.d+00)

	character*(*) FSTPCHF, FSTPCHS, FSTPCHG
	parameter (FSTPCHF='(t9,i6'' chisq '',g15.8,'' dchirel'',
	1g9.2,'' step'',i2,'' nfree '',i4,'' flambda'',e8.1)')
	parameter (FSTPCHS='(''step'',i3,'' count ='',i6,'' chi '',g15.8,'' dchi'',
	1g9.2,'' chi/f'',g15.6,'' lambda'',e8.1)')
	parameter (FSTPCHG='(9x,''step'',i3,'' count ='',i6,'' chi '',g15.8,'' dchi'',
	1g9.2,'' chi/f'',g15.6,'' lambda'',e8.1)')
	character*(*) FSTPNOPA
	parameter (FSTPNOPA='('' GASSTP: --> no parameters to be varied'')')

	include 'gasctr.icl'
	include 'gasdis.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
	include 'gaseic.icl'

        integer nfree, count
        logical silent
        real*8 dchimin, poly
	logical isensw, cancelfit
	integer ltext
	real*8 gaschi, psin, gasfun, fchisqr
	logical rep, disstep, lpbenpar, lpchiseq, lpparseq, lponce, lpout
        logical posc, areac, widthc, backv
	character textsave*128
	integer i, j, jw, step, changestep
	real*8 chiold, chistep, chisqr, chisqrf, dchi, dchi0, dchisqr, flambda, x
        data lponce /.true./

        lpout = lpa .and. .not.silent
        lpchiseq = isensw(1) .and. lpout
        lpbenpar = isensw(2) .and. lpout
        lpparseq = isensw(3) .and. lpout
        disstep = isensw(9) .and. display .and. .not.silent
        if(KANAL.eq.6) then
          lpchiseq = .not.silent
          lpbenpar = .not.silent
          lpparseq = .not.silent
        endif
        lponce = lponce .and. lpchiseq
        textsave = distext
        if(lpout) write(KANAL, '('' GASSTP: ''$)')
	if(lpbenpar)then
          write(KANAL,'(''starting parameters'')')
          if(poscon) write(KANAL, '(11x,''common peak-range: '',1f9.2)') cenrange
	  write(KANAL, '(11x,''fwhm-range:        '',1f9.2)') fwhmrange
	  if(tail) write(KANAL, '(11x,''tau L,B,R range:   '',10f9.2)') parc(postlw)
     $               , parc(postbw), parc(postrw)
	  call gasfou(par, fixvorgabe, 0)
	endif
c  fix everything and calculate starting chisqr
	do i=1,PARTOT
	  fixed(i)=.true.
	enddo
	chisqr = fchisqr(1, irange)
c  fit loop starts here,
	step = 0
	count = 0
	do while(step.le.MAXSTEP .and. .not.cancelfit(1))
c short cut on silent fitting (used by gaspck, the parameter checking routine)
          if(step.eq.3 .and. silent) step = MAXSTEP
c vary all peak amplitudes
          if(step.eq.0 .or. step.eq.3 .or. step.eq.6 .or. step.eq.7 .or. step.eq.MAXSTEP) then
            areac = .false.
            j = posarea
	    do i = 1, kpeaks
	      fixed(j) = fixvorgabe(j)
              areac = areac .or. .not.fixed(j)
              j = j + 1
	    enddo
          endif
c fix all peak amplitudes
          if(step.eq.2 .or. step.eq.5) then
            areac = .false.
            j = posarea
	    do i = 1, kpeaks
	      fixed(j) = .true.
              j = j + 1
	    enddo
          endif
c vary background polynomial
          if(step.eq.0 .or. step.eq.3 .or. step.eq.6 .or. step.eq.7 .or. step.eq.MAXSTEP) then
            backv = .FALSE.
            j = pospol
	    do i = 0, backdeg
	      fixed(j) = fixvorgabe(j)
              backv = backv .or. .not.fixed(j)
              j = j + 1
	    enddo
          endif
c fix background polynomial
          if(step.eq.2 .or. step.eq.5) then
            backv = .FALSE.
            j = pospol
	    do i = 0, backdeg
	      fixed(j) = .TRUE.
              j = j + 1
	    enddo
          endif
c vary centroids
	  if(step.eq.1 .or. step.eq.3 .or. step.eq.6 .or. step.eq.MAXSTEP) then
            posc = .FALSE.
            j = poscen
	    do i = 1,kpeaks
	      fixed(j) = fixvorgabe(j)
              posc = posc .or. .not.fixed(j)
              j = j + 1
	    enddo
          endif
c fix centroids
	  if(step.eq.0 .or. step.eq.2 .or. step.eq.4) then
            posc = .FALSE.
            j = poscen
	    do i = 1,kpeaks
	      fixed(j) = .TRUE.
              j = j + 1
	    enddo
          endif
c  vary width
          if(step.eq.1 .or. step.eq.3 .or. step.eq.6 .or. step.eq.MAXSTEP) then
            widthc = .FALSE.
            j = poswidth
	    do i = 1,kpeaks
	      fixed(j) = fixvorgabe(j)
              widthc = widthc .or. .not.fixed(j)
              if(ELEMENTS.gt.2) j = j + 1
	    enddo
          endif
c  fix width
          if(step.eq.0 .or. step.eq.2 .or. step.eq.4) then
            widthc = .FALSE.
            j = poswidth
	    do i = 1,kpeaks
	      fixed(j) = .TRUE.
              if(ELEMENTS.gt.2) j = j + 1
	    enddo
          endif
c vary background tail amp
	  if((step.eq.2 .or. step.eq.4 .or. step.eq.MAXSTEP) .and. tail .and. tailb) then
            fixed(postba) = fixvorgabe(postba)
          endif
c fix background tail amp
	  if(step.eq.0 .or. step.eq.3) then
            fixed(postba) = .TRUE.
          endif
c vary background tail decay
	  if((step.eq.2 .or. step.eq.5 .or. step.eq.MAXSTEP) .and. tail .and. tailb) then
            fixed(postbw) = fixvorgabe(postbw)
          endif
c fix background tail decay
	  if(step.eq.0 .or. step.eq.3) then
            fixed(postbw) = .TRUE.
          endif
c vary left peak  tail amp
	  if((step.eq.2 .or. step.eq.4 .or. step.eq.MAXSTEP) .and. tail .and. taill) then
            fixed(postla) = fixvorgabe(postla)
          endif
c fix left peak tail amplitude
	  if(step.eq.0 .or. step.eq.3) then
            fixed(postla) = .TRUE.
          endif
c vary left peak  tail decay
	  if((step.eq.2 .or. step.eq.5 .or. step.eq.MAXSTEP) .and. tail .and. taill) then
            fixed(postlw) = fixvorgabe(postlw)
          endif
c fix left peak tail decay 
	  if(step.eq.0 .or. step.eq.3) then
            fixed(postlw) = .TRUE.
          endif
c vary  right peak  tails amplitude
	  if((step.eq.2 .or. step.eq.4 .or. step.eq.MAXSTEP) .and. tail .and. tailr) then
            fixed(postra) = fixvorgabe(postra)
          endif
c fix right peak tail amplitude
	  if(step.eq.0 .or. step.eq.3) then
            fixed(postra) = .TRUE.
          endif
c vary  right peak  tails decay
	  if((step.eq.2 .or. step.eq.5 .or. step.eq.MAXSTEP) .and. tail .and. tailr) then
            fixed(postrw) = fixvorgabe(postrw)
          endif
c fix right peak tail decay
	  if(step.eq.0 .or. step.eq.3) then
            fixed(postrw) = .TRUE.
          endif
c vary step function
	  if((step.eq.0 .or. step.eq.3 .or. step.eq.8 .or. step.eq.MAXSTEP) .and. tail) then
            fixed(possta) = fixvorgabe(possta)
          endif
c fix step function
	  if(step.eq.1) then
            fixed(possta) = .TRUE.
          endif

c fix tail parameters if decay constant is too small
          if(tail .and. taill) then
            if(poly(parc(1), max(1,ntauleft),tauleft)*(1.d+00 + parc(postlw)*psin(par(postlw)))
              1 .lt.0.5) then
              fixed(postla) = .TRUE.
              fixed(postlw) = .TRUE.
            endif
          endif
          if(tail .and. tailr) then
            if(poly(parc(1), max(1, ntauright), tauright)*(1.d+00 + parc(postrw)*psin(par(postrw)))
              1 .lt.0.5) then
              fixed(postra) = .TRUE.
              fixed(postrw) = .TRUE.
            endif
          endif
          if(tail .and. tailb) then
            if(poly(parc(1), max(1, ntauback), tauback)*(1.d+00 + parc(postbw)*psin(par(postbw)))
              1 .lt.0.5) then
              fixed(postba) = .TRUE.
              fixed(postbw) = .TRUE.
            endif
	  endif

c only once output to learn about the fit sequence
          if(lponce) then
            if(step.eq.0) write(KANAL, '(9x,''sequence of variation of the parameters'')')
            write(KANAL, '(9x''step''i3,'' ''$)') step
            if(areac) write(KANAL, '(''- peak amp. ''$)')
            if(backv) write(KANAL, '(''- back. pol. ''$)')
            if(posc) write(KANAL, '(''- peak pos. ''$)')
            if(widthc) write(KANAL, '(''- peak widths ''$)')
            if(.not.fixed(possta)) write(KANAL, '(''- Step ''$)')
            if(.not.(fixed(postba).and.fixed(postla).and.fixed(postra))) write(KANAL,
     $                                                   '(''- tail amp.: ''$)')
            if(.not.fixed(postba)) write(KANAL, '(''back. ''$)')
            if(.not.fixed(postla)) write(KANAL, '(''left ''$)')
            if(.not.fixed(postra)) write(KANAL, '(''right ''$)')
            if(.not.(fixed(postbw).and.fixed(postlw).and.fixed(postrw))) write(KANAL,
     $                                                   '(''- tail decays: ''$)')
            if(.not.fixed(postbw)) write(KANAL, '(''back. ''$)')
            if(.not.fixed(postlw)) write(KANAL, '(''left ''$)')
            if(.not.fixed(postrw)) write(KANAL, '(''right ''$)')
            write(KANAL, '(x)')
          endif

          if(disstep) then
            write(distext, '(''step''i3$)') step
            if(areac) distext = distext(:ltext(distext))//' amp.'
            if(backv) distext = distext(:ltext(distext))//' bgr'
            if(posc) distext = distext(:ltext(distext))//' pos'
            if(widthc) distext = distext(:ltext(distext))//' width'
            if(.not.fixed(postba)) distext = distext(:ltext(distext))//' TBa'
            if(.not.fixed(postbw)) distext = distext(:ltext(distext))//' TBw'
            if(.not.fixed(postla)) distext = distext(:ltext(distext))//' TLa'
            if(.not.fixed(postlw)) distext = distext(:ltext(distext))//' TLw'
            if(.not.fixed(postra)) distext = distext(:ltext(distext))//' TRa'
            if(.not.fixed(postrw)) distext = distext(:ltext(distext))//' TRw'
            if(.not.fixed(possta)) distext = distext(:ltext(distext))//' Step'
          endif

          chistep = chisqr
          changestep = STEPCOUNT*(step+1)
	  dchi0 = 2.d+00
          if(dchimin.eq.0.) then
            x = 1.d-04
          else
            x = dchimin
          endif
c	  dchi = max(x/((step + 1)*DCHISTEP), 1.d-11)
	  dchi = x/((step + 1)*DCHISTEP)
	  flambda = 1.d-3 
c  determine degree of freedom
	  nfree = irange
	  do i = 1,npar
	    if(.not.fixed(i)) nfree = nfree-1
	  enddo
          if(nfree.gt.0) then
            if(disstep .and. step.eq.0) then
c show display with starting parameters
              x = minreg
              do i = 1, irange
                yfa(i) = gasfun(x, npar)
	        resi(i)=(ya(i)-yfa(i))*sqrt(weight(i))
                x = x + 1.d+00
	      enddo
	      call gasdis(chisqr, -3)
  	    endif
	    rep = .true.
	    do while(rep .and. .not.cancelfit(1))
	      chiold = chisqr
	      chisqr = gaschi(flambda, silent)
              chisqrf = chisqr/nfree
	      count = count + 1
              if(interactiv .AND. count.eq.MAXSTEP*STEPCOUNT/2) write(*,
	1                    '('' poor convergence, please be patient'')')
              if(count.gt.changestep) then
                if(lpout .and. step.eq.MAXSTEP-1) write(KANAL, '('' GASSTP --> fit stopped because of poor convergence'')')
                if(chisqr.ge.0.d+00) chisqr = chiold
              endif
              if(chisqr.ge.0.d+00) then
  	        dchisqr = dchi0+abs((chisqr-chiold)/max(chisqr,1.d-6))/dchi
	        dchi0 = 0.d+00
                if(OUTPAR) call binparout(20, chisqrf)
	        if(lpparseq) then
                  write(KANAL,'(11x,''intermediate parameters (step = '',i3'')'')') step
                  call gasfou(par, fixed, -2)
                endif
	        if(chisqr.eq.0.d+00) then
	          step = MAXSTEP + 1
	          if(lpout) write(KANAL,FSTPNOPA)
	          rep = .false.
	        else
		  rep = dchisqr.gt.1.d+00
	        end if
              endif   ! chisqr ge. 0.  
	    enddo     !  while(rep .and. .not.cancelfit(1))
	  else  !  nfree.gt.0
	    if(lpout) write(KANAL, '(9x''--> no degrees of freedom at step'',i3,
     $        '' fit stopped <--)') step
	    step = MAXSTEP + 1
	  endif	! nfree.eq.0
          if(lpchiseq) then
            if(step.eq.0 .and. .not.lponce) then
              write(KANAL,FSTPCHS) step, count, chisqr, chistep - chisqr, chisqrf, flambda
            else
              write(KANAL,FSTPCHG) step, count, chisqr, chistep - chisqr, chisqrf, flambda
            endif
          endif
c  control display
	  if(disstep) then
            do i = 1, irange
	      resi(i) = (ya(i) - yfa(i))*sqrt(weight(i))
	    enddo
	    call gasdis(chisqr, -3)
	  endif
	  step = step + 1
	enddo     ! while step.le.MAXSTEP
        lponce = .false.
c  redefine centroids 
	if(.not.poscon) then
          j = poscen
          jw = poscwidth
	  do i = 1, kpeaks
            if(posall) then
              x = cenrange
            else
              x = parc(jw)
            endif
	    parc(j) = parc(j) + x*psin(par(j))
	    par(j) = 0.
            j = j + 1
            jw = jw + 1
	  enddo
	endif
c  get correct errors
        flambda = 0.
	chisqr = gaschi(flambda, silent)
	if(lpbenpar)then
          write(KANAL,'(9x,''final parameters'')')
	  call gasfou(par, fixvorgabe,  0)
          write(KANAL,'(9x,''error of parameters'')')
	  call gasfou(dpar, fixvorgabe,  -2)
	endif
        distext = textsave
        gasstp = chisqr
        return
        end
