	logical function gassea()
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gassea.f,v 2.21 2003/06/22 07:29:03 riess Exp $
c  this function searches for lines in the spectrum
c  it returnes the value .true. if lines are found, false
c  otherwise
c  method: fold the spectrum with a gaussian sitting on a negative
c          counting rate. The area of the gaussian is
c          normalized to 1, the area of gaussian + background to zero.
c  the result is stored in the arrays of the common block /pea/
c  this routine has been adapted from a routine from chalk river
c  24.02.00: extern errors (daterr-Format)
c  12.10.92: More sensitivity with low statistics in correlation
c  last change: 10.30, 16.03.88
c  08.10.86  vax version
c  13.12.78  F. Riess
c------------------------------------------------------------------------------
	implicit none

	character *(*) FSEARFL
	parameter (FSEARFL = '('' GASSEA: region from list ''3i7)')
	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspea.icl'
	include 'gasspe.icl'
	include 'gastxt.icl'

	logical isensw
	character lowercase
        character outform*100
	integer addcomma, ltext, gasspc
	real*8 getstk, poly
	logical peakfound, nopeaks, istext
	integer foldzero, i, ij, iostatus, j, mintmp, n,
	1 peakbegin, peakend, peakregion, region, regpoi, regnum
	2, minregion, maxregion, stellen
	real*8 centroid, con2, cormax, newwidth, oldwidth, parea,
	1 err, peakerr, sumback, sumcor, x, variance
	integer lowreg(MAXREGIONS), highreg(MAXREGIONS), degreg(MAXREGIONS)
	real*8 foldfun(FITREG), foldvar(FITREG)
c
	if(lpa) then
	  write(3,'(//1x,60a//)')('@',j=1,60)
	  write(3,'(10x,a,5x,''file: '',a)') version,files(:ltext(files))
	  write(3,'(50x,''ENTRY ''i3)') nroute
	  call fdate (texta)
          write(3,'(10x,''created at '',a)') texta(:ltext(texta))
	  write(3,'(//1x,60a)')('@',j=1,60)
	  write(3,'(/'' option set:''/)')
	  call gasopt(' ',3)
	end if
	gassea=.false.
	maxlin=0
c  if there is a list of regions, get it
	if(reglist) then
          minregion=maxch
          maxregion=minch
	  if (lpa) write(3,'('' list of regions from file: ''a)') fileregion
	  open (unit=1, file=fileregion, status='old')
c	  open (unit=1, file=fileregion, status='old', READONLY)
	  read(1,'(a)', IOSTAT=iostatus) texta
	  regnum=0
	  do while (iostatus.eq.0 .and. regnum.lt.MAXREGIONS)
	    do n = 1, 3
	      foldfun(n) = 0.
	    enddo
	    n = 1
	    if(texta(1:1).eq.' ') n = 2
	    if(.not. (lowercase(texta(n:n)).eq.'r' .and. texta(n+1:n+1).eq.' ')) then
	      if(lpa) write (3,'(3x'': ''a)') texta(1:max(1, ltext(texta)))
	    else
              n=addcomma(texta)
	      if (.not. istext(texta(3:))) then
	        read (texta(3:), *, IOSTAT=ij) (foldfun(j),j=1,n)
	      else
	        ij=1
	      end if
	      if (ij.le.0) then
	        i=foldfun(1)+0.5
	        j=foldfun(2)+0.5
	        if (j.gt.0 .and. j.lt.i) then
	          j=i
	          i=foldfun(2)+0.5
	        end if
	        if (ij.eq.0 .and. i.ge.minch .and. j.le.min(maxch, lastch)) then
	          regnum=regnum+1
	          lowreg(regnum)=i
	          highreg(regnum)=j
                  degreg(regnum) = backpol
	          if(n.ge.3) degreg(regnum)=foldfun(3)+0.5
		  minregion=min(minregion, i)
		  maxregion=max(maxregion, j)
	          i=regnum-1
	          if (i.ge.1) then
	            if (highreg(i).eq.0) then
	              highreg(i)=lowreg(regnum)
	              degreg(i)=degreg(regnum)
	            end if
	          end if
	          if (isensw(8)) write (3,FSEARFL) lowreg(regnum), highreg(regnum), degreg(regnum)
	        end if
	      end if
	    end if
	    read(1,'(a)', IOSTAT=iostatus) texta
	  end do
	  close(unit=1)
	  if (regnum.ge.1) then
	    if (highreg(regnum).eq.0) regnum=regnum-1
	    if (regnum.ge.1) then
	      maxlin=1
	      peak(maxlin)=-lowreg(1)
	      area(maxlin)=highreg(1)
	      width(maxlin)=degreg(1)
	      regpoi=1
	      nopeaks=.true.
	    end if
	  end if
	  if (regnum.le.0) then
	    if(lpa) write(3,'('' *** no region from the list in the
	1 analyzing region'')')
	    write(*,'('' *** no region from the list in the
	1 analyzing region'')')
	    gassea=.false.
	    return
	  end if
        else
          minregion=minch
	  maxregion=maxch
	end if

c  because the spectrum can only be searched in units of SPELEN
c  channels, the search is done in a loop
	mintmp=max(minch, minregion)
	maxsp=0
	do while(mintmp.lt.min(maxch, lastch, maxregion) .and. maxlin.lt.TOTALPEAKS)
	  minsp=mintmp
	  maxsp=min(maxch, minsp+SPELEN-1, lastch, maxregion)
	  i=gasspc(minsp, maxsp, files, spek)
	  if(i.gt.0) then 
	    maxsp=i
	  else
	    gassea=.false.
	    return
	  end if
	  mintmp=maxsp+1
	  irange=maxsp-minsp+1
	  if(.not.reglist .and. interactiv)
	1    write(*, '('' Searching for peaks in region ''2i7)') minsp, maxsp
c  get statistical significance of spectrum
	  if(nonestat) then
	    tinp= getstk(1, irange, spek, spekerr)
	    if(lpa) write (3,'(4x''statistical factor for region ''i6'' -''i6'' =''f8.3)') minsp, maxsp, tinp
	  else
	    tinp=1.
	    if(highsens) tinp=0.5
	  end if
c  start folding,
	  do i=1, irange
	    cor(i)=0.
	  end do
	  oldwidth=0.
	  do i=1, irange
	    x=minsp+i-1
	    newwidth=poly(x,ndw,aws)
            if(newwidth.lt.0.5) then
              write(*,'('' GASSEA: line width too small ('',f10.2,'') no fit possible'')') newwidth
              return
            end if
c  .. recalculate folding function if width changes by more than 10%
	    if(abs(1.-oldwidth/newwidth).gt.0.1) then
	      oldwidth=newwidth/2.35482
	      con2=0.5/(oldwidth*oldwidth)
	      foldzero=4.*oldwidth+0.5
	      region=2*foldzero+1
	      oldwidth=newwidth
c  this statement restricts the width to 60 channels, which is much more
c  then the restriction given by the input
	      if(region.le.FITREG) then
	        parea=0.
	        do j=1, region
	          foldfun(j)=exp(-(con2*(j-foldzero-1)**2))
	          parea=parea+foldfun(j)
	        end do
	        variance=1./dble(region)
	        do j=1, region
	          foldfun(j)=foldfun(j)/parea-variance
	          foldvar(j)=foldfun(j)**2
	        end do
	      end if
	    end if
c  .. perform folding
	    if(region.le.FITREG) then
              sumback = 0.
	      sumcor=0.
	      variance=0.
	      do j=1, region
	        ij=i-foldzero+j-1
	        ij=max(ij, 1)
	        ij=min(ij, irange)
                sumback=sumback+spek(ij)
	        sumcor=sumcor+foldfun(j)*spek(ij)
                variance=variance+foldvar(j)*spekerr(ij)*spekerr(ij)
	      end do
c  the following statement is to overcome deficiencies with low statistics
c  the idea is based on tests with random generated spectra
              if(.not.smootherror) then
                sumback = 1
              else
                sumback=max(1.,1.5*log(oldwidth+4.)-log(max(1.,sumback/region)))
              endif
              if(variance.le.0.) variance = 1.
	      cor(i)=sumcor/sqrt(variance/sumback)
	    else
	      if(lpa)write(3,'(/'' GASSEA: line width too large, search
	1 stopped at channel '',f8.0/)') x
c	      lastch=maxsp
	    end if
	  end do
c  correlation spectrum output for test purposes
	  if(isensw(10))then
c            i = filesformat
c            filesformat = 2
c            write(*, '(a)') ' gassea: creating file correlation.dat'
c	    call gaswrtf ('correlation.dat', cor, minsp, maxsp, 'correlation function')
c            filesformat = i
            iostatus = 0
            call initfitout(iostatus, 'cor')
            if(iostatus.gt.0) then
              ij = minsp
              x = 0.
              write(iostatus, '(i10, g17.5)') minsp, x
              do i = 1, irange
                write(iostatus, '(i10, g17.5)') i + minsp - 1, cor(i)
              enddo
              write(iostatus, '(i10, g17.5)') irange + minsp - 1, x
              close(unit = iostatus)
            endif
	  end if
c  clean up correlation function: reset everything below 0.5 to 0.
c  and clear structures with low statistical value
	  cormax=0.
	  variance=3.*tinp
	  do i=1, irange
	    if (i.lt.irange. and. cor(i).gt.0.5) then
	      if(cormax.eq.0.) peakbegin=i
	      cormax=max(cormax, cor(i))
	    else
	      if(cormax.gt.0. and. cormax.lt.variance) then
	        do j=peakbegin, i
	          cor(j)=0.
	        end do
	      else
	        cor(i)=0.
	      end if
	      cormax=0.
	    end if
	  end do

c  search for lines
	  if(isensw(8)) write(3,'(/'' GASSEA:  detailed result of the
	1 peak search''/
	2 10x,''search region: ''i6'' - ''i6'' statistical factor:''f7.2//
	2 10x,''  #  peak region   centroid  raw-area'',
	3 9x,''area + error'',10x,''width'',2x,''cor_max''/)') minsp, maxsp, tinp
	  peakfound=.false.
	  i=0
	  do while(i.lt.irange .and. maxlin.lt.TOTALPEAKS)
	    i=i+1
	    x=minsp+i-1
	    oldwidth=poly(x,ndw,aws) 
	    region=1.274*oldwidth+0.5
	    peakregion=2*region+1
	    if(.not.peakfound) then
	      if (cor(i).gt.0.) then
	        peakfound=.true.
	        sumcor=cor(i)
	        centroid=i*cor(i)
	        parea=spek(i)
	        peakerr=spekerr(i)*spekerr(i)
                cormax=cor(i)
	        peakbegin=i
	      end if
	    else
	      if (cor(i).gt.0.) then
	        sumcor=sumcor+cor(i)
	        centroid=centroid+i*cor(i)
	        parea=parea+spek(i)
	        peakerr=peakerr+spekerr(i)*spekerr(i)
	        cormax=max(cormax, cor(i))
	      else
	        peakfound=.false.
	        peakend=i-1
	        if (peakend-peakbegin.le.2*peakregion) then
c  a peak has been found and it is not too broad: get the background for it
	          sumback=0.
                  err=0.
	          n=0
	          j=peakbegin-1
	          do while (peakbegin-j.le.region .and. j.ge.1)
	            if (cor(j).eq.0.) then
	              n=n+1
	              sumback=sumback+spek(j)
                      err=err+spekerr(j)*spekerr(j)
	              j=j-1
	            else
	              j=0
	            end if
	          end do
	          j=peakend+1
	          do while (j-peakend.le.region .and. j.le.irange)
	            if (cor(j).eq.0.) then
	              n=n+1
	              sumback=sumback+spek(j)
                      err=err+spekerr(j)*spekerr(j)
	              j=j+1
	            else
	              j=irange+1
	            end if
	          end do
c  calculate peak data
	          sumback=(peakend-peakbegin+1)*sumback/n
                  err=(peakend-peakbegin+1)*err/n
                  x = parea
	          parea=parea-sumback
	          peakerr=sqrt(peakerr + err)
	          newwidth=sumcor/cormax
	          centroid=centroid/sumcor+minsp-1
	          if(isensw(8)) then
                    j = 1
                    if(peakerr.gt.0.) j = log10(peakerr)
                    stellen = log10(parea)
                    if(stellen.ge.10 .or. stellen.le.-7 .or. j.le.-7) then
                      outform = '(i12,i7,'' -'',i6,f10.1,3e10.2,f9.1,f9.1)'
                    else
                      stellen = -min(0, stellen-1, j-1)
c                      if(stellen.gt.0) stellen = stellen+1
                      write(outform, "(""(i12,i7,' -',i6,f10.1,f12."",i1,"",f12."",i1,
	1		 "",f12."",i1,"",f9.1,f9.1)"")") stellen, stellen, stellen
                    endif
	            j=maxlin+1
	            write(3, outform) j, peakbegin+minsp-1, peakend+minsp-1, 
	1           centroid, x, parea, peakerr, newwidth, cormax
	          end if
	          if(parea.gt.0. .and. (highsens .or. allpeaks .or. 
	1         parea.gt.peakerr .or. newwidth.gt.0.3*oldwidth)) then
c  fit the peaks in the list of regions
	            if (reglist) then
	              j=centroid+0.5
	              do while (j.ge.highreg(regpoi) .and. regpoi.lt.regnum)
c  note: an analysis will only take place, if there is at least one peak in
c  a region
	                if (nopeaks) then
	                  maxlin=maxlin+1
	                  peak(maxlin)=0.5*(lowreg(regpoi)+highreg(regpoi))
	                  dpeak(maxlin)=0.5
	                  area(maxlin)=10.
	                  darea(maxlin)=1.
	                  width(maxlin)=oldwidth
	                  nopeaks=.false.
	                else
	                  maxlin=maxlin+1
	                  regpoi=regpoi+1
	                  peak(maxlin)=-lowreg(regpoi)
	                  area(maxlin)=highreg(regpoi)
	                  width(maxlin)=degreg(regpoi)
	                  nopeaks=.true.
	                end if
	              end do
	              if (j.ge.lowreg(regpoi) .and. j.le.highreg(regpoi)) then
	                maxlin=maxlin+1
	                peak(maxlin)=centroid
	                dpeak(maxlin)=0.5
	                area(maxlin)=parea
	                darea(maxlin)=1.
	                width(maxlin)=newwidth
	                nopeaks=.false.
	              end if
c  or add them just to the list
	            else
	              maxlin=maxlin+1
	              peak(maxlin)=centroid
	              dpeak(maxlin)=0.5
	              area(maxlin)=parea
	              darea(maxlin)=1.
	              width(maxlin)=newwidth
	            end if
	          end if
	        end if
	      end if
	    end if
	  end do
	end do
c  add a peak in the last region, if none was found
	if(nopeaks .and. reglist) then
	  maxlin=maxlin+1
	  peak(maxlin)=0.5*(lowreg(regnum)+highreg(regnum))
          dpeak(maxlin)=0.5
	  area(maxlin)=10.
	  darea(maxlin)=1.
	  width(maxlin)=oldwidth
	end if
        if(maxlin.eq.0 .and. onefitregion) then
	  maxlin=maxlin+1
	  peak(maxlin)=0.5*(minregion + maxregion)
          dpeak(maxlin)=0.5
	  area(maxlin)=10.
	  darea(maxlin)=1.
	  width(maxlin) = poly(peak(maxlin), ndw, aws)
	end if
	if (maxlin.gt.0) gassea=.true.
	if (maxlin.eq.0 .and. interactiv) write(*,'(''    *** no peaks found'')')
	if(lpa) then
	  write(3,'(/''  result of the peak search in the region ''
	1 i6'' - ''i6/)') minch, maxsp
	  call gasslp
	end if
	return
	end
