
c  $Id: gasmpar.f,v 1.5 2005/01/22 19:47:33 friedrich Exp friedrich $
c  this file contains routines which work on the parameter arrays:
c    addpar, deletepar, sortpar, setpointers


c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c  integer addpar(integer kpeaks, real*8 position_of_peak_to_be_added)
c
c  adds the position_of_peak_to_be_added to the first kpeaks elements
c  of the array parc and returns the index of the element.
c  kpeaks will be incremented by 1 and a call to setpointers is done at
c  the end. Other to the peak belonging elements will be set to 0, logical
c  elements to .TRUE.
c
c  A negativ value is returned if the number of peaks is exhausted
c  (kpeaks.ge.PEAKTOT), no action is done in his case.
c
c  F. Riess, October 2004 
c------------------------------------------------------------------

        integer function addpar(kpeaks, pos)
        implicit none
        include "gaspar.icl"
        integer kpeaks
        real*8 pos

        integer i, j, m

        if(kpeaks.lt.PEAKTOT) then
          m = 1
          do while(pos.gt.parc(m) .and.m.le.kpeaks)
            m = m + 1
          enddo
          i = PARTOT - ELEMENTS
          j = PARTOT
          kpeaks = kpeaks + 1
          m = m + (ELEMENTS - 1)*kpeaks
          do while(i.ge.1 .and. j.ge.1)
            parc(j) = parc(i)
            par(j)  = par(i)
            dpar(j) = dpar(i)
            deriv(j) = deriv(i)
            fixed(j) = fixed(i)
            fixvorgabe(j) = fixvorgabe(i)
            j = j - 1
            if(j.eq.m) then
              parc(j) = 0.d+00
              par(j)  = 0.d+00
              dpar(j) = 0.d+00
              deriv(j) = 0.d+00
              fixed(j) = .FALSE.
              fixvorgabe(j) = .FALSE.
              m = m - kpeaks
              j = j - 1
            endif
            i = i - 1
          enddo
          do while(m.le.0)
            m = m + kpeaks
          enddo
          parc(m) = pos
          call setpointers(kpeaks)
        else
          m = -1
        endif
        addpar = m
        return
        end


c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c  logical function deletepar(integer kpeaks, integer index_of_par_to_be_removed)
c
c  deletes peak number  index_of_par_to_be_remove from the parameter arrays.
c  kpeaks will be decremented by one and a call to setpointers is done at the end.
c  A value of .TRUE. is returned on succesfull completion.
c  A value of .FALSE. is returned if kpeaks = 1 or if index_of_par_to_be_remove
c  is outside of kpeaks.
c
c  F. Riess, October 2004 
c------------------------------------------------------------------

        logical function deletepar(kpeaks, m)
        implicit none

        include "gaspar.icl" 

        integer kpeaks, m
        integer i, j, n

        if(m.ge.1 .and. m.le.kpeaks .and. kpeaks.ge.2) then
          n = m
          i = 1
          j = 1
          do while(j.le.PARTOT)
            parc(i) = parc(j)
            par(i)  = par(j)
            dpar(i) = dpar(j)
            deriv(i) = deriv(j)
            fixed(i) = fixed(j)
            fixvorgabe(i) = fixvorgabe(j)
            if(j.eq.n) then
              if(n.le.(ELEMENTS - 1)*kpeaks) n = n + kpeaks
            else
              i = i + 1  
            endif
            j = j + 1
          enddo
          do i = 1, ELEMENTS
            j = PARTOT - ELEMENTS + i
            parc(j) = 0.d+00
            par(j)  = 0.d+00
            dpar(j) = 0.d+00
            deriv(j) = 0.d+00
            fixed(j) = .FALSE.
            fixvorgabe(j) = .FALSE.
          enddo
          kpeaks = kpeaks - 1
          call setpointers(kpeaks)
          deletepar = .TRUE.
        else
          deletepar = .FALSE.
        endif
        end

c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c   subroutine sortpar(integer kpeaks)
c  routine sorts the peaks according to the size of the first kpeaks elements
c  of the array parc  (gaussian positions)
c
c  F. Riess, October 2004
c-------------------------------------------------------------------------
        subroutine sortpar(kpeaks)
        implicit none
        include "gaspar.icl"

        integer kpeaks

        integer i, in, j, jn, n
        logical l
        real*8 x

	if(kpeaks.gt.1) then
	  do i = 2, kpeaks
	    do j = 1, i - 1
	      if(parc(i).lt.parc(j)) then
                do n = 0, ELEMENTS - 1
                  in = i + n*kpeaks
                  jn = j + n*kpeaks
		  x = parc(in)
	          parc(in) = parc(jn)
	          parc(jn) = x
	          x = par(in)
		  par(in) = par(jn)
	          par(jn) = x
	          x = dpar(in)
		  dpar(in) = dpar(jn)
	          dpar(jn) = x
	          x = deriv(in)
	          deriv(in) = deriv(jn)
	          deriv(jn) = x
	          l = fixed(in)
	          fixed(in) = fixed(jn)
	          fixed(jn) = l
	          l = fixvorgabe(in)
	          fixvorgabe(in) = fixvorgabe(jn)
	          fixvorgabe(jn) = l
                enddo
	      end if
	    end do
	  end do
	end if
        end


        subroutine setpointers(kpeaks)
c  subbroutine sets the pointers to the elements of the parameter arrays
c  par, parc etc
        implicit none
        include "gaspar.icl"
        
        integer kpeaks

        poscen = 1
        posarea = poscen + kpeaks        ! range of parc unused if ELEMENTS .gt. 2
        poswidth = posarea + kpeaks
        if(ELEMENTS.eq.2) then
          poscwidth = posarea            ! use area range
          pospol = poswidth + 1          ! width can be only varied common       
        else
          poscwidth = poswidth
          pospol = poswidth + kpeaks
        endif
        pospolm = pospol + 1
        pospole = pospol + 4
        postla = pospole + 1
        postlw = postla + 1
        postba = pospole + 3
        postbw = postba + 1
        postra = pospole + 5
        postrw = postra + 1
        possta = pospole + 7
        end
