	real*8 function psin(x)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gaspsin.f,v 2.7 2003/01/26 09:14:10 riess Exp $
c  this function restricts the range of some of the parameters
c  its faster than sin(x)
c  if the function is changed, its parameter range x must be
c  in the interval -1 < x < +1 because some of the calls to parlim
c  make use of this intervall
c     psin(x) = x*(2.-abs(x))   for abs(x) <= 1.
c             = 1.              for x > 1.
c             =-1.              for x < -1.
c------------------------------------------------------------------
	implicit none
        real*8 PIHALBE
        parameter (PIHALBE = 1.57079632679489661923d+00)

	real*8 x, lim
        logical first
        data first /.true./

        if(first) then
          first = .false.
          lim = sin(0.95d+00*PIHALBE)
        endif
	if(x.ge.0.95d+00) then
	  psin = lim
	else if(x.le.(-0.95d+00)) then
	  psin = -lim
	else
	  psin = sin(x*PIHALBE)
	end if
	return
	end

	real*8 function pcos(x)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  calculates the derivativ of psin(x)
c------------------------------------------------------------------
	implicit none
        real*8 PIHALBE
        parameter (PIHALBE = 1.57079632679489661923d+00)

	real*8 x, lim
        logical first
        data first /.true./

        if(first) then
          first = .false.
          lim = PIHALBE*cos(0.95d+00*PIHALBE)
        endif
	if(x.ge.0.95d+00) then
	  pcos = lim
	else if(x.le.(-0.95d+00)) then
	  pcos = lim
	else
	  pcos = PIHALBE*cos(x*PIHALBE)
	end if
	return
	end

	real*8 function parlim(x)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  restricts the parameter to a maximum and minimum value in
c  the intervall -1 < x < 1. . note: LIMIT must be < 1
c  to asure that pcos(LIMIT) .ne. 0.
c------------------------------------------------------------------
	implicit none
	real*8 LIMIT
	parameter (LIMIT = 0.95d+00)
	real*8 x
	if(x.gt.LIMIT) then
	  parlim = LIMIT
	else if(x.lt.(-LIMIT)) then
	  parlim = -LIMIT
	else
	  parlim = x
	end if
	return
	end
