/* $Id: readstrasb.c,v 2.8 2003/08/23 22:26:29 friedrich Exp $
  This routine reads spectra in the online format of Strasbourg
  int readstrasb(
     char *filename:  Filename of Spectrum. If Filename ends with .Z, it
                      will be assumed, that the file is compressed. 
                      An uncompressed file is generated under /usr/tmp
                      and used for reading. This file will be deleted
                      with a subsequent call to readstrasb with an other
                      filename. 
    int subspectrum:  Number of the subspectrum.
    double *spectrum:  Array of the spectrum. Must have length of at least
                      ende - begin + 1
    int begin:        begin of the Spectrum
    int ende:         end of the spectrum
    )
  return value:
    0 if the file is not found or if there was an eroor during reading
   <0 negativ value of last subspectrum if subspectrum does not exist
   >0 ende or last channel in the spectrum if ende is greater than 
      the last channel
  
   F. Riess, April 1993
*/
#define TESTx

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define BUFFERSIZE 512
#define ERRMESS "--> read_strasburg"

void swapbytes(unsigned char *buf, int n, int mode);

int readstrasb(char *filename, int subspectrum, double *spectrum, int begin, int ende)
{
  int i, j, k, n, spekbegin;
  float floatdata[BUFFERSIZE];
  double sum;
  char str[130];
  static char filetmp[L_tmpnam > 130 ? L_tmpnam : 130] = "";
  static char fileold[130] = " ";
  static int firstfile = 1, filesub = -1, spektrumsize, bytestoswap = 0;
  static FILE *fp = NULL;
  static short int *fileheader;
  static unsigned char *spekheader;
  static double *data = NULL;
#ifdef TEST
  static int first = 1;
#endif
    
/* check if file has already been accessed */
  if(strcmp(fileold, filename))
  {
    if(fp)
    {
      fclose(fp);  fp = NULL;
      if(!firstfile) (void) unlink(filetmp);
      firstfile = 1;
      filesub = -1;
    }     
#ifdef TEST
    first = 1;
#endif
    strcpy(fileold, filename);
    j = strlen(filename) - 1;
    if(!strcmp(&filename[j-1], ".Z")) j = 0;
    else if(!strcmp(&filename[j-2], ".gz")) j = -1;
    if(j > 0)
      strcpy(filetmp, filename);
    else
    { if(firstfile)
      { strcpy(filetmp, "/tmp/gspsXXXXXX");
        j = mkstemp(filetmp);
        if(j < 0) return 0;
        close(j);
        firstfile = 0;
      }
      sprintf(str, "zcat %s > %s\n", filename, filetmp);
      system(str);
    }
    if((fp = fopen(filetmp, "r")) == (FILE *) 0) return -1;
/* read file information header */
    if(!fileheader)
    { fileheader = (short int *) malloc(BUFFERSIZE);
      spekheader = (unsigned char *) malloc(BUFFERSIZE);
    }
    j = BUFFERSIZE / sizeof(*fileheader);
    i = fread((void *) fileheader, sizeof(*fileheader), j, fp); 
    if(i != j)
    { 
      fprintf(stderr, "%s: error in reading file %s\n", ERRMESS, filetmp);
      return 0;
    }
    if(fileheader[0] < 0)
    {
      bytestoswap = 1;
      swapbytes((unsigned char *) fileheader, BUFFERSIZE, bytestoswap);
      if(fileheader[0] < 0 || fileheader[0] > 256)
      {
        fprintf(stderr, "-->read strasburg files: byte order not correct\n");
        return -1;
      }
    }
  }  
/* the file is open and the header in core, check for the subspectrum */
/* Note: subspectra start with 0 */
#ifdef TEST
  printf("%s, # of subspectra: %d\n", ERRMESS, fileheader[0]);
  for(j = 0; j < fileheader[0] && first; ++j)
  {
    spekbegin = BUFFERSIZE* (long int) (fileheader[j+2] - 1);
    printf("%4d, %8d, ", j, spekbegin);
    fseek(fp, spekbegin, 0); 
    i = fread((void *) spekheader, 1, BUFFERSIZE, fp);
    if(i != BUFFERSIZE)
      printf("error in reading header\n");
    else
    {    
      spektrumsize = spekheader[7] + 256 * spekheader[6];
      printf("sp-size: %6d ", spektrumsize);
      if(spektrumsize == 0)
        printf("spectrum size is zero\n");
      else
      {
        int n;
        n = 25 + spekheader[17];
        for(i = 26; i < n; ++i)  printf("%c", spekheader[i]);
        printf(", ");
        for(i = 108; i < 129; ++i)
          if(spekheader[i]) printf("%c", spekheader[i]);
        printf(", ");
        if(spekheader[129])
          for(i = 224; i < 512; ++i) 
            if(spekheader[i]) printf("%c", spekheader[i]);
        printf("\n");
      }
    }
  }
  printf("selected subspectrum: %d, from %d to %d; subspectrum in core: %d\n", 
            subspectrum, begin, ende, filesub);
#endif
  if(filesub != subspectrum)
  {
    if(subspectrum >= fileheader[0]) return (-((int) fileheader[0]));
    filesub = subspectrum;
    spekbegin = BUFFERSIZE * (long int) (fileheader[filesub + 2] - 1);
    if(bytestoswap) swapbytes((unsigned char*) &spekbegin, sizeof(spekbegin), 2);
/* read spectrum header */
    fseek(fp, spekbegin, 0); 
    i = fread((void *) spekheader, 1, BUFFERSIZE, fp); 
    if(i != BUFFERSIZE)
    {
      fprintf(stderr, "%s: error in reading file %s\n", ERRMESS, filetmp);
      return 0;
    }
/* Get spectrum size and header information      */
    spektrumsize = spekheader[7] + 256 * spekheader[6];
    if(spektrumsize == 0)
    {
      filesub = -1; 
      fprintf(stderr,"%s: Spektrum size is zero\n", ERRMESS);   
      return 0;
    }
    
 /* Print Header information */
/* 1. Name des Spektrums */
    j = 25 + spekheader[17];
    for(i = 26; i < j; ++i)
      printf("%c", spekheader[i]);
    printf("\n");
/* Erzeugungsdatum */
    for(i = 108, j = 0; i < 129; ++i)
      if(spekheader[i]) j += printf("%c", spekheader[i]);
    if(j) printf("\n");
    if(spekheader[129])
    { for(i = 224, j = 0; i < 512; ++i) 
        if(spekheader[i]) j += printf("%c", spekheader[i]);
      if(j) printf("\n");
    }
/* read spectrum
    wordsize = (16 + spekheader[13]); */
    if(data) free(data);
    data = (double *) calloc(spektrumsize, sizeof(double));
    n = spektrumsize;
    i = 0;
    do
    { j = n <= (int) (BUFFERSIZE/sizeof(float)) ? n : (int) (BUFFERSIZE/sizeof(float));
      fread((void *) floatdata, sizeof(float), j, fp);
      if(bytestoswap) swapbytes((unsigned char*) floatdata, j*sizeof(float), 4);
      for(k = 0; k < j; ++k) data[k+i] = floatdata[k];
      n -= j;
      i += j;
    } while(n > 0);      
/* if spectrum is empty it is nonexistent */
    for(i = 0, sum = 0.; i < spektrumsize; ++i) sum += data[i];
#ifdef TEST
    printf("spectrum size: %4d, contents: %.0f\n", spektrumsize, sum);
    first = 0;
#endif 
    if(sum == 0)  return -99999;
  }
/* Spectrum is now in buffer, transfer it to extern buffer */
  if(ende >= spektrumsize) ende = spektrumsize-1;
  for(i = 0, j = begin; i <= (ende - begin); ++i, ++j)
    spectrum[i] = data[j];
#ifdef TEST
  printf(" spektrum ende %d\n", ende);
#endif
  return ende;
}  

/* Fortran interface */
int readstrasb_(char *fi, int *su, double *sp, int *be, int *en, int fl)
{
  char file[130];
  int i;
  int readstrasb(char *, int, double *, int, int);

  for(i = 0; i < fl; ++i)
  {
    if(fi[i] == ' ') break;
    else file[i] = fi[i];
  }
  file[i] = '\0';
  i = readstrasb(file, *su, sp, *be, *en);
  return i;
}
