c   G A S L I B . F O R 
c   $Id: gaslib.f,v 2.20 2004/08/06 15:38:06 friedrich Exp $
c   last change:   22.03.94 (getstk)
c   last change:   22.02.93(efffun, fiterror, polfun)
c   this file contains routines, independent of special features of GASPAN:
c   addcomma, autfil, chimin, dmfsd, dotcheck, dpoly, dpolyn, dsinv,
c   efffun, erfc (derfc), extens, filemain, fiterror, gasscale, getstk, indexm, 
c   invpolfun, lowercase, ltext, mfsd, next, polfun, poly, polyn, rgauss, 
c   sinv, substr, xp  




	integer function addcomma(string)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  function searches strings for blocks of characters and adds
c  a comma if commas are not allready in. It returns the number
c  of commas in the string. Multiple spaces are concatenated
c  10.10.86  F. Riess
c----------------------------------------------------------------------
	implicit none
	character*(*) string
	logical digit
	integer i, j, kommas, stringend, ltext

	digit=.false.
	kommas = 0
	stringend=ltext(string)
	j=1
	do i=1, stringend
	  if (string(i:i).gt.' ' .and. string(i:i).ne.',') then
	    digit=.true.
	    string(j:j)=string(i:i)
	    j=j+1
	  else if (string(i:i).eq.',') then
	    kommas=kommas+1
	    string(j:j)=string(i:i)
	    j=j+1
	    digit=.false.
	  else
	    if (digit) then
	      string(j:j)=','
	      j=j+1
	      kommas=kommas+1
	      digit=.false.
	    end if
	  end if
	end do
	do while (j.le.stringend)
	  string(j:j)=' '
	  j=j+1
	end do
	addcomma = kommas
	return	     
	end	  



c	integer function asciispek(filename, subspek, spektrum, anfang, ende)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this routine reads a set of integer with a header as spectrum
c  filename: string containing the name of the file. The file
c            is assumed to contain one or a series of spektra,
c	     seperated by lines (header) with the first caracter being
c            a letter
c            if the header contains at least 1 line with 10 @, it is
c            assumed that the first number in a line is the channel number
c            and this number is ignored
c            A variable number of channels can be within a line
c  subspek:  integer. Defines the number of the subspectrum in the file.
c	     The count starts with 1. Subspectra might differ in length
c  spectrum: array of real*8. The size of the array should be as large to
c            hold anfang-ende+1 elements
c  anfang:   integer. First channel to be read. This channel is mapped
c            into the arrayelement #1 of spectrum. Spectra start with
c            channel 0
c  ende:     integer. Last channel to be read. If the spectrum is shorter
c            than ende, only up to the  end of the spektrum will be read.
c            The contents of the rest of spectrum is nonsense.
c
c  return values:
c            0 if the file is not found or there was an error
c           >0 either the value of ende or the last channel in the
c              spectrum whichever is smaller. 
c           <0 Negativ value of the last subspektrum spectrum present,
c              if an attempt was made to read a non existent subspektrum.
c
c  F. Riess, June 1989            
c----------------------------------------------------------------------
c	implicit none
c	character*(*) filename
c	integer subspek, anfang, ende
c	real*8 spektrum(*)
c
c	integer LAENGE
c	parameter (LAENGE = 31)
c	character text*200, oldfile*120
c	logical da, first
c	integer addcomma, istext, ltext
c	integer i, ioc, ios, jspek, flag, kanal, numbers, online, sch
c        integer oldsubspek
c	real*8 spek(LAENGE)
c
c	asciispek = 0
c        first = .FALSE.
c	inquire(file = filename, exist = da)
c	if(.not.da) return
cc	open(unit = 1, file = filename, status = 'old', readonly)
c	open(unit = 1, file = filename, status = 'old')
c        if(oldfile.ne.filename .or. oldsubspek.ne.subspek) first = .TRUE.
c        oldfile = filename
c        oldsubspek = subspek
cc  skip over first subspectra
c	sch = 1
c10	if(sch.lt.subspek) then
c	  flag = 0
c20	    read (1, '(a)', iostat = ios) text
c	    if(ios.eq.(-1)) go to 100
c	    if(ios.eq.0) ios = istext(text)
c	    if(ios.eq.0 . and. flag.eq.0) flag = 1
c	  if(ios * flag.eq.0) go to 20
c	  sch = sch + 1
c	  go to 10
c	endif
c	online = 1
c	ioc = 1
cc skip over header of this spectrum
c30	  read (1, '(a)', iostat = ios) text
c	  if(ios.eq.(-1)) go to 100
c	  if(text(2:11).eq.'@@@@@@@@@@') then
c            if(online .eq. 2) then
c	      ioc = 0
c	      read (1, '(a)', iostat = ios) text
c	    endif
c	    online = 2
c	  endif
c	  if(online.eq.1 .and. ios.eq.0) ioc = istext(text)
c	if(ioc.ne.0) then
c          if(first) write(*, '(a)') text(1:ltext(text))
c          go to 30
c        endif
cc  read spectrum line by line
c	kanal = 0
c	jspek = 0
c40      numbers = addcomma(text) + 1
c	  read (text, *, iostat = ioc) (spek(i), i = 1, numbers)
c	  i = numbers + 1 - online
c	  if(ioc.eq.0) then
c	    if(kanal + i.lt.anfang) then
c	      kanal = kanal + i
c	    else
c	      i = online
c50	      if(kanal.ge.anfang .and. kanal.le.ende) then
c	        jspek = jspek + 1
c	        spektrum(jspek) = spek(i)
c	      endif
c	      kanal = kanal + 1
c	      i = i + 1
c	      if(i.le.numbers) go to 50
c	    endif
c	  endif
c	read (1, '(a)', iostat = ios) text
c        if(ios.eq.0) ios = istext(text)
c	if(ios.eq.0 .and. ioc.eq.0 .and. kanal.le.ende) go to 40
c	if(ioc.eq.0 .and. ios.eq.0) then
c	  sch = -ende
c	else
c	  sch = -(kanal - 1)
c	endif
c100	asciispek = -sch
c	close(unit=1)
c	return
c	end



	integer function autfil (text, incr)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  Name:
c	integer function AUTFIL
c
c  Bentigte Funktionen und Subroutinen
c	keine
c
c  Aufruf:
c	integer AUTFIL, I, INCR
c	character*? TEXT
c
c	I = AUTFIL (TEXT, INCR)
c
c  Zweck:
c	AUTFIL sucht nach der ersten geschlossenen Folge von Ziffern
c	in Text, wandelt diese in eine Ganzzahl um, addiert INCR und
c	konvertiert die Ganzzahl zurck in eine Ziffernfolge an der
c	gleichen Stelle in TEXT. Wenn eine Ziffernfolge mehr als neun
c	Stellen hat, werden nur die rechten (niederwertigsten) neun
c	Stellen beachtet.
c
c	AUTFIL liefert die Ganzzahl nach der Addition von INCR als
c	Wert, wenn kein Fehler aufgetreten ist. Wenn entweder keine
c	Ziffernfolge in TEXT vorhanden ist oder wenn durch die
c	Addition eine Zahl entsteht, die nicht mehr in den vorgegebenen
c	Platz in TEXT pat, liefert AUTFIL -1.
c
c  Autor:
c	Stephan Rie, 16.09.86
c----------------------------------------------------------------------
	implicit none
	integer MAXSTELL
	parameter (MAXSTELL = 9)
	character*(*) text
	integer bis	! letzte Ziffer der Zahl in text
	integer incr	! Wert, um den die Zahl in text verndert werden soll
	integer laenge	! Anzahl der Ziffern der Zahl in text
	integer len	! intrinsic function
	integer max	! intrinsic function
	integer nummer	! Zahl aus text als Ganzzahl
	integer von	! erste Ziffer der Zahl in text
	integer z	! Schleifenzhler
	logical anfang	! erste Ziffer gefunden?
	logical fertig	! Ende der Zahl gefunden?

c
c	wir suchen die erste geschlossene Ziffernfolge in text
c
	anfang = .false.
	fertig = .false.
	autfil = -1		! wir nehmen an, da etwas schief geht
	z = 1
	do while (.not. fertig .and. z .le. len (text))
	  if (text(z:z) .ge. '0' .and. text(z:z) .le. '9') then
	    if (.not. anfang) then
	      von = z
	      anfang = .true.
	    end if
	  else if (anfang) then
	    bis = z - 1
	    fertig = .true.
	  end if
	  z = z + 1
	end do
c
c	wenn keine Ziffer in text ist, ist anfang .false.;
c	dann hren wir auf
c
	if (.not. anfang) return
	von = max (von, bis - maxstell + 1) ! Beschrnkung auf MAXSTELL Ziffern,
					    !  um integer overflow zu vermeiden
	read (text(von:bis), '(i)') nummer ! wir lesen die Ziffern in nummer, ...
	nummer = nummer + incr	! ... addieren inc ...
	laenge = bis - von + 1	! ... und berprfen, ob wir ein breiteres Feld brauchen
	if (nummer .ge. 10 ** laenge .or. nummer .lt. 0) return
	write (text(von:bis), '(i<laenge>.<laenge>)') nummer
	autfil = nummer		! alles gut gegangen; wir geben nummer zurck
	end



	real*8 function chimin(n,x,y,w,m,a,va,fun)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  20.2.80  f.riess
c  unterprogramm fuer lineares chiquadrat problem
c	n	anzahl der variabeln
c	x,y,w	arrays der unabhaengigen und abhaengigen variabeln
c		und ihrere gewichte (single precision)
c	m	anzahl der parameter
c	a	array der parameter
c	va	varianz-kovarianz matrix in eindimensionaler form
c	fun	basis funktion fun(k,x). muss mit einem exteral statement
c		deklariert sein
c
c	chimin	normalisiertes chiquadrat, fall chi<0. war kein fit moeglich
c----------------------------------------------------------------------
	implicit none
	integer n, m
	real*8 x(*), y(*), w(*), a(*), fun
	real*8 va(*)
	integer i, ier, il, j, jl, k, l, lc, lm, lmax
	real*8 xx
	real*8 chi, eps, t, yy, ww, z
	external fun
c  berechnung der normalmatrix
	lmax(j)=(j*(j+1))/2
	lm=lmax(m)
	l=lm+m
	do i=1,l
	  va(i)=0.d+00
	end do
	do i=1,n
	  xx=x(i)
	  yy=y(i)
	  ww=w(i)
	  if(ww.le.0.d+00) ww=1.d+00
	  l=0
	  do j=1,m
	    z=ww*fun(j,xx)
	    jl=j+lm
	    va(jl)=va(jl)+yy*z
	    do k=1,j
	      l=l+1
	      va(l)=va(l)+z*fun(k,xx)
	    end do
	  end do
	end do
c  invertiere normal matrix
	eps=1.d-10
	call dsinv(va,m,eps,ier)
	if(ier.eq.0) then
c  berechne koeffizienten
	  do i=1,m
	    lc=i-1
	    l=lmax(lc)
	    il=lc*m
	    t=0.d+00
	    do j=1,m
	      l=l+1
	      if(j.gt.i) then
	        l=l+lc
	        lc=lc+1
	      end if
	      jl=lm+j
	      il=il+1
	      t=t+va(l)*va(jl)
	    end do
	    a(i)=t
	  end do
c  berechne chiquadrat
	  lc=n-m
	  if(lc.ge.0) then
	    chi=0.d+00
	    if(lc.gt.0) then
	      do i=1,n
	        xx=x(i)
	        ww=w(i)
	        if(ww.le.0.d+00) ww=1.d+00
	        yy=0.d+00
	        do j=1,m
	          yy=yy+a(j)*fun(j,xx)
	        end do
	        yy=y(i)-yy
	        chi=chi+ww*yy*yy
	      end do
	      chi=chi/dble(lc)
	    end if
	  end if
	else
	  chi = -1.d+00
	end if
	chimin=chi
	return
	end



	subroutine dmfsd(a,n,eps,ier)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c        subroutine dmfsd
c
c        purpose
c           factor a given symmetric positive definite matrix
c
c        usage
c           call dmfsd(a,n,eps,ier)
c
c        description of parameters
c           a      - upper triangular part of the given symmetric
c                    positive definite n by n coefficient matrix.
c                    on return a contains the resultant upper
c                    triangular matrix.
c           n      - the number of rows (columns) in given matrix.
c           eps    - an input constant which is used as relative
c                    tolerance for test on loss of significance.
c           ier    - resulting error parameter coded as follows
c                    ier=0  - no error
c                    ier=-1 - no result because of wrong input parame-
c                             ter n or because some radicand is non-
c                             positive (matrix a is not positive
c                             definite, possibly due to loss of signi-
c                             ficance)
c                    ier=k  - warning which indicates loss of signifi-
c                             cance. the radicand formed at factoriza-
c                             tion step k+1 was still positive but no
c                             longer greater than abs(eps*a(k+1,k+1)).
c
c        remarks
c           the upper triangular part of given matrix is assumed to be
c           stored columnwise in n*(n+1)/2 successive storage locations.
c           in the same storage locations the resulting upper triangu-
c           lar matrix is stored columnwise too.
c           the procedure gives results if n is greater than 0 and all
c           calculated radicands are positive.
c           the product of returned diagonal terms is equal to the
c           square-root of the determinant of the given matrix.
c
c        subroutines and function subprograms required
c           none
c
c        method
c           solution is done using the square-root method of cholesky.
c           the given matrix is represented as product of two triangular
c           matrices, where the left hand factor is the transpose of
c           the returned right hand factor.
c----------------------------------------------------------------------
	integer ier, n
	real*8 a(*), eps

	integer i, ind, k, kpiv, l, lend, lind
	real*8 dpiv, dsum, tol
c        test on wrong input parameter n
      if(n-1) 12,1,1
    1 ier=0
c
c        initialize diagonal-loop
      kpiv=0
      do 11 k=1,n
      kpiv=kpiv+k
      ind=kpiv
      lend=k-1
c
c        calculate tolerance
      tol=abs(eps*a(kpiv))
c
c        start factorization-loop over k-th row
      do 11 i=k,n
      dsum=0.d0
      if(lend) 2,4,2
c
c        start inner loop
    2 do 3 l=1,lend
      lanf=kpiv-l
      lind=ind-l
    3 dsum=dsum+a(lanf)*a(lind)
c        end of inner loop
c
c        transform element a(ind)
    4 dsum=a(ind)-dsum
      if(i-k) 10,5,10
c
c        test for negative pivot element and for loss of significance
    5 if(sngl(dsum)-tol) 6,6,9
    6 if(dsum) 12,12,7
    7 if(ier) 8,8,9
    8 ier=k-1
c
c        compute pivot element
    9 dpiv=dsqrt(dsum)
      a(kpiv)=dpiv
      dpiv=1.d0/dpiv
      go to 11
c
c        calculate terms in row
   10 a(ind)=dsum*dpiv
   11 ind=ind+i
c
c        end of diagonal-loop
      return
   12 ier=-1
      return
	end

        logical function dotcheck(text, n)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  checks if text contains a dot
c
c----------------------------------------------------------------------
        implicit none
        character text *(*)
        integer n

        integer i
        dotcheck = .FALSE.
        do i = 1, n
          if(text(i:i).eq.'.') dotcheck = .TRUE.
        enddo
        end

	real*8 function dpoly(x, dx, y, n, a, da)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this function calculates a polynomial function
c     y = sum (i=1,n) a(i)*x^(i-1)
c  and the error to y
c dpoly = sqrt ([sum (i=1,n-1) i*a(i+1)*x^(i-1)]^2*dx^2
c                + sum (i=1,n; j=1,n) (da(i,j)*x^(i+j-2)))
c  input variables:
c	x, dx	: independent variable and its error
c	n	: degree of polynomial
c	a	: array of polynomial coefficients
c	da	: variance-covariance matrix, lower triangle
c  output variables:
c	y	: value of polynomial
c	dpoly	: value of error
c  F. Riess, Nov. 1986
c----------------------------------------------------------------------
	implicit none
	integer n
	real*8 x, dx, y
        real*8 a(*), da(*)
	integer i, indexm, j
	real*8 dy, xi, xj, yy
	if(n.gt.0) then
	  yy = a(n)
	  dy = 0.d+00
	  do i = n-1, 1, -1
	    yy = yy*x + a(i)
	    dy = dy*x + i*a(i+1)
	  end do
	  y = yy
	  yy = dy*dx
	  dy = 0.d+00
	  xi = 1.d+00
	  do i = 1, n
	    xj = xi
	    do j = 1, n
	      dy = dy + da(indexm(i,j)) * xj
	      xj = x * xj
	    end do
	    xi = x * xi
	  end do
	  if (dy.lt.0.d+00) dy = 0.d+00
	  dpoly = sqrt(yy*yy + dy)
	else
	  y = x
	  dpoly = dx
	end if
	return
	end


	real*8 function dpolyn(x, dx, y, np, nn, a, da)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this function calculates a polynomial function
c     y = sum (i=1,np) a(i)*x^(i-1) + sum(i=1,nn) a(np+i)/x^i
c  and the error to y
c dpoly = sqrt ([sum (i=1,n-1) i*a(i+1)*x^(i-1)]^2*dx^2
c                + sum (i=1,n; j=1,n) (da(i,j)*x^(i+j-2)))
c  input variables:
c	x, dx	: independent variable and its error
c	np	: degree of polynomial with positiv power of x
c	nn	: degree of polynomial with negativ power of x
c	a	: array of polynomial coefficients dimension np + nn
c	da	: variance-covariance matrix, lower triangle
c  output variables:
c	y	: value of polynomial
c	dpolyn	: value of error
c  F. Riess, JUNE 2003
c----------------------------------------------------------------------
	implicit none
	integer np, nn
	real*8 x, dx, y
        real*8 a(*), da(*)
	integer i, indexm, j, nt, n1
	real*8 dydx, dydxn, yn, xi, xj, dy

c caculate first y and dy
        y = 0.d+00
        dydx = 0.d+00
	if(np.gt.0) then
	  y = a(np)
	  do i = np-1, 1, -1
	    y = y*x + a(i)
	    dydx = dydx*x + i*a(i+1)
	  end do
        endif
	if(nn.gt.0 .and. x.ne.0.d+00) then
          nt = np + nn
          yn = a(nt)/x
          dydxn = nn*y
          n1 = nn - 1
          if(n1.gt.0) then
            do i = 1, n1
              yn = (yn + a(nt - i))/x
              dydxn = (dydxn + (nn - i)*a(nt - i))/x
            enddo
          endif
          y = y + yn
          dydx = dydx - dydxn/x
        endif
        dpolyn = (dydx*dx)**2
c calculate contribution from variance-covariance matrix
	dy = 0.d+00
	xi = 1.d+00
	do i = 1, nt
          if(i.eq.np + 1) xi = 1.d+00/x
	  xj = 1.
	  do j = 1, nt
            if(j.eq.np + 1) xj = 1.d+00/x
	    dy = dy + da(indexm(i,j)) * xi*xj
	    if(j.le.np) then
              xj = xj*x
            else
              xj = xj/x
            endif
	  end do
          if(i.le.np) then
            xi = xi*x
          else
            xi = xi/x
          endif
        end do
	if (dy.lt.0.d+00) dy = 0.d+00
	dpolyn = sqrt(dpolyn + dy)
	return
	end




	subroutine dsinv(a,n,eps,ier)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c        subroutine sinv
c
c        purpose
c           invert a given symmetric positive definite matrix
c
c        usage
c           call dsinv(a,n,eps,ier)
c
c        description of parameters
c           a      - upper triangular part of the given symmetric
c                    positive definite n by n coefficient matrix.
c                    on return a contains the resultant upper
c                    triangular matrix.
c           n      - the number of rows (columns) in given matrix.
c           eps    - an input constant which is used as relative
c                    tolerance for test on loss of significance.
c           ier    - resulting error parameter coded as follows
c                    ier=0  - no error
c                    ier=-1 - no result because of wrong input parame-
c                             ter n or because some radicand is non-
c                             positive (matrix a is not positive
c                             definite, possibly due to loss of signi-
c                             ficance)
c                    ier=k  - warning which indicates loss of signifi-
c                             cance. the radicand formed at factoriza-
c                             tion step k+1 was still positive but no
c                             longer greater than abs(eps*a(k+1,k+1)).
c
c        remarks
c           the upper triangular part of given matrix is assumed to be
c           stored columnwise in n*(n+1)/2 successive storage locations.
c           in the same storage locations the resulting upper triangu-
c           lar matrix is stored columnwise too.
c           the procedure gives results if n is greater than 0 and all
c           calculated radicands are positive.
c
c        subroutines and function subprograms required
c           dmfsd
c
c        method
c           solution is done using the factorization by subroutine mfsd.
c----------------------------------------------------------------------
	implicit none
	integer n, ier
	real*8 a(*), eps
c
c
	integer i, ind, ipiv, j, l, lanf, lhor, lver, k, kend, min
	real*8 din,work
c
c        factorize given matrix by means of subroutine mfsd
c        a = transpose(t) * t
      call dmfsd(a,n,eps,ier)
      if(ier) 9,1,1
c
c        invert upper triangular matrix t
c        prepare inversion-loop
    1 ipiv=n*(n+1)/2
      ind=ipiv
c
c        initialize inversion-loop
      do 6 i=1,n
      din=1.d0/a(ipiv)
      a(ipiv)=din
      min=n
      kend=i-1
      lanf=n-kend
      if(kend) 5,5,2
    2 j=ind
c
c        initialize row-loop
      do 4 k=1,kend
      work=0.d0
      min=min-1
      lhor=ipiv
      lver=j
c
c        start inner loop
      do 3 l=lanf,min
      lver=lver+1
      lhor=lhor+l
    3 work=work+a(lver)*a(lhor)
c        end of inner loop
c
      a(j)=-(work*din)
    4 j=j-min
c        end of row-loop
c
    5 ipiv=ipiv-min
    6 ind=ind-1
c        end of inversion-loop
c
c        calculate inverse(a) by means of inverse(t)
c        inverse(a) = inverse(t) * transpose(inverse(t))
c        initialize multiplication-loop
      do 8 i=1,n
      ipiv=ipiv+i
      j=ipiv
c
c        initialize row-loop
      do 8 k=i,n
      work=0.d0
      lhor=j
c
c        start inner loop
      do 7 l=k,n
      lver=lhor+k-i
      work=work+a(lhor)*a(lver)
    7 lhor=lhor+l
c        end of inner loop
c
      a(j)=work
    8 j=j+k
c        end of row- and multiplication-loop
c
    9 return
      end


c	integer function dskasciisp(filename, schnitt, spektrum, anfang, ende)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this routine reads a gate spectra from a twodimensional spektrum written
c  as sequential file in ascii.
c  Warning: An opened file is only closed if a call to a nonexisting
c  file is made.
c  filename: string containing the name of the file.
c            The file is assumed to contain one or a series of spektra,
c	     seperated by lines (header) with the first caracter being
c            a letter
c            if the header contains at least 1 line with 10 @, it is
c            assumed that the first number in a line is the channel number
c            and this number is ignored
c            A variable number of channels can be within a line
c  schnitt:  integer. Defines the number of the subspectrum in the file.
c	     The count starts with 0
c  spectrum: array of real*8. The size of the array should be as large to
c            hold anfang-ende+1 elements
c  anfang:   integer. First channel to be read. This channel is mapped into the
c            arrayelement #1 of spectrum
c  ende:     integer. Last channel to be read. If the spectrum is shorter
c            than ende, only up to the  end of the spektrum will be read.
c            The contents of the rest of spectrum is nonsense.
c
c  return values:
c            0 if the file is not found or there was an error
c           >0 either the value of ende or the last channel in the
c              spectrum whichever is smaller. 
c           <0 Negativ value of the last subspektrum present,
c              if an attempt was made to read a non existent subspektrum.
c
c  F. Riess, may 1990
c  last change 21.05.90
c----------------------------------------------------------------------
c	implicit none
c	character*(*) filename
c	integer schnitt, anfang, ende
c	real*8 spektrum(*)
c
c	integer LAENGE, KANAL
c	parameter (LAENGE = 4096)
c	parameter (KANAL=19)
c	character text*200
c	logical da
c	integer addcomma, istext
c	integer i, ioc, ios, j, jspek, flag, numbers, online
c	character filesave*100
c	integer maxch, current
c	real*8 x, spek(LAENGE)
c	data filesave /' '/
c	data current /999999/
c
cc ueberpruefe ob file schon geoeffnet ist, wenn nicht tue dieses
c	dskasciisp = -1
c	if(filesave.ne.filename .or. current.gt.schnitt)  then
c	  if(filesave .ne. ' ') then
c	     close(unit=KANAL)
c	     filesave = ' '
c	     current = 999999
c	  endif
c	  inquire(file = filename, exist = da)
c	  if(da) then
c	    filesave = filename
c	    current = -1
cc	    open(unit = KANAL, file = filename, status = 'old', readonly)
c	    open(unit = KANAL, file = filename, status = 'old')
c	    read (KANAL, '(a)', iostat = ios) text
c	    if(ios.eq.(-1)) go to 100
c	  else
c	    dskasciisp = 0
c	  endif
c	endif
cc skip ueber vorhergehende Spektren und den header des richtigen
c	if(current.lt.schnitt) then
c	  if(current.lt.0) current = 0
c	  flag = 1
c	  online = 0
c	  ios = 0
c	  j = 1
c	  do while((((flag.eq.0 .and. ios.eq.1) .or. online.eq.1)
c	1         .or. (flag.eq.1 .and. ios.eq.0)) .and. current.le.schnitt)
c	    dskasciisp = -current
c	    ios = istext(text)
c	    if(text(2:11).eq.'@@@@@@@@@@') online = online + 1
c	    if(flag.eq.0) then
c	      if(ios.eq.0 .and. online.ne.1) flag = 1
c	    else
c	      if(ios.ne.0) then
c		flag = 0
c		do while (online.ge.2)
c		  online = online - 2
c		enddo
c		current = current + 1
c	      endif
c	    endif
c	    if(flag.eq.1 .and. current.eq.schnitt) then
c	      numbers = addcomma(text) + 1
c	      if(online.eq.0) then
c		maxch = j + numbers - 1
c		read (text, *, iostat = ioc) (spek(i), i = j, maxch)
c	      else
c		maxch = j + numbers - 2
c		read (text, *, iostat = ioc) x, (spek(i), i = j, maxch)
c	      endif
c	      j = maxch + 1
c	    endif
c	    if(current.le.schnitt) then
c	      read (KANAL, '(a)', iostat = ioc) text
c	      if(ioc.eq.(-1)) go to 100
c	    endif
c	  enddo
c	current = current - 1
c	endif
cc schnitt  schon gelesen, kopiere spektrum aus dem Speicher
cc  und schiebe es einen kanal runter
c40      if(current.eq.schnitt) then
c	  jspek = min(maxch - 1, ende)
c	  j = 1
c	  do i = anfang + 1, jspek
c	    spektrum(j) = spek(i)
c	    j = j + 1
c	  enddo
c	endif
c	dskasciisp = jspek
c100     continue
c	return
c	end


      real*8 function efffun0(x, n, nm, a, dydx, dyda)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  Modellfunktion fuer Efficiency Eichung
c  y = 0.5 * erfc[-a(1)^2*(x-a(2))]*[a(3)+a(4)*x+...+a(n)*x^(n-3)]
c  n muss mindestens den Wert 3 haben
c  zurueckgegeben wird der Funktionswert y,
c  die Ableitung dy nach dx und die Ableitungen dy nach da
c  F. Riess, 19.02.1993
c----------------------------------------------------------------------
      implicit none
      real*8 a(*), x, dydx, dyda(*)
      integer n
c nm is not used, inserted because of compatibility with polfun
      integer nm

      real*8 erfc, erfcd, tmp, MLN10
      real*8 erfcs, erfcds
      real*8 pols, dpoldx, tmp0, tmp1
      integer i
      parameter (MLN10 = 2.302585093) 

c Definition einiger Groessen
      tmp = a(1)**2 * (x - a(2))
      erfcs = 0.5*erfc(-tmp)
c  Berechnung des Polynoms
      dyda(3) = 1.
      tmp0 = 1.
      pols = a(3)
      dpoldx = 0
      if(n.gt.3) then
        do i = 4, n
          tmp1 = x*tmp0
          dyda(i) = tmp1
          pols = pols + a(i) * tmp1
          dpoldx = dpoldx + (i-3)*a(i)*tmp0
	  tmp0 = tmp1
        enddo
      endif
      pols = 10**pols
c  Beruecksichtigung der ersten zwei Parameter
      erfcds = -(0.5 * erfcd(-tmp) * pols)
      dyda(1) =  2 * a(1) * (x - a(2)) * erfcds
      dyda(2) = -(a(1)**2 * erfcds)
c  ...   und der entsprechenden Groessen
      erfcs = erfcs * pols
      efffun0 = erfcs
      erfcs = MLN10 * erfcs
c      dydx = dpoldx * erfcs - dyda(2)
      dydx = 0.
      do i = 3, n
        dyda(i) = erfcs * dyda(i)
      enddo
      return
      end


      real*8 function efffun(x, n, nm, a, dydx, dyda)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  Modellfunktion fuer Efficiency Eichung
c  y = 0.5 * erfc[-a(1)^2*(x-a(2))]*[a(3)+a(4)*log10(x)+...+a(n)*(log10(x))^(n-3)]
c  n muss mindestens den Wert 3 haben
c  zurueckgegeben wird der Funktionswert y,
c  die Ableitung dy nach dx und die Ableitungen dy nach da
c  F. Riess, 19.02.1993
c----------------------------------------------------------------------
      implicit none
      real*8 a(*), x, dydx, dyda(*)
      integer n
c nm is not used, inserted because of compatibility with polfun
      integer nm

      real*8 erfc, erfcd, tmp, lx, MLN10
      real*8 erfcs, erfcds
      real*8 pols, dpoldx, tmp0, tmp1
      integer i
      parameter (MLN10 = 2.302585093) 

c Definition einiger Groessen
      if(x.gt.0.d+00) then
        lx = log10(x)
        tmp = a(1)**2 * (x - a(2))
        erfcs = 0.5*erfc(-tmp)

c  Berechnung des Polynoms
        dyda(3) = 1.d+00
	tmp0 = 1.d+00
        pols = a(3)
        dpoldx = 0.d+00
        if(n.gt.3) then
          do i = 4, n
            tmp1 = lx*tmp0
            dyda(i) = tmp1
            pols = pols + a(i) * tmp1
            dpoldx = dpoldx + (i-3)*a(i)*tmp0
 	    tmp0 = tmp1
          enddo
        endif
        if(pols.gt.30.d+00) pols = 30.d+00
        pols = 10.d+00**pols
c  Beruecksichtigung der ersten zwei Parameter
        erfcds = -(0.5d+00 * erfcd(-tmp) * pols)
        dyda(1) =  2.d+00 * a(1) * (x - a(2)) * erfcds
        dyda(2) = -(a(1)**2 * erfcds)
c  ...   und der entsprechenden Groessen
        erfcs = erfcs * pols
        efffun = erfcs
        erfcs = MLN10 * erfcs
c        dydx = dpoldx * erfcs / x - dyda(2)
        dydx = 0.d+00
        do i = 3, n
          dyda(i) = erfcs * dyda(i)
        enddo
      else
        do i = 1, n
          dyda(i) = 0.d+00
        enddo
        dydx = 0.d+00
        efffun = 0.d+00
      endif
      return
      end


      real*8 function efffun1(x, n, a, dydx, dyda)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  Modellfunktion fuer Efficiency Eichung
c  y = 0.5 * erfc[-a(1)^2*(x+a(2))]*[a(3)+a(4)*x+...+a(n)*x^(n-3)]
c  n muss mindestens den Wert 3 haben
c  zurueckgegeben wird der Funktionswert y,
c  die Ableitung dy nach dx und die Ableitungen dy nach da
c
c  F. Riess, 19.02.1993
c----------------------------------------------------------------------
      implicit none
      real*8 a(*), x, dydx, dyda(*)
      integer n

      real*8 erfc, erfcd, tmp
      real*8 erfcs, erfcds
      real*8 pols, dpoldx, tmp0, tmp1
      integer i

c Definition einiger Groessen
      tmp = a(1) * a(1) * (x - a(2))
      erfcs = 0.5*erfc(-tmp)
c  Berechnung des Polynoms
      dyda(3) = 1.
      tmp0 = 1.
      pols = a(3)
      dpoldx = 0
      if(n.gt.3) then
        do i = 4, n
          tmp1 = x*tmp0
          dyda(i) = tmp1
          pols = pols + a(i) * tmp1
          dpoldx = dpoldx + (i-3)*a(i)*tmp0
	  tmp0 = tmp1
        enddo
      endif
      do i = 3, n
        dyda(i) = erfcs * dyda(i)
      enddo
c  Beruecksichtigung der ersten zwei Parameter
      erfcds = -(0.5 * erfcd(-tmp) * pols)
      dyda(1) =  2 * a(1) * (x - a(2)) * erfcds
      dyda(2) = -(a(1) * a(1) * erfcds)
c  ...   und der entsprechenden Groessen
c      dydx = dpoldx * erfcs - dyda(2) 
      dydx = 0.
      efffun1 = erfcs * pols
      return
      end


cx	real function erfc(x)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  fehlerfunktion erfc(x) und ihre ableitung erfcd
c  siehe 'handbook of mathematical functions' p 297
c  wertebereich fuer gaspan auf +/- 3 beschraenkt
c  F. Riess
c----------------------------------------------------------------------
cx	implicit none
cx	real x
cx	integer i
cx	real a(5), absx
cx        real*8 sum
cx	data a/0.078108,0.000972,0.230389,0.278393,1./
cxc	data b/0.,1.249728,0.011664,1.843112,1.113572/
cx        erfc=0.
cx	absx=abs(x)
cx	if(absx.le.3.) then
cx	  sum=a(1)
cx	  do i=2,5
cx	    sum=sum*absx+a(i)
cx	  end do
cx	  sum = sum*sum
cx	  erfc=1./(sum*sum)
cx	end if
cx	if(x.lt.0.)erfc=2.-erfc
cx	return
cx	end

cx	real function erfcd(x)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  Ableitung der Fehlerfunktion erfc(x)
c  siehe 'handbook of mathematical functions' p 297
c  wertebereich fuer gaspan auf +/- 3 beschraenkt
c  F. Riess
c----------------------------------------------------------------------
cx	implicit none
cx	real x
cx	integer i
cx	real a(5), abs, absx, b(5), sum, sum1
cx	data a/0.078108,0.000972,0.230389,0.278393,1./
cx	data b/0.,1.249728,0.011664,1.843112,1.113572/
cx	absx=abs(x)
cx	if(absx.le.3.) then
cx	  sum=a(1)*absx+a(2)
cx	  sum1=b(2)
cx	  do i=3,5
cx	    sum=sum*absx+a(i)
cx	    sum1=sum1*absx+b(i)
cx	  end do
cx	  sum1 = sum1/sum
cx	  sum = sum * sum
cx	  erfcd=-(sum1/(sum*sum))
cx	else
cx	  erfcd=0.
cx	end if
cx	return
cx	end

      real*8 function erfcd(x)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  derivative of erfc(x), use this function if erfc is in the system library
c  constant: -2/sqrt(pi)
c  values are restricted to abs(x) < 8.
c  F. Riess
c----------------------------------------------------------------------
      real*8 x

      if(abs(x).le.8.d+00) then
        erfcd=(-1.12837916709551257390d+00)*exp(-(x*x))
      else
        erfcd=0.d+00
      endif
      return
      end


	logical function extens(file, ext)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this function test a filename to have an extension defined by
c  a dot in the character string and returns the value .true.
c  if so, else .false.
c  If "ext" ne. ' ', the current extension will be replaced by
c  "ext" or ".ext" will be added to the name 
c  this function converts upper case characters into lower case one
c  03.07.92: Beruecksichtigung von ../ unter UNIX
c  13.10.86  F. Riess
c----------------------------------------------------------------------
	implicit none
	character*(*) file, ext
	integer extpoi, ltext
	extpoi=max(1, ltext(file))
	do while (extpoi.gt.0 .and. file(extpoi:extpoi).ne.'.')
	  extpoi=extpoi-1
	end do
	if (extpoi.gt.0 .and. file(extpoi+1:extpoi+1) .ne. '/') then
	  extens=.true.
	else
	  extens=.false.
	end if
	if (ext.ne.' ') then
	  if (extens) then
	    file=file(1:extpoi)//ext
	  else
	    extpoi=ltext(file)
	    if (extpoi.gt.0) then
	      file=file(1:extpoi)//'.'//ext
	    else
	      file='.'//ext
	    end if
	  end if
 	  extens=.true.
	end if
	return
	end	  


	integer function filemain(file)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  function sets a pointer to the character following the symbol ]
c  or : .if file does not containe this character, filemain=1
c  15.10.86  F. Riess
c----------------------------------------------------------------------
	implicit none
	character *(*) file
	integer i, ltext
	filemain=0
	do i=1,ltext(file)
	  if (file(i:i).eq.'/' .or. file(i:i).eq.':') filemain=i
	end do
	filemain=filemain+1
	return
	end


	real*8 function fiterror(n, dyda, varcovar)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  calculates the fit error of a function with n parameters a(*)
c  and  their errors (stored in the variance -covariance matrix 
c  varcovar(*) (lower triangle of size n*(n+1)/2)).
c  The relation to the original function is given by the derivatives
c  of the function to the parameters dyda.
c  The function efffun or polfun should be called before in order
c  to get these derivatives.
c  Return value is the error of the function due to the errors of
c  the parameters
c  26.02.93  F. Riess
c----------------------------------------------------------------------
        implicit none
        real*8 dyda(*)
        real*8 varcovar(*)
        integer n

        integer i, j, indexm
        real*8 tmp, dummy
        tmp = 0.d+00
        do i = 1, n
	  dummy=dyda(i)
          do j = 1, n
            tmp = tmp + dyda(j)*dummy*varcovar(indexm(i,j))
          enddo
        enddo
        if(tmp.gt.0.d+00) then
          tmp = sqrt(tmp)
        endif
        fiterror = tmp
        return
        end


	integer function gasscale(xmin, xmax, nmajor, xmin0, step)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c   determines scaling on axis
c
c   xmin, xmax:  minimum and maximum of scale: input values
c   nmajor:     approximate number of ticks with a label: input value
c   xmin0:      first position of the major ticks,  return value
c               note: always xmin0.le.xmin!
c   step:       distance of minor ticks
c   return value - 1: number of minor ticks between major ticks
c
c   F. Riess, June 2004
c--------------------------------------------------------------------
        implicit none
	real*8 xmin, xmax, xmin0, step
        integer nmajor

        real*8 xdist, factor, x, ideal(3)
        integer j, minor(3)
        data ideal/1., 2., 5./, minor/ 5, 4, 5/

        xdist = xmax - xmin
	factor = 1./nmajor
        do while(factor*xdist.gt.7.5) 
          factor = factor/10.
        enddo
        do while(factor*xdist.lt.0.75)
	  factor = 10.*factor
        enddo
        x = factor*xdist
        if(x.lt.1.5) then
          j = 1
        else if(x.lt.3.5) then
          j = 2
        else
          j = 3
        endif
        step = ideal(j)/(nmajor*factor)
        xmin0 = int(xmin/step)*step
        if(xmin.lt.0.) xmin0 = xmin0 - step
        step = step/minor(j)
        gasscale = minor(j)
        return
        end


	real*8 function getstk(firstch, lastch, spek, err)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this routine runs through a spectrum to get the statistical
c  fluctuation of the data compared to sqrt(data) + 1. It must be
c  called if difference spectra are to be analyzed.
c  method:
c  1. a quadrupel of staggering number is searched in the spectrum
c  2. A straight line will fitted through this points
c  3. The normalized chisquare is calculated for this fit with an
c     average error taken from the data
c  4. The statistical factor is determined such, that chisquare
c     will average to 1
c  09.03.00  modified to accept external error
c  08.01.93  modified to above description
c  11.09.86  vax version
c  26.10.78  f. riess
c----------------------------------------------------------------------

	implicit none
	integer firstch, lastch
	real*8 spek(*), err(*)

	logical jmp
	integer i, j, m, m1, lastm3, ntin
	real*8 offset, slope, tinp, x, var
        real*8 sumw, sumwy, sumwiy, sumwi, sumwii
        real*8 w(4)

	tinp = 0.d+00
	ntin = 0
	lastm3=lastch-3
	do 50 m=1,lastm3
c  suche 4 aufeinander folgende kanaele mit alternierender
c  zaehlrate
	  m1=m+1
	  jmp=.false.
	  if(spek(m1).le.spek(m))jmp=.true.
	  do 20 i=1,2
	    if(jmp)go to 10
	    if(spek(m1+1).gt.spek(m1))go to 50
	    jmp=.true.
	    go to 20
10	    if(spek(m1+1).lt.spek(m1))go to 50
	    jmp=.false.
20	    m1=m1+1
c ueberprufe ob nicht ein Punkt extrem ist: Berechne Mittelwert und
c  Varianz des Mittelwerts und vergleiche Daten mit Mittelwert
c  plus zweifache Varianz
	    do i = 1, 4
	      x = 1.d+00/err(m+i-1)
	      w(i) = x*x
	    enddo
            do j = 1, 4
	      sumwy = 0.d+00
	      sumw = 0.d+00
	      do i = 1, 4
	        if(i.ne.j) then
	          sumw = sumw + w(i)
	          sumwy = sumwy + w(i)*spek(m+i-1)
                endif
	      enddo
	      offset = sumwy/sumw
              var = 0.d+00
	      do i = 1, 4
                if(i.ne.j) var = var + w(i)*(spek(m+i-1) - offset)**2
	      enddo
	      var = 5.d+00*sqrt(0.5d+00*var/w(j))
	      if(abs(spek(m+j-1)-offset).gt.var) go to 50
	    enddo
c  a quadrupel has been found, calculate best straight line
          sumw = 0.d+00
          sumwy = 0.d+00
	  sumwiy = 0.d+00
          sumwi  = 0.d+00
          sumwii = 0.d+00
	  do i = 1, 4
            sumw   = sumw + w(i)
            sumwy  = sumwy + w(i)*spek(m+i-1)
            sumwi  = sumwi  + w(i)*i
            sumwii = sumwii + w(i)*i*i
	    sumwiy = sumwiy + w(i)*i*spek(m+i-1)
	  end do
          x = sumw*sumwii - sumwi*sumwi
          if(x.ne.0.d+00) then
            slope = (sumw*sumwiy - sumwy*sumwi)/x
            offset  = (sumwy*sumwii - sumwi*sumwiy)/x
c  ..and variance
            var = 0.d+00
            do i = 1, 4
	      x = spek(m+i-1) - slope*i - offset
	      var = var + w(i)*x*x
            end do
	    var = 0.5d+00 * var
	    if(var .gt. 0.d+00) then
c  average with the preceeding factor of significance
c	    tinp = (ntin * tinp + var) / dble(ntin+1)
	      tinp = tinp + var
	      ntin = ntin + 1
            endif
	  end if
50	  continue
        if(ntin .gt. 0) then
          tinp = tinp / ntin
        else
          tinp = 1.d+00
        endif
	getstk = sqrt(tinp)
        return
	end



	integer function indexm(i, j)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this function converts the two indices i and j of the 
c  matrix elements of a symmetric matrix into the linear element
c  of an array containing the lower triangle of the matrix
c----------------------------------------------------------------------
	implicit none
	integer i, j
	if (i.ge.j) then
	  indexm = (i*(i-1))/2 + j
	else
	  indexm = (j*(j-1))/2 + i
	end if
	return
	end

        real*8 function invpolfun(y, np, nn, a)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  converts
c 	real*8 function polfun(x, np, nn, a, dydx, dyda)
c  assuming the polynomial steems from an energy calibration with
c  a dominant a(2) - term (linear Term)
c  Method: recursive approximation
c  note: this function is rarly used, o speed does not matter.
c  7.06.2004 F. Riess
c----------------------------------------------------------------------
	implicit none
        real*8 y, a(*)
        integer np, nn

        logical belowminimum
        integer repeat
        real*8 polfun, dx, dy, dydx, yda(10), schritt

        invpolfun = -10000.
        if(a(2).eq.0.) return
        invpolfun = (y - a(1))/a(2)
        if(np.eq.1 .and. nn.eq.0) return
        repeat = 200
        dx = 10.
        schritt = 10.
        belowminimum = .FALSE.
        do while(abs(dx).gt.1.e-10 .and. repeat.ge.0)
          dy = y - polfun(invpolfun, np, nn, a, dydx, yda)
c avoid values below the minimum for negativ exponents
          if(nn.gt.0 .and. dydx.lt.0) belowminimum = .TRUE.
          if(belowminimum) then
            if(dydx.lt.0) then
              dx = schritt
            else
              dx = -dx
              schritt = 0.1*schritt
            endif
          else
            dx = dy/dydx
          endif
          invpolfun = max(1., invpolfun + dx)
          repeat = repeat - 1
        enddo
        if(repeat.eq.0) invpolfun = -10000.
        return
        end


	character function lowercase(c)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this function converts upper case characters into lower case one
c  13.10.86 F. Riess
c----------------------------------------------------------------------
	implicit none
	character c
	if (c.ge.'A' .and. c.le.'Z') then
	  lowercase=char(ichar(c)+ichar('a')-ichar('A'))
	else
	  lowercase=c
	end if
	return
	end	  



	integer function ltext(text)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this functions returns the end of a string, ignoring spaces
c  and control characters at the end of the string.
c  Note: on an empty string ltext=0
c  
c----------------------------------------------------------------------
	implicit none
	character*(*) text
	integer m, len
	m=len(text)
	do while(m.gt.0 .and. text(m:m).le.' ')
	   m=m-1
	end do
	ltext=m
	return
	end


	subroutine mfsd(a,n,eps,ier)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c        subroutine mfsd
c
c        purpose
c           factor a given symmetric positive definite matrix
c
c        usage
c           call mfsd(a,n,eps,ier)
c
c        description of parameters
c           a      - upper triangular part of the given symmetric
c                    positive definite n by n coefficient matrix.
c                    on return a contains the resultant upper
c                    triangular matrix.
c           n      - the number of rows (columns) in given matrix.
c           eps    - an input constant which is used as relative
c                    tolerance for test on loss of significance.
c           ier    - resulting error parameter coded as follows
c                    ier=0  - no error
c                    ier=-1 - no result because of wrong input parame-
c                             ter n or because some radicand is non-
c                             positive (matrix a is not positive
c                             definite, possibly due to loss of signi-
c                             ficance)
c                    ier=k  - warning which indicates loss of signifi-
c                             cance. the radicand formed at factoriza-
c                             tion step k+1 was still positive but no
c                             longer greater than abs(eps*a(k+1,k+1)).
c
c        remarks
c           the upper triangular part of given matrix is assumed to be
c           stored columnwise in n*(n+1)/2 successive storage locations.
c           in the same storage locations the resulting upper triangu-
c           lar matrix is stored columnwise too.
c           the procedure gives results if n is greater than 0 and all
c           calculated radicands are positive.
c           the product of returned diagonal terms is equal to the
c           square-root of the determinant of the given matrix.
c
c        subroutines and function subprograms required
c           none
c
c        method
c           solution is done using the square-root method of cholesky.
c           the given matrix is represented as product of two triangular
c           matrices, where the left hand factor is the transpose of
c           the returned right hand factor.
c----------------------------------------------------------------------
	integer ier, n
	real a(*), eps

	integer i, ind, k, kpiv, l, lend, lind
	real tol
	double precision dpiv, dsum
c        test on wrong input parameter n
      if(n-1) 12,1,1
    1 ier=0
c
c        initialize diagonal-loop
      kpiv=0
      do 11 k=1,n
      kpiv=kpiv+k
      ind=kpiv
      lend=k-1
c
c        calculate tolerance
      tol=abs(eps*a(kpiv))
c
c        start factorization-loop over k-th row
      do 11 i=k,n
      dsum=0.d0
      if(lend) 2,4,2
c
c        start inner loop
    2 do 3 l=1,lend
      lanf=kpiv-l
      lind=ind-l
    3 dsum=dsum+dble(a(lanf))*dble(a(lind))
c        end of inner loop
c
c        transform element a(ind)
    4 dsum=dble(a(ind))-dsum
      if(i-k) 10,5,10
c
c        test for negative pivot element and for loss of significance
    5 if(sngl(dsum)-tol) 6,6,9
    6 if(dsum) 12,12,7
    7 if(ier) 8,8,9
    8 ier=k-1
c
c        compute pivot element
    9 dpiv=dsqrt(dsum)
      a(kpiv)=dpiv
      dpiv=1.d0/dpiv
      go to 11
c
c        calculate terms in row
   10 a(ind)=dsum*dpiv
   11 ind=ind+i
c
c        end of diagonal-loop
      return
   12 ier=-1
      return
	end


	integer function next(x,p,n)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  12.10.78
c  unterprogramm sucht in dem array p mit der laenge n den
c  zu x naechst gelegensten wert und gibt den entsprechenden
c  index i in next zurueck.
c   die werte in p muessen entweder monoton abnehmen oder
c  ansteigen.
c  verfahren: sukzessive approximation
c  autor: f.riess
c
c  eingabe: x, array p, laenge n
c  ausgabe:  next gibt den zu x naechstgelgenstes array element p
c----------------------------------------------------------------------
	implicit none
	integer n
	real*8 x, p(*)
	integer i, ia, iabs, j, n2
	real*8 sig, z
	next=1
	if(n.le.1)return
	sig=1.
	if(p(n).lt.p(1))sig=-1.
	n2=2
5	if(n.le.n2)go to 10
	n2=2*n2
	go to 5
10	n2=n2/2
	i=n2
	j=0
20	j=j+i
	if(j.gt.n)j=n
	if(j.lt.1)j=1
	ia=iabs(i)/2
	if(ia.le.0)go to 30
	i=ia
	z=sig*(x-p(j))
	if(z)25,50,20
25	i=-i
	go to 20
30	z=sig*(x-p(j))
	if(z)35,50,40
35	if(j.eq.1)go to 50
	z=-z
	i=j-1
	go to 45
40	if(j.eq.n)go to 50
	i=j+1
45	if(abs(x-p(i)).lt.z)j=i
50	next=j
	return
	end

	real*8 function polfuno(x, n, a, dydx, dyda)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  1.10.80   f.riess
c  unterprogramm berechnet funktionswert fuer das polynom
c  y = a(1)+x*a(2)+...x**(n-1)*a(n) 
c  und die Ableitung nach x
c  dy = (a(2) + ... (n-1)*x^(n-2)*a(n)
c 
c  und die Ableitungen nach den Parametern dy/da(n)
c----------------------------------------------------------------------
	implicit none
        real*8 a(*), x, dydx, dyda(*)
        integer n
        
        integer i
        real*8 y, dy, tmp0, tmp1
        
        dyda(1) = 1.d+00
	tmp0 = 1.d+00
        y = a(1)
        dy = 0.d+00
        do i = 2, n
          tmp1 = x * tmp0
          dyda(i) = tmp1
          y = y + a(i) * tmp1
          dy = dy + (i-1)*a(i)*tmp0 
	  tmp0 = tmp1
        enddo
        dydx = dy
        polfuno = y
        return
        end

 	real*8 function polfun(x, np, nn, a, dydx, dyda)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  27.06.03   f.riess
c  unterprogramm berechnet funktionswert fuer das polynom
c  y = a(1)+x*a(2)+...x**(np-1)*a(np) + a(np+1)/x + ... a(np+nn)/x**nn
c  und die Ableitung nach x
c  dy = (a(2) + ... (n-1)*x^(n-2)*a(n) - nn*a(np+nn)/x**(nn+1)
c 
c  und die Ableitungen nach den Parametern dy/da(n)
c----------------------------------------------------------------------
	implicit none
        real*8 a(*), x, dydx, dyda(*)
        integer np, nn
        
        integer i, n1, nt
        real*8 y, dy, tmp0, tmp1
        
        polfun = 0.d+00
        if(np.gt.0) then
          polfun = a(np)
          dydx = (np - 1)*a(np)
          dyda(1) = 1.d+00
          n1 = np - 1
          if(n1.gt.0) then
            do i = 1, n1
              polfun = polfun*x + a(np - i)
              if(i.lt.n1) dydx = dydx*x + (np - i - 1)*a(np - i)
              tmp1 = x * tmp0
              dyda(i + 1) = x*dyda(i)
            enddo
          endif
        endif 
        if(nn.gt.0 .and. x.ne.0.d+00) then
          nt = np + nn
          y = a(nt)/x
          dy = nn*y
          dyda(np + 1) = 1.d+00/x
          n1 = nn - 1
          if(n1.gt.0) then
            do i = 1, n1
              y = (y + a(nt - i))/x
              dy = (dy + (nn - i)*a(nt - i))/x
              dyda(np + 1 + i) = dyda(np + i)/x
            enddo
          endif
          polfun = polfun + y
          dydx = dydx - dy/x
        endif
        return
        end


	real*8 function poly(x,n,a)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  1.10.80   f.riess
c  unterprogramm berechnet funktionswert fuer das polynom
c  poly=a(1)+x*a(2)+...x**(n-1)*a(n)
c----------------------------------------------------------------------
	implicit none
	integer n
	real*8 x, a(*)
	integer i, n1
	real*8 y
	poly=0.
	if(n.le.0)return
	y=a(n)
	poly=y
	n1=n-1
	if(n1.le.0)return
	do i=1,n1
	  y=y*x+a(n-i)
	enddo
	poly=y
	return
	end


	real*8 function polyn(x,np,nn,a)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  27.06.2003   f.riess
c  unterprogramm berechnet funktionswert fuer das polynom
c  polyn = a(1)+x*a(2)+...x**(np-1)*a(np) +a(np+1)/x ..a(np+nn)/x**nn
c----------------------------------------------------------------------
	implicit none
	integer np, nn
	real*8 x, a(*)
	integer i, n1, nt
	real*8 y
	polyn = 0.d+00
	if(np.gt.0) then
	  polyn = a(np)
	  n1 = np - 1
	  if(n1.gt.0) then
	    do i = 1, n1
	      polyn = polyn*x + a(np - i)
	    enddo
          endif
        endif
        if(nn.gt.0 .and. x.ne.0.d+00) then
          nt = np + nn
          y = a(nt)/x
          n1 = nn - 1
          if(n1.gt.0) then
            do i = 1, n1
              y = (y + a(nt - i))/x
            enddo
          endif
          polyn = polyn + y
        endif
	return
	end


	real*8 function rgauss(dx)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  05.10.83  f.riess
c  funktionsprogramm gibt eine mit der varianz dx um den mittelwert 0
c  verteilte zufallsgroesse in rgauss zurueck
c  benoetigte unterprogramme: next, erfc
c  achtung : diese fuer gaspan geschriebene version benutzt den common block c1
c----------------------------------------------------------------------
	implicit none
	real*8 dx
	character y*8
	integer i, j, l, next
	real*8 erfc, r(200), ran, x
	data l/0/
	if(l.eq.200)go to 20
c  setup: setze zufallsvariable und tabelliere fehlerfunktion in r
	call time(y)
	j=ichar(y(4:4))*ichar(y(7:7))+ichar(y(5:5))*ichar(y(8:8))
	l=200
c  tabelliere die fehlerfunktion mit einer varianz von 40
	do 10 i=1,l
10	r(i)=erfc(dble(i-1)/56.5685d+00)
c  bestimme aus einer zufallsvariablen die abweichung vom mittelwert 0
c  sowie das vorzeichen der abweichung
20	rgauss=0.d+00
	if(dx.le.0.)return
	x=ran(j)
	i=next(x,r,l)
	if(x.lt.r(i))i=i-1
	if(i.le.0)i=1
	if(i.ge.l)i=l-1
	if(r(i+1).ne.r(i))then
	    rgauss=dx*(i-1+(x-r(i))/(r(i+1)-r(i)))/40.d+00
	else
	    rgauss=dx*(i-1)/40.d+00
	endif
	if(ran(j).le.0.5d+00)rgauss=-rgauss
	return
	end




	subroutine sinv(a,n,eps,ier)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c        subroutine sinv
c
c        purpose
c           invert a given symmetric positive definite matrix
c
c        usage
c           call sinv(a,n,eps,ier)
c
c        description of parameters
c           a      - upper triangular part of the given symmetric
c                    positive definite n by n coefficient matrix.
c                    on return a contains the resultant upper
c                    triangular matrix.
c           n      - the number of rows (columns) in given matrix.
c           eps    - an input constant which is used as relative
c                    tolerance for test on loss of significance.
c           ier    - resulting error parameter coded as follows
c                    ier=0  - no error
c                    ier=-1 - no result because of wrong input parame-
c                             ter n or because some radicand is non-
c                             positive (matrix a is not positive
c                             definite, possibly due to loss of signi-
c                             ficance)
c                    ier=k  - warning which indicates loss of signifi-
c                             cance. the radicand formed at factoriza-
c                             tion step k+1 was still positive but no
c                             longer greater than abs(eps*a(k+1,k+1)).
c
c        remarks
c           the upper triangular part of given matrix is assumed to be
c           stored columnwise in n*(n+1)/2 successive storage locations.
c           in the same storage locations the resulting upper triangu-
c           lar matrix is stored columnwise too.
c           the procedure gives results if n is greater than 0 and all
c           calculated radicands are positive.
c
c        subroutines and function subprograms required
c           mfsd
c
c        method
c           solution is done using the factorization by subroutine mfsd.
c----------------------------------------------------------------------
	implicit none
	integer n, ier
	real a(*), eps
c
c
	integer i, ind, ipiv, j, l, lanf, lhor, lver, k, kend, min
	double precision din,work
c
c        factorize given matrix by means of subroutine mfsd
c        a = transpose(t) * t
      call mfsd(a,n,eps,ier)
      if(ier) 9,1,1
c
c        invert upper triangular matrix t
c        prepare inversion-loop
    1 ipiv=n*(n+1)/2
      ind=ipiv
c
c        initialize inversion-loop
      do 6 i=1,n
      din=1.d0/dble(a(ipiv))
      a(ipiv)=din
      min=n
      kend=i-1
      lanf=n-kend
      if(kend) 5,5,2
    2 j=ind
c
c        initialize row-loop
      do 4 k=1,kend
      work=0.d0
      min=min-1
      lhor=ipiv
      lver=j
c
c        start inner loop
      do 3 l=lanf,min
      lver=lver+1
      lhor=lhor+l
    3 work=work+dble(a(lver))*dble(a(lhor))
c        end of inner loop
c
      a(j)=-(work*din)
    4 j=j-min
c        end of row-loop
c
    5 ipiv=ipiv-min
    6 ind=ind-1
c        end of inversion-loop
c
c        calculate inverse(a) by means of inverse(t)
c        inverse(a) = inverse(t) * transpose(inverse(t))
c        initialize multiplication-loop
      do 8 i=1,n
      ipiv=ipiv+i
      j=ipiv
c
c        initialize row-loop
      do 8 k=i,n
      work=0.d0
      lhor=j
c
c        start inner loop
      do 7 l=k,n
      lver=lhor+k-i
      work=work+dble(a(lhor))*dble(a(lver))
    7 lhor=lhor+l
c        end of inner loop
c
      a(j)=work
    8 j=j+k
c        end of row- and multiplication-loop
c
    9 return
      end


	integer function substr(ar1,ar2)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this subroutine transfers the contents of ar1 to
c  ar2 up to
c  1. either maximum length of one of the tw0 strings
c  2. first occurence of a space or a comma
c  and shifts the rest of ar1 to the begin
c  substr returns of the last character transfered
c  10.09.86  f.riess
c----------------------------------------------------------------------
	implicit none
	character*(*) ar1,ar2
	integer i, j, l, len, lj, lenar1, lenar2
	lenar1 = len(ar1)
	lenar2 = len(ar2)
	i=min(lenar1, lenar2)
	substr=0
	ar2=' '
	if(i.gt.0)then
	  do j=1,i
	    if(ar1(j:j).eq.' ' .or. ar1(j:j).eq.',') then
	      if(j.gt.1 .and. substr.gt.0)then
		do l=1,lenar1
	          lj=l+j
		  if(lj.le.lenar1)then
	            ar1(l:l)=ar1(lj:lj)
	          else
	            ar1(l:l)=' '
	          end if
	        end do
	        return
	      end if
	    else
	      substr=substr+1
	      ar2(substr:substr)=ar1(j:j)
	    end if
	  end do
	end if
	return
	end


	real*8 function xp(n,x)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c----------------------------------------------------------------------
	implicit none
	integer n
	real*8 x
	integer i, m
	xp=1.d+00
	if(n.gt.1) then
	  m=n-1
	  do i=1,m
	    xp=xp*x
	  end do
	end if
	return
	end
