/*
   $Id: gasuti.c,v 2.11 2004/07/25 16:07:20 friedrich Exp $

 this file containes the routines 
   date
   time
   ran
   istext
   getdouble
   labelstring_
   equalexp 
   sleep_

   F. Riess, march 1996
*/

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>

int istext(char *);

/*
   date_(char *date, int arraylength)
   returns the date in datum in the form

     dd-Mon-yyyy
*/

void date_(char *datum, int laenge)
{
  char ptr[40];
  time_t zeit;
  int i;

  if(laenge < 11) return;
  time(&zeit);
  strncpy(ptr, ctime(&zeit), 39);
  ptr[7] = ptr[10] = ptr[24] = '\0';
  sprintf(datum, "%s-%s-%s", &ptr[8], &ptr[4], &ptr[20]);
  for(i = 11; i < laenge; ++i) datum[i] = ' ';
}

/* time(char *daytime, int length)
   returns the current time in the form
   hh:mm:ss
*/

void time_(char *daytime, int laenge)
{
  time_t zeit;
  int i;

  if(laenge < 8) return;
  time(&zeit);
  strncpy(daytime, ctime(&zeit)+11, 8);
  for(i = 8; i < laenge; ++i) daytime[i] = ' ';
}

double ran_(void)
{
  static time_t zeit = 0;
  
  if(zeit == 0)
  {
    time(&zeit);
    srand48((int) zeit);
  }
  return (drand48());
}


double erfc_(double *x)
{
  return(erfc(*x));
}



/*  int istext(char *text)

    routine to check if a string is a text string or a number string
    it returns 1 if a text string is idendified
               0 otherwise

    a non text string is a string consisting of numbers:
       a sequence of digits [seperated by a delimiter]:  122 23 33
       a sequence of digits with a dot: .122 2.3 33.
       a sequence of digits preceeded by a sign: +122 +.23 -0.33
       a sequence of digits with an e, E, d, D:  +.23e-00 -1.23E+03 1.23d5 -1.25D-7
  
    delimiters are spaces, tabs, return or a comma if preceeded by a digit
    i.e. 1234,5.6e+7   etc

    important note:
    1. the routine scanf and its derivatives does not accept commas as delimiter.
       convert commas to spaces before calling sscanf:
       for(i = 0; text[i]; ++i) if(text[i] == ',') text[i] = ' ';
    2. the routine scanf and its derivatives does not accept the d- or D-Format.
       convert d's to e's before calling sscanf:
       for(i = 0; text[i]; ++i) 
         if(text[i] == 'd' || text[i] ='D') text[i] = 'e';
 
    F. Riess August 1994, revised Jan. 2000
*/

int istext_(char *str, int length)
{
  int i, lengthc;
  char strc[201];

  lengthc = length < 200 ? length : 200;
  for(i = 0; i < lengthc; ++i) strc[i] = str[i];
  for(i = lengthc - 1; i > 0; --i)
    if(str[i] != ' ') break;
  strc[i+1] = '\0';
  return (istext(strc));
}


int istext(char *str)
{
  char *pstr;
  int was_digit, was_sign, was_dot, was_e, text_flag;
  int number, number_tot, sign, dot, e;

  was_digit = was_sign = was_dot = was_e = text_flag = 0;
  number = number_tot = sign = dot = e = 0;
  for(pstr = str; *pstr && !text_flag; ++pstr)
  {
    switch(*pstr)
    {
      case '0':;
      case '1':;
      case '2':;
      case '3':;
      case '4':;
      case '5':;
      case '6':;
      case '7':;
      case '8':;
    case '9': /* if(was_e) text_flag = 1; */
                was_digit = 1;   ++number;    ++number_tot;
                was_sign = was_dot = was_e = 0;
                break;
      case '.': if(dot || was_e) text_flag = 1;
                was_dot = 1;     ++dot;
                was_digit = was_sign = was_e = 0;
                break;
      case '+': ;
      case '-': if(was_sign || was_digit || was_dot) text_flag = 1;
                was_sign = 1;    ++sign;
                was_digit = was_dot = was_e = 0;
                break;
      case 'D': ;
      case 'd': ;
      case 'E': ;
      case 'e': if(!(was_digit || (was_dot && number))) text_flag = 1;
                was_e = 1;       ++e;
                was_digit = was_sign = was_dot = 0;
                break;
      case ',': if(!(was_digit || (was_dot && number))) text_flag = 1;
      case '\t': ;
      case '\n': ;
      case '\r': ;
      case '\v': ;
      case '\f': ;
      case ' ': if(was_e || was_sign || e > 1 || dot > 1 || sign > 2 ||
                   (sign == 2 && !e)) text_flag = 1; 
                was_digit = was_sign = was_dot = was_e = 0;
                number = sign = dot = e = 0;
                was_dot = was_e = was_sign = was_digit = 0;
                break;
      default: text_flag = 1;
    }
  }
  if(!number_tot) text_flag = 1;
  return text_flag;
}
  
/*  int gasdouble(char *string, double *val, int *error)

    decodes the variables in string:
    on each successive call to gasdec the next value is return
    until the list in string is exhausted.

    On a success the return value will be -1
    0 otherwise

  Fortranaufruf:  i = gasdouble(string, value, error)

   F. Riess, May 1993
*/

int getdouble(char *string, double *value, int *ioerror)
{
  static char *stra = (char *) 0, *str;
  int flag;
 
  if(stra == (char *) 0) stra = string;
  else stra = ++str;
  for(flag = -1, str = stra; *str; ++str)
  {
    if(*str == ' ' && flag) continue;  /* ignore leading spaces */
    if((*str == ',' || *str == ' ' || *str =='\n' || *str == '\t') && flag == 0) break;
    if(isdigit((int) *str)) flag = 0;
  }
  flag = *str == '\0' ? 0 : -1;
  *str = '\0';
  if((*ioerror = sscanf(stra, "%lf", value) - 1) != 0) flag = 0;
  if(flag == 0) stra = (char *) 0;
  return flag;
}
/* Fortran interface */
  
int gasdouble_(char *string, double *value, int *ioerror, int length)
{
  int getdouble(char *, double *, int *);
  char str[140];
  int i;
  for(i = 0; i < length; ++i)
    str[i] = string[i];
  str[length] = '\0';
  return getdouble(str, value, ioerror);
}


/*
  int labelstring_(double *x, double *dx, double *xmax, int *mode, char *string, int length)

  converts the floating point number *x into string with a precision given by *dx.
  xmax might be needed by exponential representaions with equal exponent.

  double *x      : number to be converted
  double *dx > 0 : give precision  of *x
             <= 0 : copy rest from internal string
  double *xmax   : garantee a unique represention for all *x < *xmax
  int *mode < 0  : eponential representation y *10^nn
            == 0 : pure exponential 10^*x
            > 0  : maximum number of characters in string
  char *string   : character array
  int length     : length of string

  return value   : number of characters in string

  the routine is Fortran callable
  F. Riess, Juli 2004
*/


int labelstring_(double *x, double *dx, double *xmax, int *mode, char *string, int stringlen)
{
  int i, stellen, zeichen = 0;
  double y, dy;
  char format[10], text[100], *ptr;
  static char save[100] = "";

  if(*dx <= 0.)
  {
    zeichen = strlen(save);
    ptr = save;
  }
  else
  {
    ptr = text;
    if(fabs(*x/ *dx) < 1.e-5) zeichen = sprintf(text, "0");
    else
    {
      if(*mode == 0)
      {
        if(*x >= 0) zeichen = sprintf(text, "10^%02d", (int) (*x + 0.1));
        else        zeichen = sprintf(text, "10^%03d", (int) (*x - 0.1));
      }
      else
      {
        dy = *dx;
        *save = '\0';
        stellen = 0;
        while(dy < 1.) { dy *= 10.; ++stellen; }
        if(*mode > 0)
        {
          sprintf(format, "%%.%df", stellen);
          zeichen = sprintf(text, format, *x);
        }
        if(*mode < 0 || (*mode > 0 && zeichen >= *mode))
        {
          y = floor(log10(fabs(*xmax)));
          dy = *x  * pow(10., -y);
          stellen =  y - floor(log10(*dx));
          if(*mode < 0 || stellen < 2)
          {  
            sprintf(format, "%%.%df*10^%%.0f", stellen);
            zeichen = sprintf(text, format, dy, y);
          }
          else if(stellen >= 2)
          {
            if(stellen > *mode - 2) stellen = *mode - 2;
            sprintf(format, "%%.%df", stellen);
            zeichen = sprintf(text, format, dy);
            sprintf(save, "*10^%.0f", y);
          }
        }
      }
    }
  }
  if(zeichen > stringlen) zeichen = stringlen;
  for(i = 0; i < zeichen; ++i) string[i] = ptr[i];
  return zeichen;
}

/*  char *equalexp(double x, double dx, int digits, char *between)

     generates and returns an ascii string which
     containes the data of x and dx with  digits precision
     (digits = 1,2,3)) for darea in exponential format.
     the corresponding digits are output for area.
     between is a string wich will be inserted on output
     between x and dx 
     on return: NULL if an error ocured (wrong digit number etc)

   Friedrich Riess, Nov. 2002
*/


char form[132];
char *equalexp(double xx, double dxx, int digits, char *between);

char *equalexp(double xx, double dxx, int digits, char *between)
{
  int count;
  char vorz;
  double x, dx, dxmin, dxmax;

  if(digits > 6 || digits < 1)
  {
    fprintf(stderr, "--> calling equalexp with illegal digit number (%d)\n", digits);
    return NULL;
  }
  if(dxx == 0.)
  {
    sprintf(form, "%16.8e %s     0.e+00 ", xx, between);
  }
  else
  {
    x = xx;
    dx = fabs(dxx);
    dxmax = pow(10., (double) digits) - 0.5;
    dxmin = pow(10., (double) (digits-1)) - 0.5;
    count = 0;
    while(dx > dxmax)
    {
      dx /= 10.;
      x /= 10.;
      ++count;
    }
    while(dx < dxmin)
    {
      dx *= 10.;
      x *= 10.;
      --count;
    }
    vorz = '+';
    if(count < 0)
    {
      vorz = '-';
      count = -count;
    }
    if(count == 0)
    {
      sprintf(form, "%11.0f.     %s%6.0f.     ", xx, between, dxx);
    }
    else
    {
      if(dxx < 0.) dx = -dx;
      sprintf(form, "%11.0f.e%c%2.2d %s%6.0f.e%c%2.2d ", x, vorz, count, between, dx, vorz, count);
    }
  }
  return form;
}

/* Fortran interface
   the fortran routine returns 0 if x is zero in the
   given precision and the number of digits if non zero
 */


int equalexp_(double *x, double *dx, int *digits, int *pm, char *form, int formlength)
{
  char *ff, between[6];
  int i, j, nodot;
  if(*pm)
  {  
    if(*digits >= 3) strncpy(between, "+/- ", 5);
    else             strncpy(between, "+/-", 4);
  }
  else strncpy(between, " ", 2);
  ff = equalexp(*x, *dx, *digits, between);
  for(i = j = 0, nodot = -1; ff[i] && i < formlength; ++i)
  {
    form[i] = ff[i];
    if(nodot < 0 && ff[i] >= '0') nodot = 0;
    if(nodot == 0 && (ff[i] == '.' || ff[i] == ' ')) nodot = 1;
    if(nodot == 0)
    {
      if(j > 0 && ff[i] >= 0) ++j;
      if(j == 0 && ff[i] > '0') ++j;
    }
  }
  form[i] = '?';
  for(++i; i < formlength; ++i)  form[i] = ' ';
  return j;
}


/*
   sleep_ makes the C_routine sleep available to Fortran calls
 */

void sleep_(int *seconds)
{
  sleep(*seconds);
  return;
}


#ifdef OLD
/* int istext(char *str)
   this routine determines if a line is a text line or if it consist
   of numbers.
   The following combinations count as numbers:
    +<any number>
    -<any number>
    <any number>.
    .<any number>

   not accepted as numbers are
   +.<any number>
   -.<any number>

   Note: a line with a single dot is regarded as number
         Empty lines are regarded as text lines

   return value:  1:  line is a text line
                  0:  line is a number line

  F. Riess , Juli 1993
*/

int istext(char *str)
{
  int text, flag, plu, mis, dot;
  char *pstr;
 
  if(strlen(str) == 0) return 1;
  if(*str == '\n') return 1;

  dot = plu = mis = 0;
  flag = text = 0;  
  for(pstr = str; *pstr && !text; ++pstr)
  {
    if(*pstr == ' ' || *pstr == '\t' || *pstr == '\n') continue;
    if((dot = (*pstr == '.' || dot ? ++dot : 0)) == 1)
    {  
      if(flag) dot = 0;
      continue;
    } 
    if((plu = (*pstr == '+' || plu) ? ++plu : 0) == 1) continue;  
    if((mis = (*pstr == '-' || mis) ? ++mis : 0) == 1) continue;  
    if((flag = !isdigit((int) *pstr))) dot = plu = mis = 1;
    if(dot > 2 || plu > 2 || mis > 2) text = 1;
    if(!flag) plu = mis = dot = 0;
    text += flag;
  }
  if(plu || mis) text = 1;
  return text;
}
#endif
