/* $Id: readdaterr.c,v 1.5 2003/08/23 22:22:55 friedrich Exp $
   This routine reads spectra in the dat format which is an ascii format
   with one of the following numbers per line:

   for one dimensional spectra:
   1.  channel_contents  contents_error
   2.  channel_number    channel_contents  contents_error
   3.  channel_number    subspectrum#      channel_contents  contents_error

   subspectra must be seperated in case 1 or 2 by text lines but
   no text lines between subspectra are allowed  in case 3
   subspectrum numbers start with 1
   subspectrum 0 - if existant - can not be accessed 

   spectra are assumed to start with channel 0 
      if no channel number is defined

   channel 0 will be ignored in any case

  int readdaterr(
     char *filename:  Filename of Spectrum. If Filename ends with .Z, it
                      will be assumed, that the file is compressed. 
                      An uncompressed file is generated under /usr/tmp
                      and used for reading. This file will be deleted
                      with a subsequent calls with an other filename. 
    int subspectrum:  Number of the subspectrum.
    double *spectrum:  Array of the spectrum. Must have length of at least
                      ende - begin + 1
    double *specerror: Array of the error of the spectrum. Must have length of at least
                      ende - begin + 1
    int begin:        begin of the Spectrum
    int ende:         end of the spectrum
    int header:       if non zero: print header lines to stdout
    )

    Version: $Id: readdaterr.c,v 1.5 2003/08/23 22:22:55 friedrich Exp $

    return value:
    0 if the file is not found or if there was an error during reading
   <0 negativ value of last subspectrum if subspectrum does not exist
   >0 ende or last channel in the spectrum if ende is greater than 
      the last channel
 
   F. Riess, February 2000
*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>

#define ERRMESS "--> readdat:"
#define BUFSIZE 4096

int readdaterr(char *, int, double *, double *, int, int, int);
int istext(char *);

int readdaterr(char *filename, int subspectrum, double *spectrum, double *specerror, 
                            int begin, int ende, int header)
{
  int i, j, file_end = 0, numbers_per_line, dataflag;
  int channel = 0, buffersize = 0;
  double buff[5], value, error;
  static char filetmp[L_tmpnam > 130 ? L_tmpnam : 130] = "";
  static char fileold[130] = " ", str[131];
  static int compressed = 0, filesub = -1, spectrumsize;
  static FILE *fp = NULL;
  static double *data = NULL, *dataerror = NULL;
    
/* check if file has already been accessed */
  
  if(strcmp(fileold, filename))
  {
    if(fp)
    {
      fclose(fp);
      fp = NULL;
      if(compressed) (void) unlink(filetmp);
      compressed = 0;
    }     
    j = strlen(filename) - 1;
    if(!strcmp(&filename[j-1], ".Z")) j = 0;
    else if(!strcmp(&filename[j-2], ".gz")) j = -1;
    if(j > 0)
      strcpy(filetmp, filename);
    else
    { 
      strcpy(filetmp, "/tmp/gspdaterrXXXXXX");
      j = mkstemp(filetmp);
      if(j < 0) return 0;
      close(j);
      compressed = 1;
      if(access(filename, 00) == -1) return 0;
      sprintf(str, "zcat %s > %s\n", filename, filetmp);
      system(str);
    }
    if((fp = fopen(filetmp, "r")) == (FILE *) 0)  return 0;
    strcpy(fileold, filename);
    file_end = 0;
    filesub = -1;
    *str = '\0';
  }
/* the file is open check for the subspectrum */
/* Note: subspectra start with 1 */
  if(filesub > subspectrum || fp == NULL)
  {
    if(fp) { fclose(fp); fp = NULL; }
    if((fp = fopen(filetmp, "r")) == (FILE *) 0)  return 0;
    file_end = 0;
    filesub = -1;
    spectrumsize = 0;
    *str = '\0';
  }
  if(!(spectrumsize > 0 && filesub == subspectrum))
  {
    spectrumsize = 0;
    buffersize = 0;
    channel = -1;
    if(data) free(data);
    data = NULL;
    if(dataerror) free(dataerror);
    dataerror = NULL;
    numbers_per_line = 0;
    dataflag = 1;
/* read spectrum header */
    for(;;)
    {    
      if(!*str)
      {
        if(fgets(str, 130, fp) == NULL) file_end = 1;
      }
      if(file_end) break;
      if(istext(str))
      {
        if(data) break;
        if(dataflag)
        {
          if(filesub == subspectrum) break;
          dataflag = 0;
          channel = -1;
          if(numbers_per_line < 5) ++filesub;
        }
        if(header && (filesub < 1 || filesub == subspectrum )) fprintf(stdout, "%s", str);
      }
      else
/* get data and put spectrum into an array, if correct subspectrum  */
      {
        dataflag = 1;
/* replace d-format by e-format */
        for(j = 0; str[j]; ++j)
          if(str[j] == 'd' || str[j] == 'D')  str[j] = 'e';
        numbers_per_line = sscanf(str, "%lf %lf %lf %lf %lf",
                             &buff[0], &buff[1], &buff[2], &buff[3], &buff[4]);
        switch(numbers_per_line)
        {
          case 2:  if(filesub < 1) filesub = 1;
	           error = buff[1];
	           value = buff[0];
                   ++channel;
                   break;
          case 3:  if(filesub < 1) filesub = 1;
                   error = buff[2];
                   value = buff[1];
                   channel = buff[0] + 0.1;
                   break;
          case 4:  error = buff[3];
                   value = buff[2];
                   filesub = buff[1] + 0.1;
                   channel = buff[0] + 0.1;
                   break;
          default: fprintf(stderr, "%s Spectrum %s not in dat-format\n", ERRMESS, filename);
	           fclose(fp);
                   fp = NULL;
                   *fileold = '\0';
                   return 0;
	}
        if(subspectrum == filesub)
	{
          if(spectrumsize < channel) spectrumsize = channel;
          while(spectrumsize >= buffersize)
          { 
            i = buffersize;
            buffersize += BUFSIZE;
            if((data = (double *) realloc(data, buffersize * sizeof(double))) == NULL)
            {
              fprintf(stderr,"\07-> can not allocate buffer for reading data file\n");
              return 0;
            }
            if((dataerror = (double *) realloc(dataerror, buffersize * sizeof(double))) == NULL)
            {
              fprintf(stderr,"\07-> can not allocate buffer for reading data file\n");
              return 0;
            }
            for(j = i; j < buffersize; ++j) data[j] = 0.;
            for(j = i; j < buffersize; ++j) dataerror[j] = 1.;
          }
          data[channel] = value;
          dataerror[channel] = error;
        }
        else if(subspectrum < filesub)
        {
          if(spectrumsize) filesub = subspectrum;
          break;
	}
      }
      *str = '\0';
    }
    if(file_end && filesub != subspectrum)
    {
      fclose(fp);
      fp = NULL;
      return (-filesub);
    }
  }
/* Spectrum is in buffer, transfer it to extern buffer */
  if(ende >= spectrumsize) ende = spectrumsize;
  j = begin;
  for(i = 0; i <= (ende - begin); ++i, ++j)
  {
    spectrum[i] = data[j];
    specerror[i] = dataerror[j];
  }
  return ende;
}  


/* Fortran interface */
int readdaterr_(char *fi, int *su, double *sp, double *sperr, int *be, int *en, int *header, int fl)
{
  char file[130];
  int i;

  for(i = 0; i < fl; ++i)
  {
    file[i] = fi[i];
    if(fi[i] == ' ') break;
  }
  file[i] = '\0';
  i = readdaterr(file, *su, sp, sperr, *be, *en, *header);
  return i;
}
