/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  $Id: gascdc.h,v 2.32 2005/03/23 11:40:34 friedrich Exp friedrich $
  Table of commands for gaspan as interpreted by the
  program gascmd
  The general structure of a command follows the
  VAX-VMS Command Language Interpreter:
    command subcommand -option -option=value
  or
    command value
  commands+subcommands and options can be abreviated
  as long as they are unique. Note that the possibility
  of abbreviations and check for uniqness holds for the
  combination of commands and subcommands differing from VMS.
  Note: command, subcommand and options must be seperated by spaces
  Author:      Friedrich Riess
  Beginn:      06.04.1990
  Aenderung:   10.12.90: set dis -hold -nohold -out=device
  Aenderung:   20.01.92: Pfad fuer help Datei
               29.02.00: set fit -priority eliminated
               02.03.00: go and fit are now different
---------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#define NOPTION 30             /* Maximum number of options */

typedef struct { char *command;
                 char *subcommand;
                 char *option[NOPTION];
                 void (*function)(void);
               } BEFEHL;

/* complete filenames of help file, including path */
/* the last line is overwritten with the set file -help - command */
#define HELPN 4
#define HELPL 120
char helpfilepfad[HELPN][HELPL] = {{"gaspan.hlp"}, {"./gaspan.hlp"},
                                    {"/tmp/gaspan.hlp"}, {"gaspan.hlp"}};

void gasexit_(void), calgspfile_(void), genfile_(void), getoptions_(void),
     getparameter_(void), go_(void), limits_(void), makefit_(void), saveoptions_(void),
     saveparameters_(void), setdisplay_(void), setfiles_(void),
     setfit_(void), setregion_(void), setparameters_(void),
     setpeak_(void), setstatistics_(void), settail_(void), setbackgr_(void),
     setwidth_(void), showerror_(void), showfit_(void), showoptions_(void), showsafit_(void),
     showparameters_(void), showspectrum_(void), showversion_(void), shownews(void),
     showsample_(void), testspec_(void), testprint_(void);
void exec_command(void), help_command(void);

BEFEHL command[] =
       {
	 { "calibrate", "",           {""}, calgspfile_
	 },
	 { "do",        "",           {""}, exec_command
	 },
	 { "exit",      "",           {""}, gasexit_
	 },
	 { "fit",       "",           {""}, makefit_
	 },
	 { "generate",  "",           {""}, genfile_
         },
	 { "get",       "options",    {""}, getoptions_
         },
	 { "get",       "parameters", {""}, getparameter_
         },
	 { "go",        "",           {""}, go_
	 },
	 { "help",      "",           {""}, help_command
	 },
	 { "quit",      "",           {""}, gasexit_
	 },
	 { "save",      "options",    {""}, saveoptions_
	 },
/*	 { "save",      "parameters",  {""}, saveparameters_
         },
*/
         { "set", "background",
           { "fit",
             "fixed=(%f)",
             "nofit=(%f)",
             "nofixed",
	     "max_polynomial_degree=(%d)",
	     "polynomial_degree=(%d)",
             ""
           },
	   setbackgr_
         },
         { "set", "display",
           { "centroid",
             "channels",
             "comment=(%s)",
             "energy",
             "errorbar",
             "gauss-position",
             "histogram",
             "hold",
             "intermediate",
             "linear",
             "logarithmic",
             "noerrorbar",
             "nohold",
             "nointermediate",
             "noresiduum",
             "nosaveall",
             "nosingle_peak",
             "off",
             "on",
             "print=(%s)",
             "residuum",
             "saveall=(%s)",
             "single_peak",
             "tail_include",
             "windowsize=(%f,%f)",
             "yscale=(%f,%f)",
             ""
           },
	   setdisplay_
         },
	 { "set", "files",
           {"file=(%s,%d,%d,%d)",
	    "format=(%s)",
            "helpfile=(%s)",
            "matrix",
            "single_spectrum",
            ""
           },
	   setfiles_
         },
         { "set", "fit",
           {"background",
            "interactive",
            "nobackground",
            "nointeractive",
            "noout",
            "noprintout",
            "noresidue_search",
            "nosave",
            "out",
            "printout",
	    "region=(%d,%d)",
            "residue_search",
            "save",
            ""
           },
	   setfit_
         },
	 { "set", "parameters",
	   {"all_check",
            "background_tail=(%f,%f,%f,%f,%f,%f)",
            "check",
	    "efficiency=(%f,%f,%f,%f,%f,%f,%f,%f)",
	    "energy=(%f,%f,%f,%f,%f,%f)",
            "extended_check",
            "full_check",
	    "left_peak_tail=(%f,%f,%f,%f,%f,%f)",
	    "nocheck",
	    "polynomial_degree=(%d)",
	    "right_peak_tail=(%f,%f,%f,%f,%f,%f)",
            "step=(%f,%f,%f)",
            "width=(%f,%f,%f,%f,%f,%f)",
	    ""
           },
	   setparameters_
         },
         { "set", "peak",
	   { "append",
             "common",
             "efficiency=(%s)",
             "energy=(%s)",
             "fit",
             "include_background_tail",
             "individual",
             "list=(%s)",
             "noappend",
             "nocommon",
             "noefficiency",
             "noenergy",
             "nofit",
             "noinclude_background_tail",
             "nolist",
	     "noindividual",
             "search",
	     ""
           },
	   setpeak_
         },
         { "set", "region",
	   { "fit=(%d,%d)",
	     "list=(%s)",
             "nolist",
             "search",
             ""
           },
	   setregion_
         },
         { "set", "statistics",
	   {"allpeaks",
            "noallpeaks",
            "nosmooth_error",
            "nostandard",
	    "sensitivity=(%s)",
            "smooth_error",
            "standard", 
	    ""
           },
	   setstatistics_
         },
         { "set", "tail",
	   { "all",
	     "background_tail=(%f)",
             "enforce_fit",
	     "fit=(%s)",
             "gamma",
	     "include",
             "left_peak_tail=(%f)",
             "nobackground_tail",
             "noenforce_fit",
             "nofit=(%s)",
             "noinclude",
             "noleft_peak_tail",
             "none",
             "noright_peak_tail",
             "nostep",
	     "right_peak_tail=(%f)",
             "step",
	     ""
           },
	   settail_
         },
         { "set", "width",
	   {"calibrate=(%s)",
            "common",
            "individual",
	    "list",
            "nocalibrate",
            "nocommon",
            "noindividual",
            "nolist",
	    "range=(%f)",
            "value=(%f)",
	    ""
           },
	   setwidth_
         },
	 {"show", "error",     {""},  showerror_
	  },
	 {"show", "fit",       {""},  showfit_
         },
	 {"show", "limitations",       {""},  limits_
         },
	 {"show", "news",  {""},   shownews
         },
	 {"show", "option",    {""},  showoptions_
         },
	 {"show", "parameter", {""},  showparameters_
         },
	 {"show", "SAMPLE",  {""},  showsample_
         },
	 {"show", "saved_fits", {""},  showsafit_
         },
	 {"show", "spectrum",  {""},  showspectrum_
         },
	 {"show", "version",  {""},   showversion_
         },
	 {"test", "spectrum", {""},   testspec_
	 },
	 {"test", "printout", {""},   testprint_
         },
         {"", "", {""}, showversion_
         }
       };
