/* $Id: readdat.c,v 2.10 2003/08/23 22:22:26 friedrich Exp $
   This routine reads spectra in the dat format which is an ascii format
   with one of the following numbers per line:

   for one dimensional spectra:
   1.  channel_contents
   2.  channel_number    channel_contents
   3.  channel_number_x  channel_number_y  channel_contents

   the subspectrum number must be 1 in the first two cases
   in the third case, the subspectrum number corresponds to the
   channel_number_y.
   Multiple spectra in one file are allowed in the cases 1 and 2, the spectra
   must be separated by textlines.

  int readdat(
     char *filename:  Filename of Spectrum. If Filename ends with .Z, it
                      will be assumed, that the file is compressed. 
                      An uncompressed file is generated under /usr/tmp
                      and used for reading. This file will be deleted
                      with a subsequent calls with an other filename. 
    int subspectrum:  Number of the subspectrum.
    double *spectrum:  Array of the spectrum. Must have length of at least
                      ende - begin + 1
    int begin:        begin of the Spectrum
    int ende:         end of the spectrum
    int mode:         if unequal to 0: print text lines of the spectrum
    )
  return value:
    0 if the file is not found or if there was an error during reading
   <0 negativ value of last subspectrum if subspectrum does not exist
   >0 ende or last channel in the spectrum if ende is greater than 
      the last channel
  
   F. Riess, April 1993, revised Jan 2000
*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>

#define ERRMESS "--> readdat:"
#define BUFSIZE 4096

int readdat(char *, int, double *, int, int, int);
int istext(char *);

int readdat(char *filename, int subspectrum, double *spectrum, int begin, int ende, int header)
{
  int i, j, file_end = 0, numbers_per_line, dataflag;
  int channel, buffersize = 0;
  double buff[4], value;
  static char filetmp[130] = "";
  static char fileold[130] = " ", str[131];
  static int compressed = 0, filesub = 0, spectrumsize;
  static FILE *fp = NULL;
  static double *data = NULL;
    
/* check if file has already been accessed */
  
  if(strcmp(fileold, filename))
  {
    if(fp)
    {
      fclose(fp);
      fp = NULL;
      if(compressed) (void) unlink(filetmp);
      compressed = 0;
    }
    j = strlen(filename) - 1;
    if(!strcmp(&filename[j-1], ".Z")) j = 0;
    else if(!strcmp(&filename[j-2], ".gz")) j = -1;
    if(j > 0)
      strcpy(filetmp, filename);
    else
    { 
      strcpy(filetmp, "/tmp/gspdatXXXXXX");
      j = mkstemp(filetmp);
      if(j < 0) return 0;
      close(j);
      compressed = 1;
      if(access(filename, 00) == -1) return 0;
      sprintf(str, "zcat %s > %s\n", filename, filetmp);
      system(str);
    }
    if((fp = fopen(filetmp, "r")) == (FILE *) 0)  return 0;
    strcpy(fileold, filename);
    file_end = 0;
    filesub = -1;
    *str = '\0';
  }
/* the file might be open check for the subspectrum */
/* Note: subspectra start with 1 */
  if(filesub > subspectrum || fp == (FILE *) 0)
  {
    if(fp) fclose(fp);
    if((fp = fopen(filetmp, "r")) == (FILE *) 0)  return 0;
    file_end = 0;
    filesub = -1;
    spectrumsize = 0;
    *str = '\0';
  }
  if(!(spectrumsize > 0 && filesub == subspectrum))
  {
    spectrumsize = 0;
    buffersize = 0;
    channel = -1;
    if(data) free(data);
    data = NULL;
    numbers_per_line = 0;
    dataflag = 1;
/* read spectrum header */
    for(;;)
    {    
      if(!*str)
      {
        if(fgets(str, 130, fp) == (char *) 0) file_end = 1;
      }
      if(file_end) break;
      if(istext(str))
      {
        if(data) break;
        if(dataflag)
        {
          if(filesub == subspectrum) break;
          dataflag = 0;
          channel = -1;
          if(numbers_per_line < 3) ++filesub;
        }
        if(header && (filesub < 1 || filesub == subspectrum )) fprintf(stdout, "%s", str);
      }
      else
/* get data and put spectrum into an array, if correct subspectrum  */
      {
        dataflag = 1;
/* replace d-format by e-format */
        for(j = 0; str[j]; ++j)
          if(str[j] == 'd' || str[j] == 'D')  str[j] = 'e';
        numbers_per_line = sscanf(str, "%lf %lf %lf %lf",
                             &buff[0], &buff[1], &buff[2], &buff[3]);
        switch(numbers_per_line)
        {
          case 1:  if(filesub < 1) filesub = 1;
	           value = buff[0];
                   ++channel;
                   break;
          case 2:  if(filesub < 1) filesub = 1;
                   value = buff[1];
                   channel = buff[0] + 0.1;
                   break;
          case 3:  value = buff[2];
                   filesub = buff[1] + 0.1;
                   channel = buff[0] + 0.1;
                   break;
          default: fprintf(stderr, "%s Spectrum %s not in dat-format\n", ERRMESS, filename);
	           fclose(fp);
                   fp = NULL;
                   *fileold = '\0';
                   return 0;
	}
        if(subspectrum == filesub)
	{
          if(spectrumsize < channel) spectrumsize = channel;
          while(spectrumsize >= buffersize)
          { 
            j = buffersize;
            buffersize += BUFSIZE;
            if((data = (double *) realloc(data, buffersize * sizeof(double))) == NULL)
            {
              fprintf(stderr,"\07-> can not allocate buffer for reading data file\n");
              return 0;
            }
            for(; j < buffersize; ++j) data[j] = 0.;
          }
          data[channel] = value;
        }
        else if(subspectrum < filesub)
        {
          if(spectrumsize) filesub = subspectrum;
          break;
	}
      }
      *str = '\0';
    }
    if(file_end && filesub != subspectrum)
    {
      fclose(fp);
      fp = (FILE *) 0;
      return (-filesub);
    }
  }
/* Spectrum is in buffer, transfer it to extern buffer */
  if(ende >= spectrumsize) ende = spectrumsize;
  j = begin;
  for(i = 0; i <= (ende - begin); ++i, ++j)
  {
    spectrum[i] = data[j];
    /* printf(" %d %d %.0f\n", i, j, spectrum[i]); */
  }
  return ende;
}  


/* Fortran interface */
int readdat_(char *fi, int *su, double *sp, int *be, int *en, int *header, int fl)
{
  char file[130];
  int i;

  for(i = 0; i < fl; ++i)
  {
    file[i] = fi[i];
    if(fi[i] == ' ') break;
  }
  file[i] = '\0';
  i = readdat(file, *su, sp, *be, *en, *header);
  return i;
}
