	real*8 function gaschi(flambda, silent)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gaschi.f,v 4.6 2003/08/15 18:51:04 friedrich Exp $
c  this non linear fitting routine follows the routine curfit
c  written by phil bevington, but the matrix is a onedimensional
c  array making use of its symmetry
c  gaschi returns the new chisquare if everything was okay
c    the return value will be negativ, if the matrixinversion failed
c    the absolute value will be the culprit parameter of -1000 if
c    none has been found 
c  last change 29.01.93
c------------------------------------------------------------------
	implicit none

        integer TESTKANAL
        parameter (TESTKANAL = 0)  ! set to 0 (no output) 3 (into file FILEHIST)
        real*8 FLAMBDAMIN
	parameter (FLAMBDAMIN = 1.d-10)
        real*8 FLAMBDAMAX
	parameter (FLAMBDAMAX = 1.d+16)
        real*8 EPSILON
	parameter (EPSILON = 1.d-10)
        real*8 TINY
	parameter (TINY = 1.d-100)
        real*8 PRECISIONLIMIT
        parameter (PRECISIONLIMIT = 1.d-4)
        real*8 RMS0
        parameter (RMS0 = 1.e-4)
        real*8 OFFMAX, OFFLIM
        parameter (OFFMAX = 1.d-02)
        parameter (OFFLIM = 1.d-03)
        real*8 ROUNDING
        parameter (ROUNDING = 1.d+00 + 1.d-15)

	real*8 flambda
        logical silent
	include 'gasctr.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'

	logical isensw
	logical ncs(PARTOT), nct(PARTOT), lpas, lpas4, lpas16, testout
	integer i, ier, j, jc, kk, kk1, ktmp, l, lmax, m, n,
	1 nfree, nparc
	real*8 gasfun, parlim, invcheck, solve, voidfailure, parminus1
        integer listpar(PARTOT)
        logical restricted
	real*8 chis, chisqr, fy, wf, x, maxdev
        real*8 pars(PARTOT)
	real*8 array((PARTOT*(PARTOT+1))/2), ainverse((PARTOT*(PARTOT+1))/2)
	real*8 beta(PARTOT)
        lmax(j)=(j*(j+1))/2

        lpas = lpa .and. .not.silent
        lpas4 = isensw(4) .and. lpas
        lpas16 = isensw(16) .and. lpas
        lpas = lpas4 .or. lpas16
        testout = TESTKANAL.gt.0 .and. flambda.eq.0.
        testout = TESTKANAL.gt.0 .and. flambda.eq.0.
        testout = TESTKANAL.gt.0 .and. .not.silent
        testout = TESTKANAL.gt.0
	gaschi = 0.d+00
c save parameters and parameter control variables
	do j = 1,PARTOT
	  ncs(j) = .TRUE.
	  listpar(j) = 0
          errpar(j) = 0
	enddo
	l = 0
	do j = 1,npar
	  pars(j) = par(j)
	  ncs(j) = nc(j)
	  nct(j) = nc(j)
          if(.not.nc(j)) then
            l = l + 1
            listpar(l) = j
	  endif
	  beta(j) = 0.d+00
	enddo
c calculate matrix and array of linear equations
	l = lmax(npar)
 	do j = 1,l
	  varcovar(j) = 0.d+00
	enddo
	chisqr = 0.d+00
	x = minreg
	do i = 1,irange
	  fy = gasfun(x,npar)
	  yfa(i) = fy
	  fy = ya(i) - fy
	  chisqr = chisqr + fy*fy*weight(i)
	  jc = 0
	  l = 0
	  do j = 1,npar
	    if(.not.ncs(j)) then
	      jc = jc + 1
	      wf = deriv(j)*weight(i)
	      beta(jc) = beta(jc) + wf*fy
	      do kk = 1,j
	        if(.not.ncs(kk)) then
	          l = l + 1
	          varcovar(l) = varcovar(l) + wf*deriv(kk)
	        endif
	      enddo
	    endif
	  enddo
	  x = x + 1.d+00
	enddo  !  i = 1,irange
	nparc = jc
        if(lpas16) write(3, '('' GASCHI: starting chisquare:'',16x,g18.10,'' ('',e8.1,'')'')') 
     $        chisqr, flambda
c        if(lpas4) then
c          write(3,'(9x''parameter matching (only the last 30)'')')
c          write(3,'(9x,30i3)') (i, i = max(1, nparc - 29), nparc)
c          write(3,'(9x,30i3)') (listpar(i), i = max(1, nparc - 29), nparc)
c        endif
        gaschi = chisqr
c end of calculation of the matrix 
c no parameter to be varied: return right away
	if(nparc.le.0) then
	  return
	endif 
c check for the degree of freedom, return if 0 or negativ
	nfree = irange - nparc
	if(nfree.le.0) then
	  return
	endif
	chisqr = max(chisqr, EPSILON)
c calculate new parameters, do not allow chisqr to increase
	if(testout) then
          write(TESTKANAL,'(a,13(e12.4))') 'beta:', (beta(i), i = 1,nparc)
          write(TESTKANAL,'(''Variance-covariance matrix'')')
        endif
	chis = 1.1d+00 * chisqr
        chisqr = chisqr*ROUNDING
	do while(chisqr.lt.chis)
	  l = 0
	  do j = 1,nparc
	    do kk = 1,j
	      l = l + 1
	      array(l)  =  varcovar(l)
	      ainverse(l) = array(l)
              if(testout .and. kk.lt.j) write(TESTKANAL,'(e12.4$)') array(l) 
	    enddo
	    array(l) = varcovar(l) + flambda
            ainverse(l) = array(l)
            if(testout) write(TESTKANAL, '(e12.4)') array(l)
	  enddo 
c invert matrix note: ier = 0 does not mean that the inverse is okay
	  ier = -1
	  call dsinv(ainverse, nparc, EPSILON, ier)
	  if(lpas16 .and. ier.lt.0) then
            write(3,'(9x,''--> inversion of the matrix failed ('',d8.1'')'')') flambda
          endif
	  if(flambda.eq.0.d+00) then
            chis = 0.d+00
          else
	    if(ier.ge.0.) then 
c calculate change in the parameters
              do j = 1, nparc
                deriv(j) = beta(j)
              enddo
              maxdev = solve(array, ainverse, nparc, deriv, dpar)
c accept solution if maxdev is small enough
              if(lpas16) write(3, '(''       Precision of new parameters:'',e13.3$)') maxdev
              if(maxdev.gt.PRECISIONLIMIT) then
                if(lpas16) write(3, '('' --> parameters not accepted'')')
                chis = 1.1d+00*chisqr
              else
                do jc = 1, nparc
                  j = listpar(jc)
                  par(j) = par(j) + dpar(jc)
                enddo  
c control output and check of the new parameters
                restricted = .FALSE.
	        do i = 1,kpeaks 
                  restricted = restricted .or. abs(par(i)).gt.parlim(1.d+0)
	          par(i) = parlim(par(i))
	          par(i + kpeaks) = max(abs(par(i + kpeaks)), TINY)
	        enddo 
c restrict width parameters
	        kk1 = 2*kpeaks + 1
                restricted = restricted .or. abs(par(kk1)).gt.parlim(1.d+0)
	        par(kk1) = parlim(par(kk1)) 
c restrict tail parameters
	        if(tail)then
	          if(taill) then
	            ktmp = kk1 + 7
                    restricted = restricted .or. abs(par(ktmp)).gt.parlim(1.d+0)
	            par(ktmp) = parlim(par(ktmp))
	            par(ktmp-1) = max(abs(par(ktmp-1)), TINY)
	          endif
	          if(tailb) then
	            ktmp = kk1 + 9
                    restricted = restricted .or. abs(par(ktmp)).gt.parlim(1.d+0)
	            par(ktmp) = parlim(par(ktmp))
	            par(ktmp-1) = max(abs(par(ktmp - 1)), TINY)
	          endif
	          if(tailr) then
	            ktmp = kk1 + 11
                    restricted = restricted .or. abs(par(ktmp)).gt.parlim(1.d+0)
	            par(ktmp) = parlim(par(ktmp))
	            par(ktmp - 1) = max(abs(par(ktmp - 1)), TINY)
	          endif
                  if(lstep) par(kk1 + 12) = max(abs(par(kk1 + 12)), TINY)
	        endif 
c check if the peak positions are varied independently
	        if(posall) then
	          do j = 1,kpeaks
	            par(j) = par(1)
	          enddo
	        endif 
c control output
c calculate new chisqr
                x = minreg
	        chis = 0.d+00
	        do i = 1,irange
	          yfa(i) = gasfun(x,npar)
	          fy = ya(i) - yfa(i)
	          chis = chis +  fy*fy*weight(i)
	          x = x + 1.d+00
	        enddo
	        chis = max(chis, EPSILON) 
              endif    !  maxdev.gt.PRECISIONLIMIT
	    else  ! ier.ge.0
	      chis = 1.1*chisqr
	    endif   !  ier.ge.0              
c  if the fit did not improve, try again
	    if(chis.gt.chisqr) then
              if(lpas16) write(3, '('' --> fit does not improve'')')
	      do i = 1,npar
	        par(i) = pars(i)
                nc(i) = ncs(i)
	      enddo
	      flambda = 100.d+00*flambda
	      if(flambda.ge.FLAMBDAMAX) then
                chis = chisqr
	        gaschi = chis
                flambda = FLAMBDAMAX
	      endif
c  the fit did improve, decrease flambda
	    else
	      flambda = 0.1d+00*flambda
	      if(flambda.lt.FLAMBDAMIN) flambda = FLAMBDAMIN
	      gaschi = chis
              if(lpas16) then
                write(3, '('', new parameters'')')
                call gasfou(par,ncs,brv)
              endif 
	    endif    ! chis.gt.chisqr
          endif   !  flambda.eq.0 else
	enddo  ! while(chisqr.lt.chis)
c  if flambda = 0. the inversion has only to be done to get the
c  variance-covariance matrix
        if(flambda.eq.0.d+00 .and. .not.silent) then
c check the inverse matrix, maxdev is the maximum size of the
c offdiagonal elements
          do i = 1, npar
            nct(i) = nc(i)
          enddo
          if(lpas4) write(3,'('' GASCHI: result of matrix inversion, ier ='',i3$)') ier
          if(ier.eq.-1) then
            maxdev = OFFMAX + 1.d+00
            wf = OFFLIM + 1.d+00
            if(lpas4) write(3,'('' --> inversion failed'')')
          else
            maxdev = invcheck(varcovar, ainverse, nparc, wf, x)
            if(lpas4) write(3,'(/9x,''unity matrix: max offdiag''e14.4'', <offdiag> ''e14.4,
     $     '', <diag> =''f12.10)') maxdev, wf, x
          endif
          if(maxdev.gt.OFFMAX .and. wf.gt.OFFLIM) then
c  matrix has low quality try to rectify
            if(lpas4) write(3, '(9x''adding tiny value to one off the diagonal elements''$)')
            maxdev = voidfailure(varcovar, ainverse, nparc, wf, x, j)
            if(maxdev.gt.OFFMAX .and. wf.gt.OFFLIM) then
              if(lpas4) write(3, '('' --> failed''/9x''eliminating parameters from the matrix'')')
c failure to correct a diagonal element
c  try to find out the culprit parameter:
              n = nparc
              do i = 1, lmax(n)
                array(i) = varcovar(i)
              enddo
              jc = 0
              do while(maxdev.gt.OFFMAX)
                maxdev = parminus1(array, ainverse, n, OFFMAX, wf, x, kk)
                if(kk.gt.0) then
                  jc = jc + 1
                  j = listpar(kk)
                  errpar(jc) = j
                  nct(j) = .TRUE.
                  if(lpas4) call gaschim2(j, kpeaks)
                  do while(kk.lt.n)
                    listpar(kk) = listpar(kk + 1)
                    kk = kk + 1
                  enddo
                  listpar(kk) = 0
                  if(maxdev.gt.OFFMAX) then
                    if(lpas4) write(3, '('' --> failed'')')
                    n = n - 1
                    do i = 1, lmax(n)
                      array(i) = ainverse(i)
                    enddo
                  else
                    if(lpas4) write(3,'(x)')
                  endif
                else
                  if(lpas4) write(3,'(9x,''--> all attempts failed, all values without error'')')
                  ier = -1
                  maxdev = OFFMAX
                endif   ! kk.gt.0
              enddo     ! maxdev.gt.OFFMAX
              if(lpas4) write(3,'(9x,i3,'' parameters out of''i3,'' ignored''$)') jc, nparc
c              if(lpas4 .and. errpar(1).gt.0) then
c                write(3, '(9x''--> excluded parameter #:''$)')
c                j = 1
c                do while(errpar(j).gt.0)
c                  write(3, '(i4$)') errpar(j)
c                  j = j + 1
c                enddo
c                write(3, '(x)')
c              endif
              if(wf.gt.OFFLIM) wf = OFFLIM
            endif       ! maxdev.gt.OFFMAX .and. wf.gt.OFFLIM
            if(lpas4) write(3,'(/9x,''unity matrix: max offdiag''e14.4'', <offdiag> ''e14.4,
     $     '', <diag> =''f12.10)') maxdev, wf, x
	  endif  !        maxdev.gt.OFFMAX .and. wf.gt.OFFLIM
          ier = 0
	endif  !  flambda.eq.0. .and. .not.silent
c  end of calculation of new parameter
c  get variance covariance matrix
	if(ier.ge.0) then
c  get new variation logic
c	  do j = 1,npar
c	    nc(j) = nct(j)
c	  enddo
	  m = 0
	  n = 0
	  do j = 1,npar
	    do l = 1,j
	      m = m + 1
	      varcovar(m) = 0.d+00
	      if((.not.nct(j)) .and. (.not.nct(l))) then
	        n = n + 1
                varcovar(m) = ainverse(n)
	      endif
	    enddo
	    if(.not.nct(j)) then
	      dpar(j) = sqrt(abs(varcovar(m)))
	    else
	      dpar(j) = 0.d+00
	    endif
	  enddo
	endif
	return
	end

c        subroutine gaschiml(count, i, k)
c  gives error message if there is a repeated  loss in precision
c	implicit none
c	integer count, i, k
c	character message*40
c	integer ltext
c	call gaschim(i, k, message)
c	write(3, '(9x''--> ''I6'' losses in precision for parameter: '',a)') count,
c     $     message(:ltext(message))
c	end


c	subroutine gaschim1(i, k)
c  gives error message if there is a loss in precision
c	implicit none
c	integer i, k
c	character message*40
c	integer ltext
c	call gaschim(i, k, message)
c	write(3, '(9x,''--> loss in precision for parameter: '',a)') message(:ltext(message))
c	end


	subroutine gaschim2(i, k)
c  gives  message if matrix is non divergent on a certain parameter
	implicit none
	integer i, k
	character message*40
	integer ltext
	call gaschim(i, k, message)
	write(3, '(13x,''matrix inversion without parameter #''i3'' ('',a'')''$)') i, 
     $      message(:ltext(message))
	end


	subroutine gaschim(i, k, message)
c  extrahiert von i und j = kpeaks den aktuellen parameter
	implicit none
	integer i, k
	character *(*) message
	integer k2
        k2 = 2 * k
        if(i.le.k) then
          write(message, '(''position of peak '',i2)') i
	else if(i.le.k2) then
          write(message, '(''area of peak '',i2)') i - k
        else if(i.eq.k2 + 1) then
	  write(message, '(''width '')')
	else if(i.le.k2 + 6) then
	  write(message, '(''background coefficient a('',i1,'')'')') i-k2-2
	else if(i.eq.k2 + 7) then
	  write(message, '(''left tail amplitude'')')
	else if(i.eq.k2 + 9) then
	  write(message, '(''background tail amplitude'')')
	else if(i.eq.k2 + 11) then
	  write(message, '(''right tail amplitude'')')
	else if(i.eq.k2 + 13) then
	  write(message, '(''step amplitude'')')
	else if(i.eq.k2 + 8) then
	  write(message, '(''left tail decay constant'')')
	else if(i.eq.k2 + 10) then
	  write(message, '(''background tail decay constant'')')
	else if(i.eq.k2 + 12) then
	  write(message, '(''right tail decay constant'')')
	else
          write(message, '(''-->unknown parameter'')')
	endif
	end
