	subroutine gasfit
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasfit.f,v 4.20 2003/08/15 14:08:18 friedrich Exp $
c  this routine controlls the fitting procedure
c  it is only left if the specified fitting part of the spectrum
c  has been worked out.
c  new version 19.12.2002
c  f. Riess
c------------------------------------------------------------------
	implicit none

	integer MAXCYCLES, PCKCYCLES
	parameter (MAXCYCLES = 100)
        parameter (PCKCYCLES = MAXCYCLES - 30)
	integer WRITEID
	parameter (WRITEID = 7)

	character*(*) FFITCOEF
	parameter (FFITCOEF = '  -- coefficients:')
	character*(*) FFITGSP1
	parameter (FFITGSP1 = '(''GASPAN DATA SUMMARY FILE, file: ''a''-->''a)')
	character*(*) FFITGSP2
	parameter (FFITGSP2 = '(''   options set:'')')
	character*(*) FFITGSP6
	parameter (FFITGSP6 = '('' r-lines: fitregion, degree of background polynomial, errorcode, chisq/f'')')
	character*(*) FFITNIF
	parameter (FFITNIF  = '(5x,''no improvement in fit, terminated'')')
	character*(*) FFITREG
	parameter (FFITREG='(/a,'' region '',i7,'' -'',i7)')
	character*(*) FFITPEA
	parameter (FFITPEA='(9x,''peaks at'',10f9.1,x,2(/17x,10f9.1))')
	character*(*) FFITNTN
	parameter (FFITNTN='(9x,''statistical significance'', f8.2)')
	character*(*) FFITTIN
	parameter (FFITTIN='(9x,''tail parameter included in variation'')')
	character*(*) FFITTCO
	parameter (FFITTCO='(9x,''tail parameter kept constant'')')
	character*(*) FFITERROR
	parameter (FFITERROR=' -->GASFIT: Error in opening output file: ')
	character*(*) FFITPP
	parameter (FFITPP='('' GASFIT: peak positions:   '',10f9.1,x,
	12(/27x,10f9.1))')
	character*(*) FFITVR
	parameter (FFITVR='(''         peak-range:'',1f7.1)')
	character*(*) FFITWR
	parameter (FFITWR='(''         fwhm-range:'',1f7.1)')
	character*(*) FFITPW
	parameter (FFITPW='('' GASFIT: peak widths:      '',10f9.1,x,
	12(/27x,10f9.1))')
	character*(*) FFITVF
	parameter (FFITVF='(''         fwhm fact.: '',10(f6.1,5x),
	12(/16x,10f11.1))')
	character*(*) FFITTR
	parameter (FFITTR='(''         tail decay:       '',10f9.1)')
	character*(*) FFITCHT
	parameter (FFITCHT='(a,'' cycle''i5'', chisq =''g12.4'', chisq/f ='',g12.4,i6,
     $              '' iterations'')')
        character*(*) FITFORM0
        parameter (FITFORM0 = '(f10.0,3x,g18.8)')


	include 'gasctr.icl'
	include 'gasdis.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
	include 'gaspea.icl'
	include 'gastxt.icl'

	logical gasber, gasfck, gasres, gaspck, cancelfit, isensw, disinit
	integer addcomma, ltext, filemain
	real*8 gasstp, gasfun, gaschi
	logical rep, fit, pckcheck
	character txtime*8, fildum*40, fildummy*40, speentry*4
	integer cycles, i, ios, kk1, kk7, nfree, fileende, count
        integer residuecount
	real*8 chisqr, chisqrf, x, y, flambda, pars(PARTOT)

c  if there is a printout, print a header
        residuecount = 0
	if(lpa) write(3, '(//9x,''H I S T O R Y    O F    F I T'')')
	write (speentry,'(i4)') min(9999, nroute)
	i = addcomma(speentry)
        fileende = ltext(files)
        if(files(fileende-1:fileende).eq.'.Z' .or. files(fileende-1:fileende).eq.'z') fileende = fileende-2
	if(savefit) then
	  fildummy=files(filemain(files):fileende)
	  fildum='par'//speentry(1:ltext(speentry))//fildummy(1:ltext(fildummy))
        else
          fildum = filefitsave
        endif
	inquire (file = fildum, exist = rep)
	if(rep) then
          open(unit = 20, file = fildum, status = 'unknown', iostat = ios)
	  if(ios.ne.0) then
	    write(*, '(a,a)') FFITERROR, fildum(1:ltext(fildum))
	    return 
	  endif
          close(unit = 20, status = 'delete')
          rep = .false.
        endif
        if(.not.rep) then
          open (unit=20, file=fildum, status='new', form='unformatted', iostat = ios)
	  if(ios.ne.0) then
	    write(*, '(a,a)') FFITERROR, fildum(1:ltext(fildum))
	    return 
	  endif
	  write(20) WRITEID
          write(20) nampleft, (ampleft(i), i = 1, max(1,nampleft))
          write(20) ntauleft, (tauleft(i), i = 1, max(1,ntauleft))
          write(20) nampback, (ampback(i), i = 1, max(1,nampback))
          write(20) ntauback, (tauback(i), i = 1, max(1,ntauback))
          write(20) nampright, (ampright(i), i = 1, max(1,nampright))
          write(20) ntauright, (tauright(i), i = 1, max(1,ntauright))
          write(20) nampstep, (ampstep(i), i = 1, max(1,nampstep))
	endif
	fildummy=files(filemain(files):fileende)
	if(dskspe) then
	  fildum='gsp'//fildummy(1:ltext(fildummy))
	else
	  fildum='gsp'//speentry(1:ltext(speentry))//fildummy(1:ltext(fildummy))
	endif
	texta = 'formatted'
	if(dskspe) texta = 'unformatted'
        inquire (file=fildum, exist = rep)
        if(rep) then
          if(append .or. dskspe) then
            open (unit=10, file=fildum, status='old', form=texta, access='append', iostat = ios)
	    if(ios.ne.0) then
	      write(*, '(a,a)') FFITERROR, fildum(1:ltext(fildum))
	      return 
	    endif
          else
            open(unit=10, file=fildum, status='old', iostat = ios)
	    if(ios.ne.0) then
	      write(*, '(a,a)') FFITERROR, fildum(1:ltext(fildum))
	      return 
	    endif
            close(unit=10, status='delete')
            rep = .false.
          endif
        endif
        if(.not.rep) then
          if(.not.dskspe) then
c  open the output file and write a header
	    open (unit=10, file=fildum, status='unknown', iostat = ios)
	    if(ios.ne.0) then
	      write(*, '(a,a)') FFITERROR, fildum(1:ltext(fildum))
	      return 
	    endif
	    write(speentry, '(i4)') min(9999, nroute)
	    i = addcomma(speentry)
	    write(10,FFITGSP1) files(:ltext(files)), speentry
	    write(10, '(a)'), version
	    call fdate (texta)
	    texta = texta(:ltext(texta))
	    write(10,'('' creation date: '',a)') texta (:ltext(texta))
	    write(10,FFITGSP2)
	    call gasopt(' ',10)
c            i = 0
c            if(fileenergy(1:1) .ne. ' ' .and. fileenergy(1:1) .ne. '$')i = 1
c            if(fileeffic(1:1) .ne. ' ' .and. fileeffic(1:1) .ne. '$')  i = i + 2
c            if(filewidth(1:1) .ne. ' ' .and. filewidth(1:1) .ne. '$')  i = i + 4
c            if(i .gt. 0) then
c	      write(10, '(''   parameters from calibration files:'')')
c	      call gaspas(' ',10, i)
c            endif
	    write(10,FFITGSP6)
            if(tailb.or.tailr.or.taill.or.lstep) then
              write(10,'('' T-lines: kind of tail, amplitude, error, decay-constant, error'')')
            endif
	    write(10,'(/55a)') ('@',i=1,55)
	    write(10,'(/5x,''centroid (channels)'',8x,''area (counts)'',12x,''width''$)')
	    if(fileenergy.ne.' ') then
              write(10, '(8x''centroid (energy)''$)')
	      if(fileeffic.ne.' ') write(10, '(10x,''intensity       ''$)')
              write(10, '(8x''width''/)')
	    else
              write(10, '(x/)')
	    endif
	  else
	    open (unit=10, file=fildum, status='new', form='unformatted', iostat = ios)
	    if(ios.ne.0) then
	      write(*, '(a,a)') FFITERROR, fildum(1:ltext(fildum))
	      return 
	    endif
	    open (unit=11, file = DSKSPEINF, status = 'new', iostat = ios)
	    if(ios.ne.0) then
	      write(*, '(a,a)') FFITERROR, DSKSPEINF
	      return 
	    endif
	    write (11,'('' list of analyzed slices '')')
	    close (unit=11)
	  endif
	endif
	linepo=0
c  get a fit region
	do while(gasber(i) .and. .not.cancelfit(1))
          if(lpa) then
            write(3,'(/''-----------------------------------------------------------------------------------'')')
	    call time(txtime)
            write(3,FFITREG) txtime, minreg, maxreg
	    write(3,FFITPEA) (peak(i), i = linepo + 1, linepo + kpeaks)
          endif
c  get starting parameters for this region
	  call gaspar
c  control output
	  if(lpa)then
            write(3,'(9x,''degree of background polynomial '',i2$)') backdeg
	    if(backdeg.eq.0 .and. backfixed) then
              write(3,'('', value fixed to'',f10.1)') backvalue
            else
              write(3,'(x)')
            endif
            if(nonestat) write(3, FFITNTN) tinp
	    if(taill .or. tailr .or. tailb .or. lstep) then
	      if(tail) then
	        write(3,FFITTIN)
	      else
	        write(3,FFITTCO)
	      endif
	    endif
	  endif  ! end control output
c  open display to guarantee that it is one the same working set
	  if(display .and. .not.disopen) then
            if(disinit(1)) then
	      write(*,'(''--> Can not open display'')')
	      display= .false.
	    endif
            disopen = .true.
          endif
c  loop for gettin a good fit
          cycles = 0
          fit = .true. 
          do while(fit .and.  cycles.le.MAXCYCLES)
            cycles = cycles + 1
c  minimize chisqr with the present parameter set
            chisqr = gasstp(nfree, count, .FALSE., 1.d-04)
            chisqrf = chisqr/nfree
            kk1 = 2*kpeaks + 1
            kk7 = 2*kpeaks + 7
c  control output
            if(lpa) then
	      call time(txtime)
	      write(3,FFITCHT) txtime, cycles, chisqr, chisqrf, count
	    endif
c  get residuum spectrum
	    do i=1,irange
	      resi(i)=(ya(i)-yfa(i))*sqrt(weight(i))
	    enddo
c  display spectrum and check for cancel command
	    if(disintermediate) then
              call gasval(chisqrf, .false., .false.)
              call gasdis(chisqr, -3)
            endif
            fit = .false.
            pckcheck = .false.
            if(parcheck.eq.0) pckcheck = .true.
c  there must be something wrong if the fit needs so many
c  cycles. Enforce parameter checks
            if(cycles.ge.PCKCYCLES .and. mod(cycles/5,2).eq.0) then
              i = parcheck
              if(parcheck.ne.-2) parcheck = 2
              fit = gaspck()
              if(fit) peaksadded = 0
              parcheck = i
            endif               
            if(.not.fit .and. .not.poscon) fit = gasfck(chisqrf)
            if(.not.fit .and. ressearch)   fit = gasres()
            if(.not.fit .and. .not.pckcheck .and. .not.cancelfit(1)) fit = gaspck()
c  get variance - covariance matrix
            if(.not.fit) then
              flambda = 0.d+00
              chisqr = gaschi(flambda, .FALSE.)
c              write(3,*) 'errpar(1) = ', errpar(1)
c close sample file
              i = parcheck
              parcheck = 0
              fit = gaspck()
              parcheck = i
            endif
            if(cycles.gt.MAXCYCLES .and. lpa) write(3,'('' GASFIT: --> maximum cycles reached!'')')
          enddo   !  while(fit .and.  cycles.le.MAXCYCLES)
c  display final fit
	  if(disintermediate .or. .not.onefitregion) then
            call gasval(chisqrf, .false., .false.)
            call gasdis (chisqrf,-1)
          endif
c  save final fitparameters if save option is on
          call binparout(20, chisqrf)
c output residuum spectrum if requested
	  if(isensw(11))then
            residuecount = residuecount + 1
            write(fildum, '(''residue'',I3.3,''.dat'')') residuecount
	    call gaswrtf (fildum, resi, minreg, maxreg, 'residue ')
	  end if
c  get peak data out of the parameters
	  call time(txtime)
          if(lpa) write(3,'(a,x,i5'' cycles, chisquare ='',g14.4,'', chisqr/f = '',g14.4)') txtime,
     $     cycles, chisqr, chisqrf
	  if(.not.cancelfit(1)) call gasval(chisqrf, .TRUE., .TRUE.)
c  write fit spectrum if requested
	  if(fitout.lt. 0 .and. .not.display) then
            call initfitout(fitout, 'fit')
            if(fitout.gt.0) then
              x = minreg
              y = 0.d+00
              write(fitout, FITFORM0) x, y
              do i = 1, irange
                write(fitout, FITFORM0) x, yfa(i)
                x = x + 1.d+00
              enddo
              write(fitout, FITFORM0) x - 1.d+00, y
              close(unit = fitout)
              fitout = -1
            endif
            call initfitout(fitout, 'bck')
            if(fitout.gt.0) then
	      do i = 1, npar
                pars(i) = par(i)
              enddo
              do i = 2*kpeaks + 2, npar
                par(i) = 0.d+00
              enddo
              if(tailb .and. .not.backinclude) then
                par(2*kpeaks + 9) = pars(2*kpeaks + 9)
                par(2*kpeaks + 10) = pars(2*kpeaks + 10)
              endif
              if(lstep) par(2*kpeaks + 13) = pars(2*kpeaks + 13)
              x = minreg
              y = 0.d+00
              write(fitout, FITFORM0) x, y
	      do i = 1, irange
                y = yfa(i) - gasfun(x,npar)
                write(fitout, FITFORM0) x, y
                x = x + 1.d+00
              enddo
              y = 0.d+00
              write(fitout, FITFORM0) x - 1.d+00, y
              close(unit = fitout)
              fitout = -1
            endif    
          endif !  fitout.lt.0 .and. .not.display
	enddo   !  while(gasber(i) .and. .not.cancelfit(1))
c  everything has been analyzed, close files etc
	close(unit=20)
	close(unit=10)
	if(dskspe .and. .not.cancelfit(1)) then
	  open (unit=11, file=DSKSPEINF, status='old', access='append', iostat = ios)
          if(ios.ne.0) open (unit=11, file = DSKSPEINF, status = 'new', iostat = ios)
	  write (11, '(i7)') nroute
	  close (unit=11)
	endif
	if(lpa .and. .not..not.cancelfit(1)) write (3, '('' ***  Fit cancelled on request'')')
	return
	end



        real*8 function fchisqr(minx, maxx)
c
c  calculates chisquare in the range minx,maxx
c  minx and maxx must be in the intervall [1, irange]
c

        implicit none
        integer minx, maxx

        include 'gasctr.icl'
        include 'gasfit.icl'
        include 'gaspar.icl'

        integer i
        real*8 x, tmp, gasfun
        logical ncs(PARTOT)

        fchisqr = 0.d+00
        if(minx.lt.1. or. maxx.gt.irange .or. maxx.lt. minx) return
        do i = 1, PARTOT
          ncs(i) = nc(i)
          nc(i) = .true.
        enddo
	x = minreg + minx - 1
	do i = minx, maxx
	  tmp = ya(i) - gasfun(x, npar)
	  fchisqr = fchisqr + tmp*tmp*weight(i)
          x = x + 1.d+00
        enddo
        do i = 1, PARTOT
          nc(i) = ncs(i)
        enddo
        return
        end

c  this soubroutine makes the binary output of fitparamters and
c  fit information needed to reconstruct a display of the fit
c

	subroutine binparout(kanal, chisqrf)
	implicit none

	include 'gasctr.icl'
	include 'gasfil.icl'
	include 'gaspar.icl'

        integer kanal
        real*8 chisqrf
          
        integer i

        write(kanal) minreg, maxreg, kpeaks, npar,
	1  (parc(i),i=1,npar), (par(i),i=1,npar), (dpar(i),i=1,npar), 
	1  (brv(i),i=1,kpeaks),
	2  nonestat, fileformat, fileformat, dskspe,
	3  tail, centail, tail, taill, tailb, tailr, lstep,
	4  backdeg, backfixed, nerr, tinp, chisqrf
        return
	end


        subroutine initfitout(fitout, mode)
c  initialises the outout of fit and background spectrum
c  fitout: channel number, should be -1 for the call
c  mode: string characterizing the output spectrum
c  output should be always in dat - format
c if file already exist, data will be appended
c  routine is called by gasfit and gasdis.
        integer fitout
        character *(*) mode

        include "gasfil.icl"
        include "gastxt.icl"

        logical da         
        integer addcomma, ltext, filemain
        integer i, i0, fileende
        character speentry*6, fildum*120, dummy*120


	write (speentry,'(i4)') min(9999, nroute)
	i = addcomma(speentry)
        fildum = files(filemain(files):ltext(files))
        fileende = ltext(fildum)
c check if file is compressed
        if(fildum(fileende-1:fileende).eq.'.Z' .or. 
     $     fildum(fileende-1:fileende).eq.'.z') fileende = fileende-2
c  get rid of extension
        i0 = min(8, fileende)
        i = i0
        do while(i.gt.0 .and. fildum(fileende + i - i0: fileende + i - i0).ne.'.')
          i = i - 1
        enddo
        if(i.gt.0) fileende = fileende + i - i0 - 1
c  generate filename
        dummy = fildum(:fileende)
	fildum=mode(1:ltext(mode))//speentry(1:ltext(speentry))//dummy(1:ltext(dummy))//'.dat'
c check if file is present
	inquire (file = fildum, exist = da)
        fitout = 30
	if(da) then
          open(unit = fitout, file = fildum, status = 'old', access = 'append', iostat = ios)
        else
          open(unit = fitout, file = fildum, status = 'new', iostat = ios)
          if(ios.eq.0) then
            if(mode(1:1).eq.'f') then
              write(fitout,'(''# fit spectra to file ''$)')
            else if(mode(1:1).eq.'b') then
              write(fitout, '(''# background spectra to file ''$)')
            else if(mode(1:1).eq.'c') then
              write(fitout, '(''# correlation function to file ''$)')
            else
              write(fitout, '(''# unknown spectra to file''$)')
            endif
	    write(fitout,'(a, ''-->'', a)') files(:ltext(files)), speentry(:ltext(speentry))
	    write(fitout, '(''# created by '',a)'), version
	    call fdate(dummy)
	    write(fitout,'(''# creation date: '',a)') dummy(:ltext(dummy))
            write(fitout,'(''# different regions start and end with channels with zero contents'')')
          endif
        endif
	if(ios.ne.0) then
	  write(*, '(''--> Error in opening file '',a)') fildum(1:ltext(fildum))
          fitout = 0
        endif
	return 
	end
