	logical function gasgen(exakt)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasgen.f,v 3.22 2003/05/26 12:12:42 riess Exp $
c  this function subroutine generates spectra with predefined
c  parameters in order to allow for a test of the correct
c  function of the minimizing procedure
c  if at least one spectrum has been generated, gasgen = .true.
c  change: 23.02.00: einige Formate geaendert
c  change: 21.12.95: output in either dat or ascii format
c  change: 12.10.92: size adapted to FITREG, ya(i) >= 0
c  03.10.83   f.riess
c----------------------------------------------------------------------------
	implicit none

	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
	include 'gastxt.icl'

	logical exakt, first, istext
	real*8 gasfun, poly, rgauss
	character datea*40, timea*8
        character areatext*132, postext*132, backtext*132, text*132, ratext*10
	integer addcomma, lineget
        integer i, io, ios, isp(10), j, ltext, n, nspek, lastchsave, kpeak
	real*8 backarea, chi, dy, x, ymin, wmax
	real*8 x0, xback(5),yback(5)

        data first /.TRUE./
c  no random fluctuations will be superimposed on the data  if exakt is true
c  for internal use only!
c  generating a spectrum makes only sense if there is no list
c  of channels or regions
	gasgen=.false.
	if(peaklist .or. reglist) then
	  write(*,'('' GASGEN: no list options allowed'')')
	  return
	end if
        if(exakt) then
          write(*,'(''  generation of ideal test spectrum with 3 digits precision'')')
        else
	  write(*,'(''  generation of statistical test spectra'')')
        endif
c read spectrum length
	minch=1
        if(first) then
	  maxch=FITREG
          write(ratext,'(i4)') maxch
        endif
        irange =  FITREG + 1
        do while(irange .le.1 .or. irange.gt.FITREG)
          write(*,'(''length of spectrum (2 - ''i4'') [''a'']: ''$)') FITREG, ratext(:ltext(ratext))
          ios = lineget(text)
          if(ios.eq.0) then
            ios = ltext(ratext)
            text = ratext(:ios)
          endif
          read (text, *, IOSTAT = io) i
          if(io.ne.0) return
          irange = i - minch + 1
        enddo
        ratext = text(:ios)
        maxch = i
	irange = maxch - minch + 1
c  read peakpositions
	if(first) then
          kpeaks = 1
          postext = '100'
        endif
        kpeak = 0
	do while(kpeak.eq.0)
	  do i = 1,PARTOT
	    parc(i) = 0.
	    par(i) = 0.
	    nc(i) = .TRUE.
	  end do
          i=maxch-10
	  write(*, '('' peak positions (10 -'',i5,'')['',a,'']: ''$)') i, postext(:ltext(postext))
          ios = lineget(text)
          if(ios.eq.0) then
            ios = ltext(postext)
            text = postext(:ios)
          endif
          if(istext(text(1:ios))) return
          read(text, *, IOSTAT = io) (parc(i),i=1,PEAKTOT)
	  i=1
	  do while(parc(i).gt.0.)
	    if(parc(i).lt.dble(minch).or.parc(i).gt.dble(maxch))then
	      write(*,'(''--> peak'',f8.1,'' outside of window'')') parc(i)
	      return
	    else
	      kpeak = kpeak+1
	    end if
	    i=i+1
	  end do
	  if(kpeak.eq.i-1)then
            postext = text(:ios)
c  initialize peakareas and peakwidth
	    do i=1,kpeak
	      parc(kpeak+i)=WIDTHCONSTANTE*poly(parc(i),ndw,aws)
	      if(first .or. i.gt.kpeaks) par(i)=1000.
	    end do
c  read peak areas
            if(first) then
              write(areatext, '(20f6.0)') (par(i), i = 1,kpeak)
              i = addcomma(areatext)
            endif
	    write(*, '('' areas ['',a,'']: ''$)') areatext(:ltext(areatext))
            ios = lineget(text)
            if(ios.eq.0) then
              ios = ltext(areatext)
              text = areatext(:ios)
            endif
            if(istext(text(1:ios))) return
            read(text, *, iostat = io) (par(i), i = 1, kpeak)
c  extract peak amplitudes
            do i = 1,kpeak
              if(par(i).gt.0.d+0) then
	        par(i+kpeak) = sqrt(AREACONSTANTE*par(i)/parc(i+kpeak))
              else
                write(*,'(a)') '--> areas must be positiv and non zero'
                return
              endif
            enddo
            areatext = text(:ios)
c  read background counts at 3 different channels
	    xback(1) = max(0, minch-1)
	    xback(2) = max(0, minch-1) + irange/2
	    xback(3) = maxch
	    n = xback(2)
            if(first) then
	      do i = 1, 5
	        yback (i) = 0.
	      end do
              backtext = '0,0,0'
              x0 = 0.
            endif
            if(backtext(1:1).eq.'c') then
              write(*,'(''c, xo, coefficients of background polynomial [''a''] ''$)')
	1     backtext(:ltext(backtext))
            else
	      write(*,'('' background values for channels ''i1'',''i3'',''i4'' ['',a,''] ''$)')
	1     max(0, minch-1), n, maxch, backtext(:ltext(backtext))
            endif
            ios = lineget(text)
            if(ios.eq.0) then
              ios = ltext(backtext)
              text = backtext(:ios)
            endif
            if(text(1:1).eq.'c') then
              if(text(2:2).eq.',') text(2:2) = ' '
              if(istext(text(2:ios))) return
              read(text(2:), *, IOSTAT = io) x0, (yback(i), i = 1, 5)
            else
              if(istext(text(1:ios))) return
	      read (text, *, IOSTAT = io) (yback (i), i = 1,3)
            endif
            npar = 2*kpeak+1
            if(text(1:1).eq.'c') then 
              parc(npar+2) = x0
              do i = 1, 5
                par(npar+i) = yback(i)
              enddo
            else           
	      parc(npar+2) = xback(2)
c calculate coefficients of background polynomial
c note: channels are defined with respect to parc(npar+2)
	      par(npar+1) = yback(2)
              par(npar+2) = (yback(1)-yback(2))/(xback(1)-xback(2))
	      par(npar+3) = (par(npar+2)-
	1               (yback(3)-yback(2))/(xback(3)-xback(2)))/(xback(1)-xback(3))
	      par(npar+2) = par(npar+2)-par(npar+3)*(xback(1)-xback(2))
              par(npar+3) = 0.
              par(npar+4) = 0.
              par(npar+5) = 0.
            endif
	    backarea = 0.
	    npar = npar+1
	    x = minch-parc(npar+1)
	    do i = minch,maxch
              dy = par(npar + 4)
              do j = 3,0,-1
                dy = x*dy + par(npar+j)
              enddo
              if(.not.nonestat .and. dy.lt.0.) then
                write(*, '(a,i4,a)') '--> negativ background counts at channel ', int(x+parc(npar+1))
                write(*, '(a)') '--> use option >set statistics -nostandard< to allow negativ background counts'
                return
              else
	        backarea = backarea + dy
              endif
	      x = x+1
	    end do
            backtext = text(:ios)
c  set tail parameters if tails have been specified in the options
            kpeaks = kpeak
            first = .FALSE.
            npar = 2*kpeaks+6
       	    if(taill)then
              npar = 2*kpeaks+7
	      par(npar) = 1.
	      npar = npar +1
              write(*,'('' generating left peak tails'')')
	    end if
	    if (tailb) then
	      npar = 2 * kpeaks + 9
	      par(npar) = 1.
	      npar = npar + 1
              write(*,'('' generating background tails'')')
	    end if
	    if (tailr)then
	      npar = 2 * kpeaks + 11
	      par(npar) = 1.
	      npar = npar + 1
              write(*,'('' generating right peak tails'')')
	    end if
	    if (lstep)then
	      npar = 2 * kpeaks + 13
	      par(npar) = 1.
              write(*,'('' generating step'')')
	    end if
	  else
	    kpeaks=0
	    write(*,'('' not all lines in analyzing region'')')
	  end if
	end do
c  check if centroids and peak areas match input
        call gasval(1., .FALSE., .FALSE.)
        do i = 1,kpeaks
          if(peakarea(i).ne.par(i)) par(i+kpeaks) = par(i+kpeaks)*sqrt(par(i)/peakarea(i))
          if(centail) then
            if(peakcentroid(i).ne.parc(i)) parc(i) = 2*parc(i) - peakcentroid(i)
          endif
          par(i) = 0.
        enddo
        call gasval(1., .FALSE., .FALSE.)
c  generate spectra
	nspek = 1
	if(.not.exakt) then
          write(*,'('' number of spectra to be generated (''i1'') ''$)') nspek
	  read (*, '(a)',iostat = io) text
	  if (io.eq.(-1)) return
	  read (text, *, IOSTAT = io) nspek
	  nspek = max(1, min(1000, nspek))
       endif
c  generate the ideal spectrum
	minreg=minch
	maxreg=maxch
	x=minreg
	do i=1,irange
	  yfa(i) = gasfun(x,npar)
          if(abs(filesformat).eq.1 .and. (yfa(i).gt.2.3d+9 .or. yfa(i).le.-0.9d+9)) then
            write(*, '(a)') '--> numbers too large for ascii-format, use dat-format!'
            return
          endif
	  x=x+1
	end do
c  output spectrum with superimposed statistical fluctuation
c  output is done in ascii Format or dat (default)
	if(abs(filesformat).eq.1) then
	  files='testgaspan.ascii'
        else
	  if(exakt) then
            files='testgaspan.daterr'
          else
            files='testgaspan.dat'
          endif
        endif
        open(unit=21,file=files,status='unknown', iostat = ios)
	if(ios.ne.0) then
	  write(*, '('' -->GASGEN: Error in opening output file: '',a)') files(1:ltext(files))
	  return
	endif
	call fdate(datea)
	call time(timea)
	write(21,'(''subspectrum 1'')')	
	write(21,'(a)')version
	write(21,'(''date: '',a,'' time: '',a)')datea,timea
	write(21,'(''file: '',a)') files
	write(21,'(''gaspan generated spectrum'')')
	write(21,'(''channel'',i5,'' -'',i5)') minch,maxch
	write (21, '(''background parameters''3e10.3'', area:''g15.5)') 
	1     (par(2 * kpeaks + i), i = 2, 4), backarea
        write(21,'(''peak'',2x,''centroid'',8x,''area'',9x,''fwhm''$)')
        if(taill) write(21,'(4x,''TL: amp      tau''$)')
        if(tailb) write(21,'(4x,''TB: amp      tau''$)')
        if(tailr) write(21,'(4x,''TR: amp      tau''$)')
        if(lstep) write(21,'(4x,''TS: amp         ''$)')
        write(21,'(x)')
	do i = 1, kpeaks
	  write (21, '('' #''i2,1x,f10.3,1x,g15.8,f8.2,$)') i, peakcentroid(i), peakarea(i)
	1 ,parc(kpeaks+i)/WIDTHCONSTANTE
          if(taill) then
            write(21, '(f10.4$)') poly(parc(i), max(1, nampleft), ampleft)
            if(nampleft.eq.0) write(21, '(f10.4$)') tauleft(1)*parc(kpeaks+i)
            if(nampleft.gt.0) write(21, '(f10.4$)') poly(parc(i), ntauleft, tauleft) 
          endif
          if(tailb) then
            write(21, '(f10.4$)') poly(parc(i), max(1, nampback), ampback)
            if(nampback.eq.0) write(21, '(f10.3$)') tauback(1)*parc(kpeaks+i)
            if(nampback.gt.0) write(21, '(f10.3$)') poly(parc(i), ntauback, tauback) 
          endif
          if(tailr) then
            write(21, '(f10.4$)') poly(parc(i), max(1, nampright), ampright)
            if(nampright.eq.0) write(21, '(f10.4$)') tauright(1)*parc(kpeaks+i)
            if(nampright.gt.0) write(21, '(f10.4$)') poly(parc(i), ntauright, tauright) 
          endif
          if(lstep) then
            write(21, '(f10.4$)') poly(parc(i), max(1, nampstep), ampstep)
          endif
          write(21,'(x)')
	end do
	write(*,'('' spectrum '',a)')files
	n=0
	do while(n.lt.nspek)
	  n=n+1
          ios = 0
          ymin = 0.
          wmax = 0.
	  do i=1,irange
            if(.not.exakt) then
	      weight(i) = sqrt(abs(yfa(i))+2.)
	      ya(i) = yfa(i)+rgauss(weight(i))
              if(.not.nonestat) ya(i)=max(0., ya(i))
            else
c if spectrum is "exact", restrict output precision to 3 valid digits
              if(yfa(i).eq.0.) then
                ya(i) = 0.
                wmax = 0.
                if(ios.eq.0) ios = i
              else          
                dy = log10(abs(yfa(i)))
                io = int(dy)
                ya(i) = int(10**(dy - io + 2.) + 0.5)
                dy = 10.**(io - 2.)
                ya(i) = ya(i) * dy
                weight(i) = max(0.33333*dy, 1.e-8*wmax)
                wmax = max(wmax, weight(i))
                if(yfa(i).lt.0.) ya(i) = -ya(i)
                if(ios.ne.0) then
                  if(ymin.eq.0.) ymin = abs(weight(i))
                  do j = ios, i-1
                    weight(j) = (j -ios + 1)*(abs(weight(i)) - ymin)/(i - ios + 1) + ymin
                  enddo
                  ios = 0
                endif
                ymin = abs(weight(i))
              endif
            endif
	  end do
          chi = 0.
          do i = 1, irange
            if(weight(i).eq.0.) weight(i) = ymin
	    resi(i)=(ya(i)-yfa(i))/weight(i)
	    chi=chi+resi(i)**2
          enddo
	  chi=chi/(irange-npar)
	  if(n.eq.1) then
c lastch  must be defined for gasdis
            lastchsave = lastch
            lastch = maxch
	    call gasdis(chi, -2)
	    call disclose(0)
            lastch = lastchsave
	  end if
	  if(abs(filesformat).eq.1) then
	    write(21, '(''subspectrum '',i4)') n
	    i = 0
	    do while(i.le.irange)
	      j = 0
	      do while(j.lt.10 .and. i.le.irange)
	        j = j + 1
	        if(i.gt.0) then
	          isp(j) = ya(i)
	        else
	          isp(j) = ya(1)
	        endif
	        i = i + 1
	      end do
	      write(text,'(10(x,i10))')(isp(io), io = 1, j)
	      j = addcomma(text)
	      do j = 1, ltext(text)
	         if (text(j:j).eq.',') text(j:j)=' '
	      enddo
	      write(21,'(a)') text(1:ltext(text))
	    end do
          else
            do i = 1, irange
              if(nspek.eq.1) then
	        if(exakt) then
                  write(21, '(i5,1x,g15.6,1x,g15.6)') i, ya(i), weight(i)
                else
                  write(21, '(i5,1x,f22.0)') i, ya(i)
                endif
              else
                write(21, '(i5,i5,1x,f22.0)') i, n, ya(i)
              endif
	    enddo
          endif

	end do
	close(unit=21)
	write(*,'(i4'' subspectra written into file '', a)') n, files(1:ltext(files))
	gasgen=.true.
300	files=' '
	return
	end



