/*
	logical function isensw(ii)
c  $Id: gasisw.c,v 1.7 2003/08/14 07:32:50 friedrich Exp $
c+ the purpose of this function  is the definition of the a logical function
c  for test outputs in the various steps of the actions of GASPAN
c
c  the routine will be initialised with a call of isensw(-n)
c  if n is an allowed value, a call to isensw(n) will
c  return .TRUE. else all calls to isensw will return .FALSE.
c  independent of n
c
c  selected function calls can be set with a call of isensw(0)
c
c  To add a new feature: increment ANZAHL, add number to select array
c                        add string to text data statement
c-
	*/
        
#include <stdio.h>
#include <stdlib.h>
typedef struct { char *option;
                 int argvalue;
                 int activ;
                 int lpaset;
	       } LISTE;

LISTE liste[] =  
   {
     { "output of the correlation spectrum (GASSEA)",                        10, 0,  0 },
     { "output of the residuen spectrum (GASFIT)",                           11, 0,  0 },
     { "display each fit step (GASSTP)",                                      9, 0,  0 },
     { "print fit-sequence and fit-error, calibrations (GASEIC)",            12, 0, -1 },
     { "print detailed result of peak search (GASSEA)",                       8, 0, -1 },
     { "print status of parameters (GASPAR)",                                 6, 0, -1 },
     { "print results of the residuen search (GASRES)",                       5, 0, -1 },
     { "print chisq-sequence (GASSTP)",                                       1, 0, -1},
     { "print parameter check (GASPCK)",                                      7, 0, -1 },
     { "output chisquare sample around the minimum (GASPCK)",                14, 0,  0 },
     { "gaspck: full sampling of chisquare (GASPCK)",                        15, 0,  0 },
     { "print starting-/endparameter (GASSTP)",                               2, 0, -1 },
     { "print sequence of parameters (GASSTP)",                               3, 0, -1 },
     { "print analysis of matrices behaviour (GASCHI)",                       4, 0, -1 },
     { "print sequence of parameters (GASCHI)",                              16, 0, -1 },
     { "print chi-sequence, calibrations (GASEIF)",                          13, 0, -1 },
     { "", 0, 0, 0 }
   };

int anzahl = 0, numbercheck[30];
void histfile_(int *);

int isensw_(int *num)
{
  int i, value, lpout, number;
  char str[10];

  value = 0;
  number = *num;
  if(anzahl == 0)
  {
    for(i = 0; anzahl < 30 && *liste[anzahl].option; ++anzahl, ++i)
    {
      for(i = 0; i < anzahl; ++i) 
        if(numbercheck[i] == liste[anzahl].argvalue)
	{
          fprintf(stderr, "Error in function isensw, argument %d appears twice\n", numbercheck[i]);
          exit(1);
	}
      numbercheck[anzahl] = liste[anzahl].argvalue;
      liste[anzahl].activ = 0;
    }
  }
  if(number < 0)
  {
    number = -number;
    if(number <= anzahl)
    {
      for(i = 0; i < anzahl; ++i)
      {
        if(liste[i].argvalue == number)
	{
          liste[i].activ = -1;
          lpout = liste[i].lpaset;
          number = 0;
          break;
	}
      }
    }
    else
    {
      for(i = 0; i < anzahl; ++i) liste[i].activ = 0;
    }
  }
  else if(number > 0)
  {
    if(number > anzahl) lpout = 0;
    else
    {
      for(i = 0; i < anzahl; ++i)
      {
        if(liste[i].argvalue == number)
	{
          value = liste[i].activ;
          lpout = liste[i].lpaset;
          break;
	}
      }
    }
    number = -number -1;
  }
  else
  {
    lpout = 0;
    for(i = 0; i < anzahl; ++i)
    {
      printf("%s (%d): ", liste[i].option, liste[i].argvalue);
      liste[i].activ = 0;
      fgets(str, 4, stdin);
      switch (*str)
      {
        case 'y':
        case 'Y': liste[i].activ = -1;
                  lpout = lpout || liste[i].lpaset;
                  break;
        case 'q':
        case 'Q': i = anzahl;
                  break;
        default: ;
      }
    }
  }
  if(!number && lpout) histfile_(&lpout);
  return value;
}






/*
           implicit none
	integer ii
	integer ANZAHL
	parameter (ANZAHL = 14)

	character x*1, lowercase, text(ANZAHL)*50
	logical is(ANZAHL)
	integer i, io, ltext, select(ANZAHL)
	data is/ANZAHL*.FALSE./
	data select /1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, -1/

	isensw = .FALSE.
	if(ii.gt.0.and.ii.lt.ANZAHL)then
	  isensw = is(select(ii))
	else if(ii.ge.ANZAHL) then
	  isensw = .FALSE.
	else if(ii.le.-ANZAHL)then
	  do  i = 1, ANZAHL
	    is(i) = .FALSE.
	  enddo
        else if(ii.lt.0 .and. ii.gt.-ANZAHL) then
          do i = 1, ANZAHL
            if(select(i).eq.-ii) is(select(i)) = .TRUE.
          enddo  
          isensw = .TRUE.
        else if(ii.eq.0) then
	  i = 1
	  io = 0
	  write(*,"("" input of test-options, answer with n=<cr> or y'')')
	    do while(select(i).gt.0 .and. io.eq.0)
	      write(*,'(x,a'' ''$)') text(i)(1:ltext(text(i)))
	      read (*,'(a)', IOSTAT=io) x
	      if (io.eq.0 .and. lowercase(x).eq.'y') then
	        is(select(i)) = .TRUE.
	        isensw = isensw .or. .TRUE.
              else
                is(select(i)) = .FALSE.
	      end if
              if(lowercase(x).eq.'q') io = -1
	      i=i+1
	    end do
	end if
	return
	end

*/
