/*
   $Id: writespec.c,v 2.5 2001/09/14 15:49:17 riess Exp $
   this file writes a spectrum either in the .dat format (writedat)
   or in ascii format (writeascii)
   for gaspan
   a value 1 is returned, if everything is okay
   -1 else

  F. riess, March 1996
*/



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <math.h>


int writedat(char *file, double *spec, int start, int ende, char *header);
int writeascii(char *file, double *spec, int length, char *header);

/* writedat: write a spektrum in the format:
            channel contents<cr>
   The spectrum is preceeded by a header containing the filename,
   a title with the text header and the date
   return value is 1 if everything is okay, -1 els
*/

int writedat(char *file, double *spec, int start, int ende, char *header)
{
  int i, length;
  double sp, spmin;
  FILE *fp;
  time_t t;
  char *format, mode[20]; 

/* determine precision of output from smallest spec */
  length = ende - start + 1;
  spmin = 1.e+36;
  for(i = 0; i < length; ++i)
    if(spec[i] != 0.)
      spmin = (sp = fabs(spec[i])) < spmin ? sp : spmin;
  if(spmin >= 0.999) format = "%d %.0f\n";
  else               format = "%d %.7g\n";
   
  if(file == NULL) return -1;
  *mode = 'y';
  if(!access(file, F_OK))
  {
    fprintf(stderr, "\07 -->writedat: file %s exists, overwrite (y) or append (a)? ", file);
    fgets(mode, 3, stdin);
    if(! (*mode == 'y' || *mode == 'a')) return -1;
  }
  if(*mode == 'y')
  {
    if((fp = fopen(file, "w")) == NULL) return -1;
    fprintf(fp, "file: %s\n", file);
    fprintf(fp, "title: %s\n", header);
    t = time(&t);
    fprintf(fp, "date %s", ctime(&t));  
  }
  else
    if((fp = fopen(file, "a")) == NULL) return -1;
  for(i = 0; i < length; ++i)
    fprintf(fp, format, i + start, spec[i]);
  fclose(fp);
  return 1;
}


/* Fortran interface */
int writedat_(char *file, double *spec, int *start, int *ende, char *header, int lf, int lh)
{
  char cfile[132], cheader[132];
  int i;

  for(i = 0; i < lf; ++i)
  {
    cfile[i] = file[i];
    if(file[i] == ' ') break;
  }
  cfile[i] = '\0';
  for(i = 0; i < lh; ++i)
    cheader[i] = header[i];
  cheader[lh] = '\0';
  return writedat(cfile, spec, *start, *ende, cheader);
}

/* writeascii: writes from a spektrum just the channel contents
   the data are preeceded by the title and the date and the subspectrum#
   several spectra might be put into one file
*/

int writeascii(char *file, double *spec, int length, char *header)
{
  int i, n;
  FILE *fp;
  time_t t;

  if(file == NULL) return -1;
  if((fp = fopen(file, "a")) == NULL) return -1;
  fseek(fp, 0L, SEEK_END);
  fprintf(fp, "title: %s\n", header);
  t = time(&t);
  fprintf(fp, "date %s", ctime(&t));  
  for(i = 0, n = 0; i < length; ++i)
  {
    n += fprintf(fp, "%.0f ", spec[i]);
    if(n > 80)
    {
      fprintf(fp, "\n");
      n = 0;
    }
  }
  if(n) fprintf(fp, "\n");
  fclose(fp);
  return 1;
}


/* Fortran interface */
int writeascii_(char *file, double *spec, int *length, char *header, int lf, int lh)
{
  char cfile[132], cheader[132];
  int i;

  for(i = 0; i < lf; ++i)
  {
    cfile[i] = file[i];
    if(file[i] == ' ') break;
  }
  cfile[i] = '\0';
  for(i = 0; i < lh; ++i)
    cheader[i] = header[i];
  cheader[lh] = '\0';
  return writeascii(cfile, spec, *length, cheader);
}



