	subroutine gascal(file)
c  $Id: gascal.f,v 2.5 2003/07/12 17:09:55 riess Exp riess $
c  last change:  01.08.89
c  calibrates or recalibrates GASPAN - Data summary files
c  12-NOV-86
	implicit none
        character file*(*)

	character*(*) FILEOUT
        parameter (FILEOUT = '.gaspan.bak')
	character*(*) FGSPENE
	parameter (FGSPENE = '('' set parameters -energy=('',a,'')'')')
	character*(*) FGSPEFF
	parameter (FGSPEFF = '('' set parameters -efficiency=('',a,'')'')')
	character*(*) FGSPHE2
	parameter (FGSPHE2 = '(6x,''centroid (channels)'',6x,''area (counts)'',
	1 7x,''width''6x''centroid(energy)''7x''width'')')
	character*(*) FGSPHE3
	parameter (FGSPHE3 = '(6x,''centroid (channels)''6x''area (counts)'',
	1 7x,''width''6x''centroid(energy)''12x,''intensity''7x''width'')')
	character*(*) FGSPFO2
	parameter (FGSPFO2 = '(2x,2f12.3,f12.0,f9.0,f9.2,2x,2f12.3,f9.2)')
	character*(*) FGSPFO3
	parameter (FGSPFO3 = '(2(2x,2f12.3,f12.0,f9.0,f9.2))')

	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gastxt.icl'

	integer addcomma, index, ltext, filemain
	real*8 efffun, polfun, fiterror
	logical da, wrote, istext, ioene, ioeff, iohead
	integer i, io, ios
	real*8 dx, deff, eff, pd(10), dyda(10)
        character tmpene*120, tmpeff*120

	ioene = fileenergy .eq. ' '
	if(ioene) then
	  write(*,'(''    *** No calibration defined'')')
	  return
	end if
	write(tmpene, '(f10.5, f10.7, 4e15.4)') (aes(i), i=1,nde)
        i = addcomma(tmpene)
	ioeff = fileeffic .eq. ' '
        if(.not.ioeff) then
	  write(tmpeff, '(8e15.4)') (afs(i), i=1,ndf)
          i = addcomma(tmpeff)
        else
          tmpeff = ' '
        endif
c
	if (file.ne.' ') then
          files = file
          inquire (FILE = files, EXIST = da)
        else
          da = .FALSE.
        endif
	do while(.not.da)
	  write (*,'('' _file ''$)')
	  read (*,'(a)', IOSTAT = io) files
	  if (io.eq.(-1)) return
	  inquire (FILE = files, EXIST = da)
	  if (.not.da) write (*,'(''   *** not present, file: ''a)') files(:max(1, ltext(files)))
	end do
	write(*,'(''    Calibrate or recalibrate GASPAN DATA SUMMARY file: ''a)') files(:ltext(files))
	open (unit = 1, file = files, status = 'OLD')
	open (unit = 2, file = FILEOUT, status = 'UNKNOWN', iostat = ios)
	if(ios.ne.0) then
	  write(*, '('' -->GASCAL: Error in opening output file: '',a)') FILEOUT
	  return
	endif
	write(2,'(''Calibrate or recalibrate GASPAN DATA SUMMARY file: ''a)') files(:ltext(files))
	write (2,'(x,a)') version
	da = .not. ioeff
	iohead = .FALSE.
        read (1,'(a)', IOSTAT = io) texta
	do while (io .ne. (-1))
          if(istext(texta)) then
	    wrote = .FALSE.
	    if (index(texta, 'set peak') .gt. 0) then
              if(index(texta, 'energy').gt.0) then
	        write (2,'('' set peak -energy=''a)') fileenergy(:ltext(fileenergy))
                wrote = .TRUE.
	      endif
	      if (index(texta, ' -effic').gt.0 .and .da) then
                write (2,'('' set peak -efficiency=''a)') fileeffic(:ltext(fileeffic))
                wrote = .TRUE.
	      endif
	    else if(index(texta, 'set parameters -energy').gt.0) then
	      write (2, FGSPENE), tmpene(:ltext(tmpene))
              wrote = .TRUE.
	      ioene = .TRUE.
	    else if(index(texta, 'set parameters -efficiency').gt.0 .and .da) then
	      write (2, FGSPEFF), tmpeff(:ltext(tmpeff))
              wrote = .TRUE.
	      ioeff = .TRUE.
	    endif
	    if(index(texta, 'centroid (channels)').gt.0) then
              iohead = .TRUE.
	      if (.not.ioene)  then
	        write (2, FGSPENE)  tmpene(:ltext(tmpene))
                ioene = .TRUE.
	      endif
	      if (.not.ioeff .and. da) then
	        write (2, FGSPEFF), tmpeff(:ltext(tmpeff))
	        ioeff = .TRUE.
	      end if
	      if(.not. da) then
		write(2, FGSPHE2)
	      else
		write(2, FGSPHE3)
	      endif
	      wrote = .TRUE.
	      iohead = .TRUE.
	    endif
	    if(index(texta, 'r-lines') .gt. 0) then
	      if(.not.ioene) then
	        write (2, FGSPENE)  tmpene(:ltext(tmpene))
                ioene = .TRUE.
	      endif
	      if (.not.ioeff .and. da) then
	        write (2, FGSPEFF), tmpeff(:ltext(tmpeff))
	        ioeff = .TRUE.
	      end if
	    endif
	    if(.not.wrote) write (2,'(a)') texta(:max(1, ltext(texta)))
	  else
            if(.not.iohead) then
	      if(.not.ioene) then
	        write (2, FGSPENE)  tmpene(:ltext(tmpene))
                ioene = .TRUE.
	      endif
	      if (.not.ioeff .and. da) then
	        write (2, FGSPEFF), tmpeff(:ltext(tmpeff))
	        ioeff = .TRUE.
	      end if
	      if(.not. da) then
                write(2, FGSPHE2)
              else
                write(2, FGSPHE3)
              endif
              write(2, '(2x)')
	      iohead = .TRUE.
	    endif
c
	    i = addcomma(texta)
	    if (i.gt.0) then
	      read (texta, *, IOSTAT = io) (pd(i), i = 1,5)
	    else
	      io = 2000
	    end if
	    if (io.eq.0) then
	      pd(6) = polfun(pd(1), nde - ndem, ndem, aes, dx, dyda)
              pd(7) = fiterror(nde, dyda, daes)
              pd(7) = sqrt(pd(7)**2 + (dx*pd(2))**2)
	      pd(8) = abs(polfun(pd(1)+pd(5), nde - ndem, ndem, aes, dx, dyda) - pd(6))
	      if (.not.da) then
	        write (2,FGSPFO2) (pd(i), i=1,8)
	      else
	        pd(10) = pd(8)
	        eff=0.
	        deff = 0.
	        if (pd(6).gt.0.) then
	          eff = 1. / efffun(pd(6), ndf, afs, dx, dyda)
                  deff = eff * fiterror(ndf, dyda, dafs)
	        end if
	        pd(8) = eff * pd(3)
	        pd(9) = min(sqrt((eff*pd(4))**2 + (deff*pd(8))**2), 3*pd(8))
	        write (2, FGSPFO3) (pd(i), i=1,10)
	      end if
	    else if (io.lt.200) then
	      write (2,'(a)') texta(:ltext(texta))
	    end if
	  end if
          read (1,'(a)', IOSTAT = io) texta
	end do
	close (unit=1)
	close (unit=2)
        i = filemain(files)
        texta = 'mv '//FILEOUT//' '//files(i:ltext(files))
        call system(texta)
	return
	end

