	integer function gasdis(chis, disfit)
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c   $Id: gasdis.f,v 3.28 2003/07/12 17:08:50 riess Exp riess $
c   this subroutine displays spectrum, fit, background and residuum
c         of a GASPAN fit
c  This gaspan specific subroutine calls 4 routines which
c  interface to the special grafic libaries of a system:
c
c  logical function disinit(save)
c    initializes the grafic display
c    sets the display coordinates to
c      left side , bottom corner:  0.,0.
c      right side, top corner: 1.,1.
c    erases the screen
c    argument: integer save
c              save = 0; only terminal output
c              save = -1; only output into the file gasdis.plt for
c                         later plotting
c              save = 1; output on terminal and into file
c  returns the value .true. if terminal is a grafic terminal
c     .false. if not and save = 0
c
c  subroutine diserase
c    clears the screen
c
c  subroutine disset(x,y)
c    should set a starting point at x and y
c
c  subroutine disdraw(x,y)
c    should draw a line from a previous point defined either
c    by disset or by disdraw to tne new point x,y
c
c  subroutine dismode(mode)
c    defines the drawing modes with either
c    mode = 'line'
c    mode = 'dotted'
c    mode = 'long-dashed'
c
c  subroutine diswrite(string, size)
c  is supposed to write the text in "string" beginning from
c   the current position of the curser
c
c  function disalpha()
c    switches from grafics mode to alpha numeric mode
c
c  subroutine disclose()
c    should do the things which are necessary to finish up the display
c    and close it without erasing it
c   Argument: integer disfit
c   disfit = -3 : display spectrum  and fit during fitting
c                 data are in the arrays ya, yfa and resi (gasfit.icl)
c                 acknowleged options: channels, histogram, lin-log, save
c                 chis is an unnormed chisqr
c   disfit = -2 : display spectrum and fit from call from gasgen
c                 data are in the arrays ya, yfa, weight, resi
c                 acknowleged options: all but single_peaks and energy
c                 chis is divided by the degree of freedom
c   disfit = -1 : display spectrum  and fit at the end of a fit
c                 data are in the arrays spec, specerr, yfa and resi (gasfit.icl)
c                 acknowleged options: all but single_peaks
c                 chis is divided by the degree of freedom
c   disfit = 0  : display spectrum only
c                  data are obtained from gasspc
c   disfit = 1  : display spectrum and fit with command "show fit"
c                  spectrum is obtained from gasspc, fitdata are
c                  obtained from file par...., fit is generated from fitdata
c                 chis is divided by the degree of freedom
c-------------------------------------------------------------------------
	implicit none
	integer disfit
	real*8 chis

	integer DISPID, FITLENGTH
	parameter (DISPID = 1)
	parameter (FITLENGTH = 8192)
        real*8 YMAXL, CURVLIMIT
        parameter (YMAXL = 4.)
        parameter (CURVLIMIT = 100.) 
	character*(*) FPLTFEM
	parameter (FPLTFEM = '('' *** file empty or regions not in window: ''a)')
        character*(*) FITFORM0, FITFORM2
        parameter (FITFORM0 = '(f10.0,3x,g18.8)')
        parameter (FITFORM2 = '(f12.2,x,g18.8)')

	include 'gasctr.icl'
        include 'gasplt.icl'
	include 'gasdis.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
	include 'gasspe.icl'
	include 'gastxt.icl'

	logical gasplin, disinit, cancelfit, joinps
        character lowercase
	logical da, repeat, sbackfixed, stail, scentail, singlepeaks
	character istring*40, input*1, ofile*120
	integer filemain, gasspc, ltext, addcomma, ylabel
	integer i, i1, i2, iostatus, exstatus, j, jstep, kanalin, ktail, n
        integer spebeg, speend, fitbegin, fitend, sbackdeg
	integer snampleft, sntauleft, snampback, sntauback, snampright, sntauright
	real*8 gasfun, poly, gasrep
	real*8 chisqr, parsave(PARTOT)
	real*8 fitspec(FITLENGTH), fiterr(FITLENGTH)
        real*8 xn, xno, yn, yno, r, ys(3), dx, dcor, irep
	real*8 x, xmin, xmax, xinter, y, yfit, ymin, ymax, yinter
	real*8 normx, normy, normr, curvature, multiplier
        real*8 sampleft(DEGTAILS), sampback(DEGTAILS), sampright(DEGTAILS)
        real*8 stauleft(DEGTAILS), stauback(DEGTAILS), stauright(DEGTAILS)
        real*8 xposlabel(NYLABELS), yposlabel(NYLABELS)
        integer black, red, blue, green
        data black /0/, red /2/, blue /4/, green /3/
c  functions used:
	normx(x) = XPOSMIN + (x-xmin)/xinter *DXPOS
	normy(x) = YPOSMIN + (x-ymin)/yinter *DYPOS
	normr(x) = RESPOS0 + x/RESMAX *DRPOS
        curvature(x,y,r) = CURVLIMIT*(r + x -2.*y)/(1.+0.25*(r - x)**2)**1.5
        ylabel(y) = (y - YPOSMIN)/PEAKLHEIGHT + 1
	gasdis=0
        if((disfit.eq.-3 .or. disfit.eq.-1) .and. .not.display) return
        exstatus = 0
        fitbegin = 999999
        fitend = 0
	chisqr = chis
	kanalin=0
        repeat = .TRUE.
c do only if option show fit has been given
c fit spectrum will be generated from parameter file
	if(disfit.eq.1) then
c save input parameters
          sbackdeg = backdeg
          sbackfixed = backfixed
          stail = tail
          scentail = centail
          snampleft = nampleft
          sntauleft = ntauleft
          snampback = nampback
          sntauback = ntauback
          snampright = nampright
          sntauright = ntauright
          do i = 1, DEGTAILS
            sampleft(i) = ampleft(i)
            stauleft(i) = tauleft(i)
            sampback(i) = ampback(i)
            stauback(i) = tauback(i)
            sampright(i) = ampright(i)
            stauright(i) = tauright(i)
          enddo
	  if(.not. gasplin(kanalin, chisqr)) return
          repeat = gasplin(kanalin, chisqr)
        endif
        do while(repeat .and. .not.cancelfit(1))
c  define spectrum region to be displayed
          if(disfit.eq.0) then
            minreg = minch
            maxreg = maxch
          endif
	  if(minreg.ge.minch .and. maxreg.le.maxch) then
	    i = 0
            if(abs(disfit).eq.1) i = nint(3. * fwhm)
	    spebeg = max(DEFMINCH, minreg-i)
	    speend = min(lastch, maxreg + i)
	    irange = maxreg-minreg+1
	    if(irange.gt.SPELEN) then
	      irange = SPELEN
	      speend = spebeg + SPELEN - 1
	    endif
	    speend = min(speend, lastch)
	    if(disfit.ge.-1) then
              if(spebeg.lt.minsp .or. speend.gt.maxsp) then
	        minsp = spebeg
	        maxsp = minsp+SPELEN-1
c  get total length of spectrum
	        i = gasspc(minsp, maxsp, files, spek)
                if(i.le.0) return
	        if(i.gt.0 .and. i.lt.spebeg) then
		  write(*, '(''--> GASDIS: region outside of spectrum (>'', i6,'')'')') i
                  return
		endif
	      end if
	    end if
c  write message and header
	    if(disinit(1)) then
	      write(*,'(''--> GASDIS: Can not open display'')')
	      return
	    endif
            disopen = .true.
	    call diserase
	    call dismode('solid')
            call discolor(black)
c draw frame
	    call disset (dble(0.001), dble(0.001))
	    call disdraw(dble(0.999), dble(0.001))
	    call disdraw(dble(0.999), dble(0.999))
	    call disdraw(dble(0.001), dble(0.999))
	    call disdraw(dble(0.001), dble(0.001))
c  write filename
	    i = filemain(files)
	    write(istring,'(i7)') nroute
	    j = addcomma(istring)
	    if (dskspe) then
	      texta = files(i:ltext(files))//'>>'//istring(:ltext (istring))
	    else
	      texta = files(i:ltext(files))//'->'//istring(:ltext (istring))
	    end if
	    call dismode('bold')
	    call disset(XPOSHEADER, YPOSHEADER)
	    call diswrite(texta(:ltext(texta)), SIZEHEADER)
c  write date
	    texta = ' '
	    call dismode('normal')
	    call fdate(texta)
	    call disset(0.5*(XPOSMAX+XPOSMIN)-4*AXISWIDTH, YPOSHEADER)
	    call diswrite(texta(:ltext(texta)), SIZEAXIS)
c  write version of gaspan
	    call disset(XPOSMAX-27*AXISWIDTH, YPOSHEADER)
	    call diswrite(version(1:ltext(version)), SIZEAXIS)
	    yn = YPOSHEADER
c  write comment
	    if(distext.ne.' ') then
	      i = 1
	      j = ltext(distext)
	      if(distext(1:1).eq.'"') then
		i = 2
		j = j - 1
	      endif
	      yn = yn - 1.5 * HEADERHEIGHT
	      call dismode('normal')
	      call disset(XPOSHEADER, yn)
	      call diswrite(distext(i:j), SIZETEXT)
	    endif
c  write  fitcharacteristics
	    if(disfit.ne.0) then
              write (istring,'(i1'','')') backdeg
	      texta = 'back. deg. '//istring(1:2)
              if(backdeg .eq. 0 .and. backfixed) then
                if(par(2*kpeaks+2) .eq.0.) then
                  texta(ltext(texta)+1:) = ' no backgr.,'
                else
                  write(istring, '(f10.1)') par(2*kpeaks+2)
                  i = addcomma(istring)
                  texta(ltext(texta)+1:) = ' fixed to '//istring(:ltext(istring))//','
                endif
              endif
	      if(taill .or. tailr .or. tailb .or. lstep) then
	        ktail = 2 * kpeaks + 7
		if (tail) texta=texta(:ltext(texta))//' tails (var.):'
	        if (.not.tail) texta=texta(:ltext(texta))//' tails (fixed):'
	        if (taill) texta = texta (1:ltext (texta))//' left,'
	        if (tailb) texta = texta (1:ltext (texta))//' back.,'
	        if (tailr) texta = texta (1:ltext (texta))//' right,'
	        if (lstep) texta = texta (1:ltext (texta))//' step,'
	      end if
	      write (istring,'(i3)') kpeaks
	      texta=texta(1:ltext(texta))//istring(1:ltext(istring))//' peaks,'
	      write(istring,'(g15.4)') chisqr
              if(disfit.eq.-3) then
	        texta = texta(1:ltext(texta))//' chisqr '//istring(1:ltext(istring))
              else
	        texta = texta(1:ltext(texta))//' chisqr/f '//istring(1:ltext(istring))
              endif
	      call dismode('normal')
	      call disset(XPOSHEADER, yn-1.6*AXISHEIGHT)
	      call diswrite(texta(1:ltext(texta)), SIZEAXIS)
	    end if
c  display spectrum
	    xmin=spebeg
	    xmax=speend
	    xinter=xmax-xmin
	    if (xinter.eq.0.) then
	      xinter=1.
	      xmin=xmax-xinter
	    end if
c  determine minimum and maximum of spectrum
	    j=spebeg-minsp+1
            n = 1
	    ymin = 1.d+30
            yno = ymin
            if(dislogaxis) ymin = log10(ymin)
	    ymax = -ymin
	    do i = spebeg, speend
	      cor(j)=normx(dble(i))
	      if (i.ge.minreg .and. i.le.maxreg) then
	        if(disfit.le.-2) then
                  yn = ya(n)
                  n = n + 1
                else
                  yn = spek(j)
                endif
                yno = min(yno, yn)
                da = .true.
                if(dislogaxis) then
                  if(yn.gt.0.)  then
                    yn = log10(yn)
                  else
                    da = .false.
                    yn = -99.
                  endif
                endif   
	        if(da) ymin =  min(ymin, yn)
	        if(disfit.ge.-1) then
                  yn = spek(j) + spekerr(j)
                  if(dislogaxis) yn = log10(max(yn, 1.d-99))
                endif
	        ymax=max(ymax, yn)
	      end if
	      j=j+1
	    end do
            multiplier = 1
            if(dislogaxis) then
              if(ymax.gt.0.d+0) then
                ymax = int(ymax+1.)
              else
                ymax = -int(-ymax)
              endif
              ymin = max(ymin, ymax-10.d+0)
              if(ymin.gt.0.d+0) then
                ymin = int(ymin)
              else
                ymin = -int(-ymin +0.999)
              endif
              if(yno.le.0.) ymin = ymin - 1.
              yinter = ymax - ymin
              if(yinter.lt.1.d+0) yinter = 1
              ymax = yinter + ymin
            else
              if(ymax.eq.ymin) ymax = ymin + 1.
              yinter = ymax - ymin
              do while(multiplier*yinter.lt.1.d+0)
                multiplier = 10*multiplier
              enddo
              ymin = multiplier * ymin
              ymax = multiplier * ymax
	      yinter = 1.1*(ymax-ymin)
c there are problems with the numbering of the axis
c if yinter is too small
              x = 0.5*(ymin + ymax)
              if(yinter.lt.0.02*x) then
                yinter = 0.02*x
                ymin = x - 0.5*yinter
                ymax = x + 0.5*yinter
              endif
	      irep=gasrep(ymin, ymax, DYPOS, MARKDIST)
	      ymin=irep*int(ymin/irep)
	      yinter=1.1*(ymax-ymin)
            endif
c  normalize spectrum and draw it
	    j = spebeg-minsp+1
            n = 1
	    dcor = cor(j+1)-cor(j)
	    call dismode('normal')
	    call dismode('solid')
            call discolor(black)
c  with errorbars
	    if(disfit.ge.-2 .and. diserrorbar) then
              r = min(0.01d+0, max(0.002d+0, 0.3*dcor))
	      do i = spebeg, speend
                if(disfit.le.-2) then
                  yn = ya(n) - weight(n)
                else
	          yn = spek(j) - spekerr(j)
                endif
                yn = multiplier*yn
	        if (dislogaxis) yn = max(ymin, log10(max(1.d-99,yn)))
	        yn = max(YPOSMIN, min(normy(yn), YPOSMAX))
	        call disset(cor(j),yn)
                if(disfit.le.-2) then
                  yn = ya(n) + weight(n)
                else
	          yn = spek(j) + spekerr(j)
                endif
                yn = multiplier*yn
	        if (dislogaxis) yn = max(ymin, log10(max(1.d-99,yn)))
	        yn = normy(yn)
	        call disdraw(cor(j), max(YPOSMIN, min(yn, YPOSMAX)))
                if(disfit.le.-2) then
                  yn = ya(n) 
                else
	          yn = spek(j)
                endif
	        yn = multiplier*yn
	        if (dislogaxis) yn = max(ymin, log10(max(1.d-99,yn)))
	        yn = normy(yn)
                call discircle(cor(j), max(YPOSMIN, min(yn, YPOSMAX)), r)
                n = n + 1
	        j = j + 1
	      end do
c  as histogramm
            else  ! if(disfit.ge.-2 .and. diserrorbar)
	      do i = spebeg, speend
                if(disfit.le.-2) then
                  yn = ya(n) 
                else
	          yn = spek(j)
                endif
	        yn = multiplier*yn
	        if (dislogaxis) yn = max(ymin, log10(max(1.d-99,yn)))
	        yn = normy(yn)
                yn = max(YPOSMIN, min(yn, YPOSMAX))
	        if(i.eq.spebeg) then
	          call disset(cor(j), yn)
	          x=cor(j)+0.5*dcor
	          yno=yn
	        else if (i.lt.speend) then
	          if(abs(yno-yn).gt.DYCHANGE) then
	            call disdraw(x, yno)
	            call disdraw(x, yn)
	            yno=yn
	          end if
	          x=x+dcor
	        else
	          call disdraw(x,yno)
	          call disdraw(x,yn)
	          call disdraw(cor(j),yn)
	        end if
                n = n + 1
	        j = j + 1
	      end do
	    end if  !  if(disfit.lt.-2 .or. .not. diserrorbar)
c  draw x-axis with appropriate channel markings
	    irep= gasrep(dble(spebeg), dble(speend), DXPOS, MARKDIST)
            call dismode('bold')
	    call disset(XPOSMAX,YPOSMIN)
	    j=0
	    yn=YPOSMIN-1.5*XAXISIND-0.5*AXISHEIGHT+LETTERPOSY
	    do i=speend, spebeg, -1
	      if(mod(i,irep).eq.0)then
	        xn=normx(dble(i))
	        call disdraw(xn,YPOSMIN)
	        if(j.eq.0) then
	          call disdraw(xn, YPOSMIN - XAXISIND)
	          write(istring,'(i6)')i
                  call dismode('normal')
		  call disset(xn-2.5*AXISWIDTH+LETTERPOSX, yn)
	          call diswrite(istring(:ltext(istring)), SIZEAXIS)
                  call dismode('bold')
	          j=-5
	        else
	          call disdraw(xn, YPOSMIN - 0.5 * XAXISIND)
	        end if
	        j=j+1
	        call disset(xn, YPOSMIN)
	      end if
	    end do
	    call disdraw(XPOSMIN,YPOSMIN)
c  draw y-axis with apropriate channel markings
	    irep= gasrep(ymin, ymax, DYPOS, MARKDIST)
            if(dislogaxis .or. (ymax.ge.YMAXL .and. irep.lt.1.)) irep = 1.
	    y = irep*int(ymin/irep + 0.5)
	    if(dislogaxis) y = ymin
            j = 0
            jstep = max(-5, -int(yinter/irep))
	    do while(y.le.ymin + yinter)
	      yn=normy(y)
	      call disdraw(XPOSMIN, yn)
	      if(j.eq.0) then
	        call disdraw(XPOSMIN - YAXISIND, yn)
	        if (.not. dislogaxis) then
                  i = int(log10(ymax/multiplier))
                  if(ymax/multiplier.ge.1.d+7) then
	            yno = y/multiplier/10.**i
	            write(istring,'(f5.2''*10^''i2)') yno, i
	          else if(ymax/multiplier.ge.YMAXL) then
                    write(istring, '(i7)'), int(y/multiplier)
                  else if(ymax/multiplier.ge.0.001) then
                    write(texta, '(''(f7.'',i1,'')'')') -i + 2
                    write(istring, texta), y/multiplier
	          else
                    if(y.gt.0.) then
	              yno = log10(ymax/multiplier)
                      x = log10(y/multiplier)
                      if(yno.ge.-8.1) then
	                write(istring,'(f3.1''*10^''i2)') (10**(x-int(yno-1))), int(yno-1)
                      else
	                write(istring,'(f3.1''*10^''i3)') (10**(x-int(yno-1))), int(yno-1)
                      endif
                    else if(y.eq.0.) then 
                      write(istring,'(i7)') int(y)
                    else         
	              yno = log10(-y)
                      if(yno.ge.-8.) then
	                write(istring,'(''-''i2''*10^''i1)') int(10**(yno-int(yno-1))),
	1                                     int(yno-1)
                      else
	                write(istring,'(''-''i2''*10^''i3.2)') int(10**(yno-int(yno-1))),
	1                                     int(yno-1)
                      endif
                    endif
	          endif
	        else   ! .not. dislogaxis
	          write(istring,'('' 10^''i3.2)') int(y)
	        endif  !   if(dislogaxis)
                call dismode('normal')
	        xn = max(0., XPOSMIN-YAXISIND-(ltext(istring) + 1)*AXISWIDTH)
		call disset(xn, yn+0.5*AXISHEIGHT+LETTERPOSY)
	        call diswrite(istring(:ltext(istring)), SIZEAXIS)
                call dismode('bold')
	        j = jstep
	        if (dislogaxis) then
                  do j = 2, 10
                    x = y + irep * log10(dble(j))
                    if(x.lt.ymax) then
                      x = normy(x)
	              call disset (XPOSMIN, x)
	              call disdraw(XPOSMIN - 0.5 * YAXISIND, x)
                    endif
                  enddo
                  j = -1
                endif
	      else   ! if(j.eq.0)
                call disdraw(XPOSMIN - 0.5 * YAXISIND, yn)
	      end if
	      j=j+1
	      call disset (XPOSMIN, yn)
	      y=y+irep
	    end do  ! while(y.le.ymax)
 	    call disdraw(XPOSMIN,YPOSMAX)
c  calculate fit spectrum and draw it with interpolation
	    if(disfit.ne.0) then
	      call dismode('bold')
	      call dismode('solid')
              singlepeaks = dissingle .and. disfit.ge.1
	      n = kpeaks + 1
	      if(singlepeaks) n = 1
	      do i1 = 1, npar
	        parsave(i1) = par(i1)
	      enddo
	      do i1 = n, kpeaks + 1
	        if(i1.le.kpeaks) then
                  call discolor(green)
	          do i2 = 1, kpeaks
	            par(i2 + kpeaks) = 0.
	          enddo
                  par(i1 + kpeaks) = parsave(i1 + kpeaks)
	        else
                  call discolor(red)
                  if(singlepeaks) then
	            do i2 = 1, kpeaks
	              par(i2 + kpeaks) = parsave(i2 + kpeaks)
	            enddo
                  endif
	        endif
c generate filename if output is requested and open file
		if(fitout.lt.0 .and. 
     $                (disfit.eq.1. or. (disfit.eq.-1 .and. .not.onefitregion))) then
                  call initfitout(fitout, 'fit')
                endif
c get error and write fit spetrum into file if wanted
	        j = minreg-minsp+1
		do i = 1, irange
		  if(i1.eq.n) then
		    fiterr(i) = spekerr(j)
		    j = j + 1
		  endif
		enddo
	        x = minreg
                yfit = 0.
                if(fitout.gt.0 .and. i1.gt.kpeaks) write(fitout, FITFORM0) x, yfit
                if(singlepeaks) yfa(1) = gasfun(x, npar)
                yfit = yfa(1)
	        j = minreg-minsp+1
		call disset(cor(j), YPOSMIN)
                irep = 0
		yn = multiplier*yfa(1)
		if(dislogaxis) yn = log10(max(1.0d-99, yn))
		ys(3) = max(YPOSMIN, min(normy(yn), YPOSMAX))
                ys(2) = ys(3)
		do i = 1, irange
                  yfit = yfa(i)
                  if(singlepeaks .and. i.lt.irange) yfa(i+1) = gasfun(x+1, npar)
                  ys(1) = ys(2)
                  ys(2) = ys(3)
		  yn = multiplier*yfa(min(i + 1, irange))
		  if (dislogaxis) yn = log10(max(1.0d-99, yn))
		  ys(3) = max(YPOSMIN, min(normy(yn), YPOSMAX))
		  if(disfit.ge.-1) then
c  calculate curvature of fit curve in order to decide for intermediate points
                    jstep = min(5, abs(curvature(ys(1), ys(2), ys(3))))
                  else
                    jstep = 0
                  endif 
                  if(jstep.gt.0) then
                    dx = 0.5/(1. + jstep)
                    irep = 0.5*dcor/(1. + jstep)
                    do i2 = -jstep, jstep
                      xn = x + i2*dx
                      if(xn.ge.minreg .and. xn.le.maxreg) then
                        yfit = gasfun(xn, npar)
                        yn = multiplier*yfit
		        if (dislogaxis) yn = log10(max(1.0d-99, yn))
		        yn = max(YPOSMIN, min(normy(yn), YPOSMAX))
                        call disdraw(cor(j) + i2*irep, yn)
                        if(fitout.gt.0 .and. i1.gt.kpeaks) write(fitout,FITFORM2) xn, yfit
                      endif
                    enddo
                  else
		    call disdraw(cor(j), max(YPOSMIN, min(ys(2), YPOSMAX)))
                    if(fitout.gt.0 .and. i1.gt.kpeaks) write(fitout,FITFORM0) x, yfit
                  endif
                  x = x + 1.
	          j = j + 1
	        end do   !  do i = 1, irange
		call disdraw(cor(j-1), YPOSMIN)
                if(fitout.gt.0) then
                  yfit = 0.
                  write(fitout, FITFORM0) x - 1., yfit
                  close(unit = fitout)
                  fitout = -1
                endif
	      enddo  ! do i1 = n, kpeaks + 1
c  draw peak markers
c  initialize peak label positions:
              do j = 1, NYLABELS
                xposlabel(j) = XLABEL
                yposlabel(j) = j*PEAKLHEIGHT + YPOSMIN  ! boxes for label postions
              enddo
	      call dismode('normal')
	      call dismode('dotted')
              call discolor(black)
	      do j = 1,kpeaks
c  get marker position
	        if(disfit.lt.-1 .or. disgauss.eq.1 .or. (disgauss.eq.0 .and. .not.centail)) then
                  x = gausspos(j)
                else
                  x = peakcentroid(j)
                endif
                xn = x
	        if (disenergy .and. fileenergy.ne.' ') xn = poly(x, nde, aes)
	        write(istring,'(f8.1)') xn
                xn = normx(x)
c calculate spectrum range of marker label
                n = 1
                do while(istring(n:n).eq.' ')
                  n = n + 1
                enddo
                dx = 0.5*(ltext(istring) - n)*PEAKLWIDTH
                yn = dx*xinter/DXPOS
                i1 = x - yn
                i2 = x + yn
                yn = 0.
                y = 1.d+100
                do i = i1, i2
	          yn = max(yn, multiplier*spek(max(spebeg, min(speend, i)) - minsp +1))
	          y = min(y, multiplier*spek(max(spebeg, min(speend, i)) - minsp +1))
                enddo
	        if(dislogaxis) then
                  yn = max(ymin, log10(max(1.0d-99, yn)))
                  y  = min(ymax, log10(max(1.0d-99, y)))
                endif
		yn = min(normy(yn)+PEAKIND, MAXPEAKIND)
		y = normy(y) - 2*PEAKLHEIGHT
c find appropriate y - position for label
                i1 = min(max(ylabel(yn), 1), NYLABELS)
                if(xposlabel(i1).gt.XLABEL) then
c try above
                  i1 =  min(max(ylabel(yn - PEAKIND) + 1, 1), NYLABELS)
                  i = i1
                  xno = -1
                  do while(xno.lt.0. .and. i.le.NYLABELS)
                    xno = xn - dx - xposlabel(i)
                    i2 = i
                    i = i + 1
                  enddo
c if no success, try below
                  if(xno.lt.0.) then
                    i = min(max(ylabel(y),1),NYLABELS) 
                    do while(xno.lt.0. .and. i.ge.1)
                      xno = xn - dx - xposlabel(i)
                      i2 = i
                      i = i - 1
                    enddo
                  endif
c there is still no success try anything in between
                  if(xno.lt.0.) then
                    i = i1
                    do while(xno.lt.0. .and. i.ge.1)
                      xno = xn - dx - xposlabel(i)
                      i2 = i
                      i = i - 1
                    enddo
                  endif
c  if there is still no access take minimum overlap
                  if(xno.lt.0.) then
                    i2 = NYLABELS
                    xno = xn - dx - xposlabel(i2)
                    do i = NYLABELS - 1, 1, -1
                      x = xn - dx - xposlabel(i)
                      if(xno.lt.x) then
                        xno = x
                        i2 = i
                      endif
                    enddo
                  endif
c  finaly we have a position
                  i1 = i2
                endif  ! if(xposlabel(i1).gt.XLABEL) 
                xno = max(xposlabel(i1), xn - dx)
                yno = yposlabel(i1)
                xposlabel(i1) = xn + dx + PEAKLWIDTH
c  draw marker
	        call disset(xn, YPOSMIN+YAXISIND)
		call disdraw(xn, max(yn, yno))
c  .and write label
		call disset(xno, yno)
	        call diswrite(istring(n:ltext(istring)), SIZEPEAK)
	      end do   !  do j = 1,kpeaks
c  calculate background spectrum and draw it: if no background
c  tail is defined, the background can be calculated directly,
c  otherwise calculate fit - peaks to get it
	      call dismode('bold')
	      call dismode('solid')
              call discolor(blue)
              do i = 1, npar
                parsave(i) = par(i)
              enddo
	      j = 2*kpeaks+1
	      if ((tailb .and. .not.backinclude) .or. lstep) then
	        do i = 1, 5
	          par(j+i) = 0.
	        end do
	        if(tailb .and. .not.backinclude) par(2*kpeaks + 9) = 0.
                par(2*kpeaks + 13) = 0.
	      end if
c generate filename for background spectrum
              if(fitout.lt.0 .and. (disfit.eq.1. or. 
     $           (disfit.eq.-1 .and. .not.onefitregion))) call initfitout(fitout, 'bck')
c draw (and write) background spectrum
	      x = minreg
	      j = minreg-minsp+1
              yfit = 0.
              if(fitout.gt.0) write(fitout, FITFORM0) x, yfit
	      if ((tailb .and. .not.backinclude) .or. lstep) then
	        fitspec(1) = yfa(1) - gasfun(x, npar)
	      else
	        fitspec(1) = gasfun(x, 0)
	      end if
	      yn = multiplier*fitspec(1)
	      if (dislogaxis) yn = max(ymin, log10(max(1.d-99,yn)))
              ys(3) = max(YPOSMIN, min(normy(yn), YPOSMAX))
              ys(2) = ys(3)
              call disset(cor(j), ys(2))
	      do i = 1, irange - 1
                yfit = fitspec(i)
                ys(1) = ys(2)
                ys(2) = ys(3)
                i2 = min(i+1, irange)
	        if ((tailb .and. .not.backinclude) .or. lstep) then
	          fitspec(i2) = yfa(i2) - gasfun(x + 1.,npar)
	        else
	          fitspec(i2) = gasfun(x + 1., 0)
	        end if
	        yn = multiplier*fitspec(i2)
	        if (dislogaxis) yn = max(ymin, log10(max(1.d-99,yn)))
                ys(3) = max(YPOSMIN, min(normy(yn), YPOSMAX))
c  calculate curvature of fit curve
                if(disfit.ge.-1 .and. i.gt.1 .and. i.lt.irange) then
                  jstep = min(5., abs(curvature(ys(1), ys(2), ys(3))))
                else
                  jstep = 0
                endif
                if(jstep.gt.0) then
                  dx = 0.5/(1. + jstep)
                  irep = 0.5*dcor/(1. + jstep)
                  do i2 = -jstep, jstep
                    xn = x + i2*dx
                    if(xn.ge.minreg .and. xn.le.maxreg) then
	              if((tailb .and. .not.backinclude) .or. lstep) then
                        yn = gasfun(xn, npar)
	                do i1 = 1, 5
	                  par(2*kpeaks+1+i1) = parsave(2*kpeaks+1+i1)
	                end do
	                par(2*kpeaks+9) = parsave(2*kpeaks+9)
                        yn = gasfun(xn, npar)
	                do i1 = 1, 5
	                  par(2*kpeaks+1+i1) = 0.
	                end do
	                par(2*kpeaks+9) = 0.
                        yn = yn - gasfun(xn, npar)
	              else
                        yn = gasfun(xn, 0)
                      endif
                    endif
                    yfit = yn
                    yn = multiplier*yn
                    if (dislogaxis) yn = log10(max(1.0d-99, yn))
                    yn = max(YPOSMIN, min(normy(yn), YPOSMAX))
                    call disdraw(cor(j) + i2*irep, yn)
                    if(fitout.gt.0) write(fitout, FITFORM2) xn, yfit
                  enddo
                else
	          call disdraw(cor(j), ys(2))
                  if(fitout.gt.0) write(fitout, FITFORM0) x, yfit
                endif !  if(jstep.gt.0) then
                x = x + 1.
	        j = j+1
	      end do  ! do i = 1, irange - 1
              call disdraw(cor(j), ys(3))
              yfit = 0.
              if(fitout.gt.0) then
                write(fitout,FITFORM0) x, fitspec(irange)
                write(fitout,FITFORM0) x, yfit
                close(unit = fitout)
                fitout = -1
              endif
            
              do i = 1, npar
                par(i) = parsave(i)
              enddo
c  calculate weight (see gaspar) and residuum (see gasfit)
              if(disfit.gt.0) then
                i = 0
                if(.not.errextern) i =  nint(parc(2*kpeaks + 4))
                j = minreg - minsp + 1
	        call gasweight(irange, weight, spekerr(j), i, tinp)
                do i = 1, irange
                  resi(i) = (spek(j) - yfa(i))*sqrt(weight(i))
                  j = j + 1
                enddo
              endif
c  draw residuum
	      call dismode('normal')
              call discolor(black)
	      j = minreg-minsp+1
	      do i=1,irange
	        yn = resi(i)
	        if (i.eq.1) then
	          call disset (cor(j), normr(max(-RESMAX, min(yn, RESMAX))))
	        else
	          call disdraw (cor(j), normr(max(-RESMAX, min(yn, RESMAX))))
	        end if
	        j=j+1
	      end do
c  draw two standart deviations
	      call dismode ('shortdashed')
	      call disset (cor(minreg-minsp+1), normr(2.))
	      call disdraw (cor(maxreg-minsp+1), normr(2.))
	      call disset (cor(minreg-minsp+1), normr(-2.))
	      call disdraw (cor(maxreg-minsp+1), normr(-2.))
	    end if  ! if(disfit.ne.0)
	    call disset (dble(0.005), dble(0.005))
            call disflush
c display has been done, check for user action
            texta = ' '
	    if(dishold) texta = 'next>'
            if(disfit.ge.0) then
              if(dissave) then
                texta = 'next: <cr>, next spec: ESC, p(rint)> '
              else
                texta = 'next: <cr>, next spec: ESC, p(rint), s(ave)>'
              endif
            endif
            if(texta.ne.' ') then
              write(*,'(a,$)') texta(:ltext(texta))
              read(*, '(a)') input
              iostatus = 0
              if(input .eq. char(27)) then
                exstatus = -1
                iostatus = -1
              else if(lowercase(input).eq.'p') then
                i = 1
                if(disprint(1:1) .eq. '"') i = 2
                if(disprint(i:i).eq.' ') then
                  texta = 'lpr gasplot.bak'
                else
                  texta = disprint(i:ltext(disprint)-i+1) //' ' // 'gasplot.bak'
                endif
                call disclose(0)
                call system(texta(:ltext(texta)))
              else if(lowercase(input).eq.'s') then
                write (*,'('' save into file: ''$)')
                read (*, '(a)', iostat = i1 ) ofile
                call disclose(0)
                da = joinps(ofile, 'gasplot.bak')
              endif
            endif
            if(dissave) then
              call disclose(0)
              da = joinps(disfile, "gasplot.bak")
            endif
            da = cancelfit(1)
            if(da) exstatus = -1
	    if (disfit.eq.0 .or. da) iostatus = -1
	  end if
          repeat = .FALSE.
          if(disfit.gt.0) repeat = gasplin(kanalin, chisqr)
	end do              ! while repeat
	if (disfit.gt.0) then
          if(kanalin.gt.0) then
            close(unit = kanalin)
            kanalin = 0
          endif
          exstatus = 1
          gasdis = 0
	end if
        if(exstatus .eq.0 .and. speend.lt.min(maxch,lastch)) gasdis = speend
c  restore input parameters
        if(disfit.eq.1) then
          backdeg = sbackdeg
          backfixed = sbackfixed
          tail = stail
          centail = scentail
          nampleft = snampleft
          ntauleft = sntauleft
          nampback = snampback
          ntauback = sntauback
          nampright = snampright
          ntauright = sntauright
          do i = 1, DEGTAILS
            ampleft(i) = sampleft(i)
            tauleft(i) = stauleft(i)
            ampback(i) = sampback(i)
            tauback(i) = stauback(i)
            ampright(i) = sampright(i)
            tauright(i) = stauright(i)
          enddo
        endif
	return
	end


        logical function gasplin(kanalin, chisqr)
c---------------------------------------------------------------
c  reads data from parameter file and generates fit spectrum
c  kanalin must be 0 for initialisation
c  returns .false. if parameter file is not present or if eof is found
c  filename is generated from text array files (in gasfil.icl)
c  fit spectrum is stored in the array yfa (in gasfit.icl)
c  parameters are stored in array par (in gaspar.icl)
c  peak data are stored in arrays peakcentroid, peakarea and peakwidth (in gaspar.icl)
c  note: errors are too large because variance-covariance matrix is not saved
c  note: some variables are defined in gasctr.icl
c
c---------------------------------------------------------------

	implicit none
        integer kanalin
        real*8 chisqr

	include 'gasctr.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
        include 'gaseic.icl'
        include 'gaspea.icl'

	logical da
	character filtmp*60, fildum*70, speentry*6
	integer filemain, ltext, addcomma
	integer i, j, m, iostatus, ktail
        integer writeid
	real*8 gasfun
	real*8 xi
c  these variables must be real*4
        real*4 fparc(67), fpar(67), fbrv(67), fdpar(67), ftinp, fchi

        gasplin = .FALSE.
c  check if parameterfile is present and open it
        if(kanalin.eq.0) then
	  filtmp = files(filemain(files):ltext(files))
	  write(speentry,'(i4)') min(9999, nroute)
	  i = addcomma(speentry)
          j = ltext(filtmp)
          if(filtmp(j-1:j).eq.'.Z') j = j - 2
	  fildum = 'par'//speentry(1:ltext(speentry))//filtmp(:j)
	  inquire(file=fildum, exist=da)
          if(.not.da) then
            fildum = filefitsave
	    inquire(file=fildum, exist=da)
          endif
	  if(.not.da) then
	    write(*, '(''--> GASPLIN: file not present: ''a)') fildum(:ltext(fildum))
            return
          else
            kanalin = 20
	    open(unit=kanalin, file=fildum, status='old', form='unformatted')
	    read(kanalin, IOSTAT=iostatus) writeid
	    if(iostatus.ne.0 .or. writeid.lt.1) then
	      write (*, '('' *** can not make use of this parameter file'')')
	      kanalin = 0
              return
	    end if
            if(writeid.gt.7) then
	      write(*,'(''-->GASPLIN: not implemented ID of data ('',i6,'')'')') writeid
              kanalin = 0
              return
            endif
c read tail input parameters
            if(writeid.ge.6) then
              read(kanalin) nampleft, (ampleft(i), i = 1, max(1,nampleft))
              read(kanalin) ntauleft, (tauleft(i), i = 1, max(1,ntauleft))
              read(kanalin) nampback, (ampback(i), i = 1, max(1,nampback))
              read(kanalin) ntauback, (tauback(i), i = 1, max(1,ntauback))
              read(kanalin) nampright, (ampright(i), i = 1, max(1,nampright))
              read(kanalin) ntauright, (tauright(i), i = 1, max(1,ntauright))
            endif
            if(writeid.ge.7) then
              read(kanalin) nampstep, (ampstep(i), i = 1, max(1,nampstep))
            endif
            gasplin = .TRUE.
	  end if
	else
c  come to here if file has been intialized already and read data
	  if(writeid.le.2) then
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (fparc(i),i=1,npar), (fpar(i),i=1,npar), (fbrv(i),i=1,kpeaks),
	2   nonestat, fileformat, i, dskspe,
	3   tail, centail, tail, taill, tailb, tailr,
	4   backdeg, nerr, ftinp, fchi
	    do i = 1, npar
	      fdpar (i) = 0.
	    end do
	  else if(writeid.eq.3) then
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (fparc(i),i=1,npar), (fpar(i),i=1,npar), (fdpar(i),i=1,npar), (fbrv(i),i=1,kpeaks),
	2   nonestat, fileformat, i, dskspe,
	3   tail, centail, tail, taill, tailb, tailr,
	4   backdeg, nerr, ftinp, fchi
	  else if (writeid.eq.4) then
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (fparc(i),i=1,npar), (fpar(i),i=1,npar), (fdpar(i),i=1,npar), (fbrv(i),i=1,kpeaks),
	2   nonestat, fileformat, i, dskspe,
	3   tail, centail, tail, taill, tailb, tailr,
	4   backdeg, backfixed, nerr, ftinp, fchi
	  else if (writeid.eq.5 .or. writeid.eq.6) then
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (parc(i),i=1,npar), (par(i),i=1,npar), (dpar(i),i=1,npar), (brv(i),i=1,kpeaks),
	2   nonestat, fileformat, j, dskspe,
	3   tail, centail, tail, taill, tailb, tailr,
	4   backdeg, backfixed, nerr, tinp, chisqr
	  else if (writeid.eq.7) then
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (parc(i),i=1,npar), (par(i),i=1,npar), (dpar(i),i=1,npar), (brv(i),i=1,kpeaks),
	2   nonestat, fileformat, j, dskspe,
	3   tail, centail, tail, taill, tailb, tailr, lstep,
	4   backdeg, backfixed, nerr, tinp, chisqr
	  else
            iostatus = -1
	  endif
c  either error in reading or eof
          if(iostatus.ne.0) then
            close(unit = kanalin)
            kanalin = 0
            return
	  endif
c  note: old parameter saves are in single precision
          gasplin = .TRUE.
          if(writeid.le.4) then
	    do i = 1, npar
	      parc(i) = dble(fparc(i))
              par(i) = dble(fpar(i))
              dpar(i) = dble(fdpar(i))
              brv(i) = fbrv(i)
	    enddo
            chisqr = dble(fchi)
            tinp = dble(ftinp)
          endif
	  if(writeid.eq.1 .and. (taill .or. tailr .or. tailb)) then
	    ktail = 2 * kpeaks + 7
	    parc (ktail) = 1.
	    parc (ktail + 2) = 1.
	    parc (ktail + 4) = 1.
          end if

c correct change in Parameter definition up writeid >= 6
          if(writeid.le.5 .and. (taill .or. tailr .or. tailb))  then
            if(taill) then
              nampleft = 1
              ampleft(1) = 1.
              ntauleft = 1
              tauleft(1) = parc(2*kpeaks + 8)
              parc(2*kpeaks+8) = parc(2*kpeaks+7)
            endif
            if(tailb) then
              nampback = 1
              ampback(1) = 1.
              ntauback = 1
              tauback(1) = parc(2*kpeaks + 10)
              parc(2*kpeaks+10) = parc(2*kpeaks+9)
            endif
            if(tailr) then
              nampright = 1
              ampright(1) = 1.
              ntauright = 1
              tauright(1) = parc(2*kpeaks + 12)
              parc(2*kpeaks+12) = parc(2*kpeaks+11)
            endif
          endif
          if(writeid.le.6) then
            lstep = .false.
            nampstep = 1.
            ampstep(1) = 0.01
          endif
c  set  diagonal terms of variance covariance matrix
          m = 0            
          do i = 1, npar
            do j = 1, i
              m = m + 1
              if(i.eq.j) then
                varcovar(m) = dpar(i)
              else
                varcovar(m) = 0.
              endif
            enddo
          enddo
c  generate peakdata
          call gasval(chisqr, .FALSE., .TRUE.)
c          fwhm = peakwidth(kpeaks)
c          dfwhm = dpeakwidth(kpeaks)
c  generate fit spectrum
          xi = minreg
          irange = maxreg - minreg + 1
          do i = 1, irange
            yfa(i) = gasfun(xi, npar)
            xi = xi + 1
          enddo
	end if
        return 
        end

