	logical function gasres()
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasres.f,v 2.20 2003/03/31 06:10:04 riess Exp riess $
c
c  this routine checks the residuen spectrum for peaks
c  to be added. an added peak will have nctarget = .false.
c  if no peaks are found, gasres = .false., otherwise
c  gasres = .true.
c  all added peaks are put into the list addedpeak which is used as a 
c  ring buffer.
c  peaksadded is the pointer to the last entry in this list, it must be 
c  initialized in  the routine gasber to 0. The routine will not be 
c  allowed to add a peak which is in  the list and hence has been added 
c  previously. But because fitting conditions might change,
c  several attempts to add a line twice will finally succeed: on the 
c  first attempt, the value  in the list will be negated, on the second 
c  attempt it will be removed and on the 3rd attempt
c  the addition is successfull.
c  entry in this list
c  06.06.79  f. riess
c  11.02.94: Ausgabe in file dskspec.inf falls peak -nofit und files -matrix
c------------------------------------------------------------------
	implicit none

	integer PEAKSFOUND, ADDLIST, ADDMAX
c  size of arrays to hold peaks found in residue search
	parameter (PEAKSFOUND = 25)
c  size of list of added peaks. Lines found in this list can not
c  be added in the next step
	parameter (ADDLIST = 40)
c  number of peaks which can be added in one step
c  should be larger than number of peaks which can be deleted by gasfck
        parameter (ADDMAX = 3)
c  determines the threshold for peak identification lower values mean
c  higher sensivity
c  THRESHOLD:       set statistics -sensivity=normal
c  HTHRESHOLD:      set statistics -sensivity=high 
        real*8 THRESHOLD, HTHRESHOLD
        parameter (THRESHOLD = 4.5)
        parameter (HTHRESHOLD = 3.5)   

	character*(*) FRESPAV
	parameter (FRESPAV='(9x,'' *** peak or parameter number overflow (''2i5'')'')')
	character*(*) FRESREG
	parameter (FRESREG='(9x,'' *** region changed to'',i5,'' -'',i5)')
	character*(*) FRESNOPF
	parameter (FRESNOPF='(9x,''no peaks found in residuen search'')')
	character*(*) FRESCOC
	parameter (FRESCOC='(9x,''peak at '',f8.1
	1,'' width '',i3,'' (target >='',f5.1,'') statistics '',f6.2
	2,'' (target >='',f6.2,''), priority'',f10.4$)')
	character*(*) FRESREJO
	parameter (FRESREJO='(10x,''rejected:'',4x,''peak at ''
	1,f8.1,'' because of overlap with peak '',f8.1)')
	character*(*) FRESADDP
	parameter (FRESADDP='(9x,''added:'',7x,''peak at '',f8.1)')

	include 'gasctr.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'

	logical isensw
	integer gaserr
	logical lpout, peak
	logical nctargets(PARTOT)
	integer i, iw, j, k1, l, mw, mw2, mw21, n, new, np, added 
	real*8 corm, corr, dx, sum, suma, sums, sumv, witar, x, xl, xll, xm
	real*8 pen(PEAKSFOUND), aan(PEAKSFOUND), xms(PEAKSFOUND),
	1 addedpeak(ADDLIST), pars(PARTOT),
	2 parcs(PARTOT), derivs(PARTOT), dpars(PARTOT), brvs(PEAKTOT)

c
	gasres=.false.
	lpout=lpa .and. isensw(5)
	if(lpa)write(3, '('' GASRES: result of the residuen search:'')')
	mw=wids + 0.5
	if(mw.le.0)mw=1
	witar = mw/3.
	mw2=0.5*wids + 0.5
	mw21=5*mw
c  check if there is a poor fit at the end of the spectrum
	new=0
c	if(.not.(reglist.or.peaklist.or.onefitregion)) then
c	  l=irange
c	  do while(resi(l).ge.3.)
c	    l=l-1
c	    new=new+1
c	  end do
c	endif  
c  if this part is not too large, ignore it
	if(new.gt.0 .and. new.le.2*mw) then
	  irange=l
	  maxreg=irange+minreg-1
	  gasres=.true.
	  if(lpa) write(3,FRESREG) minreg,maxreg
	end if
c  search for peaks starts here
	xl = THRESHOLD
	if(highsens) xl = HTHRESHOLD
	xll = log(xl)
c	else
c	  xll=xl
c	end if
	peak=.false.
	np=0
        i=mw
	do while(i.le.irange .and. np.le.PEAKSFOUND)
c  fold with rectangular folding function
	  x=0.
	  l=i-mw2-2*mw
	  do j=1,mw21
	    x = x + resi (max (1, min (l, irange)))
	    l=l+1
	  end do
	  corr=0.
	  l=i-mw2
	  do j=1,mw
	    corr = corr + resi (max (1, min (l, irange)))
	    l=l+1
	  end do
	  corr = corr - 0.2*x
c  check if a peak has been found and set up starting values if so
	  if(corr.gt.xl) then
	    if(.not.peak) then
	      peak=.true.
	      corm = corr
	      sums = resi(i)
              if(resi(i).gt.0) then
                suma = resi(i)/sqrt(weight(i))
              else
                suma = 1.
              endif
	      sumv = i*resi(i)
	      iw=1
	    else
	      sums = sums + resi(i)
              if(resi(i).gt.0.) suma = suma + resi(i)/sqrt(weight(i))
	      sumv = sumv + i*resi(i)
	      iw = iw+1
	      corm = max (corm, corr)
	    end if
	  else
	    if(peak) then
	      peak=.false.
	      x=sumv/sums
	      if(x.gt.(-wids)) then
	        j=x
	        x=x+minreg-1
	        sums=sums*corm
	        if (iw.eq.1) sums = 0.1*sums
	        if(lpout) write(3,FRESCOC) x,iw,witar,log(max(1.,corm)),xll,log(max(1.d-4,sums))
	        if(corm.gt.xl .and. 3*iw.ge.mw .and. j.lt.irange) then
                  if(lpout) write(3,'(x)')
	          np=np+1
	          if(np.le.PEAKSFOUND) then
	            pen(np)=x
	            if(j.le.0)j=1
c	            aan(np)=abs(resi(j)*sqrt(abs(yfa(j))))+1.
                    aan(np) = suma
	            xms(np)=sums
	          else
	            if(lpout) write(3, '(10x,''too many peaks in residuum search'')')
	          end if
	        else
	          if(lpout) write(3, '('' rejected'')')
	        end if
	      end if
	    end if
	  end if
	  i=i+1
	end do
        np = min(np, PEAKSFOUND)
c  search for the strongest peak and add it to the list of peaks
        added = 0
	do while(np.gt.0 .and. added.lt.ADDMAX)
	  if(kpeaks.lt.PEAKTOT .and. npar+2.lt.irange) then
	    xm=xms(1)
	    n=1
	    do j=1,np
	      if(xm.le.xms(j)) then
	        xm=xms(j)
	        sum=aan(j)
	        sumv=pen(j)
	        n=j
	      end if
	    end do
c  the strongest peak has been separated, shift the following down
	    np=np-1
	    if(n.le.np) then
	      do j=n,np
	        aan(j)=aan(j+1)
	        xms(j)=xms(j+1)
	        pen(j)=pen(j+1)
	      end do
	    end if
c  the peak will be rejected if it coincids with an existing one
	    peak=.true.
	    l=1
	    do while(peak .and. l.le.kpeaks)
c	      dx=deriv(l)
	      dx=0.1*wids
	      if(abs(sumv-parc(l)).le.dx) then
	        peak=.false.
	        if(lpout) write(3,FRESREJO) sumv,parc(l)
	      end if
	      l=l+1
	    end do
c  check if the peak has been added previously
	    l=1
	    do while(peak .and. l.le.min(peaksadded, ADDLIST))
	      if(abs(sumv-abs(addedpeak(l))) .le. 0.01*wids) then
	        peak=.false.
	        if(lpout) write(3, '(10x,''rejected:'',4x,''peak at ''
	1,f8.1,'' because it has been added previously'')') sumv
c  delete peak from the added peak list
	        if (addedpeak(l).lt.0.) then
	          addedpeak(l)=0.
	          do i=l,min(peaksadded, ADDLIST-1)
	            addedpeak(i)=addedpeak(i+1)
	          end do
	          peaksadded=peaksadded-1
	        else
	          addedpeak(l)=-addedpeak(l)
	        end if
	      end if
	      l=l+1
	    end do
c  now add this peak to the others
	    if(peak .and. peaksadded.lt.ADDLIST) then
c write into dskspec.inf file if peak has found
              if(poscon .and. dskspe) then
                open(unit=11, file=DSKSPEINF, status = 'old', access='append') 
                write(11, '(f11.3,x,f10.0)') sumv, sum
                close(unit=11)
              else
                added=added+1
	        gasres=.true.
	        peaksadded=peaksadded+1
	        if (peaksadded.le. ADDLIST) then
	          addedpeak(peaksadded)=sumv
	        else
	          addedpeak(peaksadded-ADDLIST)=sumv
	        end if
	        if(lpa) write(3,FRESADDP) sumv
c  save first all parameters
	        do i=1,PARTOT
	          pars(i)=par(i)
	          dpars(i)=dpar(i)
	          parcs(i)=parc(i)
	          nctargets(i)=nctarget(i)
	          if(i.le.PEAKTOT) then
	            derivs(i)=deriv(i)
	            brvs(i)=brv(i)
	          end if
	        end do
c  and restore them with the new peak in it
	        kpeaks=kpeaks+1
	        k1=2*kpeaks+1
	        npar=npar+2
	        do i=k1,PARTOT
	          par(i)=pars(i-2)
	          parc(i)=parcs(i-2)
	          nctarget(i)=nctargets(i-2)
	        end do
	        i=kpeaks-1
	        do j=kpeaks,1,-1
	          if(i.gt.0 .and. sumv.le.parc(max(1,i))) then
	            par(j)=pars(i)
	            dpar(j)=dpars(i)
	            parc(j)=parcs(i)
	            nctarget(j)=nctargets(i)
	            deriv(j)=derivs(i)
	            brv(j)=brvs(i)
	            par(j+kpeaks)=pars(i+kpeaks-1)
	            dpar(j+kpeaks)=dpars(i+kpeaks-1)
	            parc(j+kpeaks)=parcs(i+kpeaks-1)
	            nctarget(j+kpeaks)=nctargets(i+kpeaks-1)
	            i=i-1
	          else
	            par(j)=0.
	            dpar(j)=1.
	            parc(j)=sumv
	            nctarget(j)=.false.
	            deriv(j)=5.*wids
	            brv(j)=1.
	            par(j+kpeaks)=sqrt(sum)
	            if(j.eq.1) parc(j+kpeaks)=parcs(j+kpeaks-1)
	            if(j.eq.kpeaks) parc(j+kpeaks)=parcs(j+kpeaks-2)
	            if(j.gt.1 .and. j.lt.kpeaks) parc(j+kpeaks)=0.5*(parcs(j
	1           +kpeaks-2)+parcs(j+kpeaks-1))
	            nctarget(j+kpeaks)=.false.
	            sumv=0.
	          end if
	        end do
              end if
	    end if
	  else if(added.eq.0) then
	    if (lpa) write(3,FRESPAV) kpeaks,npar
	    np=0
	    nerr=gaserr(nerr,2)
	  else
            np = 0
          end if
	end do
        if (lpout .and. added.gt.0)       write(3, '(9x,''peaks added:'',i3)') added
	if (lpout .and. peaksadded.gt.0) write (3, '(9x,''there are'',i6,
	1'' entries in the peaks-added list'')') peaksadded
	if(.not.gasres .and. lpa) write (3,FRESNOPF)
	return
	end
