#define TESTx
/* $Id: readosp.c,v 2.4 2002/09/21 10:34:16 riess Exp $
  this file contains the subroutines
     readosp
  which reads a one dimensional spectrum in the 
  Munich online format (.osp)

  int readosp(
     char *filename:  Filename of Spectrum must have the extenion .osp.
                      If Filename ends with .Z, it
                      will be assumed, that the file is compressed. 
                      An uncompressed file is generated under /usr/tmp
                      and used for reading. This file will be deleted
                      with a subsequent calls with an other filename. 
    int subspectrum:  Number of the subspectrum.
    double *spectrum:  Array of the spectrum. Must have length of at least
                      ende - begin + 1
    int begin:        begin of the Spectrum
    int ende:         end of the spectrum
    )
  return value:
    0 if the file is not found or if there was an error during reading
   <0 negativ value of last subspectrum if subspectrum does not exist
   >0 ende or last channel in the spectrum if ende is greater than 
      the last channel
  
   F. Riess, March 1996
*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

typedef struct {
	char beghdr[144];		/* die ersten 4 Bytes sind 'MLSP' */
	char sname[12];			/* 144	 Name des Spektrums       */
	char user[20];			/* 156	 Name des Benutzers	  */
	char group[24];			/* 176	 Gruppe			  */
	char experiment[80];    	/* 200	 Info u"ber Experiment			*/
	char comments[80];		/* 280	 beliebiger Kommentar			*/
	char date[12];			/* 360	 wird automatisch gefu"llt		*/
	char time[12];			/* 372	 wird automatisch gefu"llt		*/
	long dimensions;		/* 368	 alle folgenden items werden ..	*/
	long wordlength;		/* 372	 ... mit put_spstat() gefu"llt.	*/
	long speclength;		/* 376			*/
	long evcomp_1;			/* 380			*/
	long lowerlim_1;		/* 384			*/
	long upperlim_1;		/* 388			*/
	long binsize_1;			/* 392			*/
	long channels_1;		/* 396			*/
	long evcomp_2;			/* 400			*/
	long lowerlim_2;		/* 404			*/
	long upperlim_2;		/* 408			*/
	long binsize_2;			/* 412			*/
	long channels_2;		/* 416			*/
	long evcomp_3;			/* 420			*/
	long lowerlim_3;		/* 424			*/
	long upperlim_3;		/* 428			*/
	long binsize_3;			/* 432			*/
	long channels_3;		/* 436			*/
	char parameter_1[12];	        /* 440			*/
	char parameter_2[12];	        /* 452			*/
	char parameter_3[12];	        /* 464			*/
} Spec_File_Header;


int readosp(char *filename, int subspectrum, double *spectrum, int begin, int ende);
int readosp_error(int fd, char *file);
void swapbytes(unsigned char *buf, int n, int mode);


/* Fortran interface */
int readosp_(char *fi, int *su, double *sp, int *be, int *en, int fl)
{
  char file[132];
  int i;
  for(i = 0; i < fl; ++i)
  {
    file[i] = fi[i];
    if(fi[i] == ' ') break;
  }
  file[i] = '\0';
  return readosp(file, *su, sp, *be, *en);
}


int readosp(char *filename, int subspectrum, double *spectrum, int begin, int ende)
{
  static int header_out = 1;
  int fildes = -1, swap, i, n;
  char str[131];
  static char filetmp[L_tmpnam > 130 ? L_tmpnam : 130] = "";
  static char fileold[130] = " ";
  static int firstfile = 1, tmp_ende;
  static unsigned char *cdata = NULL;
  static Spec_File_Header header;
  union { int tmp; unsigned char ctmp[4]; } tmp;
    
/* the following statement is used to avoid failure with -Werror */
  i = subspectrum;
/* check if file has already been accessed */
  
  if(strcmp(fileold, filename))
  {
    if(fildes)
    {
      if(!firstfile) (void) unlink(filetmp);
      if(cdata) free(cdata);
      cdata = NULL;
      firstfile = 1;
    }     
    strcpy(fileold, filename);
    if(filename[strlen(filename)-1] != 'Z')
      strcpy(filetmp, filename);
    else
    { if(firstfile)
      { (void) tmpnam(filetmp);
        if(!*filetmp) return 0;
        firstfile = 0;
      }
      if(access(filename, 00) == -1) return 0;
      sprintf(str, "zcat %s > %s\n", filename, filetmp);
      system(str);
    }
    if((fildes = open(filetmp, O_RDONLY)) == -1) return 0;
/* read header */
    n = read(fildes, &header, sizeof(Spec_File_Header));
    if(n != sizeof(Spec_File_Header))
      return readosp_error(fildes, fileold);
/* check if bytes are in the correct order */
    swap = 0;
    if(header.dimensions < 0 || header.dimensions > 4) swap = 4;
    if(swap) swapbytes((unsigned char *) &header.dimensions, 18*4, swap);
/* control output */
    if(header_out)
    {
      printf("spectrum name: %s\n", header.sname);
      printf("user:          %s\n", header.user);
      printf("group:         %s\n", header.group);
      printf("comments:      %s\n", header.comments);
      printf("date:          %s\n", header.date);
      printf("time:          %s\n", header.time);
    }
#ifdef TEST
    printf("dimension:     %ld\n", header.dimensions);
    printf("wordlength:    %ld\n", header.wordlength);
    printf("spec-length    %ld\n", header.speclength);
    printf("dimension 1:\n");
    printf("lower_limit:   %ld\n", header.lowerlim_1);
    printf("upper_limit:   %ld\n", header.upperlim_1);
    printf("binsize:       %ld\n", header.binsize_1);
    printf("channels:      %ld\n", header.channels_1);
    if(header.evcomp_2)
    {
      printf("dimension 2:\n");
      printf("lower_limit:   %ld\n", header.lowerlim_2);
      printf("upper_limit:   %ld\n", header.upperlim_2);
      printf("binsize:       %ld\n", header.binsize_2);
      printf("channels:      %ld\n", header.channels_2);
    }
    if(header.evcomp_3)
    {
      printf("dimension 3:\n");
      printf("lower_limit:   %ld\n", header.lowerlim_3);
      printf("upper_limit:   %ld\n", header.upperlim_3);
      printf("binsize:       %ld\n", header.binsize_3);
      printf("channels:      %ld\n", header.channels_3);
    }
#endif
    if(header.dimensions != 1)
    {
      fprintf(stderr, "\07-->readosp: Only 1 dimensional spectra allowed\n");
      return readosp_error(fildes, fileold);
    }
/* allocate memory for spectrum and read it */
    if((cdata = (unsigned char *) malloc(header.speclength)) == NULL)
    {
      fprintf(stderr, "\07-->readosp: can not allocate %ld bytes of data\n",
                                       header.speclength);
      return readosp_error(fildes, fileold);
    }
    if(read(fildes, cdata, header.speclength) != header.speclength)
    {
      fprintf(stderr, "\07-->readosp: error in reading file %s\n", filename);
      return readosp_error(fildes, fileold);
    }
    if(swap) swapbytes(cdata, header.speclength, swap);
    close(fildes);
  }
/* spectrum is now in core, transfer it to external buffer */
  tmp_ende = begin;
  if(header.lowerlim_1 > begin)
  {
    tmp_ende = header.lowerlim_1 > ende ? ende : header.lowerlim_1;
    for(i = begin; i < tmp_ende; ++i)
      spectrum[i - begin] = 0.;
    if(header.lowerlim_1 >= ende) return ende;
  }
  if(header.upperlim_1 < ende) ende = header.upperlim_1;
  n = 4 * (tmp_ende - header.lowerlim_1);
  for(i = tmp_ende; i < ende; ++i)
  {
    int j;
    for(j = 0; j < 4; ++j, ++n) tmp.ctmp[j] = cdata[n];
    spectrum[i - begin] = (double) tmp.tmp;
  }
  return ende;
}


int readosp_error(int fd, char *file)
{ 
  close(fd);
  *file = '\0';
  return 0;
}


void swapbytes(unsigned char *buf, int n, int mode)
{
  unsigned char tmp;
  int i;

/*  swap to consecutive bytes */
  if(mode == 1)
  {
    for(i = 0; i < n; i += 2)
    {
      tmp = buf[i];  buf[i] = buf[i+1]; buf[i+1] = tmp;
    }
  }
/* swap two consecutive short ints */
  else if(mode == 2)
  {
    for(i = 0; i < n; i += 4)
    {
      tmp = buf[i];    buf[i]   = buf[i+3]; buf[i+3] = tmp;
    }
  }
  else if(mode == 4)
  {
    for(i = 0; i < n; i += 4)
    {
      tmp = buf[i];    buf[i]   = buf[i+3]; buf[i+3] = tmp;
      tmp = buf[i+1];  buf[i+1] = buf[i+2]; buf[i+2] = tmp;
    }
  }

}









