      real*8 function gaseif(fun, npar, nparm, pare, ndata, varcovare)
c $Id: gaseif.f,v 2.9 2003/07/12 17:03:46 riess Exp $
c
c  Nichtlineare Fitroutine fuer Eichung
c
c es wird vorausgesetzt, dass die Werte in den Arrays von
c         gaspea.icl und die parameter in den Arrays von 
c         gaspar.icl enthalten sind.
c
c  argumente:
c    fun:      fitfunktion
c    npar:     Anzahl der Parameter 
c    ndata:    Anzahl der Datenpunkte
c    varcov:   Varianz-Kovarianz Matrix als eindimensionaler Array
c 
c  F. Riess 19.02.93
c
      implicit none
      real*8 fun
      real*8 pare(*), varcovare(*)
      integer npar, nparm, ndata
      external fun

      include 'gaspea.icl'
      include 'gaspar.icl'

      integer EICHPAR
      parameter (EICHPAR = 20)
      integer ABBRUCH
      parameter (ABBRUCH = 1500)
      real*8 LAMBDAMIN, LAMBDAMAX
      parameter (LAMBDAMIN = 1.d-16)
      parameter (LAMBDAMAX = 1.d+8)
      real*8 GENAUIGKEIT
      parameter (GENAUIGKEIT = 1.d-6)

      integer indexm
      logical finished, isensw
      integer i, i1, j, j1, n, nfree, npart, error, zaehler
      real*8 chiold, chinew, lambda, wert, delta
      real*8 dwert, dyda(EICHPAR)
      real*8 parsave(EICHPAR)
      real*8 dtmp, gewicht
      real*8 beta(EICHPAR), matrix((EICHPAR*(EICHPAR+1))/2)
      real*8 savem((EICHPAR*(EICHPAR+1))/2)

      zaehler = 0
      lambda = 0.001
c  bestimme die Anzahl der Freiheitsgrade
      npart = 0
      do i = 1, npar
        if(nc(i)) npart = npart + 1
      enddo
      nfree = ndata - npart
      gaseif = -1
      chinew = 0
      if(nfree.lt.0 .or. npar.gt.EICHPAR) return
      if(nfree.eq.0) nfree = 1
      do while(lambda.ge.0.)
c  Rette alte Parameter
        do i = 1, npar
          parsave(i) = pare(i)
        enddo
c Berechne matrix
        do i = 1, EICHPAR
          beta(i) = 0.
        enddo
        j = (EICHPAR*(EICHPAR+1))/2
        do i = 1, j
          savem(i) = 0.
        enddo
        chiold = 0.
        do n = 1, ndata
          wert = fun(peak(n), npar - nparm, nparm, pare, dwert, dyda)
          gewicht = dwert * dpeak(n)
          gewicht = 1./(gewicht*gewicht + darea(n) * darea(n))
          delta = area(n) - wert
          chiold = chiold + gewicht*delta*delta
          i1 = 0
          do i = 1, npar
            if(nc(i)) then
              i1 = i1 + 1
              dtmp = gewicht*dyda(i) 
              beta(i1) = beta(i1)+dtmp*delta
              j1 = 0
              do j = 1, i
                if(nc(j)) then
                  j1 = j1+1
                  savem(indexm(i1,j1)) = savem(indexm(i1,j1))+dtmp*dyda(j)
                endif
              enddo
            endif
          enddo
        enddo
        chiold = chiold/nfree
        gaseif = chiold
        if(npart.eq.0) return

        finished = .FALSE.
        do while(.not.finished)
c  Kopiere Matrix savem in matrix, beruecksichtige lambda
          if(isensw(13)) then
            if(chinew.gt.0. .and. chiold.ne.chinew) then
              write(*,'(x,''chi0 = '',g13.7, '' ('',e7.1,'')  chinew = '',g13.7)')
&                     chiold, lambda, chinew
            else
              write(*,'(x,''chi0 = '',g13.7, '' ('',e7.1,'')'')')
&                     chiold, lambda
            endif
          endif
          n = 0
          do i = 1, npart
            do j = 1,i
              n = n + 1
              matrix(n) = savem(n)
              if(i.eq.j) matrix(n) = matrix(n) + lambda
            enddo
          enddo
          if(lambda.eq.0.) lambda = -1.
          call dsinv(matrix, npart, GENAUIGKEIT, error)
          if(error.lt.0) then
            if(isensw(13))write(*, '('' --> GASEIC: Matrixinversion nicht korrekt'')')
            chinew = 1.1 * chiold
          else if(lambda.ge.0) then
c  berechne neue Parameter
            i1 = 0
            do i = 1, npar
              if(nc(i)) then
                i1 = i1 + 1
                j1 = 0
                dtmp = 0.
                do j = 1, npar
                  if(nc(j)) then
                    j1 = j1 + 1
                    dtmp = dtmp + beta(j1)*matrix(indexm(j1,i1))
                  endif
                enddo
                pare(i) = pare(i) + dtmp
              endif
            enddo
c  Berechne neues chi
            chinew = 0
            do n = 1, ndata
              wert = fun(peak(n), npar - nparm, nparm, pare, dwert, dyda)
              gewicht = dwert*dpeak(n)
              gewicht = 1./(gewicht*gewicht + darea(n)*darea(n))
              delta = area(n) - wert
              chinew = chinew + gewicht * delta * delta
            enddo
            chinew = chinew/nfree
          endif                ! if(error.lt.0)
c Aktion gemaess neuem chi
          if(lambda.gt.0.) then
            if(chinew.ge.chiold) then
              lambda = 100 * lambda
c  Kopiere alte parameter zurueck
              do i = 1, npar
                pare(i) = parsave(i)
              enddo
              finished = .FALSE.
            else
              finished = .TRUE.
            endif
          else
            finished = .TRUE.
          endif
          finished = finished .or. lambda.ge.LAMBDAMAX
        enddo               ! do while(.not.finished)
c dieser Schritt brachte (hoffentlich) eine Verbesserung, mache weiter
c keine Verbesserung von chi: gib auf
        if(chinew.ge.chiold) then
          if(lambda.gt.0) lambda = 0.
        else
          if(lambda.gt.LAMBDAMIN) then
            chiold = chinew
            zaehler = zaehler + 1
            lambda = 0.1*lambda
            if(zaehler.gt.ABBRUCH) lambda = 0
          else
            if(lambda.gt.0.) lambda = 0
          endif
        endif
      enddo                 ! do while(lambda.ge.0.)  
c Kopiere variance-kovariance Matrix
      n = (npar * (npar + 1))/2
      do i = 1, n
        varcovare(i) = 0.
      enddo
      i1 = 0
      do i = 1, npar
        if(nc(i)) then
          i1 = i1 + 1
          j1 = 0
          do j = 1, i
            if(nc(j)) then
              j1 = j1 + 1
              if(error.ge.0) varcovare(indexm(i,j)) = matrix(indexm(i1,j1))
            endif
          enddo
        endif
      enddo
      if(error.lt.0) gaseif = -1
      return
      end

          

