	integer function gasein(file, message, ndeg, mdeg)
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasein.f,v 2.7 2003/07/12 17:02:08 riess Exp riess $
c  this function subroutine reads the input for energy-, width and
c  efficiency-calibration. The data are read into the arrays of
c  the peak list. A data file might consist out of several data sets
c  which must be separated either by empty lines or by lines beginning
c  with letters.
c  Friedrich Riess  17.02.93
c---------------------------------------------------------------------------
	implicit none
	character*(*) file, message
        integer ndeg, mdeg
	character PROGID*14
        parameter (PROGID = ' --> GASEIN: ')

	include 'gastxt.icl'
        include 'gaspea.icl'

	integer ltext, addcomma
        logical istext, gasdouble
        logical mode, da, satzflag
        integer anzahl, channel, io, ios, j, count, textende, linenumber
        integer satz
        real*8 x(10)

c Bestimme ob Eingabe vom Terminal oder einer Datei erfolgt
	mode = file.eq.'TTY'
	channel = 1
	if(mode) then
	  channel = 5
	  if(message.eq.'efficiency') then
	    write(*,'('' energy, (error), ''a'', (error)'')') message
	  else
	    write(*,'('' channel, (error), ''a'', (error)'')') message
          endif
	else
	  inquire(file=file,exist=da)
	  if(.not.da) then
	    write(*,'('' GASEIC: file not present: ''a)') file
	    gasein = -1
	    return
	  else
	    open (unit=channel, file=file, status='old')
	  end if
        endif
c Lese Daten zeilenweise, markiere Headerpositionen 
	io = 0
	anzahl = 1
        satz = 0
        satzflag = .TRUE.
        linenumber = 0
	do while (io.ne.(-1) .and. anzahl.lt.TOTALPEAKS)
	  if (mode) write (*, '('' CAL> ''$)')
	  read (channel,'(a)', IOSTAT = io) texta
          linenumber = linenumber + 1
	  if(io.eq.0) then
	    textende = ltext(texta)
            if(istext(texta)) then
	      if(mode) then
                io = -1
              else 
                if(textende.gt.0)write (*,'('' : '',a)') texta(1:textende)
              endif
              if(satzflag) then
                satzflag = .FALSE.
                satz = satz + 1
              endif
              j = 1
              if(texta(1:1).eq.' ') j = 2
              ios = j + 5
	      if(texta(j:ios).eq.'degree') then
                ndeg = -1
                mdeg = -1
                ios = addcomma(texta(9:))
		read (texta(9:max(9, textende)), *, IOSTAT = ios) ndeg, mdeg
                if(ios.ne.0 .and. ndeg.le.0) ndeg = -1
              endif
            else
c  get numbers from string, allow for variable format
              count = 1
              do while(gasdouble(texta(:ltext(texta)), x(count), ios))
                if(count.le.8) count = count + 1
              enddo
 	      if(ios.eq.0) then
                peak(anzahl) = x(1)
		if(count.eq.2) then
		  area(anzahl) = x(2)
	          dpeak(anzahl) = 0.1
		  darea(anzahl) = 0.01
	          if(area(anzahl).lt.1) darea(anzahl) = 0.02*area(anzahl)
		else if(count.eq.3) then
		  dpeak(anzahl) = 0.1
		  area(anzahl) = x(2)
		  darea(anzahl) = x(3)
                else
                  dpeak(anzahl) = x(2)
                  area(anzahl) = x(3)
                  darea(anzahl) = x(4)
		end if
                width(anzahl) = satz
                anzahl = anzahl + 1
                satzflag = .TRUE.
              else
                if(ios.gt.0) then
                  write(*,'(a, a,i3,a,i3,a,a)') PROGID, 'Error (',ios,') in line ', linenumber, ' file: ', file
                endif
              endif      !   if(ios.eq.0)
	    end if         !   if(istext(texta))
          endif            !   if(io.eq.0) 
	end do             !   do while(io.ne.-1 .and. anzahl.lt.TOTALPEAKS)
        anzahl = anzahl-1
	if(.not. mode) close(unit=channel)
        if (message(:5).eq.'effic' .and. anzahl.le.5) then
          write(*,'(''  *** sorry, at least 6 calibration points needed'')')
          anzahl = 0
        endif  
        if(.not.mode) close(channel)
        gasein = anzahl
	return
	end

