	logical function gasfck (chisqr)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasfck.f,v 4.6 2003/07/22 08:12:27 riess Exp riess $
c
c  checks if there are overlapping or weak peaks
c  the peakpositions might be unsorted in this routine
c  they are sorted at the end
c  chisqr gives information about the fit:
c	chisqr >= 0: errors from gasval are valid
c	chisqr < 0 : errors are  meaningless
c       if -chisqr le npar the error in the inversion can be corrected
c  on return, gasfck = .true. if peaks have been eliminated,
c                      .false. otherwise
c  17.09.79  F. Riess
c  18.09.86  vax version
c  07.09.01  redesign
c------------------------------------------------------------------
	implicit none
	real*8 chisqr

c  number of lines which can be removed in one step
c  should be smaller than number of lines which can be added by gasres
        integer REMOVEMAX
        parameter (REMOVEMAX = 2)
c  areas must be larger than AMPFACTOR*error of area
        real*8 AMPFACTOR
        parameter (AMPFACTOR = 1.0)
c  peak distances must be larger than POSFACTOR*sqrt(sum of centroid errors squared)
        real*8 POSFACTOR
        parameter (POSFACTOR = 1.0)
c  area errors are set to TINY * average peak area
        real*8 TINY
        parameter (TINY = 1.d-20)
c  centroid errors are set to WIDTHFACTOR * fwhm
        real*8 WIDTHFACTOR
        parameter (WIDTHFACTOR = 1.0)
c
        character*(*) FFCKREJ
	parameter (FFCKREJ='(11x,''rejected:'',6x,''peak at '',f9.1$)')
	character*(*) FFCKOUTR
	parameter (FFCKOUTR='('' because it is outside of fitregion'')')
	character*(*) FFCKAREA,  FFCKTINY
	parameter (FFCKAREA='('' because of large amplitude error ('',g12.4,'' +/-'',g12.4,'')'')')
	parameter (FFCKTINY='('' because of tiny amplitude ('',g12.4,'')'')')
	character*(*) FFCKOVER
	parameter (FFCKOVER='('' +/-'',f5.1,'' because of overlap with peak at '',f9.1,
     $                  '' +/-'',f5.1)')

	include 'gasctr.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'

        logical da, chicheck
        character message*30
        integer ltext
	integer i, i1, j, kk1, l, m, nremove
	integer kill(PARTOT), sorted(PARTOT)
	real*8 parcs(PARTOT), x, y, factor, averagearea

        gasfck = .false.
c set number of peaks which can be removed
        if(lpa) write(3, '('' GASFCK: ''$)')
        nremove = min(kpeaks-1, REMOVEMAX)
        if(nremove.le.0) then
          if(lpa) write(3, '(''  nothing to do'')')
          return
        endif
        kk1 = 2*kpeaks + 1
c work only on the parcs set for the moment
c  report about problems in inversion of variace - covariance matrix
        if(lpa) then 
          i = 1
          do while(errpar(i).gt.0)
            if(i.eq.1) write(3,'(/11x,''there are problems with the errors of''$)')
            call gaschim(i, kpeaks, message)
            write(3,'('', ''a)') message(:ltext(message))
            i = i + 1
          enddo
          if(i.gt.1) write(3,'(x)')
        endif
        do i = 1, kpeaks
          parcs(i) = parc(i)
        enddo
c  get peak data from gasval
        if(lpa) write(3, '(''  checking quality of peak parameters''$)')
        call gasval(chisqr, .false., .true.)
c  restrict centroid errors, get average area
        averagearea = 0. 
        do i = 1, kpeaks
          dpeakcentroid(i) = min(dpeakcentroid(i), WIDTHFACTOR*peakwidth(i))
          averagearea = averagearea + peakarea(i)
        enddo
        averagearea = averagearea/kpeaks
c sort peakcentroids according to their sizes
        do i = 1, kpeaks
          sorted(i) = i
        enddo
        do i = 1, kpeaks-1
          x = parcs(sorted(i))
          do j = i+1, kpeaks
            if(x.gt.parcs(sorted(j))) then
              i1 = sorted(i)
              sorted(i) = sorted(j)
              sorted(j) = i1
            endif
          enddo
        enddo
        m = 0
        factor = AMPFACTOR
        if(allpeaks) factor = 0.01
c check for peaks outside of region
        do i = 1, kpeaks
          x = parcs(i) - minreg
          if(x.le.0) then
            j = 3*peakwidth(i)
            if(chicheck(i + kpeaks, 1, j)) then
              m = m + 1
              kill(m) = i
              parcs(i) = -abs(parcs(i))
              if(lpa) then
                if(m.eq.1) write(3,'(x)')
                write(3,FFCKREJ) peakcentroid(kill(m))
                write(3,FFCKOUTR)
              endif 
            endif
          endif
          x = parcs(i) - maxreg
          if(x.ge.0) then
            j = 3*peakwidth(i)
            if(chicheck(i + kpeaks, irange -j, irange)) then
              m = m + 1
              kill(m) = i
              parcs(i) = -abs(parcs(i))
              if(lpa) then
                if(m.eq.1) write(3,'(x)')
                write(3,FFCKREJ) peakcentroid(kill(m))
                write(3,FFCKOUTR)
              endif 
            endif
          endif
        enddo
	do i=1,kpeaks
          if(parcs(i).gt.0.) then
c  check for very small amplitude of peak or large error of peakarea
	    if(nremove.gt.0 .and. (peakarea(i).lt.factor*dpeakarea(i) .or. peakarea(i).lt.TINY*averagearea)) then
              if(chicheck(i + kpeaks, 1, irange)) then
	        m=m+1
	        kill(m)=i
	        if (lpa) then
                  if(m.eq.1) write(3,'(x)')
                  write(3,FFCKREJ) parcs(i)
                  if(peakarea(i).lt.factor*dpeakarea(i)) write(3,FFCKAREA) peakarea(i), dpeakarea(i)
                  if(peakarea(i).lt.TINY*averagearea) write(3,FFCKTINY) peakarea(i)
                endif
	        parcs(i) = -parcs(i)
                nremove = nremove - 1
              endif
            else
c  check for overlapping peaks
	      if(i.lt.kpeaks .and. nremove.gt.0) then
	        i1=i+1
	        if(parcs(sorted(i1)).gt.0.) then
                  y = sqrt(dpeakcentroid(sorted(i))**2 + dpeakcentroid(sorted(i1))**2)
	          if(peakcentroid(sorted(i1)) - peakcentroid(sorted(i)).lt.POSFACTOR*y) then
c  eliminate the peak with the smaller area
 	            m=m+1
	            if(peakarea(sorted(i)).lt.peakarea(sorted(i1))) then
	              kill(m) = sorted(i)
                      l = sorted(i1)
		    else
		      kill(m) = sorted(i1)
                      l = sorted(i)
		    endif
	            if(lpa) then
                      if(m.eq.1) write(3,'(x)')
                      write(3,FFCKREJ) peakcentroid(kill(m))
                      write(3,FFCKOVER)  min(dpeakcentroid(kill(m)),9.99), 
     $                          peakcentroid(l), min(dpeakcentroid(l), 9.99)
                    endif
	            parcs(kill(m))=-parcs(kill(m))
                    nremove = nremove - 1
c                  else
c                    m = m - 1
                  endif
	        end if
	      end if
	    end if
          end if
	end do
	if(m.gt.0) then
          gasfck=.true.
	  do i = 1,m
	    l =kill(i)
            if(l.gt.0) then
	      i1 = 1
	      do j=1,PARTOT
	        if(.not.(j.eq.l .or.j.eq.l+kpeaks)) then
	          par(i1)=par(j)
	          parc(i1)=parc(j)
	          nctarget(i1)=nctarget(j)
	          dpar(i1)=dpar(j)
	          deriv(i1)=deriv(j)
	          if(j.le.PEAKTOT) brv(i1)=brv(j)
		  i1=i1+1
	        end if
	      end do
	      do j = i1, PARTOT
	        par(j) = 0
	        parc(j) = 0
	        dpar(j) = 0
	        nctarget(j) =.TRUE.
	      enddo
	      kpeaks=kpeaks-1
	      npar=npar-2
	      do j=1,m
	        kill(j) = kill(j)-1
	      enddo
            endif               
	  enddo
        else
          if(lpa) write(3, '('', peaks are okay'')')
	end if
c  sort all peaks according to there position
	if(kpeaks.gt.1) then
	  do i=2,kpeaks
	    i1=i-1
	    do j=1,i1
	      if(parc(i).lt.parc(j)) then
		x=parc(i)
	        parc(i)=parc(j)
	        parc(j)=x
	        x=dpar(i)
		dpar(i)=dpar(j)
	        dpar(j)=x
	        x=deriv(i)
	        deriv(i)=deriv(j)
	        deriv(j)=x
		x=brv(i)
		brv(i)=brv(j)
		brv(j)=x
	        x=parc(i+kpeaks)
	        parc(i+kpeaks)=parc(j+kpeaks)
	        parc(j+kpeaks)=x
	        x=par(i+kpeaks)
	        par(i+kpeaks)=par(j+kpeaks)
	        par(j+kpeaks)=x
	        x=deriv(i+kpeaks)
	        deriv(i+kpeaks)=deriv(j+kpeaks)
	        deriv(j+kpeaks)=x
	        da=nctarget(i)
	        nctarget(i)=nctarget(j)
	        nctarget(j)=da
		da=nctarget(i+kpeaks)
		nctarget(i+kpeaks)=nctarget(j+kpeaks)
		nctarget(j+kpeaks)=da
	      end if
	    end do
	  end do
	end if
c  copy the centroid error for gasres
	do i=1,kpeaks
	  deriv(i) = dpeakcentroid(i)
	end do
	return
	end


	logical function chicheck(m, minrange, maxrange)
        implicit none
c limits of change in chisquare if peak has been removed
        real*8 CHILIMIT
        parameter (CHILIMIT = 1.1)

        include 'gaspar.icl'
        include 'gasctr.icl'

        integer m, minrange, maxrange, i1, i2
        real*8 fchisqr, save, chistart, ratio

        chicheck = .false.
        i1 = max(1, minrange)
        i2 = min(irange, maxrange)
        chistart= fchisqr(i1,i2)
        if(chistart.eq.0.) chistart = 1.
        save = par(m)
        par(m) = 0.
        ratio = fchisqr(i1, i2)/chistart
        par(m) = save
        if(ratio.le.CHILIMIT) chicheck = .TRUE.
        return
        end
          
