 	real*8 function gasfun(xi,nterms)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasfun.f,v 3.8 2003/04/11 09:40:40 riess Exp riess $
c
c  this function calculates the fit function and the derivatives
c  to the parameters but the latter only if nc(i)=.false.
c  the background polynomial is calculated only if nterms le.0
c  the fit function is assumed to be a gaussian with fast decaying
c  peak tails on each side, a long decaying leftside background
c  tail and a polynomial to fit the background with maximum
c  degree of 4:
c
c  gasfun=sum { ag*[exp(-es**2)+al*exp(+el)*erfc(es+sl))
c              +ab*exp(xt)*erfc(es+sb) + ar*(exp(-er)*erfc(-es+sr)]}
c              +c0 + c1*xi + c2*xi^2 + c3*xi^3 + c4*xi^4
c  the sum runs over kpeaks peaks
c  with the parameters in the common array /par/:
c      ampg2  = par(kj)^2
c      gamma = parc(kj)*{1.+parc(2*kpeaks+1)*psin[par(2*kpeaks+1)]}
c      x(j)  = parc(j)+parc(2*kpeaks+2)*psin[par(j)]
c      xg    = (xi-x(j))/gamma
c tail left
c      amp  = par(2*kpeaks+7)*poly(parc(j), nampleft, ampleft)
c      ftaul ={1.0+parc(2*keaks+8)*psin[par(2*kpeaks+8)]}
c      tau   = ftaul*poly(parc(j), ntauleft, tauleft)
c      al    = amp*amp
c      xt    = (xi-x(j))/tau
c      g2t    = 0.5*gamma/tau
c tail background
c      amp  = par(2*kpeaks+9)*poly(parc(j), nampback, ampback)
c      ftaub ={1.0+parc(2*keaks+10)*psin[par(2*kpeaks+10)]}
c      tau   = ftaub*poly(parc(j), ntauback, tauback)    
c      ab    = amp*amp
c      xt    = (xi-x(j))/tau
c      sb    = 0.5*gamma/tau
c tail right
c      amp  = par(2*kpeaks+11)*poly(parc(j), nampright, ampright)
c      ftaur ={1.0+parc(2*keaks+12)*psin[par(2*kpeaks+12)]}
c      tau   = ftaur*poly(parc(j), ntauright, tauright)   
c      ar    = amp*amp
c      er    = (xi-x(j))/tau
c      sr    = 0.5*gamma/tau
c step
c      amp  = par(2*kpeaks+13)*poly(parc(j), nampstep, ampstep)
c      ar    = amp*amp
c      xt    = (xi-x(j))/tau
c background
c      c0   = par(2*kpeaks+2)
c      c1   = par(2*kpeaks+3)
c      c2   = par(2*kpeaks+4)
c      c3   = par(2*kpeaks+5)
c      c4   = par(2*kpeaks+6)
c  the tails and the step can be switched on or of via logical variables
c   see phillips et. al.  nim 137 (1976),525
c  10.09.86  vax version
c  13.06.79  f. riess
c------------------------------------------------------------------
	implicit none
	integer nterms
	real*8 xi

	include 'gasctr.icl'
	include 'gaspar.icl'
        include 'gaseic.icl'

	integer i, j, k6, kk2, kj, kk1, kk7, kk8, kk9 ,kk10, kk11, kk12, kk13
	real*8 poly, erfc, erfcd, psin, pcos
	real*8 amp, tau, ampl2, ftaul, ampr2, ftaur, ampb2, ftaub, amps2, xt, g2t, x0
	real*8 gamma, gp, gps, xij, xg, xg2, z
        real*8 ampg, ampg2, f1, fg, ftv, ftp, result
	real*8 sumlamp, sumltau, sumramp, sumrtau, sumg, sumgj, sumbamp, sumbtau, sumpos, sumsamp

	kk1=2*kpeaks+1
	kk2=kk1+1
	k6=kk1+5
c  background polynomial
	x0=xi-parc(kk1+2)
	deriv(kk2)=1.
	f1=x0
	result=par(k6)
	do i=1,4
	  deriv(kk2+i)=f1
	  f1=f1*x0
	  result=result*x0+par(k6-i)
	end do
	gasfun=result
	if(nterms.le.0) return
c  set up pointers for tails
	kk7=kk1+6
	kk8=kk1+7
	kk9=kk1+8
	kk10=kk1+9
	kk11=kk1+10
	kk12=kk1+11
        kk13 = kk1 + 12
c  width
	gps = parc(kk1)*psin(par(kk1))
	sumg = 0.d+00
c  all peaks position are commonly varied
	sumpos=0.d+00
c  left side peak tail
	if(taill) then
          ampl2 = par(kk7)**2
	  ftaul = 1.d+00 + parc(kk8)*psin(par(kk8))
	  sumlamp = 0.d+00
          sumltau = 0.d+00
	end if
c  background tail
	if(tailb) then
          ampb2 = par(kk9)**2
	  ftaub = 1.d+00 + parc(kk10)*psin(par(kk10))
 	  sumbamp = 0.d+00
	  sumbtau = 0.d+00
	end if
c  right side peak tail
	if(tailr) then
          ampr2 = par(kk11)**2
	  ftaur = 1.d+00 + parc(kk12)*psin(par(kk12))
	  sumramp = 0.d+00
	  sumrtau = 0.d+00
	end if
c step
	if(lstep) then
          amps2 = par(kk13)**2
	  sumsamp = 0.d+00
        endif
c  go through all peaks
	do j = 1,kpeaks
	  kj = kpeaks + j
	  ampg = par(kj)
	  ampg2 = ampg*ampg
	  gp = 1.d+00 + brv(j)*gps
	  gamma = parc(kj)*gp
	  xij = xi - parc(j) - parc(kk2)*psin(par(j))
	  xg = xij/gamma
	  xg2 = xg*xg
	  if(xg2.lt.20.d+00) then
	    fg = ampg2*exp(-xg2)
	  else
	    fg = 0.d+00
	  end if
          f1 = fg
	  if(.not.nc(j)) deriv(j) = 2.d+00*xg*fg
	  if(.not.nc(kk1)) sumgj = 2.d+00*xg2*fg
	  if(taill) then
            tau = poly(parc(j), max(1, ntauleft), tauleft)
            tau = max(0.1, tau*ftaul)
	    xt = xij/tau
	    if(abs(xt).lt.20.d+00) then
	      amp = poly(parc(j), max(1, nampleft), ampleft)
              ftp = amp*ampg2*exp(xt)
	      g2t = 0.5d+00*gamma/tau
	      z = xg + g2t
	      if(z.lt.8.d+00) then
		if(z.lt.(-3.6d+00)) then
                  ftv = 2.d+00*ftp
                  ftp = 0.d+00
		else
  	          ftv = ftp*erfc(z)
                  ftp = ampl2*ftp*erfcd(z)
		endif
	        if (.not.nc(kk7)) sumlamp = sumlamp + ftv
		ftv = ampl2*ftv
                f1 = f1 + ftv
	        if (.not.nc(j)) deriv(j) = deriv(j) - 2.d+00*g2t*ftv - ftp
	        if (.not.nc(kk1)) sumgj = sumgj + (-xg + g2t)*ftp
	        if (.not.nc(kk8)) sumltau = sumltau + xt*ftv + g2t*ftp
	      endif
	    end if
	  end if
	  if(tailb) then
            tau = poly(parc(j), max(1, ntauback), tauback)
            tau = max(0.1, tau*ftaub)
	    xt = xij/tau
	    if(abs(xt).lt.20.d+00) then
              amp = poly(parc(j), max(1, nampback), ampback)
              ftp = amp*ampg2*exp(xt)
	      g2t = 0.5d+00*gamma/tau
	      z = xg + g2t
	      if(z.lt.8.d+00) then
		if(z.lt.(-3.6d+00)) then
		  ftv = 2.d+00*ftp
                  ftp = 0.d+00
		else
  	          ftv = ftp*erfc(z)
                  ftp = ampb2*ftp*erfcd(z)
		endif
	        if (.not.nc(kk9)) sumbamp = sumbamp + ftv
                ftv = ampb2*ftv
                f1 = f1 + ftv
	        if (.not.nc(j)) deriv(j) = deriv(j) - 2.d+00*g2t*ftv - ftp
	        if (.not.nc(kk1)) sumgj = sumgj + (-xg + g2t)*ftp
	        if (.not.nc(kk10)) sumbtau = sumbtau + xt*ftv + g2t*ftp
	      end if
	    end if
	  end if
	  if(tailr) then
            tau = poly(parc(j), max(1, ntauright), tauright)
            tau = max(0.1, tau*ftaur)
	    xt = xij/tau
	    if(abs(xt).lt.20.d+00) then
              amp = poly(parc(j), max(1, nampright), ampright)
              ftp = amp*ampg2*exp(-xt)
	      g2t = 0.5d+00*gamma/tau
	      z = -xg + g2t
	      if(z.lt.8.d+00) then
		if(z.lt.(-3.6d+00)) then
		  ftv = 2.d+00*ftp
                  ftp = 0.d+00
		else
  	          ftv = ftp*erfc(z)
                  ftp = ampr2*ftp*erfcd(z)
		endif
	        if (.not.nc(kk11)) sumramp = sumramp + ftv
		ftv = ampr2*ftv
                f1 = f1 + ftv
	        if (.not.nc(j)) deriv(j) = deriv(j) + 2.d+00*g2t*ftv + ftp
	        if (.not.nc(kk1)) sumgj = sumgj + (xg + g2t)*ftp
	        if (.not.nc(kk12)) sumrtau = sumrtau + xt*ftv - g2t*ftp
	      end if
	    end if
	  end if
	  if(lstep) then
            amp = poly(parc(j), max(1, nampstep), ampstep)
            ftp = amp*ampg2
	    z = xg
	    if(z.lt.8.d+00) then
	      if(z.lt.(-3.6d+00)) then
		ftv = 2.d+00*ftp
                ftp = 0.d+00
	      else
  	        ftv = ftp*erfc(z)
                ftp = amps2*ftp*erfcd(z)
	      endif
	      if (.not.nc(kk13)) sumsamp = sumsamp + ftv
              ftv = amps2*ftv
              f1 = f1 + ftv
	      if (.not.nc(j)) deriv(j) = deriv(j) - ftp
	      if (.not.nc(kk1)) sumgj = sumgj - xg*ftp
	    end if
	  end if
	  if(.not.nc(j)) then
	    deriv(j) = deriv(j)*parc(kk2)*pcos(par(j))/gamma
	    if(posall) sumpos = sumpos + deriv(j)
	  end if
	  if(.not.nc(kj) .and. ampg.ne.0.) deriv(kj) = 2.d+00*f1/ampg
	  if(.not.nc(kk1)) sumg = sumg + sumgj*brv(j)/gp
	  result = result + f1
	end do
	if(posall) deriv(1) = sumpos
	if(.not.nc(kk1))deriv(kk1) = sumg*parc(kk1)*pcos(par(kk1))
	if(.not.nc(kk7))deriv(kk7) = 2.d+00*par(kk7)*sumlamp
	if(.not.nc(kk8))deriv(kk8) = -sumltau*parc(kk8)*pcos(par(kk8))/ftaul
	if(.not.nc(kk9))deriv(kk9) = 2.d+00*par(kk9)*sumbamp
	if(.not.nc(kk10))deriv(kk10) = -sumbtau*parc(kk10)*pcos(par(kk10))/ftaub
	if(.not.nc(kk11))deriv(kk11) = 2.d+00*par(kk11)*sumramp
	if(.not.nc(kk12))deriv(kk12) = sumrtau*parc(kk12)*pcos(par(kk12))/ftaur
	if(.not.nc(kk13))deriv(kk13) = 2.d+00*par(kk13)*sumsamp
	gasfun=result
        return
	end
