	subroutine gaspar
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gaspar.f,v 2.21 2003/05/23 20:22:19 riess Exp $
c  routine determines the starting values of the parameters
c  25.02.00  spekerr included
c  11.09.86  vax version
c  30.06.79  f. riess
c  AREACONSTANTE = 1./sqrt(pi)
c------------------------------------------------------------------
	implicit none

        real*8 TAILTHRESHOLD
        parameter (TAILTHRESHOLD = 0.70)
	character*(*) FPARTAILC
        parameter (FPARTAILC = '(x,a,f6.2$)')
	character*(*) FPARPOLYD
	parameter (FPARPOLYD='('' GASPAR:   Contributions to the degree
	1 of the background polynomial. range:'',f8.3,'' statistics:'',f10.3)')

	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
	include 'gaspea.icl'

	logical taillv, tailrv, tailbv, lstepv, fittail, lpout, isensw
	integer i, i1, i2, ierr, j, jj, l, m, n, nb1, nbm, nbrv, ntau
	real*8 gasfun, getstk, poly
	real*8 sum1, sume, ampv, amppv, fwhmv, x, x1, x2, y
	real*8 wx(20), wy(20), wp(6)


c  set all parameters to novariation mode
        lpout = lpa .and. isensw(6)
	do i=1,PARTOT
	  nctarget(i)=.true.
	  par(i) = 0
	  parc(i) = 0
	end do
c  setup for centroid, amplitude, width and tail condition
        taillv = (taill .and. (fitltail .or. taillrange.ge.0.01))
	tailrv = (tailr .and. (fitrtail .or. tailrrange.ge.0.01))
	tailbv = (tailb .and. (fitbtail .or. tailbrange.ge.0.01))
	lstepv = (lstep .and.  fitlstep)
	fittail = taillv .or. tailrv .or. tailbv .or. lstepv
	tail = tailenforced .and. fittail
	l=linepo+1
	nbrv=0
        if(fittail .and. lpout) write(3, '('' GASPAR:   check for contributions to tail ''
     $   ''variation (threshold > ''f5.3'')'')') TAILTHRESHOLD
c  centroid
	do n = 1,kpeaks
	  parc(n) = peak(l)
	  par(n) = 0.
	  if(.not.(poscon .or. (peaklist .and. dpeak(l).le.0.)))  nctarget(n) = .false.
c  width
	  brv(n) = 1.
	  if(widthlist) then
            if(width(l).lt.0.) brv(n) = 0.
	    fwhmv = abs(width(l))
	  else
	    fwhmv = poly(peak(l),ndw,aws)
	  end if
	  parc(kpeaks+n) = WIDTHCONSTANTE*fwhmv
	  nbrv = nbrv + brv(n) + 0.01
c  amplitude
	  amppv = AREACONSTANTE*area(l)/parc(n+kpeaks)
	  par(n+kpeaks) = sqrt(amppv)
	  if(darea(l).gt.0.) nctarget(n+kpeaks) = .FALSE.
c  if there are tails, check if peaks are strong enough for
c  a tail variation
	  m = parc(n) + 1.5 - minreg
          j = 1.5*fwhmv + 0.5
          if(fittail .and. lpout) write(3, '(11x,''peak at'',f9.1$)') parc(n)
c          if(fittail) write(*, '(9x,''peak at'',f9.1,f14.1$)') parc(n), area(l)
	  if(taillv) then
            ntau = min(1., poly(parc(n), max(1, ntauleft), tauleft)) + 0.5
            i2 = max(1, m - j)
            i1 = max(1, i2 - ntau)
            x1 = weight(i1)
            sume = 0.
            do i = i1, i2
              if(weight(i).gt.1.2*x1) then
                 sume = sume + x1*x1
              else
                sume = sume + weight(i)*weight(i)
              endif
              x1 = min(x1, weight(i))
            enddo
            sume = sqrt(sume)/(i2 - i1 +1)
	    ampv = max(1.d-30, poly(parc(n), max(1, nampleft), ampleft))
            ampv = amppv*ampv/(1.+ampv)
            if(sume.gt.0.) then
              x = min(9.99, max(-9.99, log10(ampv/sume)))
            else 
              x = -9.99
            endif
            tail = tail .or. x.gt.TAILTHRESHOLD
            if(lpout) write(3, FPARTAILC) 'left peak tail ', x                                     
          endif
	  if(tailrv) then
            ntau = min(1., poly(parc(n), max(1, ntauright), tauright)) + 0.5
            i1 = min(irange, m + j)
            i2 = min(irange, i1 + ntau)
            x1 = weight(i1)
            sume = 0.
            do i = i1, i2
              if(weight(i).gt.1.2*x1) then
                 sume = sume + x1*x1
              else
                sume = sume + weight(i)*weight(i)
              endif
              x1 = min(x1, weight(i))
            enddo
            sume = sqrt(sume)/(i2 - i1 +1)
	    ampv = max(1.d-30, poly(parc(n), max(1, nampright), ampright))
            ampv = amppv*ampv/(1.+ampv)
            if(sume.gt.0.) then
              x = min(9.99, max(-9.99, log10(ampv/sume)))
            else 
              x = -9.99
            endif
            tail = tail .or. x.gt.TAILTHRESHOLD
            if(lpout) write(3, FPARTAILC) 'right peak tail', x                                     
          endif
	  if(tailbv) then
            ntau = max(1., poly(parc(n), max(1, ntauback), tauback)) + 0.5
            i2 = max(1, m - j)
            i1 = max(1, i2 - ntau)
            x1 = weight(i1)
            sume = 0.
            do i = i1, i2
              if(weight(i).gt.1.2*x1) then
                 sume = sume + x1*x1
              else
                sume = sume + weight(i)*weight(i)
              endif
              x1 = min(x1, weight(i))
            enddo
            sume = sqrt(sume)/(i2 - i1 +1)
	    ampv = max(1.d-30, poly(parc(n), max(1, nampback), ampback))
            ampv = amppv*ampv/(1.+ampv)
            if(sume.gt.0.) then
              x = min(9.99, max(-9.99, log10(ampv/sume)))
            else 
              x = -9.99
            endif
            tail = tail .or. x.gt.TAILTHRESHOLD
            if(lpout) write(3, FPARTAILC) 'background tail', x                  
          endif
	  if(lstepv) then
            ntau = 3*fwhmv
            i2 = max(1, m - j)
            i1 = max(1, i2 - ntau)
            x1 = weight(i1)
            sume = 0.
            do i = i1, i2
              if(weight(i).gt.1.2*x1) then
                 sume = sume + x1*x1
              else
                sume = sume + weight(i)*weight(i)
              endif
              x1 = min(x1, weight(i))
            enddo
            sume = sqrt(sume)/(i2 - i1 +1)
	    ampv = max(1.d-30, poly(parc(n), max(1, nampstep), ampstep))
            ampv = amppv*ampv/(1.+ampv)
            if(sume.gt.0.) then
              x = min(9.99, max(-9.99, log10(ampv/sume)))
            else 
              x = -9.99
            endif
            tail = tail .or. x.gt.TAILTHRESHOLD
            if(lpout) write(3, FPARTAILC) 'step function', x                                     
          endif
c             write(*, '(f8.2,i6,3f10.2)') x, I2 - i1 + 1, x1, amppv, ampv
          if(fittail .and. lpout) write(3,'(x)')
	  l = l + 1
	end do

	lineps=linepo
	linepo=linepo+kpeaks
c  setup variation range for the width
	npar=2*kpeaks+1
	par(npar)=0.
	parc(npar)=abs(fwhmrange)
	if(parc(npar).le.0.01 .or. nbrv.eq.0) parc(npar)=0.
	if(parc(npar).gt.0.) nctarget(npar)=.false.
c .. and centroids
	if(.not.poscon) then
	  parc(npar+1)=0.5*(parc(kpeaks+1)+parc(2*kpeaks))
	else
	  parc(npar+1)=0.
	end if
c .. and medium channel of fit range
	parc(npar+2)=minreg+irange/2
c  reset all background and tail parameters:
c  background:  npar = 2*kpeaks+2...2*kpeaks+6
c  tail:        npar = 2*kpeaks+7...2*kpeaks+11
	npar = 2*kpeaks + 2
	do i = npar, PARTOT
	  par(i) = 0.
	end do
	npar = 2 * kpeaks + 6
	if (taill) then
c  peak tail left: npar = 2*kpeaks+7,2*kpeaks+8
	  npar = 2 * kpeaks + 7
c if tail is to be varied: reset parameter
c otherwise keep it from previous fit
          if(tail) then
            fampleft = 1.
            ftauleft = 0.
	  end if
c if decay parameter not to be varied: parameter is zero
c note: the actual values are defined in gasfun
          if (taillrange.eq.0.) ftauleft = 0.
	  par(npar) = fampleft 
	  nctarget (npar) = .not.(tail .and. fitltail)
	  npar = npar +1
	  par(npar) = ftauleft
	  parc(npar) = taillrange
	  nctarget(npar) = .not.(tail .and. taillrange.ge.0.01)
	end if
	if(tailb)then
c  background tail: npar=2*kpeaks+9,2*kpeaks+10
	  npar = 2 * kpeaks + 9
          if(tail) then
            fampback = 1.
            ftauback = 0.
	  end if
          if (tailbrange.eq.0.) ftauback = 0.
	  par(npar) = fampback 
	  nctarget (npar) = .not.(tail .and. fitbtail)
	  npar = npar +1
	  par(npar) = ftauback
	  parc(npar) = tailbrange
	  nctarget(npar) = .not.(tail .and. tailbrange.ge.0.01)
	end if
	if(tailr)then
c  peak tail right:  npar=2*kpeaks+11, 2*kpeaks+12
	  npar = 2 * kpeaks + 11
          if(tail) then
            fampright = 1.
            ftauright = 0.
	  end if
          if (tailrrange.eq.0.) ftauright = 0.
	  par(npar) = fampright 
	  nctarget (npar) = .not.(tail .and. fitrtail)
	  npar = npar +1
	  par(npar) = ftauright
	  parc(npar) = tailrrange
	  nctarget(npar) = .not.(tail .and. tailrrange.ge.0.01)
	end if
	if(lstep)then
c  step: npar=2*kpeaks+13
	  npar = 2 * kpeaks + 13
          if(tail) fampstep = 1.
	  par(npar) = fampstep 
	  nctarget(npar) = .not.(tail .and. fitlstep)
	end if
c  get parameters for the background
c  first subtract contributions from the peaks
	do i=1,PARTOT
	  nc(i)=.true.
	end do
	x=minreg
	sum1=0.
        sume = 0.
	do i=1,irange
	  y=gasfun(x,npar)
	  yfa(i)=ya(i)-y
c	  resi(i)=abs(ya(i))+abs(y)+10.
          resi(i) = weight(i)*weight(i)
	  sum1=sum1+yfa(i)
          sume = sume + weight(i)*weight(i)
	  x=x+1.
	end do
	sum1 = sum1/irange
	sume = sqrt(sume/irange)
c  get the degree of the background polynomial if not specified yet:
c  The estimate steems from the number of peaks in the fitregion and the
c     statistics of the background
	if(backdeg.lt.0) then
          if(backpol.ge.0) then
            backdeg = backpol 
          else
            if(backdeg.lt.0.) then
              x1 =  kpeaks*wids
              x1 = sqrt(sqrt(max(0.0001,(irange  - x1)/(3.*x1))))
              x2 = 2.*log10(max(0.1, sum1/sume))
	      backdeg = max(0., min(-backpol, x1 + x2))
	      if(lpout) write (3,FPARPOLYD) x1, x2
            endif
          endif
	endif
c  determine coefficients of polynomial by a fit to the difference spectrum
	do i = 1, 5
	  par(2*kpeaks+1+i) = 0.
	enddo
        if(.not.backfixed) then
	  nb1=backdeg+1
	  nbm=(nb1*(nb1+1))/2
	  do i=1,nbm
	    wx(i)=0.
	    wy(i)=0.
	  end do
	  x=-(irange/2)
	  do i=1,irange
	    y=yfa(i)
	    x1=1./resi(i)
	    l=0
	    do j=1,nb1
	      wy(j)=wy(j)+y*x1
	      x2=1.
	      do jj=1,j
	        l=l+1
	        wx(l)=wx(l)+x1*x2
	        x2=x2*x
	      end do
	      x1=x1*x
	    end do
	    x=x+1.
	  end do
	  ierr=1
	  do while (ierr.ne.0)
	    if(nb1.eq.1) then
	      wx(1)=1./wx(1)
	      ierr=0
	    else
	      call dsinv(wx,nb1,1.d-10,ierr)
	      if(ierr.ne.0)nb1=nb1-1
	    end if
	  end do
	  do j=1,nb1
	    jj=j-1
	    l=(j*jj)/2
	    y=0.
	    do i=1,nb1
	      l=l+1
	      if(i.gt.j)then
	        l=l+jj
	        jj=jj+1
	      end if
	      y=y+wy(i)*wx(l)
	    end do
	    nbm=(j*(j+1))/2
	    if(abs(y).lt.sqrt(wx(nbm)))y=0.
	    wp(j)=y
	    par(2*kpeaks+1+j)=y
	  end do
	  do i=1, backdeg+1
	    nctarget(i+2*kpeaks+1) = .false.
	  end do
	else
	  par(2*kpeaks+2) = backvalue
	endif
c  the statistical weight is determined by smoothing, the number of
c  smoothing channels depends on the peak width
	parc(2*kpeaks + 4) = max (1., min (4., 0.4*(parc(kpeaks+1)+parc(2*kpeaks))))
	tinp = 1.
	if (nonestat) tinp = getstk(1, irange, ya, weight)
	tinp = tinp**2
        i = 0
        if(smootherror) i = nint(parc(2*kpeaks + 4))
	call gasweight(irange, weight, weight, i, tinp)
	return
	end
