	logical function gaspck()
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gaspck.f,v 3.13 2003/04/18 12:50:49 riess Exp riess $
c
c  this function checks the quality of the parameter and their
c  errors with respect to the minimum in chisqr: a change of
c  the parameter by its error should change a chisqr minimized
c  with respect to the other parameters by 1. 
c  there are 2 modes
c  the option "set parameter -check" sets the variable parcheck to +1
c    4 values of chisquare are computed: at +/- dpar and +/- 0.1*dpar
c
c  the option "set parameter -fullcheck" sets the variable parcheck to -1
c    2*SAPOINTS values of chisquare are computed in the range of
c    - dpar and + dpar
c
c  in both cases starts the fitting procedure from delta par = 0
c
c  if an improvement in chisquare is found, the return value is set
c  to .true. with the new parameter set.
c
c  the sampling will be saved into files CHISAMPLExxx.dat
c  if isensw(14) is set to .true.
c
c 
c  on return gaspck=.false. if everything is okay,
c                  =.true. if a parameter was not in the minimum
c
c  23.09.83  F. Riess
c------------------------------------------------------------------
	implicit none

        logical checkonly
        parameter (checkonly = .false.)   !  return allways with .false. if set to .true.
        integer SAPOINTS, SA2POINTS
        parameter (SAPOINTS = 10)   ! half of the number of sample points
        parameter (SA2POINTS = 2*SAPOINTS + 1)
        integer KANAL, SKANAL
        parameter (KANAL = 3)         !  lpa output channel
        parameter (SKANAL = 14)      !  output channel for sample
        logical SILENT                
        parameter (SILENT = .true.)   ! there will be too much output from gasstp and gaschi
        real*8 LIMIT
        parameter (LIMIT = 1.d+00)       ! limit for resticted parameters
        real*8 CHILIML,CHILIMU, MINCHI
        parameter (CHILIML = 0.3)        ! lower and upper limit for
        parameter (CHILIMU = 3.0)        !  acceptance of change in chisquare
        parameter (MINCHI = 0.1)       !  set abs(dchi) gt MINCHI
        real*8 DAMPMINUS, DAMPPLUS
        parameter (DAMPMINUS = 0.707)    ! limiting factors for changes in amplitudes
        parameter (DAMPPLUS = 0.414)
	character*(*) FPCKCHECK
	parameter (FPCKCHECK = '('' GASPCK: check of the parameters and their errors''$)')
        character*(*) FPCKNOOK
        parameter (FPCKNOOK = '(9x''--> ''i3'' out of ''i3'' parameter errors are not correct'')')
        character*(*) FPCKIMPR, FPCKNIMPR
        parameter (FPCKIMPR = '(9x''--> fit can be improved with parameter '',a$)')
        parameter (FPCKnIMPR = '(9x''--> fit could be improved with parameter '',a,
     $   '' but parameter is at its limit'')')
	character*(*) FPCKOKAY
	parameter (FPCKOKAY = '(9x''all parameters are okay'')')
	character*(*) FPCKCHI0
	parameter (FPCKCHI0 = '(9x''chisqr :'',g12.4/9x,
	1''change of chisqr by a parameter change in both directions'')')
	character*(*) FPCKHEAD
	parameter (FPCKHEAD = '(6x,''parameter''13x''value''11x''-dvalue''6x''+dvalue''7x
	1,''-dpar''6x,''+dpar'',7x,''dchi(-)'',5x''dchi(+)'')')
        character*(*) FPCKOUT1
        parameter (FPCKOUT1 = '(4x,a,a$)')
        character*(*) FPCKOUT2
c        parameter (FPCKOUT2 = '(a,f9.2,''(-)'',f9.2,''(+)'')')
        parameter (FPCKOUT2 = '(a,g12.2,3g15.2)')


	include 'gasctr.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
        include 'gaseic.icl'

        real*8 chi0, sqchi0f
	logical equalexp, isensw, samplefile, cancelfit
	logical tmpl, lpout, header, restricted, outsample
	character string*18, outform*120, impstr*18
        integer ltext
	integer i, j, kk1, kk7, n, nfree, ncount, nm, m, repeat, total, notokay, ndchi0
	real*8 gasstp, parlim, psin, poly
	real*8 x, tmp, dvalue(2), dparv(2), chim, step, dchimin, dparmin
	real*8 pars(PARTOT), dpars(PARTOT), parcs(PARTOT), parnew(PARTOT), parcnew(PARTOT)
        real*8 deltapar(SA2POINTS), deltachi(SA2POINTS), maxdpar
        data outsample /.false./

        gaspck = .false.
        if(parcheck.eq.0) then
          if(outsample) close(unit = SKANAL)
          outsample = .false.
          return
        endif
        header = .false.
        lpout = lpa .and. isensw(7)
c        lpout = .true.
        if(isensw(14) .and. .not.outsample) outsample = samplefile(SKANAL)
	if(lpa) write(KANAL, FPCKCHECK)
c  get initial chisquare
        chi0 = gasstp(nfree, ncount, .TRUE.,1.d-4)
        sqchi0f = sqrt(chi0/nfree)
c get values and errors
        call gasval(1., .FALSE., .TRUE.)
	kk1 = 2*kpeaks+1
	kk7 = kk1 + 6
c save parameters
	do i = 1, npar
	  pars(i) = par(i)
	  dpars(i) = dpar(i)
          parcs(i) = parc(i)
	enddo
        do i = 1, SA2POINTS
          deltachi(i) = -chi0
        enddo
        ndchi0 = SAPOINTS + 1
        deltachi(ndchi0) = 0.
        deltapar(ndchi0) = 0.
c  step through all parameters which are varied
        nm = 0
        chim = chi0
        dchimin = 0.
        notokay = 0
        total = 0
        n = 1
	do while(n.le.npar .and. .not.cancelfit(1))
	  if(.not.nctarget(n)) then
            restricted = .FALSE.
            total = total + 1
c  peak positions
            if(n.le.kpeaks) then
              restricted = .TRUE.
              dparv(1) = -min(sqchi0f*dpars(n), parlim(LIMIT))
              dparv(2) = -dparv(1)
              dvalue(1) = parcs(kk1+1)*(psin(pars(n) + dparv(1)) - psin(pars(n)))
              dvalue(2) = parcs(kk1+1)*(psin(pars(n) + dparv(2)) - psin(pars(n)))
              x = parc(n)
	      write(string, '(a,i2,a)') 'peak #',n,' pos.'
c  peakamplitude
            else if(n.le.2*kpeaks) then
              dparv(1) = -min(DAMPMINUS*pars(n), sqchi0f*dpars(n))
              dparv(2) = min(sqchi0f*dpars(n), DAMPPLUS*pars(n))
              x = peakarea(n-kpeaks)
              dvalue(1) = x*(1. + dparv(1)/pars(n))**2 - x
              dvalue(2) = x*(1. + dparv(2)/pars(n))**2 - x
	      write(string, '(a,i2,a)') 'peak #',n-kpeaks,' amp.'
c  width
            else if(n.eq.kk1) then
              restricted = .TRUE.
              x = peakwidth(kpeaks)
              dvalue(1) = x
              dparv(1) = -min(sqchi0f*dpars(n), max(pars(n) - parlim(-LIMIT), 0.))
              tmpl = .false.
              i = 0
              do while(tmpl)
                dvalue(1) = psin(pars(n) + dparv(1)) - psin(pars(n)) 
                dvalue(1) = dvalue(1)*parcs(2*kpeaks)*parcs(n)/WIDTHCONSTANTE
                tmpl = dvalue(1).gt.x - 1.
                if(tmpl) dparv(1) = dparv(1) + 0.01
            i = i + 1
                if(i.gt.20) call exit
              enddo
              dparv(2) =  min(sqchi0f*dpars(n), parlim(LIMIT) - pars(n)) 
              dvalue(2) = psin(pars(n) + dparv(2)) - psin(pars(n))
              dvalue(2) = dvalue(2)*parcs(2*kpeaks)*parcs(n)/WIDTHCONSTANTE
	      string = 'peak width'
c coefficients of backgroud polynomial
            else if(n.lt.kk7) then
              dparv(1) = -sqchi0f*dpars(n)
              dparv(2) = sqchi0f*dpars(n)
              dvalue(1) = -sqchi0f*dpars(n)
              dvalue(2) = sqchi0f*dpars(n)
              x = pars(n)
              write(string, '(''bgr. poly. a('',i1'')'')') n-kk1-1
c tail amplitudes
	    else if(n.eq.kk7 .or. n.eq.kk7+2 .or. n.eq.kk7+4 .or. n.eq.kk7+6) then
              dparv(1) = -min(DAMPMINUS*abs(pars(n)), sqchi0f*dpars(n))
              dparv(2) =  min(sqchi0f*dpars(n), DAMPPLUS*pars(n))
              if(n.eq.kk7) then
                tmp = poly(parcs(kpeaks), max(1, nampleft), ampleft)
                string = 'left tail ampl.'
	      else if(n.eq.kk7+2) then
                tmp = poly(parcs(kpeaks), max(1, nampback), ampback)
                string = 'bgr. tail ampl.'
              else if(n.eq.kk7+4) then
                tmp = poly(parcs(kpeaks), max(1, nampright), ampright)
                string = 'right tail ampl.'
	      else if(n.eq.kk7+6) then
                tmp = poly(parcs(kpeaks), max(1, nampstep), ampstep)
                string = 'step ampl.'
              else
                continue
              endif
              x = tmp*pars(n)**2
              dvalue(1) = tmp*(pars(n) + dparv(1))**2 - x
              dvalue(2) = tmp*(pars(n) + dparv(2))**2 - x
c tail decay constants
            else if(n.eq.kk7+1 .or. n.eq.kk7+3 .or. n.eq.kk7+5) then
              restricted = .TRUE.
              dparv(1) = -min(dpars(n), max(pars(n) - parlim(-LIMIT), 0.)) 
              dparv(2) =  min(dpars(n), parlim(LIMIT) - min(pars(n), parlim(LIMIT))) 
              dvalue(1) = psin(pars(n) + dparv(1)) - psin(pars(n)) 
	      if(n.eq.kk7+1)  then
                tmp = poly(parcs(kpeaks), max(1, ntauleft), tauleft)
                string = 'left tail decay'
	      else if(n.eq.kk7+3) then
                tmp = poly(parcs(kpeaks), max(1, ntauback), tauback)
                string = 'bgr. tail decay'
	      else
                tmp = poly(parcs(kpeaks), max(1, ntauright), tauright)
                string = 'right tail decay'
              endif
              x = tmp*(1. + parcs(n)*psin(pars(n)))
              dvalue(1) = tmp*(1. + parcs(n)*psin(pars(n) + dparv(1))) - x
              dvalue(2) = tmp*(1. + parcs(n)*psin(pars(n) + dparv(2))) - x
            endif
c  set up parameter points
            do repeat = 1, 2
              maxdpar = abs(dparv(3-repeat))
              if(restricted) then
                if(maxdpar.eq.0.) maxdpar = 0.95
                maxdpar = min(maxdpar, 0.95)
              else
                if(maxdpar.eq.0) maxdpar = 0.9*abs(pars(n))
              endif
              step = maxdpar/SAPOINTS
              if(repeat.eq.1) then
                do i = 1, SAPOINTS
                  deltapar(ndchi0 + i) = i*step
                enddo
              else
                do i = 1, SAPOINTS
                  deltapar(i) = -(SAPOINTS - i + 1)*step
                enddo
              endif
            enddo
            if(outsample) then
              write(SKANAL,'(a$)') string(:ltext(string))
              j = n
              if(n.gt.kpeaks) j = min(n-kpeaks, kpeaks)
              write(SKANAL,'('' (''f8.1'') par #''i3'' chi0 ='',g15.5)') parcs(j), n, chi0
            endif
c  minimize with respect to the other parameters
            nctarget(n) = .true.
            m = 1
            if(parcheck.gt.0) m = max(1, (SAPOINTS + 5)/10)
            tmpl = .false.
            i = ndchi0 + m
            do while(i.gt.0)
              if(n.le.kpeaks) then
                parc(n) = parcs(n) + parcs(kk1+1)*psin(deltapar(i))
              else
   	        par(n) = pars(n) + deltapar(i)
              endif
              deltachi(i) = gasstp(nfree, ncount, SILENT, 1.d-2) - chi0
c  avoid getting trapped by loss in precision
              tmp = deltachi(i)
              if(abs(tmp).lt.MINCHI) tmp = MINCHI
c  check if there is an improvement in chisquare
              if(tmp.lt.dchimin) then
                dchimin = tmp
                dparmin = deltapar(i)
                nm = n
                do j = 1, npar
                  parnew(j) = par(j)
                  parcnew(j) = parc(j)
                enddo 
                impstr = string
              endif
              if(i.eq.1 .or. i.eq.SA2POINTS) then
		 tmpl = tmpl .or. deltachi(i).lt.CHILIML .or. deltachi(i).gt.CHILIMU
              endif
c  increment logic according to parcheck
              if(parcheck.gt.0) then
                if(i.eq.ndchi0 + m) then
                  i =SA2POINTS
                else if(i.eq.SA2POINTS) then
                  i= ndchi0 - m
                  do j = 1, npar
                    par(j) = pars(j)
                    parc(j) = parcs(j)
                  enddo
                else if(i.eq.ndchi0 - m) then
                  i = 1
                else
                  i = 0
                endif
              else
                if(i.eq.SA2POINTS) then
                  i = ndchi0 - 1
                  do j = 1, npar
                    par(j) = pars(j)
                    parc(j) = parcs(j)
                  enddo
                else if(i.gt.ndchi0) then
                  i = i + 1
                else
                  i = i - 1
                endif
              endif
            enddo
            if(outsample) then
              do i = 1, SA2POINTS
                if(deltachi(i).gt.-chi0) write(SKANAL, '(2e16.5)') deltapar(i), deltachi(i)
              enddo
              write(SKANAL, '(4e16.5)') deltapar(1), deltachi(1), deltapar(1), deltachi(1)
            endif
            if(tmpl) notokay = notokay + 1
            if(lpout) tmpl = .true.
c  output changes if either change is not okay or it is desired
	    if(lpa .and. tmpl) then
              if(.not.header) then
                write(KANAL, FPCKCHI0) chi0
                write(KANAL, FPCKHEAD)
                header = .true.
              endif
              write(KANAL, '(''   ''$)')
              tmp = max(abs(dvalue(1)), abs(dvalue(2)))
              tmpl = equalexp(x, tmp, 2, .FALSE., outform)
	      write(KANAL, '(x,a,a$)') string, outform(:17)
              tmpl = equalexp(dvalue(1), tmp, 2, .FALSE., outform)
	      write(KANAL, '(a$)') outform(5:17)
              tmpl = equalexp(dvalue(2), tmp, 2, .FALSE., outform)
	      write(KANAL, '(a$)') outform(5:17)
              tmp = max(abs(dparv(1)), abs(dparv(2)))
              tmpl = equalexp(dparv(1), tmp, 2, .FALSE., outform)
	      write(KANAL, '(a$)') outform(5:17)
              tmpl = equalexp(dparv(2), tmp, 2, .FALSE., outform)
              write(KANAL, FPCKOUT2) outform(7:17), deltachi(1), deltachi(SA2POINTS)
	    end if
c restore all parameters
            do i = 1, npar
              par(i) = pars(i)
              dpar(i) = dpars(i)
              parc(i) = parcs(i)
            enddo
            nctarget(n) = .false.
           endif   ! .not.nctarget(n)
          if(CHECKONLY) nm = 0
          if(abs(parcheck).le.1 .and. nm.gt.0) n = npar
          n = n + 1
        enddo     ! while(n.le.npar)
	if(notokay.gt.0 .and. lpa) write(KANAL, FPCKNOOK) notokay, total
        if(nm.gt.0) then
          if(lpa) then
            write(KANAL, FPCKIMPR) impstr(:ltext(impstr))
            if(dchimin.lt.0.) write(KANAL, '('' (dchi = ''g12.2,'' at dpar = '',g12.2,
     $                                        '')'')') dchimin, dparmin
            write(KANAL, '(9x,'' --> returning to fit routine'')')
          endif
c  chisquare can be improved, adapt new parameters
          do j = 1, npar
            par(j) = parnew(j)
            parc(j) = parcnew(j)
          enddo
          gaspck = .TRUE.
        else
c restore variance - covariancematrix
          chi0 = gasstp(nfree, ncount, .TRUE.,1.d-4)
          if(nm.lt.0 .and. lpa) write(KANAL, FPCKNIMPR) impstr   
        endif
        if(lpa .and. notokay.eq.0 .and. nm.eq.0) write(KANAL,FPCKOKAY)
	return
	end



        logical function samplefile(kanal)
c open s and closes the history file

        implicit none
        
        include 'gasfil.icl'

        integer kanal
        integer addcomma, filemain, ltext
        character filename*20, fstatus*10
        logical da
        integer ios, filecount
        data filecount/0/
   
        inquire(unit = kanal, opened = da)
        if(da) close(unit = kanal)
c
        write(filename, '(a,i3.3,''.dat'')') CHISAMPLE, filecount
	inquire (file = filename, exist = da)
	if(da) then
          if(filecount.eq.0) write(*,'('' overwriting existing sample files'')')
          fstatus = 'old'
        else
          fstatus = 'unknown'
        endif  
        open(unit = kanal, file = filename, status = fstatus, iostat = ios)
        if(ios.ne.0) then
          samplefile = .FALSE.
          if(filecount.eq.0) write(*, '('' --> can not write into sample file'')')
        else
          write(fstatus,'(i7)') nroute
	  ios = addcomma(fstatus)
          ios = filemain(files)
	  write(kanal, '(''file: ''a'' -> ''a)') files(ios:ltext(files)), fstatus(:ltext(fstatus))
          samplefile = .TRUE.
        endif
        filecount = filecount + 1
        return
	end
