	real*8 function gasrep( xmin, xmax, length, distance)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasrep.f,v 2.4 2002/09/26 12:54:07 riess Exp $   
c  this function tries to define a reasonable division of
c  an axis according to values of xmin and xmax with markings
c  around "distance"
c------------------------------------------------------------
	implicit none
	real*8 xmin, xmax, length, distance
	real*8 dx, multipl
	integer n, step
c  get number of intervalls
	gasrep=xmax+abs(xmin)+10.
	n=length/distance
	if(n.gt.0) then
c  get the corresponding values for this intervall
	  dx=(xmax-xmin)/n
	  if(dx.gt.0.) then
	    multipl=1.
	    do while (dx.ge.10.)
	      dx= dx/10.
	      multipl = 10.*multipl
	    end do
            do while (dx.lt.1.)
              dx = 10.*dx
              multipl = multipl/10.
            enddo
	    if(dx.gt.8.) then
	      dx=0.
	      step=10
	    else if(dx.gt.4.) then
	      dx=0.
	      step=5
	    else if(dx.gt.1.5) then
	      dx=0.
	      step=2
	    else
	      step=1
	    end if
	    gasrep=step*multipl
	  end if
	end if
	return
	end	


