	integer function gasspc(xbeg,xend,file,sp)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasspc.f,v 2.6 2000/06/27 15:05:05 riess Exp $
c  this routine reads a spectrum according to the  variable fileformat
c  it should return the following values:
c  0, if the file was not found or none of the variables are set
c  >0, value of last channel
c  <0, non existent subspectrum, negativ value of last subspectrum
c  the routine will fill the arrays defined in gasfil.f with
c  the available spectrum input formats when called the first time
c  if the spectrum is empty, the value -99999 will be returned
c  24.02.2000 filling spekerr for any file format
c  04.02.2000 including daterr format, excluding pemler formats
c  11.09.86  vax version
c  03.09.78  F. Riess
c----------------------------------------------------------------------
	implicit none

	integer xbeg, xend
	character file*(*)
	real*8 sp(1)

	character *(*) FGASSPC
	parameter (FGASSPC = '('' --> GASSPC: '',a,a,a,a,a,i4)')

	include 'gasctr.icl'
	include 'gasfil.icl'
        include 'gasspe.icl'

	integer readascii, readdat, readdaterr, ltext, readosp, readstrasb
	integer readmatrix, readfft, addcomma
        integer i, j
        logical first
        character string*9
        data first /.true./

c  define the possible spectrum input formats:
c  cmdformat: String of the command
c  extformat: fileextension
c  txtformat: Text to describe the format
        if(first) then
          cmdformat(1) = 'ascii'
          extformat(1) = 'ascii'
          txtformat(1) = 'sequence of channel contents'
          cmdformat(2) = 'dat'
          extformat(2) = 'dat'
          txtformat(2) = 'sequence of channel number and contents'
          cmdformat(3) = 'daterr'
          extformat(3) = 'daterr'
          txtformat(3) = 'sequence of channel number,contents and error'
          cmdformat(4) = 'online'
          extformat(4) = 'osp'
          txtformat(4) = 'online format (Munich)'
          cmdformat(5) = 'stras'
          extformat(5) = 's'
          txtformat(5) = 'online format Strasbourg'
          cmdformat(6) = 'fourier'
          extformat(6) = 'fft'
          txtformat(6) = 'format falch (Munich)'
          first = .false.
        endif
	gasspc = 0
	if(ltext(file).le.0) return
c  ascii format: channel contents per line
        errextern = .FALSE.
        if(fileformat.eq.1 .or. fileformat.eq.(-1)) then
	  gasspc = readascii(file(:ltext(file)), nroute, sp, xbeg, xend, interactiv)
c  dat format, channel number [+subspectrum number] + contents per line
        else if(fileformat.eq.2 .or. fileformat.eq.(-2)) then
          gasspc = readdat(file(:ltext(file)), nroute, sp, xbeg, xend, interactiv)
c  err format, channel number [+subspectrum number] + contents + error per line
        else if(fileformat.eq.3 .or. fileformat.eq.(-3)) then
          errextern = .TRUE.
          gasspc = readdaterr(file(:ltext(file)), nroute, sp, spekerr, xbeg, xend, interactiv)
c local online format (Munich)
	else if(fileformat.eq.4 .or. fileformat.eq.(-4)) then
	  gasspc = readosp (file(:ltext(file)), nroute, sp, xbeg, xend)
c Strasbourg online format
        else if(fileformat.eq.5) then
          gasspc = readstrasb(file(:ltext(file)), nroute, sp, xbeg, xend)
        else if(fileformat.eq.(-5)) then
          gasspc = readmatrix(file(:ltext(file)), nroute, sp, xbeg, xend)
c Pemler Format
c       else if(fileformat.eq.5) then
c         gasspc = readpemler1(file(:ltext(file)), nroute, sp, i, xend)
c       else if(fileformat.eq.(-5)) then
c         gasspc = readpemler2(file(:ltext(file)), nroute, sp, i, xend)
c fourier transforms of Falch
        else if(fileformat.eq.6) then
          gasspc = readfft(file(:ltext(file)), nroute, sp, xbeg, xend, interactiv)
        else
	  write(*, FGASSPC) 'Unimplemented fileformat ', file(:ltext(file))
          gasspc = 0
          return
	end if
        write(string,'(i7)') nroute
        i = addcomma(string)
	if(gasspc.le.0 .and. ltext(file).gt.1) then
	  if(gasspc.eq.0) then
            write(*, FGASSPC) 'Error in reading file ', file(:ltext(file)), '->', string(:ltext(string))
          else
            if(gasspc.eq.(-99999)) then
              write(*, FGASSPC) 'Empty spectrum in file ',
	1           file(:ltext(file)), '->', string(:ltext(string))
	    else
              write(*, FGASSPC) 'Nonexistent spectrum in file ',
	1         file(:ltext(file)), '->', string(:ltext(string)), '  >', -gasspc
            endif
          endif
	endif
c assume statistical error from data if no external error is specified
        if(.not.errextern .and. gasspc.gt.0) then
          j = 1
          do i = xbeg, gasspc
            spekerr(j) = sqrt(abs(sp(j)+1.))
            j = j+1
          enddo
        endif
	return
	end
