/* Linien Eigenschaften (Routine linemode) */
#define BOLD -2
#define NORMAL -1
#define LINE 0
#define SOLID 0
#define DOTTED 1
#define DOT_DASHED 2
#define SHORT_DASHED 3
#define LONG_DASHED 4

/* Symbole nicht benutzt  */
#define CIRCLE 1
#define TRIANGLE 2
#define INV_TRIANGLE 3
#define SQUARE 4
#define ROUTE 5
#define CROSS 6

/* Farben (Routine set_color) */
#define SCHWARZ 0
#define WEISS 1
#define ROT 2
#define GRUEN 3
#define BLAU 4
#define HELLROT 5
#define DUNKELROT 6
#define HELLGRUEN 7
#define DUNKELGRUEN 8
#define HELLBLAU 9
#define DUNKELBLAU 10
#define GELB 11
#define VIOLETT 12
#define LILA 13
#define BRAUN 14
#ifndef __TURBOC__
#define GRAU 15
#endif

/* Initialisierungsroutinen */
int openpl(void);
int openplt(char *title);
/* mit Ausgabe in Postscriptdatei */
int openpf(char *filename);
int openpft(char *file, char *title);
/* Ereignisroutinen */
int check_mouse(double*, double *);
int check_remap(void);
int check_resize(void);
int get_mouse_position(double *x, double *y);
/*  sonstiges */
int get_color(int);
int load_font(char *fontname);
int select_color(void);

/* Keyboard Ereignis */
#ifndef MSDOS
int kbhit(void);
#endif

/* schliessen der Grafik (wichtig, falls mit openpf? geoeffnet) */ 
void closepl(int Rueckfrage);
/* schliessen der Postscriptdatei */
void closeps(int reopen);
/* Loeschen des Bildschirms */
void erase(void);
/* Ausgabe der gesetzten Bildschirmkoordinaten */
void get_f_scale(double *x_min, double *y_min, double *x_max, double *y_max);
/* Kreisbogen mit x- und y-Radius von Winkel a bis b */
void f_arc(double xm, double ym, double rx, double ry, double wa, double we);
/* Kreisbogen mit einem Radius von Winkel a nach b */
void f_arc0(double xm, double ym, double r, double wa, double we);
/* Kreisbogen ab a, mit Winkel */
void f_arc1(double xm, double ym, double xa, double ya, double w);
/* Kreisbogen von a nach e */
void f_arc2(double xm, double ym, double xa, double ya, double xe, double ye);
/* gefuelltes Kreissegment mit x- und y-Radius von Winkel a bis b */
void f_arc_fill(double xm, double ym, double rx, double ry, double wa, double we);
/* Pfeil von a nach b  */
void f_arrow(double xa, double ya, double xe, double ye, double arrowlength);
/* Rechteck zwischen (a,a),(a,e),(e,e),(e,a) */
void f_box(double xa, double ya, double xe, double ye);
/* gefuelltes Rechteck */
void f_box_fill(double xa, double ya, double xe, double ye);
/* Kreis */
void f_circle(double xm, double ym, double r);
/* gefuellter kreis */
void f_circle_fill(double xm, double ym, double r);
/* Setzen einer Position */
void f_move(double x, double y);
/* Fortfuehrung der Position */
void f_cont(double x, double y);
/* Ellipse */
void f_ellipse(double x, double y, double rx, double ry);
/* gefuellte Ellipse */
void f_ellipse_fill(double x, double y, double rx, double ry);
/* Linie von a nach e */
void f_line(double xa, double ya, double xe, double ye);
/* Punkt */
void f_point(double x, double y);
/* Polygonzug */
void f_poly(double *x, double *y, int npoints);
/* gefuelltes Polygon */
void f_poly_fill(double *x, double *y, int npoints);
/* Wahl der externen Koordianten */
void f_space(double xmin, double ymin, double xmax, double ymax);
void set_f_scale(double xmin, double ymin, double xmax, double ymax);
/* Ausgaben eines Textes */
void label(char *text, int textgroesse);
/* Wahl der Linienform */
void linemod(char *mode);
void linemode(int mode);
/* wahl der Farbe */
void set_color(int farbe);
/* Wahl der Fenstergroesse, maximal 1 */
void set_window_size(double rel_width, double rel_height);
void set_focus(char *window);
void flushpl(void);
/* obsolete */
void select_pen(unsigned int pen);

/* Ausgaberoutine von n Punkte x, y (mit Fehler dx, dy) mit verschiedenen
   Moden. Unabh"angig von vorhergehenden Aufrufen */
int graph(double* x, double* dx, double* y, double* dy, int n, int modus);
/* Schliessen dieser Ausgaberoutine */
void closegr(int Abfrage);
/* Bechriftung */
void graphlabel(char* x_Text, char* y_Text, char* Titel);


