/*  package for TEKTRONIX GRAFICS
    $Id: Tekgraflibc.c,v 1.3 2000/12/14 12:07:24 riess Exp $
    c Routinen package

      void set_f_scale(xmin, ymin, xmax, ymax),
      void f_move(x, y), void f_point(x, y), void f_cont(x, y),
      void f_line(x1, y1, x2, y2)
    haben als Koordinatenargumente doppelt genaue Gleitkommagroessen
    (double) und setzten, falls mit set_f_scale keine Koordinanten-
    definition gemacht wurde, eine Bildgroesse von 1024 x 768  voraus.

    F. Riess, Oktober 1990
*/

#include "grafik.h"
#include <stdio.h>
#include <math.h>

void move(int, int);
void cont(int, int);
void point(int, int);
void circle(int, int, int);

void f_space(double xmin, double ymin, double xmax, double ymax)
{
  set_f_scale(xmin, ymin, xmax, ymax);
}

void set_f_scale(double xmin, double ymin, double xmax, double ymax)
{ extern double xslope, yslope, xoffset, yoffset;
  xmax = xmax > xmin ? xmax : xmin + 1.;
  xslope = 8192. / (xmax - xmin);
  xoffset = -xmin * xslope;
  ymax = ymax > ymin ? ymax : ymin + 1.;
  yslope = 6144. / (ymax - ymin);
  yoffset = -ymin * yslope;
}


void f_move(double x, double y)
{ extern double xslope, yslope, xoffset, yoffset;
  move((int) (x * xslope + xoffset), (int) (y * yslope + yoffset));
}

void f_cont(double x, double y)
{ extern double xslope, yslope, xoffset, yoffset;
  cont((int) (x * xslope + xoffset), (int) (y * yslope + yoffset));
}

void f_point(double x, double y)
{ extern double xslope, yslope, xoffset, yoffset;
  point((int) (x * xslope + xoffset), (int) (y * yslope + yoffset));
}

void f_line(double x1, double y1, double x2, double y2)
{
  f_move(x1, y1);
  f_cont(x2, y2);
}



void f_circle(double x, double y, double r)
{ extern double xslope, yslope;
  double phi, dphi, rtrans;
  int i;
  rtrans = fabs(r * xslope);
  rtrans = rtrans < (phi = fabs(r * yslope)) ? rtrans : phi;
  dphi = 1. / (rtrans > 0. ? sqrt(rtrans) : 1.);
  i = (i = M_PI / dphi) > 2 ? i : 2;
  dphi = M_PI / i;
  rtrans = r * xslope / yslope;
  f_move(x + r, y);
  for(phi = dphi; phi <= 2 * M_PI; phi += dphi)
    f_cont(x + r * cos(phi), y + rtrans * sin(phi));
}

void set_focus(char* window)
{
  return;
}
