/*  package for XWINDOW graphics
    $Id: Xgraflibf.c,v 1.13 2005/03/11 06:10:16 friedrich Exp $
    FORTRAN interface routins

    The routines
      int disinit(int), void disclose(void), void diserase(void)
      void disset(x, y), void dispoint(x, y), void disdraw(x, y)
      void diswrite(string, size),  void dissymbol(x, y, symbol, size)
      void disalpha(), void dismode(mode), void discolor(color)
    have single precisiion floating point numbers x, y as arguments
    and are in the range of  0 < x ,y < 1. 
    The window will be opened and never closed again

    The routines which are called need double precision arguments.
    F. Riess, April 2000
*/
#include "grafik.h"

#define YMAX 1.04

int grafik_is_not_open = 1;
double xfractsize = 1., yfractsize = 0.7;

void disclose_(int *mode);
int disinit_(int *save);

/* setze Groesse des Grafikfensters in Bruchteile der Bildschirmgroesse  */

void windowsize_(double *xfract, double *yfract)
{
  int dummy;
  xfractsize = *xfract = *xfract < 0.575 ? 0.575 : (*xfract > 1 ? 1. : *xfract);
  yfractsize = *yfract = *yfract < 0.35 ? 0.35 : (*yfract > 1 ? 1. : *yfract);
  if(!grafik_is_not_open)
  {
    dummy = 1;
    disclose_(&dummy);
    disinit_(&dummy);
  }
}

/* save is ignored, output is always saved */
int disinit_(int *save)
{
  if(grafik_is_not_open)
  {
    set_window_size(xfractsize, yfractsize);
    set_color(WEISS);
/* dummy statements to satisfy -Werror */
    grafik_is_not_open =  *save;
    grafik_is_not_open =  openpft("gasplot.bak", "GASPAN");
/* change focus to root window */
    set_focus("root");
  }
  if(!grafik_is_not_open)
  {
    set_color(WEISS);
    erase();
    set_color(SCHWARZ);
    set_f_scale(0., 0., 1., YMAX);
  }
  return grafik_is_not_open;
}

void disclose_(int *mode)
{
  if(!grafik_is_not_open)
  {
    if(*mode)
    {
      closepl(0);
      grafik_is_not_open = 1;
    }
/* note: with mode = 0: the window stays always open, 
   but the postscript file will be closed and reopened */
    else closeps(1);
  }
}

void diserase_(void)
{
  /* note: erase closes the postscript file and reopens it. */
  erase();
    set_f_scale(0., 0., 1., YMAX);
}


void disalpha_(void)
{
  /* dummy routine
     label("", 1);
 */
}

void disflush_(void)
{
  flushpl();
}


void dismode_(char *mode, int length)
{
  char cmode[20];
  int i;
  
  if(length > 19) length = 19;
  for(i = 0; i < length; ++i) cmode[i] = mode[i];
  cmode[length] = '\0';
  linemod(cmode);
}

void disset_(double *x, double *y)
{
  f_move( *x,  *y);
}

void dispoint_(double *x, double *y)
{
  f_point( *x,  *y);
}

void disdraw_(double *x, double *y)
{ 
  f_cont( *x,  *y);
}

void diswrite_(char *string, int *size, int string_length)
{
  int i, j;
  char str[132];
  j = string_length > 130 ? 130 : string_length;
  for(i = 0; i < j; ++i) str[i] = string[i];
  str[string_length] = '\0';
  i = *size-1;
  if(i < 0) i = 0;
  label(str, i);
}
      
void discolor_(int *color)
{
  set_color(*color);
}

void discircle_(double *x, double *y, double *r)
{
  f_circle_fill( *x,  *y,  *r);
}

void checkexpose_(void)
{
  check_expose();
}
