/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  Programm:    gascdc(char *text)
  Funktion:    interpretiert den Textstring und dispatched zu einer
                Routine
               The general structure of a command follows the
               VAX-VMS Command Language Interpreter:
                 command subcommand -option -option=value
               commands+subcommands and options can be abreviated
               as long as they are unique. Note that the possibility
               of abbreviations and check for uniqness holds for the
               combination of commands and subcommands differing from VMS.
               Note: command, subcommand and options must be seperated
                     by spaces
  Author:      Friedrich Riess
  Beginn:      06.04.1990
  Aenderung:   03.09.1992 : falls beim Compilieren -DMEMORY spezifiziert
                            wird, wird eine History Funktion eingeschaltet.
                            Hierzu wird die Routine lineget von B. Stanzel
                            benoetigt.
  Version: 1.15
  Date: 96/01/18
  $Id: gascdc.c,v 2.16 2005/02/03 13:56:59 friedrich Exp $
---------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "gascdc.h"

#define OPTIONDEKLARATOR '-'
#define CMDID "-->CMD"

char *optionptr[NOPTION], *valueptr[NOPTION], *formatptr[NOPTION];
int options, current;
char *stringptr[NOPTION + 2];
void gascdc(char *);
char *cligettext(void);
int substring, curstring;


void gascmd(char *string)
{ BEFEHL *cmdptr;
  int i, j, jsub, found;
  unsigned int equal;
  char *ptr, *ptrc;

/* get rid of a return at end of string */
  i = strlen(string) - 1;
  if(i < 0 || *string == '\n') return;
  if(string[i] == '\n') string[i] = '\0';
/* break string in single commands */
  for(i = 0; i < NOPTION; ++i) stringptr[i] = (char *) 0;
  for(substring = found = 0, ptr = string; *ptr && substring <= NOPTION; ++ptr)
    { if(*ptr == '\"')     /* " */
    { ptr++;
      while(!*ptr || *ptr != '\"') ++ptr;   /* " */
    }
    if(*ptr == ' ') { found = 0;        *ptr = '\0';}
    else if(!found)
         { found = 1; stringptr[substring++] = ptr; }
  }
  if(found == 0) return;
/* check for valid and unique command  */
  for(i = found = 0, cmdptr = (BEFEHL *) 0; *command[i].command && strlen(stringptr[0]); ++i)
  {
    jsub = strlen(command[i].command);
    if(i > 0)
    {
      if(jsub > (signed) strlen(command[i-1].command)) jsub = strlen(command[i-1].command); 
      if(!strncmp(command[i].command, command[i-1].command, jsub)) continue;
    }
    if(!strncmp(stringptr[0], command[i].command, strlen(stringptr[0]))) ++found;
  }
  if(found == 0)
  {
    fprintf(stderr, "%s: Option not found: %s\n", CMDID, stringptr[0]);
    fflush(stderr);
    return;
  }
  if(found >= 2)
  {
    fprintf(stderr,"%s: command ambigious: %s\n", CMDID, stringptr[0]);
    fflush(stderr);
    return;
  }
/* check again for command and look at qualifiers */       
  for(i = 0, cmdptr = (BEFEHL *) 0; *command[i].command && strlen(stringptr[0]); ++i)
  { jsub = found = 0;
    if(!strncmp(stringptr[0], command[i].command, strlen(stringptr[0])))
    { 
/* check for subcommand */
      if(*command[i].subcommand)
      { jsub = 1;
        if(substring <= 1)
        { fprintf(stderr, "%s: subcommand missing from: %s\n",
                                                       CMDID, stringptr[0]);
          fflush(stderr);
          return;
        }
        else
        { found = strncmp(stringptr[1], command[i].subcommand,
                                 strlen(stringptr[1])) ? 0 : 1;
        }
      }
      else  found = 1;
    }
    if(found)
    { if(cmdptr == (BEFEHL *) 0) cmdptr = &command[i];
      else
      { fprintf(stderr,"%s: command ambigious: %s %s\n", CMDID,
                                            stringptr[0], stringptr[1]);
        fflush(stderr);
        return;
      }
    }
/* help has special condiditions */
    if(found && !strcmp(command[i].command, "help")) break;
  }
  if(cmdptr == (BEFEHL *) 0)
  { fprintf(stderr,"%s: command not found: %s", CMDID, stringptr[0]);
    if(substring > 1) fprintf(stderr, " %s", stringptr[1]);
    fprintf(stderr, "\n");
    fflush(stderr);
    return;
  }
/* set option pointers: get option and check if present and unique */
  options = 0;
  for(i = 0; i < NOPTION; ++i)
    optionptr[i] = valueptr[i] = formatptr[i] = (char *) 0;
  if(*cmdptr->option[0])
  { for(jsub = 2; jsub < substring; ++jsub, ++options)
    { ptrc = stringptr[jsub];
      if(*ptrc == OPTIONDEKLARATOR)
      { ptrc++;
/* check if value is given for this option */
        for(i = 0, equal = 0, ptr = ptrc; i < (int) strlen(ptrc) ; ++i, ++ptr)
          if(*ptr == '=') equal = i;
        if(strlen(ptrc))
        { for(j = found = 0; *cmdptr->option[j]; ++j)
          { if(!strncmp(ptrc, cmdptr->option[j], equal == 0 ? strlen(ptrc) : equal))
            { if(found)
              { fprintf(stderr, "%s: option ambigious: %s\n",
                                       CMDID, stringptr[jsub]);
                fflush(stderr);
                return;
              }
              else
              { found = 1;
                optionptr[options] = cmdptr->option[j];
/* check if a value is required */
                for(ptr = cmdptr->option[j]; *ptr; ++ptr)
                  if(*ptr == '=')
                    { formatptr[options] = ptr + 1;
                      valueptr[options] = ptrc + equal + 1;
                      break;
                    }
                if(formatptr[options] == (char *) 0 && equal > 0)
                { fprintf(stderr, "%s: no value possible in option: %s\n",
                                       CMDID, stringptr[jsub]);
                  fflush(stderr);
                  return;
                }
                if(formatptr[options] && (equal == 0 ? 1 : !*valueptr[options]))
                { fprintf(stderr, "%s: value required in option: %s\n",
                                       CMDID, stringptr[jsub]);
                  fflush(stderr);
                  return;
                }
              }
            }
          }
        }
        if(optionptr[options] == (char *) 0)
        { fprintf(stderr, "%s: Option not found: %s\n",
                                       CMDID, stringptr[jsub]);
          fflush(stderr);
          return;
        }
      }
      else
      { fprintf(stderr, "%s: Missing optionsign (%c): %s\n",
                             CMDID, OPTIONDEKLARATOR, stringptr[jsub]);
        fflush(stderr);
        return;
      }
    }
    if(!options)
    { fprintf(stderr, "%s: option required\n", CMDID);
      fflush(stderr);
      return;
    }
  }
/* dispatch to function */
  curstring = 0;
  (*cmdptr->function)();
}


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  Programm:    int gasinp_(char *filename)
  Funktion:    reads a command line from file with filepointer fp,
	       calls gascdc to decode and to dispatch to the appropriate
               routine
  Author:      Friedrich Riess
  Beginn:      12.04.1990
  Aenderung:   Oktober 1990
---------------------------------------------------------------------*/
#include <stdio.h>

int gasinp_(char *filename, int filelen)
{
  static char commandtext[131];
  int i;
  FILE *fp = NULL;
  int check_expose(void);
#ifdef MEMORY
  int lineget(char *, int);
#endif
  strncpy(commandtext, filename, filelen >= 130 ? 130 : filelen);
  if(filelen >= 1) commandtext[filelen] = '\0';
  for(i = 0; i < filelen; ++i)
    if(commandtext[i] == ' ')
    { commandtext[i] = '\0';
      break;
    }
  if(fp == (FILE *) 0 && *commandtext)
    if((fp = fopen(commandtext, "r")) == (FILE *) 0)
    {
      printf(" file %s not found\n", commandtext);
      fflush(stderr);
      return 0;
    }
  if(fp == (FILE *) 0)
  {
#ifdef MEMORY
    i = lineget(commandtext, 130);
    if(i < 0) i = 0;
#else
    i = (int) gets(commandtext);
#endif
  /* has the display been obscured by overlapping windows? fix it */
    check_expose();
    if(i == 0) return 1;
    gascmd(commandtext);
  }
  else
  { while(fgets(commandtext, 130, fp) != NULL)  gascmd(commandtext);
    fclose(fp);
    fp = (FILE *) 0;
  }
  return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   int clipresent_(char *ask_option)
  function:  returns the value true (1) if ask_option agrees  with a given
             option, 0 if not
  author:    Friedrich Riess
  begin:     10.04.90
  change:
----------------------------------------------------------------------*/
int clipresent_(char *ask_option, int stringlength)
{ int i;
  current = -1;
  if(options)
  { for(i = 0; i < options; ++i)
    { if(optionptr[i])
      { if(!strncmp(ask_option, optionptr[i], stringlength))
        { current = i;
          return -1;
        }
      }
    }
  }
  return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   void gaspanrc_(void)
  function:  checks if the file $HOME/.gaspanrc is present and
             reads it if so
  author:    Friedrich Riess
  begin:     09.06.2004
----------------------------------------------------------------------*/
void gaspanrc_(void)
{
  char string[120];
  FILE *fp;

  (void) strncpy(string, getenv("HOME"), 120);
  (void) strncat(string, "/.gaspanrc", 120);
  if((fp = fopen(string, "r")) == NULL) return;
  while(fgets(string, 120, fp) != NULL)  gascmd(string);
  fclose(fp);
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   int cligetreal_(double *value)
  function:  checks the value specified by the current option pointer
	     and tries to extract an float, returns float in
             argument and function value 1, otherwise does not change
             *value and returns 0;
             proceeds on each call until the list is exhausted
  author:    Friedrich Riess
  begin:     12.04.90
  change:
----------------------------------------------------------------------*/
int cligetreal_(double *value)
{ char *ptr, *ptrs;
  int j = 0;
  float x;
  if(current >= 0)
  { if(!(ptrs = valueptr[current])) return 0;
    if(*ptrs)
    { if(*ptrs == '(') ++ptrs;
      for(ptr = ptrs; ; ++ptr)
        if(*ptr == ',' || *ptr == ')' || *ptr == '\0')
        { valueptr[current] = *ptr ? ptr + 1 : ptr;
          *ptr = '\0';
	  j = sscanf(ptrs, "%f", &x);
          if(j == 1) *value = x;
          else j = 0;
          break;
        }
    }
  }
  return (j ? -1 : 0);
}
 
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   int cligetdouble_(double *value)
  function:  checks the value specified by the current option pointer
	     and tries to extract an double, returns double in
             argument and function value 1, otherwise does not change
             *value and returns 0;
             proceeds on each call until the list is exhausted
  author:    Friedrich Riess
  begin:     12.04.90
  change:
----------------------------------------------------------------------*/
int cligetdouble_(double *value)
{ char *ptr, *ptrs;
  int j = 0;
  double x;
  if(current >= 0)
  { if(!(ptrs = valueptr[current])) return 0;
    if(*ptrs)
    { if(*ptrs == '(') ++ptrs;
      for(ptr = ptrs; ; ++ptr)
        if(*ptr == ',' || *ptr == ')' || *ptr == '\0')
        { valueptr[current] = *ptr ? ptr + 1 : ptr;
          *ptr = '\0';
	  j = sscanf(ptrs, "%lf", &x);
          if(j == 1) *value = x;
          else j = 0;
          break;
        }
    }
  }
  return (j ? -1 : 0);
}


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   int cligetinteger_(int *value)
  function:  checks the value specified by the current option pointer
             and tries to extract an integer, returns integer in
             argument and function value 1, otherwise does not change
             *value and returns 0;
             proceeds on each call until the list is exhausted
  author:    Friedrich Riess
  begin:     10.04.90
  change:
----------------------------------------------------------------------*/
int cligetinteger_(int *value)
{ char *ptr, *ptrs;
  int i, j = 0;
  if(current >= 0)
  { if(!(ptrs = valueptr[current])) return 0;
    if(*ptrs)
    { if(*ptrs == '(') ++ptrs;
      for(ptr = ptrs; ; ++ptr)
        if(*ptr == ',' || *ptr == ')' || *ptr == '\0')
        { valueptr[current] = *ptr ? ptr + 1 : ptr;
          *ptr = '\0';
          j = strlen(ptrs) - 1;
          if(ptrs[j] == '.') ptrs[j] ='\0';
          j = sscanf(ptrs, "%d", &i);
          if(j == 1 && strlen(ptrs) -1 == (unsigned int) log10((double) i)) *value = i;
          else
          { j = 0;
            fprintf(stderr, "--> bad argument: %s\n", ptrs);
	  }
          break;
        }
    }
  }
  return (j ? -1 : 0);
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   int cligetstring_(char *string, stringlen)
  function:  checks the value specified by the current option pointer
             and tries to extract a string, returns pointer to string in
             argument and function value 1, otherwise does not change
             *string and returns 0;
             proceeds on each call until the list is exhausted
  author:    Friedrich Riess
  begin:     12.04.90
  change:    10.12.90
----------------------------------------------------------------------*/

int cligetstring_(char *string, int stringlen)
{ char *ptr, *ptrs;
  int j;
  for(j = 0, ptr = string; j < stringlen; ++j, ++ptr) *ptr = ' ';
  j = 0;
  if(current >= 0)
  { if(!(ptrs = valueptr[current])) return 0;
    if(*ptrs)
    { j = -1;
      if(*ptrs == '(') ++ptrs;
      for(ptr = ptrs; ; ++ptr)
        if(((*ptr == ',' || *ptr == ')') && *ptrs != '"') || *ptr == '\0')
        { valueptr[current] = *ptr ? ptr + 1 : ptr;
          *ptr = '\0';
	  if(stringlen < (int) strlen(ptrs))
	  {
            fprintf(stderr, "-->cligetstring: length of string %d, should %u\n",
		     stringlen, strlen(ptrs));
            fflush(stderr);
          }
	  else
	  { strcpy(string, ptrs);
	    j = -1;
	  }
          break;
        }
    }
  }
  return j;
}


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   char *cligettext ()
  function:  checks the value specified by the text pointer
             and returns the pointer and function value 1, otherwise does not change
             text and returns 0;
             proceeds on each call until the list is exhausted
  author:    Friedrich Riess
  begin:     12.04.90
  change:
----------------------------------------------------------------------*/
char *cligettext(void)
{
  if(curstring < substring)
    return stringptr[curstring++];
  else return (char *) 0;
}

int cligettext_(char *string, int stringlen)
{
  char *ptr;
  int j = 0;
  if((ptr = cligettext()))
  { j = -1;
    strncpy(string, ptr,stringlen);
  }
  return j;
}


void exec_command (void)
{
  char bef[100], *ptr;
  *bef='\0';
  ptr = cligettext();
  while((ptr = cligettext())){ strcat(bef, ptr); strcat(bef, " "); }
  if(*bef) system(bef);
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   void sethelppath_(char *path, int pathlength)
  function:  copies path into helpfilepath
  author:    Friedrich Riess
  begin:     01.08.2004
  change:
----------------------------------------------------------------------*/
void sethelppath_(char *path, int pathlength)
{
  int i;

  if(pathlength >= HELPL)
    fprintf(stderr, "Path to helpfile too long\n");
  else
  {
    for(i = 0; path[i] != ' ' || i < pathlength; ++i)
      helpfilepfad[0][i] = path[i];
    helpfilepfad[0][i] = '\0';
  }
  return;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   void help_command()
  function:  gives a list of commands and help if available
  author:    Friedrich Riess
  begin:     08.04.90
  change:
----------------------------------------------------------------------*/
#define FNULL (FILE*)0
#define NORMAL { printf("\033[0m"); fflush(stdout);}
#define INVERS { printf("\033[7m"); fflush(stdout);}
#define QUOTE '`'

void help_command(void)
{ long match(FILE *, int, char *);
  void helpout(FILE *, int );
  int tab(int, int);
  int i, io, j, l, sub = 0, opti;
  long found;
  FILE *fp;
  int vt100 = 1;

/* check if command is present */
  if(substring > 1)
  { for(i = 0, io = sub = opti = -1; *command[i].command; ++i)
    { if(!strncmp(stringptr[1], command[i].command, strlen(stringptr[1])))
      { if(io == -1) io = i;
        else
        { if(strcmp(command[io].command, command[i].command))
          { printf("-->help on ambigious command: %s\n", stringptr[1]);
            fflush(stdout);
            return;
          }
        }
        if(substring > 2)
          if(!strncmp(stringptr[2], command[i].subcommand,
                                                strlen(stringptr[2])))
          { if(sub == -1)
            { sub = i;
              if(substring > 3)
              for(l = 0; command[i].option[l]; ++l)
              { if(!strncmp(stringptr[3]+1, command[i].option[l],
                                                strlen(stringptr[3])-1))
                { if(opti == -1) opti = l;
                  else
	          { printf("-->help on ambigious command: %s %s %s\n",
                                    stringptr[1], stringptr[2], stringptr[3]);
                    fflush(stdout);
                    return;
                  }
	        }
	      }
	    }
            else
	    { printf("-->help on ambigious command: %s %s\n", stringptr[1],
                                                             stringptr[2]);
              fflush(stdout);
              return;
            }
          }
      }
    }
    if(io == -1 || (substring > 2 && sub == -1) || (substring > 3 && opti == -1))
    { printf("-->help on nonexisting command:");
      for(i = 1; i < substring; ++i) printf(" %s\n", stringptr[i]);
      printf("\n");
      fflush(stdout);
      return;
    }
    stringptr[1] = command[io].command;
    if(substring > 2) stringptr[2] = command[sub].subcommand; 
    if(substring > 3) stringptr[3] = command[sub].option[opti];
}
/* and print it in the correct length */
  printf("\n ");
  if(vt100) INVERS;
  for(i = 1; i < substring; ++i)
  { if(i > 1) printf(" ");
    printf("%s%s", i == 3 ? "-": "", stringptr[i]);
  }
  if(vt100) NORMAL;
  printf("\n");
  if(substring > 4)  return;
/* Open Help file  and search for level "substring-1" string */
  found = -1L;
  fp = FNULL;
  for(i = 0; i < HELPN && fp == FNULL; ++i)
    if(!access(&helpfilepfad[i][0], 4))
      fp = fopen(&helpfilepfad[i][0], "r");
  if(fp == FNULL)
    fprintf(stderr,"--> Help file \"gaspan.hlp\" not found,\n     notify operator or use command: set file -helpfile=PATH/gaspan.hlp\n");
  else
  { 
    if(substring <= 1) found = 0L;
    else for(i = 1; i < substring; ++i) found = match(fp, i, stringptr[i]);
  }
/* Print Information in Help file */
  if(found >= 0L)
    if(!fseek(fp, found, 0)) helpout(fp, vt100);
/* print possible commands */
  if(substring == 1)
  { printf(" List of commands:\n");
    for(i = j = 0; *command[i].command; ++i)
    { if(i > 0)
        if(!strcmp(command[i-1].command, command[i].command)) continue;
      j = tab(j, 12);
      if(vt100) INVERS;
      j += printf("%s", command[i].command);
      if(vt100) NORMAL;
    } 
    printf("\n");
  }
/* subcommands */
  else if(substring == 2)
  { for(i = j = io = 0; *command[i].command; ++i)
    { if(!strcmp(stringptr[1], command[i].command))
      { if(*command[i].subcommand)
        { if(!io) io = printf(" List of subcommands:\n");
          j = tab(j, 15);
          if(vt100) INVERS;
          j += printf("%s", command[i].subcommand);
          if(vt100) NORMAL;
	}
      }
    }
    printf("\n");
  }
/* options */
  else if(substring == 3)
  { for(i = io = j = 0; *command[sub].option[i]; i++)
    { if(i == 0) printf(" List of options:\n");  
      j = tab(j, 36);
      if(vt100) INVERS;
      j += printf("-%s", command[sub].option[i]);
      if(vt100) NORMAL;
    }
    printf("\n");
  }
  printf("\n");
  if(fp != FNULL)
  { fclose(fp);
    fp = FNULL;
    if(found < 0L) printf(" no help vailable for this command\n\n");
  }
  fflush(stderr); fflush(stdout);
}


/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   long match(FILE *fp, int i, char *string)
  function:  looks for a match in the help file for the help level i
             in the first column of a line and the occurence of string
             starting from the third column of such a line
  author:    Friedrich Riess
  begin:     20.01.92
  change:
----------------------------------------------------------------------*/
long match(FILE *fp, int i, char *string)
{ char str[100], *pstr;
  for(;;)  
  { if(fgets(str, 100, fp) == (char *) 0)
    {
      return -1L;
    }
    else
    { if(*str == '0' + i)
      { pstr = &str[1];
        while(*pstr && *pstr == ' ') ++pstr;
        *(pstr + strlen(pstr) - 1) = '\0';
        if(i == 3) ++pstr;
        if(!strncmp(pstr, string, strlen(pstr))) return ftell(fp);         
      }
    }
  }
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   void helpout(FILE *fp, int vt100)
  function:  prints the information in the help file on stdout with
             the provision:
             vt100 = 0: no further action
             vt100 = 1: on each occurence of the symbol ` the display
                        is switched from normal to inverse display
                        and vice versa.
             The file must be opened and the file pointer must be
             positioned at the correct place.
  author:    Friedrich Riess
  begin:     20.01.92
  change:
----------------------------------------------------------------------*/
void helpout(FILE *fp, int vt100)
{ int i, io;
  char str[100], *pstr;
  for(;;)
  { if(fgets(str,100, fp) == (char *) 0) break;
    if(*str != ' ' && *str != '\n') break;
    pstr = str;
    if(vt100)
    { for(i = io = 0; str[i]; ++i)
      { if(str[i] == QUOTE)
        { str[i] = '\0';
          printf("%s", pstr); 
          pstr = &str[i+1];
          if(io) {io = 0; NORMAL;}
          else   {io = 1; INVERS;}
        }
      }
    }
    printf("%s", pstr);
  }
  fflush(stdout);
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  program:   int tab(int j, int distance)
  function:  corresponds to a tabulating enviroment giveen by distance
             according to j which should be positioned on the last
             column of the output.
             The new position is returned.
  author:    Friedrich Riess
  begin:     20.01.92
  change:
----------------------------------------------------------------------*/
#define INSERT "   "
#define ZLENGTH 78
int tab(int j, int dist)
{ 
  printf(" ");
  if((unsigned) j < ZLENGTH - dist -strlen(INSERT) && j > 0)
     for(; j % dist; ++j) printf(" ");
  if((unsigned) j >= ZLENGTH - dist - strlen(INSERT) || j == 0)
  { j = 0;
    printf("\n%s", INSERT);
  }
  return j;
}
