	program gaspan
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gaspan.f,v 2.68 2005/03/11 06:14:55 friedrich Exp friedrich $
c  main program
c  see file gaspan.upd for changes and improvements 
c  
c  command input and control loops
c
c  Friedrich Riess, Oct. 1986
c------------------------------------------------------------
	implicit none
	include 'gasctr.icl'
	include 'gasfil.icl'
	include 'gastxt.icl'
	logical i, gasinp, cancelfit, isensw

	maxfil = 0
	filestring = ' '
	version = 'GASPAN, Version 11.03.2005'
c  set default parameters
	call gasdefc
        call gasdefd
	call gasdefe
	call gasdeff
	call gasdefw
	call gasdeft('l')
	call gasdeft('r')
	call gasdeft('b')
	call gasdeft('s')
	i = cancelfit(0)
	call showversion
        i = isensw(-100)
c  hier you can set debug options by calling isensw with a negativ argument
c  see routine isensw in gasisw.f. These debug options can also be set
c  with the command "test print"
c  do not forget to enable lpa with the command "set fit -printout"
c      
c 	i = isensw(-1)   ! GASFIT: chisq-sequence?
c	i = isensw(-2)   ! GASFIT: starting-/endparameter?
c	i = isensw(-3)   ! GASFIT: sequence of parameters?
c	i = isensw(-4)   ! GASCHI: sequence of parameters?
c	i = isensw(-5)   ! GASRES: result of the residuum search?
c	i = isensw(-6)   ! GASPAR: status of parameters?
c	i = isensw(-7)   ! GASPCK: parameter check?
c	i = isensw(-8)   ! GASSEA: detailed result of peak search?
c	i = isensw(-9)   ! GASFIT: display each fit step?
c	i = isensw(-10)  ! GASSEA: output of the correlation spectrum?
c	i = isensw(-11)  ! GASFIT: output of the residue spectrum?
c	i = isensw(-12)  ! GASEIC: fit-sequence and fit-error?
c	i = isensw(-13)  ! GASEIF: output of chi-sequence?
c
c  read history file       
        call linectrl(1, ".gaspan")
c read .gaspanrc if exists
        call gaspanrc
	do while (.true.)
	  write (*, '('' GSP> ''$)')
	  i = gasinp(" ")
	enddo
	end

	subroutine gasexit
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   exit
c  command:   quit
c  close display channel if still open in order to bring the
c  terminal into a transparent mode.
c------------------------------------------------------------
	implicit none
        include 'gasctr.icl'
        include 'gasspe.icl'
        include 'gasfil.icl'
        integer gasspc, ios
        logical da
        character disfile*30
c delete files in /usr/tmp if any
        ios = gasspc(1, 1, ' ', spek)
        inquire(file=filefitsave, exist = da)
        if(da) then
          open(unit=20, file=filefitsave, iostat = ios)
          if(ios.eq.0)  then
            close(unit=20, status='delete')
          else
            close(unit=20)
          endif
        endif
c delete backup file from the display
        disfile='gasplot.bak'
        inquire(file=disfile, exist = da)
        if(da) then
          open(unit=20, file=disfile, iostat = ios)
          close(unit=20, status='delete')
        endif
        disfile='gasplot.bak.'
        inquire(file=disfile, exist = da)
        if(da) then
          open(unit=20, file=disfile, iostat = ios)
          close(unit=20, status='delete')
        endif
c save history file
        call linectrl(0, ".gaspan")
	stop
	end

	subroutine calgspfile
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   calibrate (filename)
c  erlaubt die Energie und Efficiency Eichung einer gsp--file
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gastxt.icl'
	logical da
        da = cligettext(texta)
        da = cligettext(texta)
        if(.not.da) texta = ' '
	call gascal(texta)
	return
	end


	subroutine genfile
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   generate (filename)
c  routine call gasque to generate gate spectra from matrix analysis
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gastxt.icl'
	integer i, gasque
	if (cligetstring(texta)) then
	  i = gasque (texta)
        else
	  texta = ' '
	  i = gasque (texta)
	endif
	return
	end

	subroutine getfile (file, extension)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   service routine
c  routine gets filename from command string and adds extension
c  default filename is gaspan.extension
c------------------------------------------------------------
	implicit none
	character file*(*), extension *(*)
	include 'cli_parms.icl'
	logical da, extens
	da = cligettext (file)
	da = cligettext (file)
	file = ' '
	if(.not.cligettext(file)) file = 'gaspan'
	da = extens(file, extension)
	return
	end

	subroutine getoptions
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   get options (filename)
c  set default extensions for option file and get it
c------------------------------------------------------------
	include 'gastxt.icl'
        integer ltext
        logical i, gasinp
	call getfile(texta, 'sta')
	i = gasinp(texta(:ltext(texta)))
	return
	end

	subroutine getparameter
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   get parameter (filename)
c  set default extensions for parameter file and get it
c------------------------------------------------------------
	include 'gastxt.icl'
        integer ltext
        logical i, gasinp
	call getfile (texta, 'stp')
	i = gasinp(texta(:ltext(texta)))
	return
	end



	subroutine makefit
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   fit [channel_min,chanel_max[,degree_of_background_polynomial]
c  routine runs the fit with one fit region only
c------------------------------------------------------------
	implicit none
	include 'gasctr.icl'
        include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
        include 'gastxt.icl'
        include 'gasdis.icl'  !xxxxx
        include 'cli_parms.icl'
	integer addcomma, ltext
	integer l
	logical gasfil
	logical gaslst, gasdouble
	logical gassea
	logical gofit
	logical cancelfit
        logical saveinteractiv, savereglist
	character nroutetext*7
        integer i, j, n, io, saveminch, savemaxch, savebackpol
        character text2*20, text3*20
        real*8 x, invpolfun
c  save fit regions
        saveminch = minch
        savemaxch = maxch
        saveinteractiv = interactiv
        interactiv = .TRUE.
        savereglist = reglist
        savebackpol = backpol
        reglist = .FALSE.
        onefitregion = .TRUE.
c check for optional arguments
        gofit = cligettext(texta)
        texta = ' '
        if(cligettext(texta)) then
          text2 = ' '
          text3 = ' '
          j = 0
          n = 0
	  do i = 1, ltext(texta)
            if(texta(i:i) .eq. ',') then
              if(j.eq.0) then
                j = 1
              else
                n = 1
              endif
              texta(i:i) = ' '
            else if(n .gt. 0) then
              text3(n:n) = texta(i:i)
              texta(i:i) = ' '
              n = n+1
            else if(j .gt. 0) then
              text2(j:j) = texta(i:i)
              texta(i:i) = ' '
              j = j+1
            endif
          enddo
          if(.not. gasdouble(texta(:ltext(texta)), x, io)) then
            if(io.eq.0) then
              if(disenergy .and. fileenergy.ne.' ') x =  max(1., invpolfun(x, nde - ndem, ndem, aes))
               minch = max(1, int(x + 0.5))
            endif
          endif
          if(.not. gasdouble(text2(:ltext(text2)), x, io)) then
            if(io.eq.0) then
              if(disenergy .and. fileenergy.ne.' ') x =  max(1., invpolfun(x, nde - ndem, ndem, aes))
              maxch = int(x + 0.5)
            endif
          endif
          if(minch.gt.maxch) then
            io = minch
            minch = maxch
            maxch = io
          endif
          if(.not. gasdouble(text3(:ltext(text3)), x, io)) then
            if(io.eq.0)  backpol = x + 0.5
          endif
        endif
c  do fit only if it can be done in one fit region
        if(maxch - minch.le.FITREG .and. backpol.ge.-4 .and. backpol.le.4) then
 	  gofit = cancelfit(0)
          j = 0
	  do while (gasfil ())
	    if (interactiv) then
	      write(nroutetext, '(i7)'), nroute
	      l = addcomma(nroutetext)
	      write (*, '('' Working on ''a''-->''a)') files (:ltext (files)), nroutetext
	    endif
	    if (peaklist) then
	      gofit = gaslst ()
	    else
	      gofit = gassea ()
	    end if
	    if (gofit) then
c           if (interactiv)
c       1      write (*, '('' You may cancel the fitting with CTRL C'')')
	    call gasfit
	    j = j+1
	    end if
	  end do
          call showfit
	else if(maxch - minch.gt.FITREG) then
	  write(*,'('' Fitregion larger than '',i4,'' channels'')') FITREG
          write(*,'('' use either: fit min,max    or: go'')')
        else 
          write(*,'('' degree of background polynomial must be in the range [0,4]'')')
	endif
        minch = saveminch
        maxch = savemaxch
        interactiv = saveinteractiv
        reglist = savereglist
        backpol = savebackpol
	onefitregion = .FALSE.
	end

	subroutine go
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   go
c  routine runs the fit.
c------------------------------------------------------------
	implicit none
	include 'gasctr.icl'
	include 'gasfil.icl'
	integer addcomma, ltext
	integer l
	logical gasfil
	logical gaslst
	logical gassea
	logical gofit
	logical cancelfit
	character nroutetext*7
	gofit = cancelfit(0)
	do while (gasfil ())
	  if (interactiv) then
	    write(nroutetext, '(i7)'), nroute
	    l = addcomma(nroutetext)
	    write (*, '('' Working on ''a''-->''a)') files (:ltext (files)), nroutetext
	  endif
	  if (peaklist) then
	    gofit = gaslst ()
	  else
	    gofit = gassea ()
	  end if
	  if (gofit) then
c           if (interactiv)
c       1      write (*, '('' You may cancel the fitting with CTRL C'')')
	    call gasfit
	  end if
	end do

	end

        subroutine limits
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   limitations
c  prints the limitations in number of parameters, array sizes
c    etc
c------------------------------------------------------------
        implicit none
        include 'gasctr.icl'
        include 'gasspe.icl'
        include 'gaspea.icl'
        include 'gasfil.icl'
        include 'gasfit.icl'
        include 'gaspar.icl'
        include 'gaseic.icl'

        integer i, ltext

        write(*,'('' The following limitations are given by array sizes etc'')')
        write(*,'('' - Total size of a spectrum:     '',i8,'' channels'')') DEFMAXCH
        write(*,'('' - Working size of the spectrum: '',i8,'' channels'')') SPELEN
        write(*,'('' - Number of peaks in a spectrum:'',i11)') 3*TOTALPEAKS/2
        write(*,'('' - Number of peaks in a peak list:'',i10)')  TOTALPEAKS
        write(*,'('' - Number of regions in a region list:'',i6)') MAXREGIONS
        write(*,'('' - Number of peaks and regions in a peak list:'',i4)') TOTALPEAKS
        write(*,'('' - Size of a fit region:    '',i10,'' channels'')') FITREG
        write(*,'('' - Number of peaks in a fit region: '',i3)') PEAKTOT
        write(*,'('' - Maximum full width half Maximum for a peak: '',i3,'' channels'')') nint(MAXWIDTH)
        write(*,'('' - Maximum degree of polynomial for energy calibration:'',i6)') DEGENERGY-1
        write(*,'('' - Maximum parameters for the efficiency calibration:  '',i6)') DEGEFFI
        write(*,'('' - Maximum degree of polynomial for width calibration: '',i6)') DEGENERGY-1
        write(*,'('' - Maximum degree of polynomial for tail calibrations: '',i6)') DEGTAILS-1
c output the available formats for the spectra
        write(*,'(/'' The following formats for spectrum files are available'')')
        write(*,'('' command, default extension, discription'')') 
        do i = 1, FIFORMAT
          write(*,'(x, a, 3x, a, 10x, a)') cmdformat(i), extformat(i), txtformat(i)(1:ltext(txtformat(i))) 
        enddo
        return
        end

	subroutine saveoptions
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   save options (filename)
c  save options into specified files, the extension .sta will
c  be appended. Default filename is gaspan.sta
c------------------------------------------------------------
	include 'gastxt.icl'
	call getfile (texta, 'sta')
	call gasopt(texta, 17)
	end

	subroutine saveparameters
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   save parameters (filename)
c  saves parameters into specified file, the extionsion .stp
c  will be appended. default filename is gaspan.stp
c  --> outdated: use save option
c------------------------------------------------------------
	include 'gastxt.icl'
c        call getfile (texta, 'stp')
c        call gaspas (texta, 17, 7)
	write(*, '('' Use: save option  to save parameters'')')
	end

	subroutine setbackgr
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   set background (-fit, -fixed=value, -nofit,
c                             -nofixed,
c                             -max_polynomial_degree=value)
c                             -polynomial_degree=value)
c  sets the switches for the background
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gastxt.icl'
	logical code
        integer backtmp
	if(clipresent('max_polynomial_degree')) then
	  if(cligetinteger(backtmp)) then
	    if(.not.(backtmp .ge. 0 .and. backtmp .le. 4)) then
	      write (*,'('' Polynomial degree must be an integer [0,4]'')')
	    else
	      backpol = -backtmp
	    end if
	  end if
	end if
	if(clipresent('polynomial_degree')) then
	  if(cligetinteger(backtmp)) then
	    if(.not.(backtmp .ge. 0 .and. backtmp .le. 4)) then
	      write (*,'('' Polynomial degree must be an integer [0,4]'')')
	    else
              backpol = backtmp
            end if
	  end if
	end if
	if(clipresent('nofixed') .or. clipresent('fit')) backfixed = .FALSE.
c	if(clipresent('fixed') .or. clipresent('nofit')) then
	if(clipresent('fixed')) then
	  if(backpol .ne. 0) then
	    write(*,'('' WARNING: Fixed background only active with polynomial degree = 0!'')')
          else
	    backfixed = .TRUE.
	    code = cligetreal(backvalue)
          endif
	else 
          if(clipresent('nofit')) then
	    if(backpol .ne. 0) then
	      write(*,'('' WARNING: Fixed background only active with polynomial degree = 0!'')')
            else
	      backfixed = .TRUE.
	      code = cligetreal(backvalue)
            endif
	  endif
	endif
	end


	subroutine setdisplay
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   set display (-channels -energy -linear -logarithmic
c                          -on -off -singlepeak -nosinglepeak
c                          -comment=text)
c  sets the switches for the display of spectrum and fit
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
        include 'gasdis.icl'
        include 'gastxt.icl'

	logical code, joinps, gasdouble
         integer ltext, io

	if(clipresent('on')) display = .TRUE.
	if(clipresent('off')) display = .FALSE.
	if(clipresent('logarithmic')) dislogaxis = .TRUE.
	if(clipresent('linear')) dislogaxis = .FALSE.
	if(clipresent('channel')) disenergy = .FALSE.
	if(clipresent('energy')) disenergy = .TRUE.
	if(clipresent('single')) dissingle = .TRUE.
	if(clipresent('nosingle')) dissingle = .FALSE.
	if(clipresent('intermediate')) disintermediate = .TRUE.
	if(clipresent('nointermediate')) disintermediate = .FALSE.
	if(clipresent('hold')) dishold = .TRUE.
	if(clipresent('nohold')) dishold = .FALSE.
	if(clipresent('comment')) code = cligetstring (distext)
	if(clipresent('print')) code = cligetstring (disprint)
	if(clipresent('errorbar')) diserrorbar = .TRUE.
	if(clipresent('noerrorbar')) diserrorbar = .FALSE.
	if(clipresent('histogram')) diserrorbar = .FALSE.
        if(clipresent('gauss-position')) disgauss = 1
        if(clipresent('centroid')) disgauss = -1
        if(clipresent('tail_include')) disgauss = 0
        if(clipresent('residuum')) disresiduum = .TRUE.
        if(clipresent('noresiduum')) disresiduum = .FALSE.
        if(clipresent('nosaveall')) dissave = .FALSE.
        if(clipresent('saveall')) then
           dissave = .TRUE.
           code = cligetstring(disfile)
           if(joinps(disfile, " ")) then
             dissave = .FALSE.
             write(*, '(a)') ' command ignored, option set to nosave'
           endif
        endif
        if(clipresent('windowsize')) then
          code = cligetdouble(disxsize)
          code = cligetdouble(disysize)
          call windowsize(disxsize, disysize)
        endif 
        if(clipresent('yscale')) then
          code = cligetstring(texta)
c          if(texta(:ltext(texta)).eq.' ') then
c            disymin = -LARGENUMBER
c          else
c            read(texta(:ltext(texta)), '(f14.1)') disymin
c          endif
          code = gasdouble(texta(:ltext(TEXTA)), disymin, io)
          if(io.ne.0) disymin = -LARGENUMBER
          code = cligetstring(texta)
          code = gasdouble(texta(:ltext(TEXTA)), disymax, io)
          if(io.ne.0) disymax = LARGENUMBER
        endif
	end

	subroutine setfiles
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   set files (-file=filenames
c                        -format, -matrix, -single_spectrum)
c  sets the switches for spectrum input mode and filename
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gasfil.icl'
	include 'gastxt.icl'

        logical da
	integer l
	integer i, j, ltext
        i = 1
        l = 0
	if(clipresent('file')) then
          filestring = ' '
          do while(cligetstring(texta))
            j = ltext(texta)
            if(texta(j:j).eq.'"') texta(j:j) = ' '
            if(l.eq.0 .and.  texta(1:1).eq.'"') i = 2
            l = l + 1
            if(l.eq.1) then
              filestring(l:) = texta(i:ltext(texta))           
	    else 
              if(ltext(texta).gt.0) filestring(l:) =','//texta(:ltext(texta))
            endif
            l = ltext(filestring)
	  end do
          if(l.gt.0) then
            if(filestring(l:l).eq.',') filestring(l:l) = ' '
          endif
c check if file is present and give a warning if not
          i = 1
          if(filestring(1:1).eq.'@') i = 2
          da = .false.
          j = i
          l = 1
          do while(.not.da .and. j.le.ltext(filestring) .and.l.gt.0)
            texta = ' '
            if(filestring(j:j).eq.',') then
              j = j - 1
              l = -1
            else if(j.eq.ltext(filestring))  then
              l = -1
            endif
            if(l.le.0) then
              texta = filestring(i:j)
              inquire(file = texta, exist = da)
            else
              j = j + 1
            endif
          enddo               
          if(.not.da) write(*,'(''--> Warning: file not present: ''a)') texta(:j)
	end if
	if(clipresent('helpfile')) then
          da = cligetstring(texta)
          j = ltext(texta)
          if(texta(j:j).eq.'"') texta(j:j) = ' '
          i = 1
          if(texta(1:1).eq.'"') i = 2
          helpfile = texta(i:ltext(texta))           
          inquire(file = helpfile, exist = da)
          if(da) then
            call sethelppath(helpfile(:ltext(helpfile)))
          else
            write(*,'(''--> Warning: file not present: ''a)') helpfile(:ltext(helpfile))
          endif
	end if
        if (clipresent('format')) then
          l = -1
          if(cligetstring(texta)) then
            i = 0
            do while(i.le.FIFORMAT .and.l.eq.-1)
              if(i.eq.0) then
                if(texta(:6).eq.'search') l = 0
              else
                if(texta(:ltext(texta)).eq.cmdformat(i)(:ltext(texta))) l = i
              endif
              i = i + 1
            enddo
          endif
          if(l.eq.-1) then
            write(*, '('' --> unknown file format'')')
          else
            filesformat = l
          endif
        endif
	if (clipresent('matrix')) dskspe = .TRUE.
	if (clipresent('single_spectrum'))  dskspe = .FALSE.
	end

	subroutine setfit
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   set fit (-interactive, -nointeractive, 
c                      -printout, -noprintout, 
c                      -out, -noout,
c                      -residue_search, -noresidue_search,
c                      -region, -save, -nosave)
c  set options and switches for fitting procedure
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gasfil.icl'
	logical da

	if (clipresent ('interactiv')) interactiv = .TRUE.
	if (clipresent ('nointeractiv')) interactiv = .FALSE.
	if (clipresent ('background') .or. clipresent('nobackground')) then
          write(*,'('' Use option set background ... '')')
	endif
	if (clipresent ('out')) then
          fitout = -1
c          fitdatafile = ' '
c          da = cligetstring(fitdatafile)
c          if(fitdatafile(1:1).eq.' ') fitdatafile = ' '
        endif
	if (clipresent ('noout')) fitout = 0
	if (clipresent ('printout')) lpa = .TRUE.
	if (clipresent ('noprintout')) lpa = .FALSE.
	if (clipresent ('region')) then
	  da = cligetinteger (minch)
	  da = cligetinteger (maxch)
          if(minch.lt.DEFMINCH) minch = DEFMINCH
	  if (maxch.le.minch) then
	    write (*,'('' *** last channel is less then first channel, both reset to default'')')
	    minch = 1
	    maxch = DEFMAXCH
	  end if
	end if
	if (clipresent ('residue_search')) ressearch = .TRUE.
	if (clipresent ('noresidue_search')) ressearch = .FALSE.
	if (clipresent ('save')) savefit = .TRUE.
	if (clipresent ('nosave')) savefit = .FALSE.
        call histfile(lpa)
        end

        subroutine histfile(lpout)
c open s and closes the history file

        implicit none

        include 'gasctr.icl'
        include 'gasfil.icl'
        logical lpout, da
        integer ios

	inquire (file = FILEHIST, opened = da)
	if(.not.lpout .and. da) then
          close(unit = 3, IOSTAT = ios)
          lpa = .FALSE.
        elseif(lpout .and. .not.da) then
	  inquire(file = FILEHIST, exist = da)
          if(.not.da) then
            open (unit = 3, file = FILEHIST, status = 'unknown', iostat = ios)
	  else
            open (unit = 3, file = FILEHIST, status = 'old', access = 'append', iostat = ios)
	  endif
          if(ios.ne.0) then
            write(*, '('' -->GASPAN: Error in opening file:'',a)') FILEHIST
            write(*, '('' --> can not write into history file'')')
            lpa = .FALSE.
          else
            lpa = .TRUE.
          endif
        endif 
	end

	subroutine setparameters
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:  setparameters (-check   -nocheck
c                            -energy=coefficients
c                            -efficiency=coefficients
c                            -width=coefficients,
c                            -background_tail=coefficients
c                            -left_peak_tail=coefficients
c                            -right_peak_tail=coefficients
c                            -polynomial_degree=value (obsolet)
c                            -width=coefficients
c  sets fitoptions (check, nocheck) and the coefficients
c  for the expansion of different parameters.
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gasfil.icl'
	include 'gaseic.icl'
	integer set_par_e, set_par_f, set_par_g
	integer n

	if (clipresent ('nocheck')) parcheck = 0
	if (clipresent ('check')) parcheck = 1
	if (clipresent ('full_check')) parcheck = -1
	if (clipresent ('all_check')) parcheck = 2
	if (clipresent ('extended_check')) parcheck = -2
	if (clipresent('energy')) then
	  nde = set_par_e ('energy', DEGENERGY, aes, daes, fileenergy)
          ndem = 0
	  if(nde.eq.0) call gasdefe
          if(nde.gt.2 .and. abs(aes(nde)).gt.0.1) ndem = 1
          if(nde.gt.3 .and. abs(aes(nde - 1)).gt.0.1) ndem = 2
	end if
	if (clipresent('efficiency')) then
	  if (fileenergy.ne.' ') then
	    ndf = set_par_e ('efficiency', DEGEFFI, afs, dafs, fileeffic)
	    if(nde.eq.0 .and. ndf.eq.0) call gasdeff
	  else
	    write (*,'('' *** make energy calibration first'')')
	  end if
	end if
	if (clipresent('width')) then
	  ndw =  set_par_e ('width', DEGENERGY, aws, daws, filewidth)
	  if (ndw.eq.0) call gasdefw
	end if
	if (clipresent('step')) then
          nampstep = set_par_f(DEGTAILS, ampstep)
          if(nampstep.eq.0) then
            ampstep(1)= 0.01
            nampstep = 1
          endif
        endif
	if (clipresent('background_tail')) n =
	1   set_par_g ('background_tail', DEGTAILS, nampback, ampback, ntauback, tauback)
        if(n.eq.0) tauback(1) = WTAILBACK*aws(1)
	if (clipresent('left_peak_tail'))  n =
	1   set_par_g ('left_peak_tail', DEGTAILS, nampleft, ampleft, ntauleft, tauleft)
        if(n.eq.0) tauleft(1) = WTAILPEAK*aws(1)
	if (clipresent('right_peak_tail')) n =
	1   set_par_g ('right_peak_tail', DEGTAILS, nampright, ampright, ntauright, tauright)
        if(n.eq.0) tauright(1) = WTAILPEAK*aws(1)
	if (clipresent ('nopolynomial_degree')) backpol = 0
	if (clipresent ('polynomial_degree')) then
	  if (cligetinteger (backpol)) then
	    if(.not.(backpol .ge. (-2) .and. backpol .le. 4)) then
	      write (*,'('' Polynomial degree must be an integer [-2,4]'')')
	      backpol = -2
	    end if
	    if(backpol .eq. (-1)) backpol = -4
	    if(backpol .eq. (-2)) then
	      backpol = 0
	      backfixed = .TRUE.
	      backvalue = 0.
	    endif
	  end if
	end if
	end

	integer function set_par_e (calib, n, a, da, file)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  service routine:
c   gets coefficients for energy, efficiency and width calibration
c------------------------------------------------------------
	implicit none
	character*(*) calib, file
	integer n
	real*8 a(*), da(*)
	include 'cli_parms.icl'
	include 'gastxt.icl'
	integer i
	do i = 1, (n*(n+1))/2
	  da (i) = 0.
	end do
	i = 1
	do while (i.le.n .and. cligetdouble (a(i)))
	  i = i + 1
	end do
	set_par_e = i - 1
	file = '$coefficient'
	return
	end

	integer function set_par_f(n, a)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  service routine:
c   gets a maximum of n coefficients into array a
c   number of coefficients is returned as function value
c------------------------------------------------------------
	implicit none
	integer n
	real*8 a(*)
	include 'cli_parms.icl'
	include 'gastxt.icl'
	integer i
	do i = 1, n
	  a(i) = 0.
	enddo
	i = 1
	do while(i.le.n .and. cligetdouble(a(i)))
	  i = i + 1
	end do
	set_par_f = i - 1
	return
	end
	
	integer function set_par_g (tail, n, namp, amp, ntau, tau)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  service routine:
c  gets coefficients for tail calibration
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gastxt.icl'
	character tail*(*)
	integer i
	integer n, namp, ntau
	integer code
	real*8 amp(*)
	real*8 tau(*)
	real*8 x(8)
	i = 1
	do while (i.le.2*n. and. cligetdouble (x(i)))
	  i = i + 1
	enddo
	i = i - 1
        if(i.eq.0) then
          namp = 1
          amp(1) = 0.1
          ntau = 0
          set_par_g = 0
          return
        endif
	code = i / 2
	if (2 * code.ne.i) then
	  write (*, '('' type equal numbers of amplitude and decay coefficients'')')
	  code = 0
	else
          namp = code
          ntau = code
	  do i = 1, code
            if(namp.gt.0) then
              amp(i) = x(i)
            else
              amp(i) = 0.
            endif
c reset amplitude to default value
	    if(i.eq.1 .and. x(i).eq.0.) then
              namp = 0
              amp(i) = 0.1
            endif
            if(ntau.gt.0) then
              tau(i) = x(code+i)
            else
              tau(i) = 0.
            endif
c reset decay constant to default value
	    if(i.eq.1 .and. x(code+i).eq.0.) then
              ntau = 0
              tau(i) = 0.
            endif
	  end do
	end if
	if (amp(1).le.0.) write (*,'('' *** WARNING: rel. amplitude might be out of range'')')
	set_par_g = ntau
	end
	
	subroutine setpeak
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   set peak (-append                  -noappend
c                       -fit                     -nofit
c                       -individual, -nocommon   -noindividual, -common
c                       -list=filename           -search, -nolist
c                       -energy=filename         -noenergy
c                       -efficiency=filename     -noefficiency
c  sets switches and options for peak position and intensity
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gastxt.icl'
	include 'gasfil.icl'
	logical gaseic
	integer ltext
	if (clipresent ('append'))   append = .TRUE.
	if (clipresent ('noappend')) append = .FALSE.
	if (clipresent ('fit'))   poscon = .FALSE.
	if (clipresent ('nofit')) poscon = .TRUE.
	if (clipresent ('common') .or. clipresent('noindividual')) posall = .TRUE.
	if (clipresent ('nocommon') .or. clipresent('individual')) posall = .FALSE.
	if (clipresent ('include_background_tail'))   backinclude = .TRUE.
	if (clipresent ('noinclude_background_tail')) backinclude = .FALSE.
	if (clipresent ('search').or.clipresent('nolist')) then
	  peaklist = .FALSE.
	  widthlist = .FALSE.
	  posall = .FALSE.
	  poscon = .FALSE.
	else
	  if(clipresent ('list')) then
	    if(cligetstring (texta)) then
	      filepeak = texta(:ltext(texta))
	      inquire (file = filepeak, exist = peaklist)
	      if (peaklist) then
		reglist = .FALSE.
	      else
		write (*, '('' Cannot open list file.'')')
		posall = .FALSE.
		poscon = .FALSE.
	      end if
	    else
	      write(*, '('' --> No filename specified for option: list'')')
	    endif
	  endif
	end if
	if (clipresent('noenergy')) call gasdefe
	if (clipresent('energy')) then
	  if (cligetstring (texta)) then
            fileenergy=texta(:ltext(texta))
	    if(fileenergy(1:1) .ne. '$') then
	      if(.not.gaseic('energy')) call gasdefe
            endif
	  else
	    call gasdefe
	  endif
	end if
	if (clipresent('noefficiency')) call gasdeff
	if (clipresent('efficiency')) then
	  if( cligetstring (texta)) then
	    if (fileenergy.eq.' ') then
	      write (*,'('' *** make energy calibration first'')')
	      call gasdeff
	    else
	      fileeffic=texta(:ltext(texta))
c	      if(fileenergy(1:1) .ne. '$') then
	        if (.not. gaseic ('efficiency')) call gasdeff
c              endif
	    end if
	  else
	    call gasdeff
	  endif
	end if
	if ((poscon .or. posall) .and. .not. peaklist) then
	  write (*, '('' A peaklist must be defined in order to use -common or
	1 -nofit'')')
	  poscon = .FALSE.
	  posall = .FALSE.
	end if
	if (widthlist .and. .not. peaklist) then
	  widthlist = .false.
	  write (*, '('' A  widthlist is part of a peaklist - define this one first'')')
	end if
	end

	subroutine setregion
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   set region (-fit=values
c                         -list=filename       -nolist, -search
c  defines fit regions
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gastxt.icl'
	logical code
	integer ltext
	if(clipresent('fit')) then
	  code = cligetinteger(minch)
	  if(code .and. cligetinteger(maxch)) then
            if(minch.le.DEFMINCH) minch = DEFMINCH
	    if(maxch.le.minch) then
	      write (*,'(''*** last channel is less then first channel, both reset to default'')')
	      minch = 1
	      maxch = DEFMAXCH
	    end if
	  end if
        endif 
	if (clipresent('nolist') .or. clipresent('search')) then
	  reglist = .FALSE.
	else
	  if (clipresent ('list')) then
	    code = cligetstring (texta)
	    fileregion = texta(:ltext(texta))
	    inquire (file = fileregion, exist = reglist)
	    if (.not. reglist) then
	      write (*, '('' *** Cannot open input file: ''a)') fileregion (:ltext (fileregion))
	      fileregion = ' '
	    end if
	  endif
	end if
	end

	subroutine setstatistics
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   set statistics (-allpeaks            -noallpeaks
c                             -intern_error        -extern_error
c                              -smooth_error        -nosmooth_error
c                             -standard            -nostandard
c                             -normal, -nohigh     -nonoram, -high
c  sets parameters which define statistical conditions
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gastxt.icl'

	logical i
	if (clipresent ('standard')) nonestat = .FALSE.
	if (clipresent ('nostandard')) nonestat = .TRUE.
	if (clipresent ('allpeaks')) allpeaks = .TRUE.
	if (clipresent ('noallpeaks')) allpeaks = .FALSE.
	if (clipresent ('smooth_error')) smootherror = .TRUE.
	if (clipresent ('nosmooth_error')) smootherror = .FALSE.
	if (clipresent ('sensitivity')) then
	  i = cligetstring (texta)
	  if(texta(1:1) .eq. 'h')  highsens = .TRUE.
	  if(texta(1:1) .eq. 'n')  highsens = .FALSE.
	endif
	end

	subroutine settail
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   set tail (-all       -gamma     -none
c                       -background=real      -nobackground
c                       -left_peak_tail=real       -noleft_tail
c                       -right_peak_tail=real      -noright_tail
c                       -fit=string           -nofit
c                       -include              -noinclude
c  routine defines tail parameters
c------------------------------------------------------------
	implicit none
	character TAILRMESS*44
	parameter (TAILRMESS = '('' tail range must be in [0.;''f4.2'']'' )')
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gastxt.icl'
	real*8 value
c  define which tails are to be included
c  if special tails are given, look for range parameters for the decay constants
c  if range parameters are zero, decay constants will not be included in the fit
	if (clipresent ('all')) then
	  taill = .TRUE.
	  tailr = .TRUE.
	  tailb = .TRUE.
          lstep = .TRUE.
	  taillrange = 0.8
	  tailrrange = 0.8
	  tailbrange = 0.8
	else if (clipresent ('gamma')) then
	  taill = .TRUE.
	  tailr = .FALSE.
	  tailb = .TRUE.
          lstep = .FALSE.
	  taillrange = 0.8
	  tailbrange = 0.8
	else if (clipresent ('none')) then
	  taill = .FALSE.
	  tailr = .FALSE.
	  tailb = .FALSE.
          lstep = .FALSE.
	else
	  if (clipresent ('noleft')) taill = .FALSE.
	  if (clipresent ('left')) then
	    taill = .TRUE.
	    if (cligetreal (value)) then
	      if (value.ge.0. .and. value.le. TAILRANGE) then
	        taillrange = value
	      else
		write (*, TAILRMESS) TAILRANGE
	      end if
	    end if
	  end if
	  if (clipresent ('noright')) tailr = .FALSE.
	  if (clipresent ('right')) then
	    tailr = .TRUE.
	    if (cligetreal (value)) then
	      if (value.ge.0. .and. value.le. TAILRANGE) then
	        tailrrange = value
	      else
		write (*, TAILRMESS) TAILRANGE
	      end if
	    end if
	  end if
	  if (clipresent ('nobackground')) tailb = .FALSE.
	  if (clipresent ('background')) then
	    tailb = .TRUE.
	    if (cligetreal (value)) then
	      if (value.ge.0. .and. value.le. TAILRANGE) then
	        tailbrange = value
	      else
		write (*, TAILRMESS) TAILRANGE
	      end if
	    end if
	  end if
	  if (clipresent ('nostep')) lstep = .FALSE.
	  if (clipresent ('step'))  lstep = .TRUE.
	end if
c  are tail amplitudes to be included in the fit ?
	if (clipresent ('fit')) then
	  do while (cligetstring (texta))
	    if (texta(1:1) .eq. 'l') fitltail = .TRUE.
	    if (texta(1:1) .eq. 'r') fitrtail = .TRUE.
	    if (texta(1:1) .eq. 'b') fitbtail = .TRUE.
	    if (texta(1:1) .eq. 's') fitlstep = .TRUE.
	    if (texta(1:1) .eq. 'a') then
	      fitltail = .TRUE.
	      fitrtail = .TRUE.
	      fitbtail = .TRUE.
              fitlstep = .TRUE.
	    endif
	    if (texta(1:1) .eq. 'g') then
	      fitltail = .TRUE.
              fitbtail = .TRUE.
              fitrtail = .FALSE.
              fitlstep = .FALSE.
	    endif
	  end do
        endif
	if (clipresent ('nofit')) then
	  do while (cligetstring (texta))
	    if (texta(1:1) .eq. 'l') fitltail = .FALSE.
	    if (texta(1:1) .eq. 'r') fitrtail = .FALSE.
	    if (texta(1:1) .eq. 'b') fitbtail = .FALSE.
	    if (texta(1:1) .eq. 's') fitlstep = .FALSE.
	    if (texta(1:1) .eq. 'a') then
	      fitltail = .FALSE.
	      fitrtail = .FALSE.
	      fitbtail = .FALSE.
              fitlstep = .FALSE.
	    endif
	    if (texta(1:1) .eq. 'g') then
	      fitltail = .FALSE.
	      fitbtail = .FALSE.
              fitlstep = .FALSE.
	    endif
	  enddo
	end if
	if (clipresent ('enforce_fit')) tailenforced = .TRUE.
	if (clipresent ('noenforce_fit')) tailenforced = .FALSE.
c  are peak tails to be included into the centroid calculation?
	if (clipresent ('include')) centail = .TRUE.
	if (clipresent ('noinclude')) centail = .FALSE.
c restrict variation of width if line tails are active
cxx	if((taill .or. tailr) .and. fwhmrange.gt.1.0) then
cxx          write(*,'('' --> range of width variation restricted to 1.0'')')
cxx	  fwhmrange = 1.0
cxx	endif
	end

	subroutine setwidth
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   set width  -calibrate=filename       -nocalibrate
c                        -list=filename            -nolist
c                        -range=value
c                        -value=value
c  defines width paramters
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gastxt.icl'
	include 'gaspar.icl'
	logical code, gaseic
	integer ltext
	real*8 zwischen
	if(clipresent ('list')) widthlist = .TRUE.
	if(clipresent ('nolist')) widthlist = .FALSE.
        if(clipresent ('individual')) widthall = .FALSE.
        if(clipresent ('nocommon')) widthall = .FALSE.
        if(clipresent ('common')) widthall = .TRUE.
        if(clipresent ('noindividual')) widthall = .TRUE.
        if(ELEMENTS.eq.2 .and. .not.widthall) then
          write(*, '('' no individual width parameters in this version'')')
          widthall = .TRUE.
        endif
        if(clipresent ('range')) then
	  code = cligetreal (zwischen)
	  if (code) then
            if(zwischen.lt.0. .or. zwischen.gt. 100.) then
	      write(*, '('' value to -range must be a number in [0.;100.]!'')')
            else
              if(zwischen.ge.0.01) then
  	        fwhmrange = zwischen
              else
                fwhmrange = 0.d+00
                if(zwischen.gt.0.) write(*, '(  range set to zero!)')
              endif
	    end if
	  end if
	end if
	if (clipresent ('value')) then
	  code = cligetreal (zwischen)
	  if (code .and. zwischen .ge. 1. .and. zwischen .le. MAXWIDTH) then
	    aws(1) = zwischen
	    filewidth = ' '
	    ndw = 1
	  else
	    write (*, '('' Value to -value must be a real number in [1;''i3''].'')') int (MAXWIDTH)
	  end if
	end if
	if(clipresent ('nocalibrate')) call gasdefw
	if(clipresent('calibrate')) then
	  code = cligetstring (texta)
	  filewidth = texta(:ltext(texta))
          if(filewidth(1:1) .ne. '$') then
	    if (.not.gaseic('width')) call gasdefw
          endif
	end if
	if (widthlist .and. .not. peaklist) then
	  write (*, '('' A peak list must be defined in order to define a width list.'')')
	  widthlist = .false.
	end if
	end

        subroutine showerror
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:  show error
c  prints the current errors in a fit
c------------------------------------------------------------
        implicit none
        call show_error(.true.)
        end

        subroutine show_error(mode)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:  show error
c  prints the current errors in a fit
c falls mode = .true. wird auch no error in this fit  ausgegeben.
c------------------------------------------------------------
        implicit none
        include 'gasctr.icl'
        logical mode
        integer i, rest

        if(nerr.eq.0 .and. mode) write(*, '('' No error in this fit'')')
        rest = nerr
        i = rest/100000
        if(i .eq. 1) write(*, '('' Input value for background tail decay constant too small.'')')
        if(i .eq. 4) write(*, '('' Input value for background tail decay constant too large.'')')
        rest = rest - i * 100000
        i = rest/10000
        if(i .eq. 1) write(*, '('' Input value for right tail decay constant too small.'')')
        if(i .eq. 4) write(*, '('' Input value for right tail decay constant too large.'')')
        rest = rest - i * 10000
        i = rest/1000
        if(i .eq. 1) write(*, '('' Input value for left tail decay constant too small.'')')
        if(i .eq. 4) write(*, '('' Input value for left tail decay constant too large.'')')
        rest = rest - i * 1000
        i = rest / 100
        if(i .eq. 1) write(*, '('' Input value for width too small'')')
        if(i .eq. 4) write(*, '('' Input value for width too large'')')
        rest = rest - i * 100
        i = rest / 10
        if(i .eq. 1) then
           write(*, '('' Too many lines in a fit region:'')')
           write(*, '(''  The residue search had to be stopped'')')
        endif
        rest = rest - i * 10
        if(rest .eq. 1 .or. rest.eq.5) then
           write(*, '('' Lines too close in the fit region:'')')
           write(*, '(''  some lines might have been dropped'')')
        endif
        if(rest.eq.4 .or. rest.eq.5) then
           write(*, '('' Fit  has been stopped because of poor converence:'')')
           write(*, '(''  Result is meaningless!'')')
        endif
        return
        end
        
	subroutine showfit
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:  show fit
c  shows fit from a saved fit file
c------------------------------------------------------------
	implicit none
	include 'gasctr.icl'
	logical gasfil
	logical i, cancelfit
	integer gasdis, j
	i = cancelfit(0)
	do while (gasfil ())
          j = gasdis(0., 1)
	end do
	maxfil = 0
	end

	subroutine showoptions
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:    show option
c  shows option set
c------------------------------------------------------------
	call gasopt (' ', 6)
	end

	subroutine showparameters
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   show parameters
c  shows set parameters
c------------------------------------------------------------
	call gaspas (' ', 6, 7)
	end

        subroutine showsample
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c command show sample
c displays the sample files taken with the option
c set parameter -check or -fullcheck and isensw(14) = .true.
c------------------------------------------------------------
        implicit none
        integer KANAL
        parameter (KANAL= 14)

        include 'gasfil.icl'
        include 'gasdis.icl'
        include 'gasctr.icl'

        character filename*20, title*120, str*120, request*10
        logical da, sa, istext, joinps, ende
        integer i, ios, filecount, anzahl, mode, ltext
        real*8 deltapar(200), deltachi(200), xa(2), ya(2), minchi, maxchi, fac
   
        inquire(unit = kanal, opened = da)
        if(da) close(unit = kanal)
c
        filecount = 0
        da = .true.
        call disclose(1)
        disopen = .FALSE.
        do while(da)
          write(filename, '(a,i3.3,''.dat'')') CHISAMPLE, filecount
	  inquire (file = filename, exist = da)
	  if(da) then
            open(unit = kanal, file = filename, status = 'old', iostat = ios)
            write(*,'(''working on file '',a)') filename
            anzahl = 0
            do while(ios.eq.0)
              read(kanal, '(a)', iostat = ios) str
              if(ios.ne.0) str = 'end'
              if(str(:4).eq.'file') then
                write(*,'(a)') str(:ltext(str))
              else if(istext(str)) then
                if(anzahl.gt.0) then
                  fac = 1.
                  minchi = abs(deltapar(1))
                  do while(fac*minchi.lt.0.1)
                    fac = 10.*fac
                  enddo
                  if(fac.eq.1.) then
                    request = 'dpar'
                  else
                    do i = 1, anzahl
                      deltapar(i) = fac*deltapar(i)
                    enddo
                    write(request, '(''dpar*10^'',i1)') min(int(log10(fac) + 0.5), 9)
                  endif
                  minchi = deltachi(1)
                  maxchi = minchi
                  do i = 2, anzahl
                    if(minchi.gt.deltachi(i)) minchi = deltachi(i)
                    if(maxchi.lt.deltachi(i)) maxchi = deltachi(i)
                  enddo
                  mode = 0
                  if(maxchi.gt.10.) then
                    mode = -1
                    minchi = 1. + (0.9999 - minchi)
                    do i = 1, anzahl
                      deltachi(i) = deltachi(i) + minchi
                    enddo
                  else
                    minchi = 0
                  endif
                  call disclose(0)
                  call graph(deltapar, deltapar, deltachi, deltachi, anzahl,mode)
                  mode = mode + 1
                  if(mode.eq.0) mode = -2
                  call graph(deltapar, deltapar, deltachi, deltachi, anzahl,mode)
                  xa(1) = deltapar(1)
                  xa(2) = deltapar(anzahl)
                  ya(1) = minchi
                  ya(2) = minchi
                  call graph(xa, xa, ya, ya, 2, mode)
                  ya(1) = 1. + minchi
                  ya(2) = 1. + minchi
                  call graph(xa, xa, ya, ya, 2, mode)
                  call graphlabel(request, 'dchi', title(:ltext(title)))
                  request = " "
                  if(dishold .or. .not.dissave) then
                    write(*,'('' >''$)')
                    read (*,'(a)') request
                    call closegr(0)
                    if(request.eq."s" .and. dissave) sa = joinps(disfile, 'graphplt.bak')
                    if(request.eq.'n' .or. request.eq.'q') then
                      ios = -1
                      if(request.eq.'q') da = .false.
                    endif
                  else if(dissave) then
                    call closegr(0)
                    sa = joinps(disfile, 'graphplt.bak')
                  endif
                  if(ende) ios = -1
                  anzahl = 0
                  title = str
                else
                  title = str
                endif   ! anzahl.gt.0
              else if(ltext(str).lt.40) then
                anzahl = anzahl + 1
                read(str, *) deltapar(anzahl), deltachi(anzahl)
              endif ! istext(str)
              if(ios.ne.0)  close(unit = kanal)
            enddo    ! ios.eq.0
            filecount = filecount + 1
          endif      !  if(da)
        enddo        !  while(da)
        return
        end


	subroutine showspectrum
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   show spectrum
c  displays the spectrum
c  soll auch die alternative Form
c             show spectrum min,max
c  erlauben
c------------------------------------------------------------
	implicit none
	include 'gasctr.icl'
        include 'gastxt.icl'
        include 'cli_parms.icl'
        include 'gaseic.icl'
	include 'gasdis.icl'
        include 'gasfil.icl'
	logical gasfil
	logical cancelfit
	integer gasdis
        integer ltext
        logical da, gasdouble
        integer io
        integer i, j, saveminch, savemaxch
        real*8 x, invpolfun
        character text2*20

c  save fit regions
        saveminch = minch
        savemaxch = maxch
        da = cligettext(texta)
        da = cligettext(texta)
        texta = ' '
        if(cligettext(texta)) then
          text2 = ' '
          j = 0
	  do i = 1, ltext(texta)
            if(texta(i:i) .eq. ',') then
              j = 1
              texta(i:i) = ' '
            else if(j .gt. 0) then
              text2(j:j) = texta(i:i)
              texta(i:i) = ' '
              j = j+1
            endif
          enddo
          if(.not. gasdouble(texta(:ltext(texta)), x, io)) then
            if(io.eq.0) then
              if(disenergy .and. fileenergy.ne.' ') x =  max(1., invpolfun(x, nde - ndem, ndem, aes))
               minch = max(1, int(x + 0.5))
            endif
          endif
          if(.not. gasdouble(text2(:ltext(text2)), x, io)) then
            if(io.eq.0) then
              if(disenergy .and. fileenergy.ne.' ') x =  max(1., invpolfun(x, nde - ndem, ndem, aes))
              maxch = int(x + 0.5)
            endif
          endif
        endif
        if(minch.gt.maxch) then
          io = minch
          minch = maxch
          maxch = io
        endif
        i = minch
	da = cancelfit(0)
	do while (gasfil ())
          minch = i
	  do while (minch.lt.maxch)
            minch = gasdis(0., 0)
            if(minch.eq.0) then
              minch = maxch
            else
              maxch = min(lastch, maxch)
            endif
	  end do
	end do
        maxch = savemaxch
        minch = saveminch
	end

	subroutine showversion
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:   show version
c------------------------------------------------------------
	implicit none
	include 'gastxt.icl'
	integer ltext
	write(*, '(xa)') version(:ltext (version))
	write(*, '('' A program to fit gamma and particle spectra'')')
	write(*, '('' Author: Friedrich Riess, email: friedrich.riess@physik.uni-muenchen.de'')')
        write(*, '('' URL: http://www.cip.physik.uni-muenchen.de/~riess/'')')
	end

	subroutine testspec
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command: test spectrum
c  generates test spectrum
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gastxt.icl'
	logical da
	logical gasgen

        da = cligettext(texta)
        da = cligettext(texta)
	da = gasgen(cligettext(texta))
	end

	subroutine testprint
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command: test printout
c  for debugging purposes
c------------------------------------------------------------
	implicit none
	include 'cli_parms.icl'
	include 'gasctr.icl'
	include 'gasfil.icl'
	include 'gastxt.icl'

	integer ios,num, ltext
	logical da
	logical isensw
c  check for optional argument
        da = cligettext(texta)
        da = cligettext(texta)
        da = cligettext(texta)
        num = 0
        ios = 0
        if(da) then
          texta = texta(:ltext(texta)) // ' '
          read(texta, '(i4)', IOSTAT=ios) num
        endif
        if(ios.ne.0) then
          write(*,'(''--> Argument must be a number, command ignored'')')
        else
          if(num.gt.0) then
            da = isensw(-num)
          elseif(num.le.-30) then
            da = isensw(-100)
          else
            da = isensw(0)
          endif
        endif
c	code = isensw (0)
c	if (code .and. .not. lpa) then
c	  lpa = .TRUE.
c	  inquire (unit = 3, opened = da)
c	  if (.not. da) then
c            open (unit = 3, file = FILEHIST, status = 'unknown', iostat = ios)
c            if(ios.ne.0) then
c              write(*, '('' -->test: can not open file '',a)') FILEHIST
c              lpa = .FALSE.
c            endif
c          endif 
c	else
c	  if(.not.code .and. lpa)  close(UNIT=3)
c	end if
	end

	subroutine gasopt (file, channel)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  service routine:
c  routine prints the options on slot "channel" into filename "file"
c  if the file is already opened, it will be neither opened nor closed
c------------------------------------------------------------
	implicit none
        character*(*) SET_FILES
	parameter (SET_FILES = '('' set files -''a,a'' -''a)')
	character*(*) SET_PEAK
	parameter (SET_PEAK = '('' set peak -''a))')

	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gastxt.icl'
        include 'gasdis.icl'

	character file*(*)
	character parascii*16
	integer addcomma
	integer channel
	integer fehler
	integer i, l
	integer ltext
	logical opened, da

	inquire (unit = channel, opened = opened, exist = da)
	if(channel .eq. 6) then
          opened = .true.
        else
          if(.not.opened .and. da) then
            open(unit = channel, file = file, status = 'unknown')
            close(unit = channel, status = 'DELETE')
          end if
        end if
	fehler = 0
	if (.not. opened) open (unit = channel, iostat = fehler,
	1         file = file, status = 'unknown')
	if (fehler .ne. 0) then
	  write (*, '('' --> GASOPT: Cannot open output file.'',a)') file(:ltext(file))
	  opened = .true.
	else
c save first parameter settings, but only into file
	  if (channel .ne. 6) call gaspas(' ', channel, 7)
c  Display options
	  texta = ' set display'
	  if(display) then
	    texta(ltext(texta)+1:) = ' -on'
	  else
	    texta(ltext(texta)+1:) = ' -off'
          endif
          write(texta(ltext(texta)+1:), '(" -windowsize="f5.3","f5.3)') disxsize, disysize
          write(texta(ltext(texta)+1:), '(" -print="a)') disprint(:ltext(disprint))
          write(channel, '(a)') texta(:ltext(texta))
	  texta = ' set display -'
          if(.not.disresiduum) texta(ltext(texta)+1:) = 'no'
          texta(ltext(texta)+1:) = 'residuum'
	  if(disenergy) then
	    texta(ltext(texta)+1:) = ' -energy'
	  else
	    texta(ltext(texta)+1:) = ' -channels'
	  endif
	  if(dislogaxis) then
	    texta(ltext(texta)+1:) = ' -logarithmic'
	  else
	    texta(ltext(texta)+1:) = ' -linear'
	  endif
          if(diserrorbar) then
	    texta(ltext(texta)+1:) = ' -errorbar'
	  else
	    texta(ltext(texta)+1:) = ' -histogram'
	  endif
	  texta(ltext(texta)+1:) = ' -'
	  if(.not.dissingle) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'single_peak'
	  write (channel, '(a)') texta(:ltext(texta))
	  texta = ' set display -'
          if(disgauss.gt.0) then
            texta(ltext(texta)+1:) = 'gauss-position -'
          else if(disgauss.lt.0) then
            texta(ltext(texta)+1:) = 'centroid -'
          else
            texta(ltext(texta)+1:) = 'tail_include -'
          endif
	  if(.not.disintermediate) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'intermediate -'
	  if(.not.dishold) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'hold'
          if(.not.dissave) then
             texta(ltext(texta)+1:) = ' -nosaveall'
          else
            texta(ltext(texta)+1:) = ' -saveall='// disfile(:ltext(disfile))
          endif
	  write (channel, '(a)') texta(:ltext(texta))
	  if(distext.ne.' ') write(channel, '(a,a)') ' set display -comment=', distext(:ltext(distext))
          
c  file options
          if(filesformat.eq.0) then
            texta = ' set files -format=search'
          else
	    texta = ' set files -format='//cmdformat(filesformat)
          endif
	  if(dskspe) then
	    texta(ltext(texta)+1:) = ' -matrix'
	  else
	    texta(ltext(texta)+1:) = ' -single_spectrum'
	  endif
	  write (channel, '(a)') texta(:ltext(texta))
c .. file
	  if(ltext(filestring).eq.0) then
	    write(channel, '(a)') ' set files -file='
	  else
	    write(channel, '(a)') ' set files -file='//filestring(:ltext(filestring))
	  endif
c  region
	  texta = ' set region -'
	  if (reglist) then
            texta(ltext(texta)+1:) = 'list='//fileregion
	  else
	    texta(ltext(texta)+1:) = 'search'
	  endif
	  texta(ltext(texta)+1:) = ' -fit='
	  write (parascii,'(2i8)') minch, maxch
	  l = addcomma (parascii)
	  write (channel, '(a,a)') texta(:ltext (texta)), parascii(:ltext(parascii))
c  fit options
	  texta = ' set fit -'
	  if(.not.interactiv) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'interactive -'
	  if(.not.ressearch) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'residue_search -'
	  if(.not.savefit) texta(ltext(texta)+1:) = 'no'
          texta(ltext(texta)+1:) = 'save -'
	  if(.not.lpa)  texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'printout'
	  write (channel, '(a)') texta(:ltext(texta))
          if(fitout.eq.0) then
            write(channel, '('' set fit -noout'')')
          else
            write(channel, '('' set fit -out'')') 
          endif
c  Background options
	  write (parascii, '(i2)') abs(backpol)
	  i = addcomma(parascii)
	  texta = ' set background -'
	  if(backpol .lt. 0) texta(ltext(texta)+1:) = 'max_'
	  texta(ltext(texta)+1:) = 'polynomial_degree='//parascii(:ltext(parascii))
	  if(backpol .eq. 0) then
	    if(backfixed) then
	      write(parascii, '(f10.1)') backvalue
	      i = addcomma(parascii)
	      texta(ltext(texta)+1:) = ' -fixed='//parascii(:ltext(parascii))
	    else
	      texta(ltext(texta)+1:) = ' -fit'
	    endif
	  endif
	  write (channel, '(a)') texta(:ltext(texta))
c peak
          texta = ' set peak'
	  if (.not. peaklist) then
	    texta(ltext(texta)+1:) = ' -search'
	  else
	    texta(ltext(texta)+1:) = ' -list='//filepeak
	  end if
	  if (fileenergy(1:1) .eq. ' ') then
	    texta(ltext(texta)+1:) = ' -noenergy'
	  else
	    texta(ltext(texta)+1:) = ' -energy='//fileenergy
	  end if
	  if (fileeffic(1:1) .eq. ' ') then
	    texta(ltext(texta)+1:) = ' -noefficiency'
	  else
	    texta(ltext(texta)+1:) = ' -efficiency='//fileeffic
	  end if
	  write (channel, '(a)') texta(:ltext (texta))
c ..peak
          texta = ' set peak -'
	  if(.not.append) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'append -'
	  if(poscon) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'fit'
	  if (posall) then
	    texta(ltext(texta)+1:) = ' -common -'
          else
	    texta(ltext(texta)+1:) = ' -individual -'
	  endif
	  if(.not.backinclude) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'include_background_tail'
	  write (channel, '(a)') texta(:ltext(texta))
c  set width ...
	  texta = ' set width -'
          if(widthall) then
            texta(ltext(texta) + 1:) = 'common -'
          else
            texta(ltext(texta) + 1:) = 'individual -'
          endif
	  if(.not.widthlist) texta(ltext(texta)+1:) = 'no'
	   texta(ltext(texta)+1:) = 'list -range='
	  write(parascii, '(f6.2)') fwhmrange
	  i = addcomma(parascii)
	  texta = texta(:ltext(texta))//parascii
	  if (.not. widthlist .and. ndw .eq. 1) then
	    l = 4 + int (log10 (max (.1, aws(1))))
	    write (parascii, '(f6.2)') aws(1)
	    i = addcomma(parascii)
	    texta(ltext(texta)+1:) = ' -value='//parascii
	  else
	    if (filewidth(:1) .ne. ' ') then
	      texta(ltext(texta)+1:) = ' -calibrate='//filewidth(1:ltext(filewidth))
	    else
	      texta(ltext(texta)+1:) = ' -nocalibrate'
	    end if
	  end if
	  write (channel, '(a)') texta(:ltext (texta))
c  set tails ....
	  texta = ' set tail -'
	  if(.not.centail) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'include -'
	  if(.not.tailenforced) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'enforce_fit'
	  if(.not.taill) texta(ltext(texta)+1:) = ' -noleft'
	  if(.not.tailr) texta(ltext(texta)+1:) = ' -noright'
	  if(.not.tailb) texta(ltext(texta)+1:) = ' -nobackground'
	  if(.not.lstep) texta(ltext(texta)+1:) = ' -nostep'
	  write(channel, '(a)') texta(:ltext(texta))
c tails if set
	  if(taill) then
	    texta = ' set tail -'
	    if(.not.fitltail) texta(ltext(texta)+1:) = 'no'
	    texta(ltext(texta)+1:) = 'fit=left -left='
	    write(parascii, '(f4.2)') taillrange
	    i = addcomma(parascii)
	    write(channel, '(a,a)') texta(:ltext(texta)), parascii(:ltext(parascii))
	  endif
	  if(tailr) then
	    texta = ' set tail -'
	    if(.not.fitrtail) texta(ltext(texta)+1:) = 'no'
	    texta(ltext(texta)+1:) = 'fit=right -right='
	    write(parascii, '(f4.2)') tailrrange
	    i = addcomma(parascii)
	    write(channel, '(a,a)') texta(:ltext(texta)), parascii(:ltext(parascii))
	  endif
	  if(tailb) then
	    texta = ' set tail -'
	    if(.not.fitbtail) texta(ltext(texta)+1:) = 'no'
	    texta(ltext(texta)+1:) = 'fit=background -background='
	    write(parascii, '(f4.2)') tailbrange
	    i = addcomma(parascii)
	    write(channel, '(a,a)') texta(:ltext(texta)), parascii(:ltext(parascii))
	  endif
	  if(lstep) then
	    texta = ' set tail -'
	    if(.not.fitlstep) texta(ltext(texta)+1:) = 'no'
	    texta(ltext(texta)+1:) = 'fit=step -step'
	    write(channel, '(a)') texta(:ltext(texta))
	  endif
c  statistik
	  texta = ' set statistic -'
	  if(.not.allpeaks) texta(ltext(texta)+1:) = 'no'
          texta(ltext(texta)+1:) = 'allpeaks -'
	  if(.not.smootherror) texta(ltext(texta)+1:) = 'no'
          texta(ltext(texta)+1:) = 'smooth_error -'
	  if(nonestat) texta(ltext(texta)+1:) = 'no'
	  texta(ltext(texta)+1:) = 'standard -sensitivity='
          if(highsens) then
	    texta(ltext(texta)+1:) = 'high'
	  else
	    texta(ltext(texta)+1:) = 'normal'
	  endif
	  write (channel, '(a)') texta(:ltext (texta))
c parameters
	  texta = ' set parameters -'
	  if(parcheck.eq.0) then
            texta(ltext(texta)+1:) = 'no'
          else if(parcheck.eq.-1) then
            texta(ltext(texta)+1:) = 'full_'
          else if(parcheck.eq.+2) then
            texta(ltext(texta)+1:) = 'all_'
          else if(parcheck.eq.-2) then
            texta(ltext(texta)+1:) = 'extended_'
          endif
          texta(ltext(texta)+1:) = 'check'
	  write (channel, '(a)') texta(:ltext(texta))
c finishing up
	  if (.not. opened) then
            close (unit = channel, IOSTAT = i)
            if(i.ne.0) write(*, '('' --> GASOPT: Error in closing File ('',i,'')'')') i
          end if
	end if
        return
	end


	subroutine gaspas(file, channel, printcode)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  service routine
c  this subroutine saves or shows the parameters stored in the arrays
c  of gaseic.icl
c  note: + sign will not be accepted on input. the SS option in the format
c  statement does not suppress the + sign in e+nn. The routine eraseplus
c  replaces the + sign by a 0
c------------------------------------------------------------
	implicit none
	character file*(*)
	integer channel, printcode
	character FMTCURA*55, FMTCURW*55, FMTCUAA*55, FMTCUAW*55, SETFMT*40
	parameter (FMTCURA = '('' tail-''a'' rel. amplitude'',t35,f16.4'' +/-''f9.4)')
        parameter (FMTCURW = '('' tail-''a'' decay constant'',t35,f16.4'' +/-''f9.4)')
	parameter (FMTCUAA = '('' tail-''a'' rel. amplitude'',t35,a)')
       	parameter (FMTCUAW = '('' tail-''a'' decay constant'',t35,a)')
	parameter (SETFMT = '('' set parameters -''a''=(''a'')'')')
	include 'gasctr.icl'
	include 'gaspar.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	character string*132
	logical opened, da
	integer addcomma, ltext, equalexp
	integer i, fehler, n
	inquire (unit = channel, opened = opened, exist = da)
	if(channel .eq. 6) then
          opened = .true.
        else
          if(.not.opened .and. da) then
            open(unit = channel, file = file, status = 'unknown')
            close(unit = channel, status = 'DELETE')
          end if
        end if
	fehler = 0
	if (.not. opened) open (unit = channel, iostat = fehler, file = file,
	1          status = 'unknown')
	if(fehler .ne. 0) then
	  write (*, '('' ***Cannot open output file ''a)') file (:ltext (file))
	  opened = .true.
	else
	  if (channel .eq. 6) write (channel, '(/'' coefficients of calibrations'')')
	  if(fileenergy.ne.' ' .and. mod(printcode,2) .eq. 1) then
	    write (string, '(SS6g16.7)') (aes(i), i = 1, nde)
	    i = addcomma (string)
	    call eraseplus (string)
	    write (channel, SETFMT) 'energy', string(:ltext(string))
	  end if
	  if(fileeffic.ne.' ' .and. mod(printcode/2, 2) .eq. 1) then
	    write (string, '(SS8g16.7)') (afs(i), i = 1, ndf)
	    i = addcomma (string)
	    call eraseplus (string)
	    write (channel, SETFMT) 'efficiency', string(:ltext(string))
	  end if
	  if(filewidth.ne.' ' .and. mod(printcode/4, 2) .eq. 1) then
	    write (string, '(SS6g16.7)') (aws(i), i = 1, ndw)
	    i = addcomma (string)
	    call eraseplus (string)
	    write (channel, SETFMT) 'width', string(:ltext(string))
	  endif
	  if (channel .eq. 6) then
	    if (tailb .or. taill. or. tailr .or. lstep) then
	      write (channel, '(/''  coefficients of relative amplitudes and decay constants'')')
	    else
	      write (channel, '(''  no tails defined'')')
	    end if
	  end if
	  if (tailb) then
            n = max (1, nampback, ntauback)
	    write (string, '(SS6g16.4)') (ampback (i), i = 1, n), (tauback (i), i = 1, n)
	    i = addcomma(string)
	    call eraseplus (string)
	    write (channel, SETFMT) 'background_tail', string(:ltext(string))
	  end if
	  if (taill) then
	    n = max (1, nampleft, ntauleft)
	    write (string, '(SS6g16.4)') (ampleft (i), i = 1, n), (tauleft (i), i = 1, n)
	    i = addcomma(string)
	    call eraseplus (string)
	    write (channel, SETFMT) 'left_peak_tail', string(:ltext(string))
	  end if
	  if (tailr) then
	    n = max (1, nampright, ntauright)
	    write (string, '(SS6g16.4)') (ampright (i), i = 1, n), (tauright (i), i = 1, n)
	    i = addcomma(string)
	    call eraseplus (string)
	    write (channel, SETFMT) 'right_peak_tail', string(:ltext(string))
	  end if
	  if (lstep) then
            n = max (1, nampstep)
	    write (string, '(SS6g16.4)') (ampstep (i), i = 1, n)
	    i = addcomma(string)
	    call eraseplus (string)
	    write (channel, SETFMT) 'step', string(:ltext(string))
	  end if
c  type current settings values 
	  if(channel.eq.6 .and. parposition.gt.0.) then
	    write (channel, '(/''   current parameter values at channel'',f9.0)') parposition
            if(1.e+8.gt.dfwhm .and. dfwhm.ge.0.001) then
	      write (channel, '('' width (FWHM)''t35,f16.4'' +/-''f9.4)') fwhm, dfwhm
            else
              i = equalexp(fwhm, dfwhm, 2, .TRUE., string)
              write (channel, '('' width (FWHM)''t35,a)'), string(:ltext(string)-1)
            endif
	    if (taill) then
              if(1.e+8.gt.dampl .and. dampl.ge.0.001) then
	        write (channel, FMTCURA) 'left', ampl, dampl
              else
                i = equalexp(ampl, dampl, 2, .TRUE., string)
                write (channel, FMTCUAA) 'left', string(:ltext(string)-1)
              endif
              if(1.e+8.gt.dtaul .and. dtaul.ge.0.001) then
	        write (channel, FMTCURW) 'left', taul, dtaul
              else
                i = equalexp(taul, dtaul, 2, .TRUE., string)
                write (channel, FMTCUAW) 'left', string(:ltext(string)-1)
              endif
	    end if
	    if (tailr) then
              if(1.e+8.gt.dampr .and. dampr.ge.0.001) then
	        write (channel, FMTCURA) 'right', ampr, dampr
              else
		i = equalexp(ampr, dampr, 2, .TRUE., string)
                write (channel, FMTCUAA) 'right', string(:ltext(string)-1)
              endif
              if(1.e+8.gt.dtaur .and. dtaur.ge.0.001) then
	        write (channel, FMTCURW) 'right', taur, dtaur
              else
                i = equalexp(taur, dtaur, 2, .TRUE., string)
                write (channel, FMTCUAW) 'right', string(:ltext(string)-1)
              endif
	    end if
	    if (tailb) then
              if(1.e+8.gt.dampb .and. dampb.ge.0.001) then
	        write (channel, FMTCURA) 'background', ampb, dampb
              else
                i = equalexp(ampb, dampb, 2, .TRUE., string)
                write (channel, FMTCUAA) 'background', string(:ltext(string)-1)
              endif
              if(1.e+8.gt.dtaub .and. dtaub.ge.0.001) then
	        write (channel, FMTCURW) 'background', taub, dtaub
              else
                i = equalexp(taub, dtaub, 2, .TRUE., string)
                write (channel, FMTCUAW) 'background', string(:ltext(string)-1)
              endif
	    end if
	    if (lstep) then
              if(1.e+8.gt.damps .and. damps.ge.0.001) then
	        write (channel, FMTCURA) 'step', amps, damps
              else
                i = equalexp(amps, damps, 2, .TRUE., string)
                write (channel, FMTCUAA) 'step', string(:ltext(string)-1)
              endif
	    end if
            write(channel, '(/'' coefficients of background polynomial y = sum a(i)*(x-xo)^i'')')
            write(channel, '(''    xo = '',f10.1)')  back0
            do n = 1, backdeg + 1
              i = equalexp(backc(n), dbackc(n), 2, .TRUE., string)
              write(channel, '(''    a('',i1,'') = '',a)') n-1, string(:ltext(string)-1)
            enddo
	  end if    !  if(channel .eq. 6)
	end if   ! if(fehler.eq.0)
	if (.not. opened) close (unit = channel)
	end

	subroutine eraseplus (string)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  command:
c------------------------------------------------------------
	implicit none
	character string*(*)
	integer i, ltext
	do i = 1, ltext (string)
	  if (string(i:i).eq.'+') string (i:i) = '0'
	end do
	end





        subroutine wait
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  waits on keyboard input
c------------------------------------------------------------
        implicit none

        character input*10

        write(*,'(''<cr> to continue, q to quit: ''$)')
        read(*,'(a)') input
        if(input(1:1).eq.'q') call gasexit()
        return
        end
