	logical function gasres()
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasres.f,v 2.27 2005/03/02 15:54:30 friedrich Exp friedrich $
c
c  this routine checks the residuen spectrum for peaks
c  to be added. an added peak will have fixvorgabe = .false.
c  if no peaks are found, gasres = .false., otherwise
c  gasres = .true.
c  all added peaks are put into the list addedpeak which is used as a 
c  ring buffer.
c  peaksadded is the pointer to the last entry in this list, it must be 
c  initialized in  the routine gasber to 0. The routine will not be 
c  allowed to add a peak which is in  the list and hence has been added 
c  previously. But because fitting conditions might change,
c  several attempts to add a line twice will finally succeed: on the 
c  first attempt, the value  in the list will be negated, on the second 
c  attempt it will be removed and on the 3rd attempt
c  the addition is successfull.
c  entry in this list
c  06.06.79  f. riess
c  11.02.94: Ausgabe in file dskspec.inf falls peak -nofit und files -matrix
c------------------------------------------------------------------
	implicit none

	integer PEAKSFOUND, ADDLIST, ADDMAX, KANAL, WAITCOUNT
c output channel for debuging, should be on 3 or 6
        parameter (KANAL = 3)
c  size of arrays to hold peaks found in residue search
	parameter (PEAKSFOUND = 25)
c  size of list of added peaks. Lines found in this list can not
c  be added in the next WAITCOUNT steps
	parameter (ADDLIST = 40)
        parameter (WAITCOUNT = 3)
c  number of peaks which can be added in one step
c  should be larger than number of peaks which can be deleted by gasfck
        parameter (ADDMAX = 3)

c  determines the threshold for peak identification lower values mean
c  higher sensivity
c  THRESHOLD:       set statistics -sensivity=normal
c  HTHRESHOLD:      set statistics -sensivity=high 
        real*8 THRESHOLD, HTHRESHOLD
        parameter (THRESHOLD = 4.5)
        parameter (HTHRESHOLD = 3.5)   

	character*(*) FRESPAV
	parameter (FRESPAV='(9x,'' *** peak or parameter number overflow (''2i5'')'')')
	character*(*) FRESREG
	parameter (FRESREG='(9x,'' *** region changed to'',i5,'' -'',i5)')
	character*(*) FRESNOPF
	parameter (FRESNOPF='(9x,''no peaks found in residuen search'')')
	character*(*) FRESCOC
	parameter (FRESCOC='(12x,''peak at '',f9.1,'' width '',f6.1 
        1,'' (target >='',f5.1,'') statistics '',f6.2,'' (target >= 0)''$)')
	character*(*) FRESREJ
 	parameter (FRESREJ='(''  rejected'')')
	character*(*) FRESREJO
 	parameter (FRESREJO='(10x,''rejected:'',4x,''peak at ''
	1,f8.1,'' because of overlap with peak '',f8.1)')
	character*(*) FRESADDP
	parameter (FRESADDP='(9x,''added:'',7x,''peak at '',f9.1,'', amplitude '',g14.6
        1, '', width '',f7.1)')

	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'

	logical isensw
        real*8 poly
	integer gaserr, addpar
	logical header, lpa5, lplocal, peak
	integer i, j, l, foldwidth, mw2, foldrange, n, new, npeaks, added, naddmax, repeat
	real*8 corr, dx, cormax, resmax, diffmax, corarea, resarea, diffarea
        1, corpos, respos, diffpos, witar, x, corrmin, xm
	real*8 position(PEAKSFOUND), ampfound(PEAKSFOUND), priority(PEAKSFOUND), addedpeak(ADDLIST)
        real*8 widthfound(PEAKSFOUND)
        integer addcount(ADDLIST),  cyclecount(ADDLIST), lsave
        real*8 resimin, corwidth, reswidth, sumerror
c
	gasres = .FALSE.
        resimin = 2.

        lplocal = lpa
	lpa5 = lpa .and. isensw(5)
        if(KANAL.eq.6) then
          lpa5 = .TRUE.
          lplocal = .TRUE.
        endif
c cleanup ADDLIST
        if(peaksadded.eq.0) then
          do i = 1, ADDLIST
            addedpeak(i) = 0.
            cyclecount(i) = 0
            addcount(i) = WAITCOUNT
          enddo
        else
          j = 0
          do i = 1, ADDLIST
            if(addedpeak(i).ge.minreg .and. addedpeak(i).le.maxreg) then
              j = j + 1
              addedpeak(j) = addedpeak(i)
              cyclecount(j) = cyclecount(i) - 1
              if(cyclecount(j).eq.0) addcount(j) = addcount(i) + WAITCOUNT
            endif
          enddo
          i = j + 1
          do while(i.le.ADDLIST)
            addedpeak(i) = 0.
            addcount(i) = WAITCOUNT 
            i = i + 1
          enddo
          peaksadded = j
        endif
        header = .TRUE.
	if(lplocal) write(KANAL, '('' GASRES: result of the residuen search:'')')
	foldwidth = max(1., wids) + 0.4
	witar = max(1., wids/3.)
	mw2 = max(1., 0.5*wids) + 0.5
	foldrange = 5*foldwidth
c  check if there is a poor fit at the end of the spectrum
	new=0
c	if(.not.(reglist.or.peaklist.or.onefitregion)) then
c	  l=irange
c	  do while(resi(l).ge.3.)
c	    l=l-1
c	    new=new+1
c	  end do
c	endif  
c  if this part is not too large, ignore it
	if(new.gt.0 .and. new.le.2*foldwidth) then
	  irange=l
	  maxreg=irange+minreg-1
	  gasres=.true.
	  if(lplocal) write(KANAL,FRESREG) minreg,maxreg
	end if
        repeat = 2
        do while(repeat.gt.0)
          if(repeat.eq.2) then
c  search for peaks with a folding procedure starts here
	    corrmin = THRESHOLD
	    if(highsens) corrmin = HTHRESHOLD
    	    peak = .false.
	    npeaks = 0
            i = foldwidth
            naddmax = ADDMAX
            if(lplocal) write(KANAL, '(''         peaks from folding the residue spectrum:'')')
	    do while(i.le.irange .and. npeaks.le.PEAKSFOUND)
c  fold with rectangular folding function
	      x = 0.
	      l = i - mw2 - 2*foldwidth
	      do j=1, foldrange
	        x = x + resi(max(1, min(l, irange)))
	        l = l + 1
	      end do
	      corr = 0.
	      l = i - mw2
	      do j = 1, foldwidth
	        corr = corr + resi(max(1, min(l, irange)))
	        l = l+1
	      end do
	      corr = corr - 0.2*x
c  check if a peak has been found and set up starting values if so
	      if(corr.gt.corrmin) then
	        if(.not.peak) then
	          peak = .true.
	          cormax = corr
                  corarea = corr
                  corpos = i*corr
                  if(resi(i).gt.0) then
                    diffmax = resi(i)/sqrt(weight(i))
                  else
                    diffmax = 0.
                  endif
                  diffarea = diffmax
                  sumerror = 1./weight(i)
	        else
	          cormax = max(cormax, corr)
                  corarea = corarea + corr
                  corpos = corpos + i*corr
                  if(resi(i).gt.0) then
                    x = resi(i)/sqrt(weight(i))
                    diffmax = max(diffmax, x)
                    diffarea = diffarea + x
                    sumerror = sumerror + 1./weight(i)
                  endif          
	        end if
	      else
	        if(peak) then
	          peak = .FALSE.
                  corwidth = AREACONSTANTE/WIDTHCONSTANTE*corarea/cormax
	          corpos = corpos/corarea
                  diffarea = log(diffarea/sqrt(sumerror))
	          j = corpos
	          if(corpos.gt.(-wids) .and. j.lt.irange .and. corwidth.ge.0.9*witar .and. 
		  1            diffarea.ge.-0.5) then
	            corpos = corpos + minreg - 2
	            if(lpa5) write(KANAL,FRESCOC) corpos, corwidth, witar, diffarea
    	            if(corwidth.ge.witar .and. diffarea.ge.0.) then
	              npeaks = npeaks + 1
	              if(npeaks.le.PEAKSFOUND) then
	                position(npeaks) = corpos
                        ampfound(npeaks) = diffmax
                        widthfound(npeaks) = corwidth
	                priority(npeaks) = diffarea
	                if(j.le.0) j = 1
                        if(lpa5) write(KANAL, '(x)')
	              else
	                if(lpa5) write(KANAL, '(12x,''too many peaks in residuum search'')')
                      endif
                    else
                      if(lpa5) write(KANAL, FRESREJ)
	            end if
	          end if
	        end if
	      end if
	      i = i + 1
	    end do
            npeaks = min(npeaks, PEAKSFOUND)
c  if no peaks have been found and widths are individual:
c  look directly at the residual
          else     !  repeat.eq.2
            naddmax = 1
            npeaks = 0
            if(lplocal) write(KANAL, '(''         peaks from looking at the residue spectrum:'')')
            i = 1
            peak = .false.
	    do while(i.le.irange .and. npeaks.le.PEAKSFOUND)
c  check if a peak has been found and set up starting values if so
	      if(resi(i).gt.resimin) then
	        if(.not.peak) then
	          peak = .true.
	          resmax = resi(i)
                  resarea = resi(i)
                  sumerror =  1./weight(i)
                  diffmax = resi(i)/sqrt(weight(i)) 
                  diffarea = diffmax
                  diffpos = i*diffmax
                else
                  resmax = max(resi(i), resmax)
 	          resarea = resarea + resi(i)
                  sumerror = sumerror + 1./weight(i)
                  x = resi(i)/sqrt(weight(i))
                  diffmax = max(diffmax, x)
                  diffarea = diffarea + x
                  diffpos = diffpos + i*x
	        end if
	      else
	        if(peak) then
	          peak = .false.
	          x = diffpos/diffarea
                  reswidth = AREACONSTANTE/WIDTHCONSTANTE*resarea/resmax
                  x = x + minreg - 1
                  diffarea = log(diffarea/sqrt(sumerror))
                  if(reswidth.gt.0.9*witar .and. diffarea.ge.-0.5) then
                    if(lpa5) write(KANAL,FRESCOC) x, reswidth, witar, diffarea
                    if(reswidth.gt.witar .and. diffarea.ge.0.) then
                      if(lpa5) write(KANAL, '(x)')
	              npeaks = npeaks + 1
	              if(npeaks.le.PEAKSFOUND) then
	                position(npeaks) = x
                        ampfound(npeaks) = diffmax
                        widthfound(npeaks) = reswidth*WIDTHCONSTANTE
	                priority(npeaks) = diffarea
	              else
	                if(lpa5) write(KANAL, '(12x,''too many peaks in residuum search'')')
	              end if
                    else
                      write(KANAL, FRESREJ)
                    endif
                  endif
	        end if
	      end if
	      i = i + 1
       	    enddo
          endif    ! repeat.eq.2
c  search for the strongest peak and add it to the list of peaks
          added = 0
	  do while(npeaks.gt.0 .and. added.lt.naddmax)
	    if(kpeaks.lt.PEAKTOT .and. npar + 3.lt.PARTOT) then
	      xm = priority(1)
	      n = 1
	      do j = 1,npeaks
	        if(xm.le.priority(j)) then
	          xm = priority(j)
	          diffmax = ampfound(j)
	          respos = position(j)
                  reswidth = widthfound(j)
	          n = j
	        end if
	      end do
c  the strongest peak has been separated, shift the following down
	      npeaks = npeaks -1
	      if(n.le.npeaks) then
	        do j = n, npeaks
	          ampfound(j) = ampfound(j+1)
	          priority(j) = priority(j+1)
	          position(j) = position(j+1)
                  widthfound(j) = widthfound(j+1)
	        end do
	      end if
c  the peak will be rejected if it coincids with an existing one
	      peak = .TRUE.
	      l = poscen
              i = 0
	      do while(peak .and. i.lt.kpeaks)
	        dx = 0.1*wids
                if(.not.widthall) dx = 0.
	        if(abs(respos-parc(l + i)).le.dx) then
	          peak = .FALSE.
	          if(lpa5) write(KANAL,FRESREJO) respos,parc(l + i)
	        end if
	        i = i + 1 
	      end do
c  check if the peak has been added previously
	      l = 1
              lsave = 0
	      do while(lsave.eq.0 .and. l.le.min(peaksadded, ADDLIST))
	        if(abs(respos - addedpeak(l)) .le. 0.01*wids) then
                  lsave = l
                  if(cyclecount(l).gt.0) then
	            peak = .false.
	            if(lpa5) write(KANAL, '(10x,''rejected:'',4x,''peak at ''
	1,f8.1,'' because it has been added previously'')') respos
                  endif
	        end if
	        l = l+1
	      end do
c  now add this peak to the others
	      if(peak .and. peaksadded.lt.ADDLIST) then
c write into dskspec.inf file if peak has found
                if(poscon .and. dskspe) then
                  open(unit=11, file=DSKSPEINF, status = 'old', access='append') 
                  write(11, '(f11.3,x,f10.0)') respos, diffmax
                  close(unit=11)
                else
                  xm = par(poswidth)
                  j = addpar(kpeaks, respos)
                  if(j.gt.0) then
                    dpar(j) = 1.d+00
                    deriv(j) = 5.*wids
                    par(j + posarea - 1) = sqrt(diffmax)
                    fixvorgabe(j + posarea - 1) = .FALSE.
                    if(widthall) then
                      parc(j + poscwidth - 1) = WIDTHCONSTANTE*poly(respos, ndw, aws)
                      if(ELEMENTS.gt.2) par(j + poswidth - 1) = xm
                    else
                      parc(j + poscwidth - 1) = reswidth
                    endif
                    added = added + 1
	            gasres = .TRUE.
                    npar = npar + ELEMENTS
c check if peak is already in he peak addlist
                    if(lsave.eq.0) then
	              if(peaksadded.lt.ADDLIST) then
                        peaksadded = peaksadded + 1
                      else
                        if(lplocal) write(KANAL, '(9x,''Warning: addedpeak-list is exhausted'')')
                      endif
                      l = peaksadded
                      addedpeak(l) = respos
                    else
                      l = lsave
                    endif
                    cyclecount(l) = addcount(l)
                    if(lplocal) write(KANAL,FRESADDP) respos, diffmax, reswidth
c                  write(*,'(20f9.3)') (parc(i), i = 1, kpeaks)
c                  write(*,'(20f9.0)') (par(i), i =kpeaks+1, 2*kpeaks)
                    respos = 0.
                  endif
	       end if
	      end if
	    else if(added.eq.0) then
	      if (lplocal) write(KANAL,FRESPAV) kpeaks,npar
	      npeaks=0
	      nerr=gaserr(nerr,2)
	    else
              npeaks = 0
            end if
	  end do
          repeat = repeat - 1
          if(widthall) repeat = repeat - 1
          if(added.gt.0) repeat = 0
          if (lpa5 .and. added.gt.0)       write(KANAL, '(9x,''peaks added:'',i3)') added
        enddo   ! repeat.gt.0
	if(lpa5 .and. peaksadded.gt.0) then
          write(KANAL, '(9x,''there are'',i3,'' entries in the peaks-added list:'')') peaksadded
          write(KANAL, '(''        ''$)')
          do j = 1, peaksadded
            write(KANAL, '(f12.3,''(''i3'')''$)') addedpeak(j), cyclecount(j)
            if(mod(j, 6).eq.0) write(KANAL, '(/''        ''$)')
          enddo
          write(KANAL, '(x)')
        endif
	if(lplocal .and. .not.gasres) write(KANAL,FRESNOPF)
        if(KANAL.eq.6) call wait()
 	return
	end
