/* int joinps(char *joinfile, char *filetojoin)

  $Id: joinps.c,v 1.3 2002/09/22 11:40:06 riess Exp $
  this routine joins the postscriptfile "filetojoin" at the end
  of the postscript file "joinfile" from the Xgraphik output.
  The postsrict files are assumed to have page numbering
  (i.e. %%Page: n n and %%Pages: m) statements. It is assumed
  that the page numbering of "joinfile" is in sequence. The
  pagenumber of "filetojoin" will be set to m+1

  if "filetojoin" is an empty string, "joinfile" will only be checked
  to be a legal file

  the return value of joinps will be
  0  if the routine was succesfull
  -1 if an error was encountered
 
  F. Riess, September 2002
*/

#define MAINx

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>

#define ERRMESS "--> joinps:"

int joinps(char*, char*);

#define STRLENGTH 132

int joinps(char *joinfile, char *filetojoin)

{
  int flag, numberofpages = 0, filecheck, pagestoadd = 0;
  long int trailer_position = 0L;
  char str[STRLENGTH];
  FILE *fpjoin, *fptojoin;

  filecheck = (strlen(filetojoin) == 0);
  if(!filecheck)
  {
    if((fptojoin = fopen(filetojoin, "r")) == NULL)
    {
      fprintf(stdout, "%s '%s' is not present\n", ERRMESS, filetojoin);
      fflush(stdout);
      return -1;
    }
/* Check if filetojoin is a usable postscript file:
   first a %%Trailer and then %%Pages              */
    flag = 0;
    while(fgets(str, STRLENGTH, fptojoin))
    {
      if(!flag) flag = !strncmp(str, "%%Trailer", 9);
      if(flag)
      {
        if(!strncmp(str, "%%Pages", 7))
        {
          sscanf(&str[8], "%d", &pagestoadd);
          break;
        }
      }
    }
    if(pagestoadd == 0)
    {
      fprintf(stdout, "%s '%s' is not a usable postscript file\n", ERRMESS, filetojoin);
      fclose(fptojoin);
      return -1;
    }
    fseek(fptojoin, 0L, SEEK_SET);
  }
  else fptojoin = NULL;
  if(!strlen(joinfile))
  {
    fprintf(stderr, "%s empty file name for target file\n", ERRMESS);
    return -1;
  }
  if((fpjoin = fopen(joinfile, "r+")) == NULL)
/* the join file does not exist, a copy does the job */
  {
    if(filecheck) return 0;
    sprintf(str, "cp %s %s", filetojoin, joinfile);
    system(str);
    return 0;
  } 
  if(fseek(fpjoin, -100L, SEEK_END))
  {
    fprintf(stdout, "%s '%s' is an empty file\n", ERRMESS, joinfile);
    fclose(fpjoin);
    fclose(fptojoin);
    fflush(stdout);
    return -1;
  }
  flag = 0;
  while(fgets(str, STRLENGTH, fpjoin))
  {
    if(!flag) flag = !strncmp(str, "%%Trailer", 9);
    if(!flag) trailer_position = ftell(fpjoin);
    else
    {
      if(!strncmp(str, "%%Pages", 7))
      {
        sscanf(&str[8], "%d", &numberofpages);
        break;
      }
    }
  }
  if(numberofpages == 0)
  {
    fprintf(stdout, "%s '%s' is not a usable postscript file\n", ERRMESS, joinfile);
    fclose(fpjoin);
    if(fptojoin != NULL) fclose(fptojoin);
    fflush(stdout);
    return -1;
  }
  else if(filecheck)
  {
    fclose(fpjoin);
    return 0;
  }
  fseek(fpjoin, trailer_position, SEEK_SET);
  while(fgets(str, STRLENGTH, fptojoin))
  {
    if(!strncmp(str, "%%Page:", 7))
    {
      ++numberofpages;
      sprintf(str, "%%%%Page: %d %d\n", numberofpages, numberofpages);
      --pagestoadd;
    }
    if(!strncmp(str, "%%Pages", 7))
    {
       sprintf(str, "%%%%Pages %d\n", numberofpages);
    }
    fprintf(fpjoin, "%s", str);
  }
  fclose(fpjoin);
  fclose(fptojoin);
  return 0;
}


/* Fortran Interface */
int joinps_(char *f1, char *f2, int fl1, int fl2)
{
  char cfile1[132] = " ", cfile2[132] = " ";
  int i, flag;

  for(i = fl1-1, flag = 0; i >= 0; --i)
  { 
    if(!flag)
    {
      if(f1[i] == ' ')  cfile1[i] = '\0';
      else flag = 1;
    }
    if(flag) cfile1[i] = f1[i];
  }
  for(i = fl2-1, flag = 0; i >= 0; --i)
  { 
    if(!flag)
    {
      if(f2[i] == ' ')  cfile2[i] = '\0';
      else flag = 1;
    }
    if(flag) cfile2[i] = f2[i];
  }
  return (joinps(cfile1, cfile2));
}

#ifdef MAIN

#define JOINFILE "tmp.bak"
#define FILETOJOIN "../testsuite/grx.ps"

int main(void)
{

  if(!joinps(JOINFILE, ""))
    printf("%d\n", joinps(JOINFILE, FILETOJOIN));
  return 0;
}

#endif
