/* $Id: readascii.c,v 1.3 2003/08/23 22:24:51 friedrich Exp $
   This routine reads spectra in the ascii format
   with one or several numbers per line

   channel numbers are supposed to start with channel 0
   but channel 0 is ignored.

   subspectra are seperated by header lines (lines with nonnumerical
   contents).
   subspectrum count starts with 1.

  int readascii(
     char *filename:  Filename of Spectrum. If Filename ends with .Z, it
                      will be assumed, that the file is compressed. 
                      An uncompressed file is generated under /usr/tmp
                      and used for reading. This file will be deleted
                      with a subsequent calls with an other filename. 
    int subspectrum:  Number of the subspectrum.
    double *spectrum:  Array of the spectrum. Must have length of at least
                      ende - begin + 1
    int begin:        begin of the Spectrum
    int ende:         end of the spectrum
    int mode:         if unequal to 0: print text lines of the spectrum
    )
  return value:
    0 if the file is not found or if there was an error during reading
   <0 negativ value of last subspectrum if subspectrum does not exist
   >0 ende or last channel in the spectrum if ende is greater than 
      the last channel
  
   F. Riess, July 2000
*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>

#define ERRMESS "--> readascii:"
#define BUFSIZE 4096

int readascii(char *, int, double *, int, int, int);
int istext(char *);
int getdouble(char *string, double *value, int *ioerror);

int readascii(char *filename, int subspectrum, double *spectrum, int begin, int ende, int header)
{
  int i, j, file_end = 0, dataflag;
  int buffersize = 0, ioerror = 0;
  double value;
  static char filetmp[130] = "";
  static char fileold[130] = " ", str[131];
  static int compressed = 0, filesub = -1, spectrumsize;
  static FILE *fp = NULL;
  static double *data = NULL;
    
/* check if file has already been accessed */
  
  if(strcmp(fileold, filename))
  {
    if(fp)
    {
      fclose(fp);  fp = NULL;
      if(compressed) (void) unlink(filetmp);
      compressed = 0;
    }     
    j = strlen(filename) - 1;
    if(!strcmp(&filename[j-1], ".Z")) j = 0;
    else if(!strcmp(&filename[j-2], ".gz")) j = -1;
    if(j > 0)
      strcpy(filetmp, filename);
    else
    { 
      strcpy(filetmp, "/tmp/gspasciiXXXXXX");
      j = mkstemp(filetmp);
      if(j < 0) return 0;
      close(j);
      compressed = 1;
      if(access(filename, 00) == -1) return 0;
      sprintf(str, "zcat %s > %s\n", filename, filetmp);
      system(str);
    }
    if((fp = fopen(filetmp, "r")) == (FILE *) 0)  return 0;
    strcpy(fileold, filename);
    filesub = 0;
    file_end = 0;
    *str = '\0';
  }
/* the file might be open, check for the subspectrum */
/* Note: subspectra start with 1 */
  if(filesub > subspectrum || fp == (FILE *) 0)
  {
    if(fp) { fclose(fp); fp = NULL; }
    if((fp = fopen(filetmp, "r")) == (FILE *) 0)  return 0;
    file_end = 0;
    filesub = 0;
    spectrumsize = 0;
    *str = '\0';
  }
  if(!(spectrumsize > 0 && filesub == subspectrum))
  {
    spectrumsize = 0;
    buffersize = 0;
    dataflag = 1;
    if(data) free(data);
    data = NULL;
/* read spectrum header */
    for(;;)
    {    
      if(!*str)
      {
        if(fgets(str, 130, fp) == (char *) 0) file_end = 1;
      }
      if(file_end) break;
      if(istext(str))
      {
        if(data) break;
        if(dataflag)
        {
          if(filesub == subspectrum) break;
          dataflag = 0;
          ++filesub;
        }
        if(header && filesub == subspectrum) fprintf(stdout, "%s", str);
      }
      else
/* get data and put spectrum into an array, if correct subspectrum  */
      {
        dataflag = 1;
        if(subspectrum == filesub)
	{
/* replace d-format by e-format */
          for(j = 0; str[j]; ++j)
            if(str[j] == 'd' || str[j] == 'D')  str[j] = 'e';
/* get numbers */
          while(getdouble(str, &value, &ioerror))
          {
            if(ioerror) return 0;
            while(spectrumsize >= buffersize)
            { 
              j = buffersize;
              buffersize += BUFSIZE;
              if((data = (double *) realloc(data, buffersize * sizeof(double))) == NULL)
              {
                fprintf(stderr,"\07-> can not allocate buffer for reading data file\n");
                return 0;
              }
              for(; j < buffersize; ++j) data[j] = 0.;
            }
            data[spectrumsize] = value;
            ++spectrumsize;
          }
	}
      }
      *str = '\0';
    }
    if(filesub != subspectrum)
    {
      fclose(fp);
      fp = NULL;
      return (-filesub);
    }
  }
/* Spectrum is in buffer, transfer it to extern buffer */
  if(ende >= spectrumsize) ende = spectrumsize;
  j = begin;
  for(i = 0; i <= (ende - begin); ++i, ++j)
  {
    spectrum[i] = data[j];
    /* printf(" %d %d %.0f\n", i, j, spectrum[i]); */
  }
  return ende;
}  


/* Fortran interface */
int readascii_(char *fi, int *su, double *sp, int *be, int *en, int *header, int fl)
{
  char file[130];
  int i;

  for(i = 0; i < fl; ++i)
  {
    file[i] = fi[i];
    if(fi[i] == ' ') break;
  }
  file[i] = '\0';
  i = readascii(file, *su, sp, *be, *en, *header);
  return i;
}
