	integer function readmatrix(filename, schnitt, spektrum, anfang, ende)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c $Id: readmatrix.f,v 2.3 2000/05/19 14:17:47 riess Exp $
c  this routine reads the spectra out of a matrix generated by the
c  direct access Fortran mode with a record size of 8192 Bytes, 
c  2 Byte words and 4096 Records
c
c  filename: string containing the name of the file. 
c            The file is assumed to containe no header  
c  schnitt:  integer. Defines the number of the Record in the file.
c	     The count starts with 0.
c  spectrum: array of real*8. The size of the array should be as large to
c            hold anfang-ende+1 elements
c  anfang:   integer. First channel to be read. This channel is mapped
c            into the arrayelement #1 of spectrum. Spectra start with
c            channel 0
c  ende:     integer. Last channel to be read. If the spectrum is shorter
c            than ende, only up to the  end of the spektrum will be read.
c            The contents of the rest of spectrum is nonsense.
c
c  return values:
c            0 if the file is not found or there was an error
c           >0 either the value of ende or the last channel in the
c              spectrum whichever is smaller. 
c           <0 Negativ value of the first nonexistent subspectrum
c              if an attempt was made to read a non existent subspektrum.
c
c  F. Riess, July 1993            
c----------------------------------------------------------------------
      implicit none
      character*(*) filename
      integer schnitt, anfang, ende
      real*8 spektrum(*)

      integer buffer(4096)
c      integer*2 buffer(4096)
      character oldfile*120
      integer i, j, ios, iot, current
      logical opened
      data current /-100/

c if there is a change in filename, close old file and open new one
      if(oldfile.ne.filename .or. current.ne.schnitt) then
        readmatrix = 0
	inquire (unit = 1, opened = opened)
	if(opened) then
          close(unit = 1)
	  oldfile = ' '
	endif
        open(UNIT = 1, FILE = filename, STATUS = 'old', ACCESS = 'DIRECT', RECL = 2048, IOSTAT = ios)
        if(ios.ne.0) return
        j = current + 1
        if(schnitt.lt.0 .or. schnitt.ge.4096) then
	  ios = 1
          readmatrix = -4096
	else
	  j = schnitt + 1
          read(1, REC=j, IOSTAT = ios) buffer
	endif
	close(unit = 1)
	if(ios.ne.0) return
        oldfile = filename
        current = schnitt
      endif
c  copy buffer into spectrum
      ios = max(anfang, 0)
      iot = min(ende, 4095)
      j = 1
      do i = ios, iot
        spektrum(j) = buffer(i + 1)
	j = j + 1
      enddo
      readmatrix = iot
      return
      end







