/*  package for TEKTRONIX GRAFICS
    $Id: Tekgraflibf.c,v 1.3 2000/05/19 12:10:32 riess Exp $
    FORTRAN routinen

    Die Routinen
      int disinit(int), void disclose(void), void diserase(void)
      void disset(x, y), void dispoint(x, y), void disdraw(x, y)
      void diswrite(string, size),  void dissymbol(x, y, symbol, size)
      void disalpha(), void dismode(mode), discolor(color)
    haben als Koordinaten doppeltgenaue Gleitkommavariablen
    und setzen einen Wertebereich von 0 < x ,y < 1. voraus.

    F. Riess, Oktober 1990
*/
#include "Tekgraflib0.h"

int disinit_(int *save)
{ 
  if(*save)  return openpf("gasplot.bak");
  else      return openpl();
}

/* modes is ignored in TEK graphics */
void disclose_(int *mode)
{
  closepl(0);
}

void diserase_(void)
{
  erase();
}


void disalpha_(void)
{
  label("", 1);
}

void disflush_(void)
{
  flushpl();
}


void dismode_(char *mode, int length)
{
  linemod(mode);
}

void disset_(double *x, double *y)
{
  move((int) (8192. * *x), (int) (6144. * *y));
}

void dispoint_(double *x, double *y)
{
  point((int) (8192. * *x), (int) (6144. * *y));
}

void disdraw_(double *x, double *y)
{ 
  cont((int) (8192. * *x), (int) (6144. * *y));
}

void diswrite_(char *string, int *size, int string_length)
{
  int i, j;
  char str[132];
  j = string_length > 130 ? 130 : string_length;
  for(i = 0; i < j; ++i) str[i] = string[i];
  str[string_length] = '\0';
  label(str, *size);
}
      
void discolor_(int color)
{
  /* ignored in Tek mode */
}

/* circle draws a square instet of a circle */
void discircle_(double *x, double *y, double *r)
{
  int ix, iy, ir;
  ix = 8192 * *x;
  iy = 6144 * *y;
  ir = 8192 * *r;
  move(ix - ir, iy - ir);
  cont(ix - ir, iy + ir);
  cont(ix + ir, iy + ir);
  cont(ix + ir, iy - ir);
  cont(ix - ir, iy - ir);
}
