	subroutine gasslp
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasslp.f,v 3.2 2002/12/06 23:11:15 riess Exp $
c  routine makes the output for gassea and gaslst
c  03.03.00  variable output format
c  25.02.00  accepting areas smaller than 1
c  03.09.78  F. Riess
c------------------------------------------------------------------------------
	implicit none
	include 'gasctr.icl'
	include 'gaspea.icl'

	integer NUMBERCOL
	parameter (NUMBERCOL = 3)
        real*8 LOWERLIMIT
        parameter (LOWERLIMIT = 10.)   ! smaller areas are printed in e-format

        integer i, j, jj, jjj

	if(maxlin.eq.0) then
	  write(3,'(4x,'' *** no lines found'')')
	else
	  write(3,'(3(4x,''#'',3x,''channel'',5x,''area'',6x,''FWHM'')//)')
          jjj = (maxlin - 1)/NUMBERCOL + 1
          do jj = 1, jjj
            do j = 1, NUMBERCOL
              i = jj + (j - 1)*jjj
              if(i.le.maxlin) then
                if(area(i).lt.1.e+7 .and. area(i).ge.LOWERLIMIT) then
                  write(3, '(i5,f10.1,f11.1,f8.1$)') i, peak(i), area(i), width(i)
                else
                  write(3, '(i5,f10.1,e11.3,f8.1$)') i, peak(i), area(i), width(i)
                endif
              endif
            enddo
            write(3, '(x)')
          enddo
        endif
	return
        end
