	real*8 function gaschi(flambda, silent)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gaschi.f,v 4.12 2005/02/10 19:07:20 friedrich Exp friedrich $
c  this non linear fitting routine follows the routine curfit
c  written by phil bevington, but the matrix is a onedimensional
c  array making use of its symmetry
c  gaschi returns the new chisquare if everything was okay
c    the return value will be negativ, if the matrixinversion failed
c    the absolute value will be the culprit parameter of -1000 if
c    none has been found 
c  last change 29.01.93
c------------------------------------------------------------------
	implicit none

        integer KANAL
        parameter (KANAL = 3)
        integer TESTKANAL
        parameter (TESTKANAL = 0)  ! set to 0 (no output) 3 (into file FILEHIST)
        real*8 FLAMBDAMIN
	parameter (FLAMBDAMIN = 1.d-10)
        real*8 FLAMBDAMAX
	parameter (FLAMBDAMAX = 1.d+16)
        real*8 EPSILON
	parameter (EPSILON = 1.d-10)
        real*8 TINY
	parameter (TINY = 1.d-100)
        real*8 PRECISIONLIMIT
        parameter (PRECISIONLIMIT = 1.d-4)
        real*8 RMS0
        parameter (RMS0 = 1.e-4)
        real*8 OFFMAX, OFFLIM
        parameter (OFFMAX = 1.d-02)
        parameter (OFFLIM = 1.d-03)
        real*8 ROUNDING
        parameter (ROUNDING = 1.d+00 + 1.d-15)
        real*8 TAILMAX
        parameter (TAILMAX = 10.)

	real*8 flambda
        logical silent
	include 'gasctr.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
	include 'gaseic.icl'

	logical isensw
	logical ncs(PARTOT), nct(PARTOT), lpas, lpas4, lpas16, testout
	integer i, ier, j, ja, jc, jw, kk, l, lmax, m, n, nfree, nparc
	real*8 gasfun, parlim, invcheck, solve, voidfailure, parminus1, poly
        integer listpar(PARTOT), jcall, jcend, jwall, jwend
        integer indexm
        logical restricted
	real*8 chis, chisqr, fy, wf, x, maxdev
        real*8 pars(PARTOT)
	real*8 array((PARTOT*(PARTOT+1))/2), ainverse((PARTOT*(PARTOT+1))/2)
	real*8 beta(PARTOT)
        lmax(j)=(j*(j+1))/2

        lpas = lpa .and. .not.silent
        lpas4 = isensw(4) .and. lpas
        lpas16 = isensw(16) .and. lpas
        lpas = lpas4 .or. lpas16
        testout = TESTKANAL.gt.0 .and. flambda.eq.0.
        testout = TESTKANAL.gt.0 .and. .not.silent
        testout = TESTKANAL.gt.0
	gaschi = 0.d+00
c save parameters and parameter control variables
	do j = 1,PARTOT
          if(j.le.npar) then
	    ncs(j) = fixed(j)
          else
            ncs(j) = .TRUE.
          endif
          nct(j) = .TRUE.
	  pars(j) = par(j)
	  listpar(j) = 0
          errpar(j) = 0
	  beta(j) = 0.d+00
	enddo
c setup pointer for common  variations of centroid or width
        jcend = poscen + kpeaks - 1
        jcall = -1
        if(posall) jcall = 0
        jwend = poswidth
        if(poswidth.eq.poscwidth) jwend = poswidth + kpeaks - 1
        jwall = -1
        if(widthall) jwall = 0
	l = 0
        j = 1
        do while(j.le.npar)
	  nct(j) = fixed(j)
          if(.not.fixed(j)) then
            l = l + 1
            listpar(l) = j
	  endif
          if(jcall.eq.0 .and. j.ge.poscen .and. j.le.jcend) then
            jcall = j
            j = jcend
          endif
          if(jwall.eq.0 .and. j.ge.poswidth .and. j.le.jwend) then
            jwall = j
            j = jwend
          endif
          j = j + 1
	enddo
c calculate matrix and array of linear equations
	l = lmax(npar)
 	do j = 1,l
	  varcovar(j) = 0.d+00
	enddo
	chisqr = 0.d+00
	x = minreg
	do i = 1,irange
	  fy = gasfun(x,npar)
	  yfa(i) = fy
	  fy = ya(i) - fy
	  chisqr = chisqr + fy*fy*weight(i)
	  jc = 0
	  l = 0
	  do j = 1,npar
	    if(.not.nct(j)) then
	      jc = jc + 1
	      wf = deriv(j)*weight(i)
	      beta(jc) = beta(jc) + wf*fy
	      do kk = 1,j
	        if(.not.nct(kk)) then
	          l = l + 1
	          varcovar(l) = varcovar(l) + wf*deriv(kk)
	        endif
	      enddo
	    endif
	  enddo
	  x = x + 1.d+00
	enddo  !  i = 1,irange
	nparc = jc
        if(lpas16) write(KANAL, '('' GASCHI: starting chisquare:'',16x,g18.10,'' ('',e8.1,'')'')') 
     $        chisqr, flambda
        if(lpas4) then
          write(KANAL,'(9x''parameter matching (only the last 30)'')')
          write(KANAL,'(9x,30i3)') (i, i = max(1, nparc - 29), nparc)
          write(KANAL,'(9x,30i3)') (listpar(i), i = max(1, nparc - 29), nparc)
        endif
        gaschi = chisqr
c end of calculation of the matrix 
c no parameter to be varied: return right away
	if(nparc.le.0) then
	  return
	endif 
c check for the degree of freedom, return if 0 or negativ
	nfree = irange - nparc
	if(nfree.le.0) then
	  return
	endif
	chisqr = max(chisqr, EPSILON)
c calculate new parameters, do not allow chisqr to increase
	if(testout) then
          write(TESTKANAL,'(A,13(e12.4))') 'oldp:', (par(i),i = 1,min(10,npar))
          write(TESTKANAL,'(a,13(e12.4))') 'beta:', (beta(i), i = 1,nparc)
          write(TESTKANAL,'(''Variance-covariance matrix'')')
        endif
	chis = 1.1d+00 * chisqr
        chisqr = chisqr*ROUNDING
	do while(chisqr.lt.chis)
	  l = 0
	  do j = 1,nparc
	    do kk = 1,j
	      l = l + 1
	      array(l)  =  varcovar(l)
	      ainverse(l) = array(l)
              if(testout .and. kk.lt.j) write(TESTKANAL,'(e12.4$)') array(l) 
	    enddo
	    array(l) = varcovar(l) + flambda
            ainverse(l) = array(l)
            if(testout) write(TESTKANAL, '(e12.4)') array(l)
	  enddo 
c invert matrix note: ier = 0 does not mean that the inverse is okay
	  ier = -1
	  call dsinv(ainverse, nparc, EPSILON, ier)
	  if(lpas16 .and. ier.lt.0) then
            write(KANAL,'(9x,''--> inversion of the matrix failed ('',d8.1'')'')') flambda
          endif
	  if(flambda.eq.0.d+00) then
            chis = 0.d+00
          else
	    if(ier.ge.0.) then 
c calculate change in the parameters
              do j = 1, nparc
                deriv(j) = beta(j)
              enddo
              maxdev = solve(array, ainverse, nparc, deriv, dpar)
c accept solution if maxdev is small enough
              if(lpas16) write(KANAL, '(''       Precision of new parameters:'',e13.3$)') maxdev
              if(maxdev.gt.PRECISIONLIMIT) then
                if(lpas16) write(KANAL, '('' --> parameters not accepted'')')
                chis = 1.1d+00*chisqr
              else
                do jc = 1, nparc
                  j = listpar(jc)
                  par(j) = par(j) + dpar(jc)
                  if(j.eq.jcall) then
                    do while(j.lt.jcend)
                      j = j + 1
                      if(.not.fixed(j)) par(j) = par(jcall)
                    enddo
                    j = j - 1
                  endif
                  if(j.eq.jwall) then
                    do while(j.lt.jwend)
                      j = j + 1
                      if(.not.fixed(j)) par(j) = par(jwall)
                    enddo
                  endif
                enddo  
c control output and check of the new parameters
                restricted = .FALSE.
                ja = posarea
                jc = poscen
                jw = poswidth
	        do i  = 1, kpeaks
                  restricted = restricted .or. abs(par(jc)).gt.parlim(1.d+0)
	          par(jc) = parlim(par(jc))
	          par(ja) = max(abs(par(ja)), TINY)
                  restricted = restricted .or. abs(par(jw)).gt.parlim(1.d+0)
	          par(jw) = parlim(par(jw)) 
                  ja = ja + 1
                  jc = jc + 1
                  if(ELEMENTS.gt.2) jw = jw + 1
	        enddo 
c restrict tail parameters
	        if(tail)then
	          if(taill) then
                    restricted = restricted .or. abs(par(postlw)).gt.parlim(1.d+0)
	            par(postlw) = parlim(par(postlw))
	            par(postla) = max(abs(par(postla)), TINY)
                    x = poly(parc(poscen), max(1,nampleft),ampleft)
                    if(x*par(postla)**2.gt.TAILMAX) par(postla) = sqrt(TAILMAX/x)
	          endif
	          if(tailb) then
                    restricted = restricted .or. abs(par(postbw)).gt.parlim(1.d+0)
	            par(postbw) = parlim(par(postbw))
	            par(postba) = max(abs(par(postba)), TINY)
                    x = poly(parc(poscen), max(1,nampback),ampback)
                    if(x*par(postba)**2.gt.TAILMAX) par(postba) = sqrt(TAILMAX/x)
	          endif
	          if(tailr) then
                    restricted = restricted .or. abs(par(postrw)).gt.parlim(1.d+0)
	            par(postrw) = parlim(par(postrw))
	            par(postra) = max(abs(par(postra)), TINY)
                    x = poly(parc(poscen), max(1,nampright),ampright)
                    if(x*par(postra)**2.gt.TAILMAX) par(postra) = sqrt(TAILMAX/x)
	          endif
                  if(lstep) par(possta) = max(abs(par(possta)), TINY)
	        endif 
c check if the peak positions are varied independently
	        if(posall) then
	          do j = 1,kpeaks
	            par(j) = par(1)
	          enddo
	        endif 
                if(testout) write(TESTKANAL,'(/A,13(e12.4))') 'newp:', (par(i),i = 1,min(10,npar))
c control output
c calculate new chisqr
                do i = 1, npar
                  ncs(i) = fixed(i)
                  fixed(i) = .TRUE.
                enddo
                x = minreg
	        chis = 0.d+00
	        do i = 1,irange
	          yfa(i) = gasfun(x,npar)
	          fy = ya(i) - yfa(i)
	          chis = chis +  fy*fy*weight(i)
	          x = x + 1.d+00
	        enddo
	        chis = max(chis, EPSILON)
                do i = 1, npar
                  fixed(i) = ncs(i)
                enddo 
              endif    !  maxdev.gt.PRECISIONLIMIT
	    else  ! ier.ge.0
	      chis = 1.1*chisqr
	    endif   !  ier.ge.0              
c  if the fit did not improve, try again
	    if(chis.gt.chisqr) then
              if(lpas16) write(KANAL, '('' --> fit does not improve'')')
	      do i = 1,npar
	        par(i) = pars(i)
                fixed(i) = ncs(i)
	      enddo
	      flambda = 10.d+00*flambda
	      if(flambda.ge.FLAMBDAMAX) then
                chis = chisqr
	        gaschi = chis
                flambda = FLAMBDAMAX
	      endif
c  the fit did improve, decrease flambda
	    else
	      flambda = 0.1d+00*flambda
	      if(flambda.lt.FLAMBDAMIN) flambda = FLAMBDAMIN
	      gaschi = chis
              if(lpas16) then
                write(KANAL, '('', new parameters'')')
                call gasfou(par,ncs,-1)
              endif 
	    endif    ! chis.gt.chisqr
          endif   !  flambda.eq.0 else
	enddo  ! while(chisqr.lt.chis)
c  if flambda = 0. the inversion has only to be done to get the
c  variance-covariance matrix
        if(flambda.eq.0.d+00 .and. .not.silent) then
c check the inverse matrix, maxdev is the maximum size of the
c offdiagonal elements
          if(lpas4) write(KANAL,'('' GASCHI: result of matrix inversion, ier ='',i3$)') ier
          if(ier.eq.-1) then
            maxdev = OFFMAX + 1.d+00
            wf = OFFLIM + 1.d+00
            if(lpas4) write(KANAL,'('' --> inversion failed'')')
          else
            maxdev = invcheck(varcovar, ainverse, nparc, wf, x)
            if(lpas4) write(KANAL,'(/9x,''unity matrix: max offdiag''e14.4'', <offdiag> ''e14.4,
     $     '', <diag> =''f12.10)') maxdev, wf, x
          endif
          if(maxdev.gt.OFFMAX .and. wf.gt.OFFLIM) then
c  matrix has low quality try to rectify
            if(lpas4) write(KANAL, '(9x''adding tiny value to one off the diagonal elements''$)')
            maxdev = voidfailure(varcovar, ainverse, nparc, wf, x, j)
            if(maxdev.gt.OFFMAX .and. wf.gt.OFFLIM) then
              if(lpas4) write(KANAL, '('' --> failed''/9x''eliminating parameters from the matrix'')')
c failure to correct a diagonal element
c  try to find out the culprit parameter:
              n = nparc
              do i = 1, lmax(n)
                array(i) = varcovar(i)
              enddo
              jc = 0
              do while(maxdev.gt.OFFMAX)
                maxdev = parminus1(array, ainverse, n, OFFMAX, wf, x, kk)
                if(kk.gt.0) then
                  jc = jc + 1
                  j = listpar(kk)
                  errpar(jc) = j
                  nct(j) = .TRUE.
                  if(lpas4) call gaschim2(j, kpeaks)
                  do while(kk.lt.n)
                    listpar(kk) = listpar(kk + 1)
                    kk = kk + 1
                  enddo
                  listpar(kk) = 0
                  if(maxdev.gt.OFFMAX) then
                    if(lpas4) write(KANAL, '('' --> failed'')')
                    n = n - 1
                    do i = 1, lmax(n)
                      array(i) = ainverse(i)
                    enddo
                  else
                    if(lpas4) write(KANAL,'(x)')
                  endif
                else
                  if(lpas4) write(KANAL,'(9x,''--> all attempts failed, all values without error'')')
                  ier = -1
                  maxdev = OFFMAX
                endif   ! kk.gt.0
              enddo     ! maxdev.gt.OFFMAX
              if(lpas4) write(KANAL,'(9x,i3,'' parameters out of''i3,'' ignored''$)') jc, nparc
              if(wf.gt.OFFLIM) wf = OFFLIM
            endif       ! maxdev.gt.OFFMAX .and. wf.gt.OFFLIM
            if(lpas4) write(KANAL,'(/9x,''unity matrix: max offdiag''e14.4'', <offdiag> ''e14.4,
     $     '', <diag> =''f12.10)') maxdev, wf, x
	  endif  !        maxdev.gt.OFFMAX .and. wf.gt.OFFLIM
          ier = 0
	endif  !  flambda.eq.0. .and. .not.silent
c  end of calculation of new parameter
c  get variance covariance matrix
	if(ier.ge.0) then
	  m = 0
	  n = 0
	  do j = 1,npar
	    do l = 1,j
	      m = m + 1
	      varcovar(m) = 0.d+00
	      if((.not.nct(j)) .and. (.not.nct(l))) then
	        n = n + 1
                varcovar(m) = ainverse(n)
	      endif
	    enddo
	    if(.not.nct(j)) then
	      dpar(j) = sqrt(abs(varcovar(m)))
	    else
	      dpar(j) = 0.d+00
	    endif
	  enddo
c copy the rows of the position parameter into the other positions if common varied
          if(jcall.gt.0) then
            j = jcall + 1
            do while(j.le.jcend)
              if(.not.fixed(j)) then
                do i = 1, npar
                  varcovar(indexm(i,j)) = varcovar(indexm(i,jcall))
                enddo
                dpar(j) = dpar(jcall)
              endif
              j = j + 1
            enddo
          endif          
c copy the rows of the width parameter into the other width if common varied
          if(jwall.gt.0) then
            j = jwall + 1
            do while(j.le.jwend)
              if(.not.fixed(j)) then
                do i = 1, npar
                  varcovar(indexm(i,j)) = varcovar(indexm(i,jwall))
                enddo
                dpar(j) = dpar(jwall)
              endif
              j = j + 1
            enddo
          endif          
	endif
	return
	end


	subroutine gaschim2(i, k)
c  gives  message if matrix is non divergent on a certain parameter
	implicit none
	integer i, k
        integer KANAL
        parameter (KANAL = 3)
	character message*40
	integer ltext
	call gaschim(i, k, message)
	write(KANAL, '(13x,''matrix inversion without parameter #''i3'' ('',a'')''$)') i, 
     $      message(:ltext(message))
	end


	subroutine gaschim(i, k, message)
c  extrahiert von i und k = kpeaks den aktuellen parameter
	implicit none
        include 'gaspar.icl'
	integer i, k
	character *(*) message

        if(i.ge.poscen .and. i.lt.poscen+k) then
          write(message, '(''position of peak '',i2)') i - poscen + 1
	else if(i.ge.posarea .and. i.lt.posarea+k) then
          write(message, '(''area of peak '',i2)') i - posarea + 1
        else if(i.ge.poswidth .and. i.lt.poswidth+k) then
	  write(message, '(''width of peak '',i2)') i - poswidth + 1
	else if(i.ge.pospol .and. i.le.pospole) then
	  write(message, '(''background coefficient a('',i1,'')'')') i - pospol
	else if(i.eq.postla) then
	  write(message, '(''left tail amplitude'')')
	else if(i.eq.postba) then
	  write(message, '(''background tail amplitude'')')
	else if(i.eq.postra) then
	  write(message, '(''right tail amplitude'')')
	else if(i.eq.possta) then
	  write(message, '(''step amplitude'')')
	else if(i.eq.postlw) then
	  write(message, '(''left tail decay constant'')')
	else if(i.eq.postbw) then
	  write(message, '(''background tail decay constant'')')
	else if(i.eq.postrw) then
	  write(message, '(''right tail decay constant'')')
	else
          write(message, '(''-->unknown parameter'')')
	endif
	end


        subroutine outmatrix(np, matrix)
        implicit none

        integer np
        real*8 matrix(*)

        integer KANAL
        parameter (KANAL = 3)

        integer i, i1, i2, j
        integer indexm
        
        i1 = 1
        do while(i1.lt.np)
          i2 = min(i1 + 9, np)
          write(KANAL, '(/10x$)')
          do i = i1, i2
            write(KANAL, '(i12$)') i
          enddo
          do j = i1, np
            write(KANAL, '(/i6$)') j
            do i = i1, min(j, i2)
              write(KANAL, '(e12.4$)') matrix(indexm(i,j))
            enddo
          enddo
          i1 = i2 + 1
          write(KANAL, '(x)')
        enddo
        end
