	logical function gasfck (chisqr)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasfck.f,v 4.13 2005/03/02 16:16:01 friedrich Exp friedrich $
c
c  checks if there are overlapping or weak peaks
c  the peakpositions might be unsorted in this routine
c  they are sorted at the end
c  chisqr gives information about the fit:
c	chisqr >= 0: errors from gasval are valid
c	chisqr < 0 : errors are  meaningless
c       if -chisqr le npar the error in the inversion can be corrected
c  on return, gasfck = .true. if peaks have been eliminated,
c                      .false. otherwise
c  17.09.79  F. Riess
c  18.09.86  vax version
c  07.09.01  redesign
c------------------------------------------------------------------
	implicit none
	real*8 chisqr

        integer KANAL
        parameter (KANAL = 3)
c  number of lines which can be removed in one step
c  should be smaller than number of lines which can be added by gasres
        integer REMOVEMAX
        parameter (REMOVEMAX = 1)
c  gives the limit for the relativ change of chisquare if a 
c  peak amplitude is set to 
        real*8  DCHIMAX
        parameter (DCHIMAX = 0.01)
c  areas must be larger than AMPFACTOR*error of area
        real*8 AMPFACTOR
        parameter (AMPFACTOR = 0.5)
c  peak distances must be larger than POSFACTOR*sqrt(sum of centroid errors squared)
        real*8 POSFACTOR
        parameter (POSFACTOR = 1.0)
c  area errors are set to TINY * average peak area
        real*8 TINY
        parameter (TINY = 1.d-6)
c  centroid errors are set to WIDTHFACTOR * fwhm
c  peakidth are regarded as equal if their difference is < WIDTHFAKTOR * error
        real*8 WIDTHFACTOR, WIDTHFAKTOR
        parameter (WIDTHFACTOR = 1.0)
        parameter (WIDTHFAKTOR = 2.0)
c
        character*(*) FFCKREJ, FFCKPAT
        parameter (FFCKPAT = '(10x,''peak at ''f9.1$)')
	parameter (FFCKREJ='(15x,''rejected peak at '',f9.1$)')
        character*(*) FFCKREL
        parameter (FFCKREL='('' rel. change in chi: ''g10.2)') 
	character*(*) FFCKOUTR
	parameter (FFCKOUTR='('' because it is outside of fitregion'')')
	character*(*) FFCKREM
	parameter (FFCKREM='('' removed'')')
	character*(*) FFCKOVER
	parameter (FFCKOVER='('' +/-'',f5.1,'' overlaps with '',f9.1,'' +/-'',f5.1$)')

	include 'gasctr.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
	include 'gaseic.icl'

        logical da, deletepar, lplocal, lpa17, isensw
        character message*30
        integer ltext
	integer i, i1, j, l, npeaks, nremove, range, serious
	integer sorted(PARTOT)
	real*8 parcs(PARTOT), priority(PEAKTOT), tmp, x, y, factor, averagearea, chicheck

        lplocal = lpa
        lpa17 = lpa .and. isensw(17)
        if(KANAL.eq.6) then
          lplocal = .TRUE.
          lpa17 = .TRUE.
        endif
        gasfck = .false.
c set number of peaks which can be removed
        if(lplocal) write(KANAL, '('' GASFCK: ''$)')
        nremove = min(kpeaks-1, REMOVEMAX)
        if(nremove.le.0) then
          if(lplocal) write(KANAL, '(''nothing to do, there is only one peak'')')
          return
        endif
c check for problems in the inversion of variance - covariance matrix
        serious = 1
        do while(errpar(serious).gt.0)
          if(serious.eq.1.and.lplocal) write(KANAL,'(''there are problems with the errors of:'')')
          i = errpar(serious)
          call gaschim(i, kpeaks, message)
          if(lplocal) write(KANAL,'(15x,a)') message(:ltext(message))
          serious = serious + 1
        enddo
        serious = serious - 1
        if(serious.gt.0 .and. lplocal) write(KANAL,'(''        ''$)')
c  save peak positions
c work only on the parcs set for the moment
        j = poscen
        do i = 1, kpeaks
          parcs(i) = parc(j)
          j = j + 1
        enddo
c  get peak data from gasval
        if(lplocal) write(KANAL, '(''checking the quality of peak parameters: '')')
        call gasval(chisqr, .false., .true.)
c  get average area and restrict centroid error to width
        averagearea = 0. 
        do i = 1, kpeaks
          averagearea = averagearea + peakarea(i)
          dpeakcentroid(i) = min(dpeakcentroid(i), peakwidth(i))
          priority(i) = 0.
        enddo
        averagearea = averagearea/kpeaks
        npeaks = 0
        factor = AMPFACTOR
        if(allpeaks) factor = 0.01
c check for peaks outside of region
        do i = 1, kpeaks
          x = parcs(i) - minreg
          if(x.le.0) then
            range = 3*peakwidth(i)
            if(chicheck(posarea + i - 1, 1, range).le.DCHIMAX) then
              npeaks = npeaks + 1
              priority(i) = 99.
              if(lpa17) then
                write(KANAL,FFCKREJ) peakcentroid(i)
                write(KANAL,FFCKOUTR)
              endif 
            endif
          endif
          x = parcs(i) - maxreg
          if(x.ge.0) then
            range = 3*peakwidth(i)
            if(chicheck(posarea + i - 1, irange - range, irange).le.DCHIMAX) then
              npeaks = npeaks + 1
              priority(i) = 99.
              if(lpa17) then
                write(KANAL,FFCKREJ) peakcentroid(i)
                write(KANAL,FFCKOUTR)
              endif 
            endif
          endif
        enddo
c  check for peaks with tiny width
        do i = 1, kpeaks
          if(peakwidth(i).lt.MINWIDTH) then
            x = chicheck(posarea + i - 1, 1, irange)
            if(lpa17) then
              write(KANAL, FFCKPAT) parcs(i)
              write(KANAL,'('' has tiny width   (''f6.3'' < ''f6.3'')            ''$)')
     $          peakwidth(i), MINWIDTH
              write(KANAL, FFCKREL) x
            endif
c            if(x.le.DCHIMAX) then
	      if(priority(i).le.0.) npeaks = npeaks + 1
              priority(i) = priority(i) + 100. + DCHIMAX/max(1.d-4,x)
c            endif
          endif
        enddo
c  check for very small amplitude of peak
	do i = 1, kpeaks
	  if(peakarea(i).lt.TINY*averagearea) then
            x = chicheck(posarea + i - 1, 1, irange)
            if(lpa17) then
              write(KANAL, FFCKPAT) parcs(i)
              write(KANAL,'('' has tiny area    (''g12.4'')               ''$)') peakarea(i)
              write(KANAL, FFCKREL) x
            endif
            if(x.le.DCHIMAX) then
	      if(priority(i).le.0.) npeaks = npeaks + 1
              priority(i) = priority(i) + 100. + DCHIMAX/max(1.d-4,x)
            endif
          endif
        enddo
c  check for large error of peakarea
	do i = 1, kpeaks
	  if(peakarea(i).lt.factor*dpeakarea(i)) then
            x = chicheck(posarea + i - 1, 1, irange)
            if(lpa17) then
              write(KANAL, FFCKPAT) parcs(i)
              write(KANAL,'('' has large darea (''g12.4'' +/-''g12.4'')''$)') peakarea(i), dpeakarea(i)
              write(KANAL, FFCKREL) x
            endif
            if(x.le.DCHIMAX) then
	      if(priority(i).le.0.) npeaks = npeaks + 1
              priority(i) = priority(i) + abs(dpeakarea(i)/max(0.025*dpeakarea(i), peakarea(i)))
            endif
          endif
        enddo
c  check for overlapping peaks: width of the peaks must be similar
	do i = 1,kpeaks
          i1 = i + 1
	  do while(i1.le.kpeaks)
            x = abs(peakwidth(i) - peakwidth(i1))
            1 - WIDTHFAKTOR*sqrt(dpeakwidth(i)**2 + dpeakwidth(i1)**2)
            if(x.le.0.) then
              y = POSFACTOR
              if(peakarea(i).lt.dpeakarea(i)) y = 1.4*y
              if(peakarea(i1).lt.dpeakarea(i1)) y = 1.4*y
              y = y*sqrt(dpeakcentroid(i)**2 + dpeakcentroid(i1)**2)
              tmp = abs(peakcentroid(i1) - peakcentroid(i))
      	      if(tmp.lt.y) then
c  eliminate the peak with the smaller change in chisquare
                tmp = y/max(0.001, tmp)
                call chi2check(i, i1, x, y)
	        if(x.lt.y) then
                  j = i
                  l = i1
		else
                  j = i1            
                  l = i
                  factor = y
                  y = x
                  x = factor
		endif
                if(priority(j).le.0.) npeaks = npeaks + 1
                priority(j) = priority(j) + tmp + DCHIMAX/max(0.1*DCHIMAX,y)
	        if(lpa17) then
                  write(KANAL,FFCKPAT) parcs(j)
                  write(KANAL,FFCKOVER)  min(dpeakcentroid(j),9.99), 
     $                           peakcentroid(l), min(dpeakcentroid(l), 9.99)
                  write(KANAL,'(6x''rel. change in chi:''2f10.3)') x,y
                endif
              endif
	    end if
            if(widthall) then
              i1 = kpeaks + 1
            else
              i1 = i1 + 1
            endif
	  enddo
	end do
c if there is a serious problem but no peak to eliminate: find one
        if(serious.gt.0 .and. npeaks.eq.0) then
          x = 1.e+30
          i1 = 1
          do i = 1, kpeaks
            y = chicheck(i + posarea - 1, 1, irange)
            if(x.gt.y) then
              x = y
              i1 = i
            endif
          enddo
          if(lpa17) write(KANAL,'(15x,''eliminated peak at'',f9.1
        1,'' with the least change in chisquare ('',f9.3,'')'')') parcs(i1), x
          priority(i1) = DCHIMAX/max(0.1*DCHIMAX, x)
          npeaks = 1
        endif
	if(npeaks.gt.0) then
          if(lpa17) then
            write(KANAL, '(9x,''list of peaks which can be removed:'')')
            do i = 1, kpeaks
              if(priority(i).gt.0.) write(KANAL, '(10x,''peak at''f11.3'' +/-''f8.3 ''  area: ''
     $   g14.4'' +/-''g14.4''  width  ''f8.3''  priority:'',f8.2)') parcs(i),
     $ dpeakcentroid(i), peakarea(i), dpeakarea(i), peakwidth(i), priority(i)
            enddo
          endif
c sort according to highest priority
          do i = 1, kpeaks
            sorted(i) = i
          enddo
          do i = 1, kpeaks-1
            x = priority(sorted(i))
            do j = i+1, kpeaks
              if(x.lt.priority(sorted(j))) then
                x = priority(sorted(j))
                i1 = sorted(i)
                sorted(i) = sorted(j)
                sorted(j) = i1
              endif
            enddo
          enddo
cc          if( .and. .not.allpeaks .or. serious.gt.0) then
          gasfck=.true.
          da = .TRUE.
          if(lplocal) write(KANAL, '(9x,''peaks removed: ''$)')
          i = 1
	  do while(i.le.npeaks .and. da .and. nremove.gt.0)
	    l = sorted(i)
            if(lplocal) write(KANAL, '(f12.3$)') parcs(l)
            if(l.gt.0) then
              da = deletepar(kpeaks, l)
	      npar = npar - ELEMENTS
            endif               
            i = i + 1
            nremove = nremove - 1
	  enddo
          if(lplocal) write(KANAL, '(x)')
        else
          if(lplocal) write(KANAL, '(9x,''all peaks are okay'')')
	end if
c  sort all peaks according to there position
	if(kpeaks.gt.1) call sortpar(kpeaks)
c  copy the centroid error for gasres
        j = poscen
	do i=1,kpeaks
	  deriv(j) = dpeakcentroid(i)
          j = j + 1
	end do
        if(KANAL.eq.6) call wait()
	return
	end


	real*8 function chicheck(m, minrange, maxrange)
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c  calculates the change in chisquare if the amplitude of a
c  peak is set to 0 and returns the change
c  
c it is in the responsibility of the calling routine that
c       posarea.le. m .lt.posarea + kpeaks
c----------------------------------------------------------
        implicit none

        include 'gaspar.icl'
        include 'gasctr.icl'

        integer m, minrange, maxrange, i1, i2
        real*8 fchisqr, save, chistart, chiohne

        i1 = max(1, minrange)
        i2 = min(irange, maxrange)
        chistart= fchisqr(i1,i2)
        save = par(m)
        par(m) = 0.
        chiohne = fchisqr(i1, i2)
        par(m) = save
        chicheck = (chiohne - chistart)/max(1., 0.5*(chiohne + chistart)) 
        return
        end

	subroutine chi2check(m1, m2, dchi1, dchi2)
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c
c  calculates the change in chisquare if the amplitude of a
c  peak is set to 0 and returns the change
c  
c it is in the responsibility of the calling routine that
c       posarea.le. m .lt.posarea + kpeaks
c----------------------------------------------------------
        implicit none

        include 'gaspar.icl'
        include 'gasctr.icl'

        integer m1, m2, i1, i2
        real*8 dchi1, dchi2, fchisqr, save, chistart, chiohne

        i1 = m1 + posarea -1
        i2 = m2 + posarea - 1
        chistart= fchisqr(1, irange)
        save = par(i1)
        par(i1) = 0.
        chiohne = fchisqr(1, irange)
        dchi1 = (chiohne - chistart)/max(1., 0.5*(chiohne + chistart)) 
        par(i1) = save
        save = par(i2)
        par(i2) = 0
        chiohne = fchisqr(1, irange)
        dchi2 = (chiohne - chistart)/max(1., 0.5*(chiohne + chistart)) 
        par(i2) = save
        return
        end
