	integer function gasque (filename)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasque.f,v 3.2 2005/03/02 16:08:50 friedrich Exp $
c  this routine generates spectra from the analysis of 2 dimensional  matrices
c  as obtained with the option set file /dskspe. It is assumed that the options
c  set up are the one of the matrix analysis i.e. have the correct file name.
c  Spectra are only generated for lines which fall into the analysing window.
c  On return, the number of generated spectra will be given.
c  F. Riess,  March 1987, redesign July 1996
c------------------------------------------------------------------------------
	implicit none
	character*(*) filename

	real*8 reject
	parameter (reject = 2.)
	integer MAXSPEC
	parameter (MAXSPEC = 128)
	integer MAXENTRY
	parameter (MAXENTRY = 116)

	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gaspea.icl'
	include 'gasspe.icl'
	include 'gastxt.icl'

        integer BUFLEN
        parameter (BUFLEN = 2*SPELEN)

	character fildum*40, fileg*60, string*40, fileo*60
	integer filemain, ltext, addcomma, equalexp, istext
        integer anzahl
	integer i, j, n
	integer io
	integer length
	integer nr
	integer numspec
	integer listsize, listmin, listmax
        character outform*40
	logical da
	logical alldone
	real*8 polyn
	real*4 pc, pa, dpa, spebuf(2*SPELEN), errbuf(2*SPELEN) 
	real*8 pcd, sum(MAXSPEC), olddpa
        equivalence (spebuf, spek), (errbuf,spekerr)
	gasque = 0
c  check for correct options
	if(.not. dskspe) then
	  write (*, '('' Set the correct options first (see: help generate'')')
	  return
	endif
	if (filepeak.eq.' ') then
	  write(*,'('' A peak list must be defined ....'')')
	  return
	endif
c  get filename of matrix if not defined by set file command
c  extract from filename name of gsp binary file
	fileg = ' '
        fildum = filestring(filemain(filestring):ltext(filestring))
c  clean the extension
        io = -1
        do i = 1, ltext(fildum) 
          if(fildum(i:i).eq.'.' .or. fildum(i:i).eq.' '.or.fildum(i:i).eq.',') io = io + 1
          if(io.gt.0) fildum(i:i) = ' '
        enddo
c get file name
	do while (fileg.eq.' ')
	  if (fildum(1:1).eq.' ') then
	    write (*, '('' Filename of gsp-file ''$)')
	    read (*, '(a)', iostat = io) fileg
	    if (io.eq.(-1)) return
	  else
	    fileg = 'gsp'//fildum(:ltext(fildum))
	  end if
	  inquire(file = fileg, exist = da)
	  if (.not.da) then
	    write (*, '('' File not present : ''a)') fileg(:ltext (fileg))
	    fileg = ' '
	    fildum = ' '
	  end if
	end do
c  get main part of output filename
	fildum = filename(:40)
	do while (fildum.eq.' ')
	  write (*, '('' leading string for output file names: ''$)')
	  read (*, '(a)', iostat = io) fildum
	  if (io.eq.(-1)) return
	end do
c  get length of spectra to be generated
	write (*, '('' spectrum length of generated spectra: ''$)')
	read (*, '(a)', iostat = io) string
	if (io.eq.(-1) .or. string.eq.' ') return
	read (string, *, iostat = io) length
        if(length.le.1 .or. length.gt.BUFLEN) then
          write(*,'('' spectra length must be [1,'',i5,'']'')') BUFLEN
	  return
	endif
c  check for peak list and read peak data
	listsize = 0
        anzahl = 0
	alldone = .FALSE.
	do while(.not. alldone)
	  open (unit = 1, file = filepeak, status = 'old')
	  io = 0
	  listmin = listsize
	  do while (io.ge.0 .and. listsize.lt.TOTALPEAKS)
	    read (1, '(a)', iostat = io) texta
	    if (io.eq.0 .and. istext(texta).eq.0) then
	      read (texta, *, iostat = io) pc  !, pa, dpa
	      if (io.eq.0) then
	        i = nint (pc)
	        if (i.ge.minch .and. i.le.maxch) then
	          listsize = listsize + 1
	          peak (listsize) = pc
	        end if
	      else
		write(*, '(a,i)') ' GASQUE: error in input of peak list:', io
	        io = 1
	      end if
	    end if
	  end do
	  close (unit=1)
	  if(listsize.eq.0) then
	    if(listmin.eq.0) write(*, '('' No lines in analysing window'')')
	    return
	  endif
	  if(listsize.lt.TOTALPEAKS) alldone = .TRUE.
c  all input finished, start:
          if(listmin.eq.0) write(*,'(''    Reading data from file '',a)') fileg(:ltext(fileg))
c  get number of spectra which can be assembled at one time
	  listmin = 1
	  numspec = BUFLEN/length
	  do while(listmin.le.listsize)
	    listmax = listmin + numspec - 1
	    if(listmax.gt.listsize) listmax = listsize
c zero spectra
	    do i = 1, BUFLEN
	      spebuf(i) = 0.
	      errbuf(i) = 0.
	    enddo
	    do i = 1, MAXSPEC
	      sum(i) = 0
	    enddo
c  now start with assembling
	    open(unit = 10, file = fileg, status = 'old', form = 'unformatted')
	    io = 0
	    do while (io.ne.(-1))
	      read(10, iostat = io) nr, pc, pa, dpa
	      i = nint(pc)
              pcd = dble(pc)
c  check if data within windows
	      if(io.eq.0 .and. i.ge.minch .and. i.le.maxch .and. nr.ge.1 .and. nr.le.length) then
c  check if the peak is in the current range of the peak list and add contents to the spectrum if so
	        da = .FALSE.
	        i = listmin
	        do while (i.le.listmax .and. .not.da)
		  j = i - listmin
	          if(abs(pcd - peak(i)).le.0.01) then
                    da = .true.
	            nr = nr + length * j
	            spebuf(nr) = pa	
                    errbuf(nr) = dpa
		    sum(j+1) = sum(j+1) + pa
		  endif
		  i = i+1
	        enddo
	      end if
	    end do
	    close (unit = 10)       
c  the spectra have been assembled, write them out in .dat-Format
	    i = listmin
	    do while (i.le.listmax)
	      pcd = peak(i)
	      if(fileenergy.ne.' ') pcd = polyn(peak(i), nde - ndem, ndem, aes)
c  spectra in dat-Format: one spectrum per file
	      write(string, '(f10.1)') pcd
	      j = addcomma(string)
	      do j = 1, 40
		if(string(j:j).eq.'.') string(j:j) = '_'
	      enddo
              fileo = fildum(:ltext(fildum))//string(:ltext(string))//'.daterr'
              inquire(file=fileo, exist = da)
              if(da) then
                open(unit = 10, file = fileo, status = 'old')
                close(unit=10, status='delete')
              endif
	      if(sum(i-listmin+1).eq.0) then
		write(*,'('' file: '', a,'', empty, not generated'')') fileo(:ltext(fileo))
	      else
                write(*,'('' file: '', a,'', contents = '',f10.0)') fileo(:ltext(fileo)), sum(i-listmin+1)
                open(unit = 10, file = fileo, status = 'new')
                write(10, '(1x,a,a)') 'gate spektrum from file: ', fileg(:ltext(fileg))
                call fdate(string)
                write(10, '(1x,a,a)') 'generated at ', string(:ltext(string)) 
                write(10, '(1x,a,f9.3)') 'gatechannel: ', peak(i)    
	        if(fileenergy.ne.' ') write(10, '(1x,a,f9.3)') 'gateenergy: ', pc
                write(10, '(1x,a,i6)') 'spectrum length', length
		nr = length * (i - listmin)
                olddpa = 1.
                do j = 1, length
                  if(errbuf(nr+j).gt.0.) olddpa = dble(errbuf(nr+j))
                  n = equalexp(dble(spebuf(nr + j)), olddpa, 2, .FALSE., outform)
                  write(10, '(i7, a)') j, outform(:ltext(outform)-1)
                enddo
                close(unit=10)
		anzahl = anzahl + 1
              endif  
	      if (io.gt.0) gasque = io
	      i = i + 1
	    end do
	    listmin = listmax + 1
	  enddo
	enddo
        if(iabs(fileformat).ne.1) write(*,'(''    last  file: '',a)') fileo(:ltext(fileo))
        write(*, '(1x, i5,''   spectra generated'')') anzahl
	end 






