	integer function gasdis(chis, disfit)
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c   $Id: gasdis.f,v 3.48 2005/06/15 14:38:10 friedrich Exp friedrich $
c   this subroutine displays spectrum, fit, background and residuum
c         of a GASPAN fit
c  This gaspan specific subroutine calls 4 routines which
c  interface to the special grafic libaries of a system:
c
c  logical function disinit(save)
c    initializes the grafic display
c    sets the display coordinates to
c      left side , bottom corner:  0.,0.
c      right side, top corner: 1.,1.
c    erases the screen
c    argument: integer save
c              save = 0; only terminal output
c              save = -1; only output into the file gasdis.plt for
c                         later plotting
c              save = 1; output on terminal and into file
c  returns the value .true. if terminal is a grafic terminal
c     .false. if not and save = 0
c
c  subroutine diserase
c    clears the screen
c
c  subroutine disset(x,y)
c    should set a starting point at x and y
c
c  subroutine disdraw(x,y)
c    should draw a line from a previous point defined either
c    by disset or by disdraw to tne new point x,y
c
c  subroutine dismode(mode)
c    defines the drawing modes with either
c    mode = 'line'
c    mode = 'dotted'
c    mode = 'long-dashed'
c
c  subroutine diswrite(string, size)
c  is supposed to write the text in "string" beginning from
c   the current position of the curser
c
c  function disalpha()
c    switches from grafics mode to alpha numeric mode
c
c  subroutine disclose()
c    should do the things which are necessary to finish up the display
c    and close it without erasing it
c   Argument: integer disfit
c   disfit = -3 : display spectrum  and fit during fitting
c                 data are in the arrays ya, yfa and resi (gasfit.icl)
c                 acknowleged options: channels, histogram, lin-log, save
c                 chis is an unnormed chisqr
c   disfit = -2 : display spectrum and fit from call from gasgen
c                 data are in the arrays ya, yfa, weight, resi
c                 acknowleged options: all but single_peaks and energy
c                 chis is divided by the degree of freedom
c   disfit = -1 : display spectrum  and fit at the end of a fit
c                 data are in the arrays spec, specerr, yfa and resi (gasfit.icl)
c                 acknowleged options: all but single_peaks
c                 chis is divided by the degree of freedom
c   disfit = 0  : display spectrum only
c                  data are obtained from gasspc
c   disfit = 1  : display spectrum and fit with command "show fit"
c                  spectrum is obtained from gasspc, fitdata are
c                  obtained from file par...., fit is generated from fitdata
c                 chis is divided by the degree of freedom
c-------------------------------------------------------------------------
	implicit none
	integer disfit
	real*8 chis

	integer DISPID, FITLENGTH, XTICKS, YTICKS, YSTELLEN
	parameter (DISPID = 1)
	parameter (FITLENGTH = 8192)
        parameter (XTICKS = 6)
        parameter (YTICKS = 5)
	parameter (YSTELLEN = 8)  ! you have to change code if ge.10
        real*8 YMAXL, CURVLIMIT
        parameter (YMAXL = 4.)
        parameter (CURVLIMIT = 100.) 
	character*(*) FPLTFEM
	parameter (FPLTFEM = '('' *** file empty or regions not in window: ''a)')
        character*(*) FITFORM0, FITFORM2
        parameter (FITFORM0 = '(f10.0,3x,g18.8)')
        parameter (FITFORM2 = '(f12.2,x,g18.8)')

	include 'gasctr.icl'
        include 'gasplt.icl'
	include 'gasdis.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
	include 'gasspe.icl'
	include 'gastxt.icl'

	logical gasplin, disinit, cancelfit, joinps, gasinp
        character lowercase
	logical da, repeat, singlepeaks, showenergies
c        logical sbackfixed, swidthall, stail, scentail, ssmootherror
c        1, staill, stailr, stailb, slstep
	character istring*40, input*1, ofile*120
	integer filemain, gasspc, ltext, addcomma, gasscale, labelstring, ylabel, nvylabels
	integer i, i1, i2, iostatus, exstatus, j, jstep, jminreg, kanalin, n
        integer spebeg, speend, fitbegin, fitend
	real*8 gasfun, polfun
	real*8 chisqr, parsave(PARTOT), yfanorm
	real*8 fitspec(FITLENGTH), fiterr(FITLENGTH)
        real*8 xn, xno, yn, yno, r, ys(3), dx, dcor, reps
	real*8 x, xmin, xmax, xinter, y, dy, yfit, ymin, ymax, yinter, yvposmin, dypos
	real*8 normx, normy, normr, curvature
        real*8 xposlabel(NYLABELS), yposlabel(NYLABELS)
        integer black, red, blue, green
        data black /0/, red /2/, blue /4/, green /3/
c  functions used:
	normx(x) = XPOSMIN + (x-xmin)/xinter *DXPOS
	normy(x) = yvposmin + (x-ymin)/yinter *dypos
	normr(x) = RESPOS0 + x/RESMAX *DRPOS
        curvature(x,y,r) = CURVLIMIT*(r + x -2.*y)/(1.+0.25*(r - x)**2)**1.5
        ylabel(y) = disysize*(y - yvposmin)/(0.7*PEAKLHEIGHT) + 1

	gasdis=0
        if((disfit.eq.-3 .or. disfit.eq.-1) .and. .not.display) return
        exstatus = 0
        fitbegin = 999999
        fitend = 0
	chisqr = chis
	kanalin=0
        repeat = .TRUE.
        yfanorm = 1.
        yvposmin = RESPOS0
        if(disresiduum) yvposmin = YPOSMIN 
	dypos = YPOSMAX - yvposmin
        showenergies = disenergy .and. fileenergy.ne.' '
c do only if option show fit has been given
c fit spectrum will be generated from parameter file

	if(disfit.eq.1) then
c save input parameters
          ofile = filefitsave(:ltext(filefitsave))//'.sta'
          call gasopt(ofile(:ltext(ofile)), 20)
          close(unit = 20)
	  if(.not. gasplin(kanalin, chisqr)) return
          repeat = gasplin(kanalin, chisqr)
        endif
        do while(repeat .and. .not.cancelfit(1))
c  define spectrum region to be displayed
          if(disfit.eq.0) then
            minreg = minch
            maxreg = maxch
          endif
	  if(minreg.ge.minch .and. maxreg.le.maxch) then
	    i = 0
            if(abs(disfit).eq.1) i = max(5, irange/20)
c            if(abs(disfit).eq.1) i = nint(3. * fwhm)
	    spebeg = max(DEFMINCH, minreg-i)
	    speend = min(lastch, maxreg + i)
	    irange = maxreg-minreg+1
	    if(irange.gt.SPELEN) then
	      irange = SPELEN
	      speend = spebeg + SPELEN - 1
	    endif
	    speend = min(speend, lastch)
	    if(disfit.ge.-1) then
              if(spebeg.lt.minsp .or. speend.gt.maxsp) then
	        minsp = spebeg
	        maxsp = minsp+SPELEN-1
c  get total length of spectrum
	        i = gasspc(minsp, maxsp, files, spek)
                if(i.le.0) return
	        if(i.gt.0 .and. i.lt.spebeg) then
		  write(*, '(''--> GASDIS: region outside of spectrum (>'', i6,'')'')') i
                  return
		endif
	      end if
c   check if fit belongs to current spectrum, renormalize if not
              if(disfit.gt.0) then
                i = 0
                if(smootherror) i =  nint(parc(pospole))
                j = minreg - minsp + 1
	        call gasweight(irange, weight, spekerr(j), i, tinp)
                xn = 0.
                yn = 0.
                dx = 0.
                do i = 1, irange
                  x = sqrt(weight(i))
                  xn = xn + x*spek(j)
                  yn = yn + x*yfa(i)
                  resi(i) = x*(spek(j) - yfa(i))
                  dx = dx + resi(i)
                  j = j + 1
                enddo
                yfanorm = 1.
                if(abs(dx/irange).ge.0.2) then
                  yfanorm = xn/yn
                  write(*, '(6x,''normalizing fit with factor ''g12.4)') yfanorm
                  do i = 1, irange
                     yfa(i) = yfanorm*yfa(i)
                  enddo
                endif
              endif
	    end if
c  write message and header
	    if(disinit(1)) then
	      write(*,'(''--> GASDIS: Can not open display'')')
	      return
	    endif
            disopen = .true.
	    call diserase
	    call dismode('solid')
            call discolor(black)
c draw frame
	    call disset (dble(0.001), dble(0.001))
	    call disdraw(dble(0.999), dble(0.001))
	    call disdraw(dble(0.999), dble(0.999))
	    call disdraw(dble(0.001), dble(0.999))
	    call disdraw(dble(0.001), dble(0.001))
c  write filename
	    i = filemain(files)
	    write(istring,'(i7)') nroute
	    j = addcomma(istring)
	    if (dskspe) then
	      texta = files(i:ltext(files))//'>>'//istring(:ltext (istring))
	    else
	      texta = files(i:ltext(files))//'->'//istring(:ltext (istring))
	    end if
	    call dismode('bold')
	    call disset(XPOSHEADER, YPOSHEADER)
	    call diswrite(texta(:ltext(texta)), SIZEHEADER)
c  write date
	    texta = ' '
	    call dismode('normal')
	    call fdate(texta)
	    call disset(0.5*(XPOSMAX+XPOSMIN)-4*AXISWIDTH, YPOSHEADER)
	    call diswrite(texta(:ltext(texta)), SIZEAXIS)
c  write version of gaspan
	    call disset(XPOSMAX-27*AXISWIDTH, YPOSHEADER)
	    call diswrite(version(1:ltext(version)), SIZEAXIS)
	    yn = YPOSHEADER
c  write comment
	    if(distext.ne.' ') then
	      i = 1
	      j = ltext(distext)
	      if(distext(1:1).eq.'"') then
		i = 2
		j = j - 1
	      endif
	      yn = yn - 1.5 * HEADERHEIGHT
	      call dismode('normal')
	      call disset(XPOSHEADER, yn)
	      call diswrite(distext(i:j), SIZETEXT)
	    endif
c  write  fitcharacteristics
	    if(disfit.ne.0) then
              write (istring,'(i1'','')') backdeg
	      texta = 'back. deg. '//istring(1:2)
              if(backdeg .eq. 0 .and. backfixed) then
                if(par(pospol) .eq.0.) then
                  texta(ltext(texta)+1:) = ' no backgr.,'
                else
                  write(istring, '(f10.1)') par(pospol)
                  i = addcomma(istring)
                  texta(ltext(texta)+1:) = ' fixed to '//istring(:ltext(istring))//','
                endif
              endif
	      if(taill .or. tailr .or. tailb .or. lstep) then
		if (tail) texta=texta(:ltext(texta))//' tails (var.):'
	        if (.not.tail) texta=texta(:ltext(texta))//' tails (fixed):'
	        if (taill) texta = texta (1:ltext (texta))//' left,'
	        if (tailb) texta = texta (1:ltext (texta))//' back.,'
	        if (tailr) texta = texta (1:ltext (texta))//' right,'
	        if (lstep) texta = texta (1:ltext (texta))//' step,'
	      end if
	      write (istring,'(i3)') kpeaks
	      texta=texta(1:ltext(texta))//istring(1:ltext(istring))//' peaks,'
	      write(istring,'(g15.4)') chisqr
              if(disfit.eq.-3) then
	        texta = texta(1:ltext(texta))//' chisqr '//istring(1:ltext(istring))
              else
	        texta = texta(1:ltext(texta))//' chisqr/f '//istring(1:ltext(istring))
              endif
	      call dismode('normal')
	      call disset(XPOSHEADER, yn-1.6*AXISHEIGHT)
	      call diswrite(texta(1:ltext(texta)), SIZEAXIS)
	    end if
c  display spectrum
c  determine minimum and maximum of spectrum
	    j=spebeg - minsp + 1
            jminreg = j
            n = 1
	    xmin = LARGENUMBER
	    ymin = LARGENUMBER
            yno = ymin
            if(dislogaxis) ymin = log10(ymin)
	    xmax = -xmin
	    ymax = -ymin
	    do i = spebeg, speend
              cor(j) = i
              if(showenergies) cor(j) = polfun(cor(j), nde - ndem, ndem, aes, x, xposlabel) 
              xmin = min(xmin, cor(j))
              xmax = max(xmax, cor(j))
              if(i.eq.minreg) jminreg = j
	      if (i.ge.minreg .and. i.le.maxreg) then
	        if(disfit.le.-2) then
                  yn = ya(n)
                  n = n + 1
                else
                  yn = spek(j)
                endif
                yno = min(yno, yn)
                da = .true.
                if(dislogaxis) then
                  if(yn.gt.0.)  then
                    yn = log10(yn)
                  else
                    da = .false.
                    yn = -99.
                  endif
                endif   
	        if(da) ymin =  min(ymin, yn)
	        if(disfit.ge.-1) then
                  yn = spek(j) + spekerr(j)
                  if(dislogaxis) yn = log10(max(yn, 1.d-99))
                endif
	        ymax=max(ymax, yn)
	      end if
	      j=j+1
	    end do
	    xinter=xmax-xmin
	    if (xinter.eq.0.) then
	      write(*,'("GASDIS: display range is zero!")')
	      return
	    end if
            if(dislogaxis) then
              if(ymax.gt.0.d+0) then
                ymax = int(ymax+1.)
              else
                ymax = -int(-ymax)
              endif
              ymin = max(ymin, ymax-10.d+0)
              if(ymin.gt.0.d+0) then
                ymin = int(ymin)
              else
                ymin = -int(-ymin +0.999)
              endif
              if(yno.le.0.) ymin = ymin - 1.
              if(disymin.ne.-LARGENUMBER) then
                y = aint(log10(max(disymin, 1.d-99)))
                if(ymax.gt.y) ymin = y
              endif
              if(disymax.ne.LARGENUMBER) then
                y = aint(log10(max(disymax, 1.d-98))) + 1.
                if(ymin.lt.y) ymax = y
              endif
              yinter = ymax - ymin
              if(yinter.le.0.) yinter = 1
              ymax = yinter + ymin
            else
              if(ymax.eq.ymin) then
                ymin = ymin - 1.
                ymax = ymax + 1.
              endif
              yinter = ymax - ymin
c  allow for overshoots of the fit function
              ymax = ymin + 1.1*yinter
              if(disymin.ne.-LARGENUMBER .and. ymax.gt.disymin) ymin = disymin
              if(disymax.ne.LARGENUMBER  .and. ymin.lt.disymax) ymax = disymax
	      yinter = ymax - ymin
            endif
c  normalize spectrum and draw it
	    j = spebeg-minsp+1
            n = 1
	    dcor = normx(cor(j+1)) - normx(cor(j))
	    call dismode('normal')
	    call dismode('solid')
            call discolor(black)
c  with errorbars
	    if(disfit.ge.-2 .and. diserrorbar) then
              r = min(0.01d+0, max(0.002d+0, 0.3*dcor))
	      do i = spebeg, speend
                if(disfit.le.-2) then
                  yn = ya(n) - weight(n)
                else
	          yn = spek(j) - spekerr(j)
                endif
	        if (dislogaxis) yn = log10(max(1.d-99,yn))
                xn = normx(cor(j))
                if(yn.lt.YPOSMAX) then 
	          yn = max(yvposmin, min(normy(yn), YPOSMAX))
	          call disset(xn, yn)
                  if(disfit.le.-2) then
                    yn = ya(n) + weight(n)
                  else
	            yn = spek(j) + spekerr(j)
                  endif
	          if (dislogaxis) yn = log10(max(1.d-99,yn))
	          yn = normy(yn)
                  if(yn.gt.yvposmin) then
	            call disdraw(xn, max(yvposmin, min(yn, YPOSMAX)))
                  endif
                endif
                if(disfit.le.-2) then
                  yn = ya(n) 
                else
	          yn = spek(j)
                endif
	        if (dislogaxis) yn = log10(max(1.d-99,yn))
	        yn = normy(yn)
                if(yn.ge.yvposmin .and. yn.le.YPOSMAX) then
                  call discircle(xn, max(yvposmin, min(yn, YPOSMAX)), r)
                endif
                n = n + 1
	        j = j + 1
	      end do
c  as histogramm
            else  ! if(disfit.ge.-2 .and. diserrorbar)
	      do i = spebeg, speend
                if(disfit.le.-2) then
                  yn = ya(n) 
                else
	          yn = spek(j)
                endif
	        if (dislogaxis) yn = max(ymin, log10(max(1.d-99,yn)))
	        yn = normy(yn)
                yn = max(yvposmin, min(yn, YPOSMAX))
	        if(i.eq.spebeg) then
	          call disset(normx(cor(j)), yn)
	          xn = normx(0.5*(cor(j) + cor(j+1)))
	          yno=yn
	        else if (i.lt.speend) then
	          if(abs(yno-yn).gt.DYCHANGE) then
	            call disdraw(xn, yno)
	            call disdraw(xn, yn)
	            yno=yn
	          end if
	          xn = normx(0.5*(cor(j) + cor(j+1)))
	        else
	          call disdraw(xn, yno)
	          call disdraw(xn, yn)
	          call disdraw(normx(cor(j)), yn)
	        end if
                n = n + 1
	        j = j + 1
	      end do
	    end if  !  if(disfit.lt.-2 .or. .not. diserrorbar)
c  draw x-axis with appropriate channel markings
            call dismode('bold')
	    call disset(XPOSMIN,yvposmin)
	    call disdraw(XPOSMAX,yvposmin)
            jstep = gasscale(xmin, xmax, XTICKS, xno, reps) 
            dx = jstep*reps
	    j=0
	    yn=yvposmin-1.5*XAXISIND-0.5*AXISHEIGHT+LETTERPOSY
            x = xno
            do while(x.le.xmax)
              if(x.ge.xmin) then
                xn = normx(x)
                if(mod(j, jstep).eq.0) then
                  i = labelstring(x, dx, xmax, 9, istring)
                  call dismode('normal')
		  call disset(xn - 0.5*i*AXISWIDTH/disxsize, yn)
	          call diswrite(istring(:i), SIZEAXIS)
                  call dismode('bold')
                  call disset(xn, yvposmin - XAXISIND)
                else
                  call disset(xn, yvposmin - 0.5*XAXISIND)
                endif
                call disdraw(xn, yvposmin)
              endif
              x = x + reps
              j = j + 1
            enddo
            if(showenergies) then
              istring = "energy"
            else
              istring = "channel"
            endif
            call disset(XPOSMAX - 6*AXISWIDTH/disxsize, yvposmin - 4.5*AXISHEIGHT)
            call diswrite(istring(:ltext(istring)), SIZEAXIS)
c  draw y-axis with apropriate channel markings
            call disset(XPOSMIN, yvposmin)
            call disdraw(XPOSMIN, YPOSMAX)
	    if(dislogaxis) then
              reps = 1
              j = 0
              y = ymin
              if(y - int(y).ne.0) j = 1
              jstep = max(-5, -int(yinter/reps))
	      do while(y.le.ymin + yinter)
	        yn=normy(y)
	        call disdraw(XPOSMIN, yn)
	        if(j.eq.0) then
	        call disdraw(XPOSMIN - YAXISIND, yn)
                i = labelstring(y, x, x, 0, istring)
                call dismode('normal')
	        xn = max(AXISWIDTH, XPOSMIN - 2*YAXISIND - i*AXISWIDTH/disxsize)
		call disset(xn, yn+0.5*AXISHEIGHT+LETTERPOSY)
	        call diswrite(istring(:i), SIZEAXIS)
                call dismode('bold')
	        j = jstep
                  do j = 2, 10
                    x = y + reps * log10(dble(j))
                    if(x.lt.ymax) then
                      x = normy(x)
	              call disset (XPOSMIN, x)
	              call disdraw(XPOSMIN - 0.5 * YAXISIND, x)
                    endif
                  enddo
                  j = -1
	      else   ! if(j.eq.0)
                call disdraw(XPOSMIN - 0.5 * YAXISIND, yn)
	      end if
	      j=j+1
	      call disset (XPOSMIN, yn)
	      y=y+reps
	      end do  ! while(y.le.ymax)
 	    call disdraw(XPOSMIN,YPOSMAX)
            else
c y - axis: linear scale
              jstep = gasscale(ymin, ymax, YTICKS, yno, reps) 
              dy = jstep*reps
              y = yno
              yn = normy(y)
              j = 0
              do while(yn.le.YPOSMAX)
                if(y.ge.ymin) then
c major ticks with labels are if mod(j, jstep) = 0, decide which format to use
                  if(mod(j, jstep).eq.0) then
                    i1 = YSTELLEN
                    i = labelstring(y, dy, max(abs(ymin), abs(ymax)), i1, istring) 
                    xn = yn - xno
                    xno = yn
                    call dismode('normal')
                    x = XPOSMIN - 2*YAXISIND - i*AXISWIDTH/disxsize
	            x = max(AXISWIDTH, x)
		    call disset(x, yn+0.5*AXISHEIGHT+LETTERPOSY)
	            call diswrite(istring(:i), SIZEAXIS)
                    call disset(XPOSMIN - YAXISIND, yn)
                  else
                    call disset(XPOSMIN - 0.5*YAXISIND, yn)
                  endif ! if(mod(j, reps).eq.0)
                  call disdraw(XPOSMIN, yn)
                endif  ! y.ge.ymin
                j = j + 1
                y = y + reps
                yn = normy(y)
              enddo   ! while(y.le.ymax)
              i = labelstring(y, 0.d+00, max(abs(ymin), abs(ymax)), i1, istring) 
              if(i > 0) then
                call dismode('bold')
                x = XPOSMIN - 2*YAXISIND - (i + 1)*AXISWIDTH/disxsize
	        x = max(AXISWIDTH, x)
		call disset(x, xno - 0.5*xn +0.5*AXISHEIGHT+LETTERPOSY)
	        call diswrite(istring(:i), SIZEAXIS)
              endif
            endif  !  if(dislogaxis)
c  calculate fit spectrum and draw it with interpolation
	    if(disfit.ne.0) then
	      call dismode('bold')
	      call dismode('solid')
              singlepeaks = dissingle .and. disfit.ge.1
	      n = kpeaks + 1
	      if(singlepeaks) n = 1
	      do i1 = 1, npar
	        parsave(i1) = par(i1)
	      enddo
	      do i1 = n, kpeaks + 1
	        if(i1.le.kpeaks) then
                  call discolor(green)
	          do i2 = 1, kpeaks
	            par(i2 + posarea - 1) = 0.
	          enddo
                  par(i1 + posarea - 1) = parsave(i1 + posarea - 1)
	        else
                  call discolor(red)
                  if(singlepeaks) then
	            do i2 = 1, kpeaks
	              par(i2 + posarea - 1) = parsave(i2 + posarea - 1)
	            enddo
                  endif
	        endif
c generate filename if output is requested and open file
		if(fitout.lt.0 .and. 
     $                (disfit.eq.1. or. (disfit.eq.-1 .and. .not.onefitregion))) then
                  call initfitout(fitout, 'fit')
                endif
c get error and write fit spetrum into file if wanted
	        j = minreg-minsp+1
		do i = 1, irange
		  if(i1.eq.n) then
		    fiterr(i) = spekerr(j)
		    j = j + 1
		  endif
		enddo
	        x = minreg
                yfit = 0.
                if(fitout.gt.0 .and. i1.gt.kpeaks) write(fitout, FITFORM0) x, yfit
                if(singlepeaks) yfa(1) = yfanorm*gasfun(x, npar)
                yfit = yfa(1)
	        j = minreg - minsp + 1
		call disset(normx(cor(j)), yvposmin)
                reps = 0
		yn = yfa(1)
		if(dislogaxis) yn = log10(max(1.0d-99, yn))
		ys(3) = max(yvposmin, min(normy(yn), YPOSMAX))
                ys(2) = ys(3)
		do i = 1, irange - 1
                  yfit = yfa(i)
                  if(singlepeaks) yfa(i+1) = yfanorm*gasfun(x+1, npar)
                  ys(1) = ys(2)
                  ys(2) = ys(3)
		  yn = yfa(min(i + 1, irange))
		  if (dislogaxis) yn = log10(max(1.0d-99, yn))
		  ys(3) = max(yvposmin, min(normy(yn), YPOSMAX))
		  if(disfit.ge.-1) then
c  calculate curvature of fit curve in order to decide for intermediate points
                    jstep = min(5, abs(curvature(ys(1), ys(2), ys(3))))
                  else
                    jstep = 0
                  endif 
                  if(jstep.gt.0) then
                    dx = 0.5/(1. + jstep)
                    reps = 0.5*(cor(j + 1) - cor(j))/(1. + jstep)
                    do i2 = -jstep, jstep
                      xn = x + i2*dx
                      if(xn.ge.minreg .and. xn.le.maxreg) then
                        yfit = yfanorm*gasfun(xn, npar)
                        yn = yfit
		        if (dislogaxis) yn = log10(max(1.0d-99, yn))
		        yn = max(yvposmin, min(normy(yn), YPOSMAX))
                        call disdraw(normx(cor(j) + i2*reps), yn)
                        if(fitout.gt.0 .and. i1.gt.kpeaks) write(fitout,FITFORM2) xn, yfit
                      endif
                    enddo
                  else
		    call disdraw(normx(cor(j)), max(yvposmin, min(ys(2), YPOSMAX)))
                    if(fitout.gt.0 .and. i1.gt.kpeaks) write(fitout,FITFORM0) x, yfit
                  endif
                  x = x + 1.
	          j = j + 1
	        end do   !  do i = 1, irange
		call disdraw(normx(cor(j)), yvposmin)
                if(fitout.gt.0) then
                  yfit = 0.
                  write(fitout, FITFORM0) x - 1., yfit
                  close(unit = fitout)
                  fitout = -1
                endif
	      enddo  ! do i1 = n, kpeaks + 1
c  draw peak markers
c  note: the following  code requests the peaks to be in increasing order
c        this is not the case for calibrations which invert the sequence
c  initialize peak label positions:
              da = .FALSE.
              if(showenergies .and. kpeaks.gt.1) then
                xn = polfun(gausspos(kpeaks), nde - ndem, ndem, aes, dx, deriv)
                if(dx.lt.0.) da = .TRUE.
              endif
              nvylabels = 0
              j = 1
              do while(nvylabels.eq.0)
                xposlabel(j) = XLABEL
                yposlabel(j) = 0.7*j*PEAKLHEIGHT/disysize + yvposmin  ! boxes for label positions
                if(yposlabel(j).gt.MAXPEAKIND .or. j.eq.NYLABELS) nvylabels = j - 1
                j = j + 1
              enddo
	      call dismode('normal')
	      call dismode('dotted')
              call discolor(black)
	      do jstep = 1,kpeaks
c  get marker position
                j = jstep
                if(da) j = kpeaks + 1 - jstep
	        if(disfit.lt.-1 .or. disgauss.eq.1 .or. (disgauss.eq.0 .and. .not.centail)) then
                  x = gausspos(j)
                else
                  x = peakcentroid(j)
                endif
                xn = x
	        if (showenergies) xn = polfun(x, nde - ndem, ndem, aes, dx, deriv) 
	        write(istring,'(f8.1)') xn
                xn = normx(xn)
c calculate spectrum range of marker label
                n = 1
                do while(istring(n:n).eq.' ')
                  n = n + 1
                enddo
                dx = 0.5*(ltext(istring) - n)*PEAKLWIDTH/disxsize
                yn = dx*xinter/DXPOS
                i1 = x - yn
                i2 = x + yn
                yn = 0.
                y = 1.d+100
                do i = i1, i2
	          yn = max(yn, spek(max(spebeg, min(speend, i)) - minsp +1))
	          y = min(y, spek(max(spebeg, min(speend, i)) - minsp +1))
                enddo
	        if(dislogaxis) then
                  yn = max(ymin, log10(max(1.0d-99, yn)))
                  y  = min(ymax, log10(max(1.0d-99, y)))
                endif
		yn = min(normy(yn)+PEAKIND, MAXPEAKIND)
		y = normy(y) - 2*PEAKLHEIGHT
c find appropriate y - position for label
                i1 = min(max(ylabel(yn), 1), nvylabels)
                if(xposlabel(i1).gt.XLABEL) then
c try above
                  i1 =  min(max(ylabel(yn - 2*PEAKIND) + 1, 1), nvylabels)
                  i = i1
                  xno = -1
                  do while(xno.lt.0. .and. i.le.nvylabels)
                    xno = xn - dx - xposlabel(i)
                    i2 = i
                    i = i + 1
                  enddo
c if no success, try below
                  if(xno.lt.0.) then
                    i = min(max(ylabel(y),1),nvylabels) 
                    do while(xno.lt.0. .and. i.ge.1)
                      xno = xn - dx - xposlabel(i)
                      i2 = i
                      i = i - 1
                    enddo
                  endif
c there is still no success try anything in between
                  if(xno.lt.0.) then
                    i = i1
                    do while(xno.lt.0. .and. i.ge.1)
                      xno = xn - dx - xposlabel(i)
                      i2 = i
                      i = i - 1
                    enddo
                  endif
c  if there is still no access take minimum overlap
                  if(xno.lt.0.) then
                    i2 = nvylabels
                    xno = xn - dx - xposlabel(i2)
                    do i = nvylabels - 1, 1, -1
                      x = xn - dx - xposlabel(i)
                      if(xno.lt.x) then
                        xno = x
                        i2 = i
                      endif
                    enddo
                  endif
c  finaly we have a position
                  i1 = i2
                endif  ! if(xposlabel(i1).gt.XLABEL) 
                xno = max(xposlabel(i1), xn - dx)
                yno = yposlabel(i1)
                xposlabel(i1) = xn + dx + PEAKLWIDTH
c  draw marker
	        call disset(xn, yvposmin+YAXISIND)
		call disdraw(xn, max(yn, yno))
c  .and write label
		call disset(xno, yno)
	        call diswrite(istring(n:ltext(istring)), SIZEPEAK)
	      end do   !  do j = 1,kpeaks
c  calculate background spectrum and draw it: if no background
c  tail is defined, the background can be calculated directly,
c  otherwise calculate fit - peaks to get it
	      call dismode('bold')
	      call dismode('solid')
              call discolor(blue)
              do i = 1, npar
                parsave(i) = par(i)
              enddo
	      if ((tailb .and. .not.backinclude) .or. lstep) then
	        do i = 0, 4
	          par(pospol + i) = 0.
	        end do
	        if(tailb .and. .not.backinclude) par(postba) = 0.
                par(possta) = 0.
	      end if
c generate filename for background spectrum
              if(fitout.lt.0 .and. (disfit.eq.1. or. 
     $           (disfit.eq.-1 .and. .not.onefitregion))) call initfitout(fitout, 'bck')
c draw (and write) background spectrum
	      x = minreg
	      j = minreg-minsp+1
              yfit = 0.
              if(fitout.gt.0) write(fitout, FITFORM0) x, yfit
	      if ((tailb .and. .not.backinclude) .or. lstep) then
	        fitspec(1) = yfa(1) - yfanorm*gasfun(x, npar)
	      else
	        fitspec(1) = yfanorm*gasfun(x, 0)
	      end if
	      yn = fitspec(1)
	      if (dislogaxis) yn = max(ymin, log10(max(1.d-99,yn)))
              ys(3) = max(yvposmin, min(normy(yn), YPOSMAX))
              ys(2) = ys(3)
              call disset(normx(cor(j)), ys(2))
	      do i = 1, irange - 1
                yfit = fitspec(i)
                ys(1) = ys(2)
                ys(2) = ys(3)
                i2 = min(i+1, irange)
	        if ((tailb .and. .not.backinclude) .or. lstep) then
	          fitspec(i2) = yfa(i2) - yfanorm*gasfun(x + 1.,npar)
	        else
	          fitspec(i2) = yfanorm*gasfun(x + 1., 0)
	        end if
	        yn = fitspec(i2)
	        if (dislogaxis) yn = max(ymin, log10(max(1.d-99,yn)))
                ys(3) = max(yvposmin, min(normy(yn), YPOSMAX))
c  calculate curvature of fit curve
                if(disfit.ge.-1 .and. i.gt.1 .and. i.lt.irange) then
                  jstep = min(5., abs(curvature(ys(1), ys(2), ys(3))))
                else
                  jstep = 0
                endif
                if(jstep.gt.0) then
                  dx = 0.5/(1. + jstep)
                  reps = 0.5*(cor(j+1) - cor(j))/(1. + jstep)
                  do i2 = -jstep, jstep
                    xn = x + i2*dx
                    if(xn.ge.minreg .and. xn.le.maxreg) then
	              if((tailb .and. .not.backinclude) .or. lstep) then
                        yn = yfanorm*gasfun(xn, npar)
	                do i1 = 0, 4
	                  par(pospol + i1) = parsave(pospol + i1)
	                end do
	                par(postba) = parsave(postba)
                        yn = yfanorm*gasfun(xn, npar)
	                do i1 = 0, 4
	                  par(pospol + i1) = 0.
	                end do
	                par(postba) = 0.
                        yn = yn - yfanorm*gasfun(xn, npar)
	              else
                        yn = yfanorm*gasfun(xn, 0)
                      endif
                    endif
                    yfit = yn
                    if (dislogaxis) yn = log10(max(1.0d-99, yn))
                    yn = max(yvposmin, min(normy(yn), YPOSMAX))
                    call disdraw(normx(cor(j) + i2*reps), yn)
                    if(fitout.gt.0) write(fitout, FITFORM2) xn, yfit
                  enddo
                else
	          call disdraw(normx(cor(j)), ys(2))
                  if(fitout.gt.0) write(fitout, FITFORM0) x, yfit
                endif !  if(jstep.gt.0) then
                x = x + 1.
	        j = j+1
	      end do  ! do i = 1, irange - 1
              call disdraw(normx(cor(j)), ys(3))
              yfit = 0.
              if(fitout.gt.0) then
                write(fitout,FITFORM0) x, fitspec(irange)
                write(fitout,FITFORM0) x, yfit
                close(unit = fitout)
                fitout = -1
              endif
            
              do i = 1, npar
                par(i) = parsave(i)
              enddo
c  calculate weight (see gaspar) and residuum (see gasfit)
              if(disfit.gt.0) then
                i = 0
                if(smootherror) i =  nint(parc(pospole))
                j = minreg - minsp + 1
	        call gasweight(irange, weight, spekerr(j), i, tinp)
                do i = 1, irange
                  resi(i) = (spek(j) - yfa(i))*sqrt(weight(i))
                  j = j + 1
                enddo
              endif
c  draw residuum
              if(disresiduum) then
	        call dismode('normal')
                call discolor(black)
	        j = minreg-minsp+1
	        do i=1,irange
	          yn = resi(i)
	          if (i.eq.1) then
	            call disset (normx(cor(j)), normr(max(-RESMAX, min(yn, RESMAX))))
	          else
	            call disdraw (normx(cor(j)), normr(max(-RESMAX, min(yn, RESMAX))))
	          end if
	          j=j+1
	        end do
c  draw two standart deviations
	        call dismode ('shortdashed')
	        call disset (normx(cor(minreg-minsp+1)), normr(2.))
	        call disdraw (normx(cor(maxreg-minsp+1)), normr(2.))
	        call disset (normx(cor(minreg-minsp+1)), normr(-2.))
	        call disdraw (normx(cor(maxreg-minsp+1)), normr(-2.))
              endif  ! if(disresiduum)
	    end if  ! if(disfit.ne.0)
	    call disset (dble(0.005), dble(0.005))
            call disflush
c display has been done, check for user action
            texta = ' '
	    if(dishold) texta = 'next>'
            if(disfit.ge.0) then
              if(disrumpf.eq.' ') then 
                if(dissave) then
                  texta = 'next: <cr>, next spec: ESC, p(rint)> '
                else
                  texta = 'next: <cr>, next spec: ESC, p(rint), s(ave)>'
                endif
              else
                regcount = regcount + 1
                write(istring, '(i6)') regcount
                i = addcomma(istring)
                ofile = disrumpf(:ltext(disrumpf))//istring(:ltext(istring))//'.eps'
                call disclose(0)
                da = joinps(ofile, "gasplot.bak")
              endif
            endif
            if(texta.ne.' ') then
              write(*,'(a,$)') texta(:ltext(texta))
              read(*, '(a)') input
              iostatus = 0
              if(input .eq. char(27)) then
                exstatus = -1
                iostatus = -1
              else if(lowercase(input).eq.'p') then
                i = 1
                if(disprint(1:1) .eq. '"') i = 2
                if(disprint(i:i).eq.' ') then
                  texta = 'lpr gasplot.bak'
                else
                  texta = disprint(i:ltext(disprint)-i+1) //' ' // 'gasplot.bak'
                endif
                call disclose(0)
                call system(texta(:ltext(texta)))
              else if(lowercase(input).eq.'s') then
                write (*,'('' save into file: ''$)')
                read (*, '(a)', iostat = i1 ) ofile
                call disclose(0)
                da = joinps(ofile, 'gasplot.bak')
              endif
            endif
            if(dissave) then
              call disclose(0)
              da = joinps(disfile, "gasplot.bak")
            endif
            da = cancelfit(1)
            if(da) exstatus = -1
	    if (disfit.eq.0 .or. da) iostatus = -1
	  end if
          repeat = .FALSE.
          if(disfit.gt.0) repeat = gasplin(kanalin, chisqr)
	end do              ! while repeat
	if (disfit.gt.0) then
          if(kanalin.gt.0) then
            close(unit = kanalin)
            kanalin = 0
          endif
          exstatus = 1
          gasdis = 0
	end if
        if(exstatus .eq.0 .and. speend.lt.min(maxch,lastch)) gasdis = speend
c  restore input parameters
        if(disfit.eq.1) then
           ofile = filefitsave(:ltext(filefitsave))//'.sta'
           eicsilent = .TRUE.
	   da = gasinp(ofile(:ltext(ofile)))
           eicsilent = .FALSE.
        endif
	return
	end


        logical function gasplin(kanalin, chisqr)
c---------------------------------------------------------------
c  reads data from parameter file and generates fit spectrum
c  kanalin must be 0 for initialisation
c  returns .false. if parameter file is not present or if eof is found
c  filename is generated from text array files (in gasfil.icl)
c  fit spectrum is stored in the array yfa (in gasfit.icl)
c  parameters are stored in array par (in gaspar.icl)
c  peak data are stored in arrays peakcentroid, peakarea and peakwidth (in gaspar.icl)
c  note: errors are too large because variance-covariance matrix is not saved
c  note: some variables are defined in gasctr.icl
c
c---------------------------------------------------------------

	implicit none
        integer kanalin
        real*8 chisqr

	include 'gasctr.icl'
	include 'gasfil.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
        include 'gaseic.icl'
        include 'gaspea.icl'

	logical da
	character filtmp*60, fildum*70, speentry*6
	integer filemain, ltext, addcomma
	integer i, j, m, io, iostatus
        integer writeid
	real*8 gasfun
	real*8 xi
c  these variables must be real*4
        real*4 fparc(67), fpar(67), fbrv(67), fdpar(67), ftinp, fchi
        real*8 brv(67)

        gasplin = .FALSE.
c  check if parameterfile is present and open it
        if(kanalin.eq.0) then
          kanalin = 20
          writeid = 0
          if(.not.showsaved) then
	    open(unit=kanalin, file=filefitsave, status='old', form='unformatted')
	    read(kanalin, IOSTAT=iostatus) writeid
            if(iostatus.ne.0) then
              close(unit = kanalin)
              kanalin = 0
              write(*,'(''--> no fit done'')')
              return
            endif
          else
	    filtmp = files(filemain(files):ltext(files))
	    write(speentry,'(i4)') min(9999, nroute)
	    i = addcomma(speentry)
            j = ltext(filtmp)
            if(filtmp(j-1:j).eq.'.Z') j = j - 2
	    fildum = 'par'//speentry(1:ltext(speentry))//filtmp(:j)
	    inquire(file=fildum, exist=da)
	    if(.not.da) then
	      write(*, '(''--> GASPLIN: file not present: ''a)') fildum(:ltext(fildum))
              kanalin = 0
              return
            else
 	      open(unit=kanalin, file=fildum, status='old', form='unformatted')
	      read(kanalin, IOSTAT=iostatus) writeid
            endif
          endif
	  if(iostatus.ne.0 .or. writeid.lt.1) then
	    write (*, '(''--> GASPLIN: can not make use of this parameter file'')')
            close(unit = kanalin)
	    kanalin = 0
            return
	  end if
          if(writeid.gt.8) then
	    write(*,'(''--> GASPLIN: not implemented ID of data ('',i6,'')'')') writeid
            close(unit = kanalin)
            kanalin = 0
            return
          endif
c read tail input parameters
          if(writeid.ge.6 .and. writeid.le.7) then
            read(kanalin) nampleft, (ampleft(i), i = 1, max(1,nampleft))
            read(kanalin) ntauleft, (tauleft(i), i = 1, max(1,ntauleft))
            read(kanalin) nampback, (ampback(i), i = 1, max(1,nampback))
            read(kanalin) ntauback, (tauback(i), i = 1, max(1,ntauback))
            read(kanalin) nampright, (ampright(i), i = 1, max(1,nampright))
            read(kanalin) ntauright, (tauright(i), i = 1, max(1,ntauright))
          endif
          if(writeid.eq.7) then
            read(kanalin) nampstep, (ampstep(i), i = 1, max(1,nampstep))
          endif
          gasplin = .TRUE.
	else
c  come to here if file has been intialized already and read data
	  if(writeid.le.2) then
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (fparc(i),i=1,npar), (fpar(i),i=1,npar), (fbrv(i),i=1,kpeaks),
	2   nonestat, fileformat, i, dskspe,
  	3   tail, centail, tail, taill, tailb, tailr,
	4   backdeg, nerr, ftinp, fchi
	    do i = 1, npar
	      fdpar (i) = 0.
	    end do
	  else if(writeid.eq.3) then
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (fparc(i),i=1,npar), (fpar(i),i=1,npar), (fdpar(i),i=1,npar), (fbrv(i),i=1,kpeaks),
     $           nonestat, fileformat, i, dskspe,
	3   tail, centail, tail, taill, tailb, tailr,
	4   backdeg, nerr, ftinp, fchi
	  else if (writeid.eq.4) then
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (fparc(i),i=1,npar), (fpar(i),i=1,npar), (fdpar(i),i=1,npar), (fbrv(i),i=1,kpeaks),
	2   nonestat, fileformat, i, dskspe,
	3   tail, centail, tail, taill, tailb, tailr,
	4   backdeg, backfixed, nerr, ftinp, fchi
	  else if (writeid.eq.5 .or. writeid.eq.6) then
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (parc(i),i=1,npar), (par(i),i=1,npar), (dpar(i),i=1,npar), (brv(i),i=1,kpeaks),
	2   nonestat, fileformat, j, dskspe,
	3   tail, centail, tail, taill, tailb, tailr,
	4   backdeg, backfixed, nerr, tinp, chisqr
	  else if (writeid.eq.7) then   
	    read(kanalin, IOSTAT=iostatus) minreg, maxreg, kpeaks, npar,
	1   (parc(i),i=1,npar), (par(i),i=1,npar), (dpar(i),i=1,npar), (brv(i),i=1,kpeaks),
	2   nonestat, j, j, dskspe,
	3   tail, centail, tail, taill, tailb, tailr, lstep,
	4   backdeg, backfixed, nerr, tinp, chisqr
c	2   nonestat, fileformat, j, dskspe,
	  else if (writeid.eq.8) then
            iostatus = 0
            read(kanalin, IOSTAT=iostatus) nampleft, (ampleft(i), i = 1, max(1,nampleft))
            if(iostatus.eq.0) then
              read(kanalin) ntauleft, (tauleft(i), i = 1, max(1,ntauleft))
              read(kanalin) nampback, (ampback(i), i = 1, max(1,nampback))
              read(kanalin) ntauback, (tauback(i), i = 1, max(1,ntauback))
              read(kanalin) nampright, (ampright(i), i = 1, max(1,nampright))
              read(kanalin) ntauright, (tauright(i), i = 1, max(1,ntauright))
              read(kanalin) nampstep, (ampstep(i), i = 1, max(1,nampstep))
c              read(kanalin, IOSTAT=io) minreg, maxreg, kpeaks, npar, backdeg, fileformat, nerr
              read(kanalin, IOSTAT=io) minreg, maxreg, kpeaks, npar, backdeg, i, nerr
              if(io.ne.0) iostatus = io
              read(kanalin, IOSTAT=io) poscen, posarea, poswidth, poscwidth, pospol, pospolm, 
            1 pospole, postba, postla, postra, postbw, postlw, postrw, possta
              if(io.ne.0) iostatus = io
              read(kanalin, IOSTAT=io) chisqr, cenrange, fwhmrange, taillrange, tailrrange
            1, tailbrange, tinp
              read(kanalin, IOSTAT=io) dskspe, poscon, posall, backfixed, backinclude, highsens
            1, nonestat, allpeaks, smootherror, tail, centail, tail, taill, tailb, tailr, lstep
            2, smootherror, widthall
              if(io.ne.0) iostatus = io
	      read(kanalin, IOSTAT=io) (parc(i),i=1,npar), (par(i),i=1,npar), (dpar(i),i=1,npar)
              if(io.ne.0) iostatus = io
              read(kanalin, IOSTAT=io) (fixed(i), i = 1, npar)
              if(io.ne.0) iostatus = io
            endif
	  else
            iostatus = -1
	  endif
c  either error in reading or eof
          if(iostatus.ne.0) then
            close(unit = kanalin)
            kanalin = 0
            return
	  endif
c  note: old parameter saves are in single precision
          gasplin = .TRUE.
c          call setpointers(kpeaks)
          if(writeid.le.4) then
	    do i = 1, npar
	      parc(i) = dble(fparc(i))
              par(i) = dble(fpar(i))
              dpar(i) = dble(fdpar(i))
              brv(i) = fbrv(i)
	    enddo
            chisqr = dble(fchi)
            tinp = dble(ftinp)
          endif
	  if(writeid.eq.1 .and. (taill .or. tailr .or. tailb)) then
	    parc(postba) = 1.
	    parc(postla) = 1.
	    parc(postra) = 1.
          end if

c correct change in Parameter definition up writeid >= 6
          if(writeid.le.5 .and. (taill .or. tailr .or. tailb))  then
            if(taill) then
              nampleft = 1
              ampleft(1) = 1.
              ntauleft = 1
              tauleft(1) = parc(2*kpeaks + 8)
              parc(postlw) = parc(2*kpeaks + 7)
            endif
            if(tailb) then
              nampback = 1
              ampback(1) = 1.
              ntauback = 1
              tauback(1) = parc(2*kpeaks + 10)
              parc(postbw) = parc(2*kpeaks + 9)
            endif
            if(tailr) then
              nampright = 1
              ampright(1) = 1.
              ntauright = 1
              tauright(1) = parc(2*kpeaks + 12)
              parc(postrw) = parc(2*kpeaks + 11)
            endif
          endif
          if(writeid.le.6) then
            lstep = .false.
            nampstep = 1.
            ampstep(1) = 0.01
          endif
c upgrade to writeid 8
          if(writeid.le.7) then
c see  gasmpar.f revision 1.5
            poscen = 1
            posarea = poscen + kpeaks        ! range of parc unused if ELEMENTS .gt. 2
            poswidth = posarea + kpeaks
            poscwidth = poswidth
            pospol = poswidth + kpeaks
            pospolm = pospol + 1
            pospole = pospol + 4
            postla = pospole + 1
            postlw = postla + 1
            postba = pospole + 3
            postbw = postba + 1
            postra = pospole + 5
            postrw = postra + 1
            possta = pospole + 7
c  see yfanorm*gasfun.f rev 3.8
            do i = 1, npar
              deriv(i) = par(i)
              par(i) = 0.
            enddo
            par(possta) = deriv(2*kpeaks + 13)
            par(postrw) = deriv(2*kpeaks + 12)
            par(postra) = deriv(2*kpeaks + 11)
            par(postbw) = deriv(2*kpeaks + 10)
            par(postba) = deriv(2*kpeaks +  9)
            par(postlw) = deriv(2*kpeaks +  8)
            par(postla) = deriv(2*kpeaks +  7)
            do i = 0, 4
              par(pospol + i) = deriv(2*kpeaks + i + 2)
            enddo
            do i = 1, kpeaks
              par(posarea + i - 1) = deriv(kpeaks + i)
              par(poswidth + i - 1) =  deriv(2*kpeaks + 1)
              if(brv(i).eq.0.) par(poswidth + i - 1) = 0.
            enddo
            do i = 1, npar
              deriv(i) = dpar(i)
              dpar(i) = 0.
            enddo
            dpar(possta) = deriv(2*kpeaks + 13)
            dpar(postrw) = deriv(2*kpeaks + 12)
            dpar(postra) = deriv(2*kpeaks + 11)
            dpar(postbw) = deriv(2*kpeaks + 10)
            dpar(postba) = deriv(2*kpeaks +  9)
            dpar(postlw) = deriv(2*kpeaks +  8)
            dpar(postla) = deriv(2*kpeaks +  7)
            do i = 0, 4
              dpar(pospol + i) = deriv(2*kpeaks + i + 2)
            enddo
            do i = 1, kpeaks
              dpar(poscen + i - 1) = deriv(i)
              dpar(posarea + i - 1) = deriv(kpeaks + i)
              dpar(poswidth + i - 1) =  deriv(2*kpeaks + 1)
            enddo
            do i = 1, npar
              deriv(i) = parc(i)
              parc(i) = 0.
            enddo
            parc(possta) = deriv(2*kpeaks + 13)
            parc(postrw) = deriv(2*kpeaks + 12)
            parc(postra) = deriv(2*kpeaks + 11)
            parc(postbw) = deriv(2*kpeaks + 10)
            parc(postba) = deriv(2*kpeaks +  9)
            parc(postlw) = deriv(2*kpeaks +  8)
            parc(postla) = deriv(2*kpeaks +  7)
            parc(pospolm) = deriv(2*kpeaks + 3)
            do i = 1, kpeaks
              parc(poscwidth + i - 1) = deriv(kpeaks + i)
              parc(poscen + i - 1) = deriv(i)
            enddo
            widthall = .TRUE.
            fwhmrange = deriv(2*kpeaks + 1)
            parc(pospole) = max(1., min(4., 0.4*(parc(poscwidth) + parc(poscwidth + kpeaks - 1))))
            npar = npar + kpeaks - 1
          endif
c  set  diagonal terms of variance covariance matrix
          m = 0            
          do i = 1, npar
            do j = 1, i
              m = m + 1
              if(i.eq.j) then
                varcovar(m) = dpar(i)
              else
                varcovar(m) = 0.
              endif
            enddo
          enddo
c  generate peakdata
          call setpointers(kpeaks)
          call gasval(chisqr, .FALSE., .TRUE.)
c          fwhm = peakwidth(kpeaks)
c          dfwhm = dpeakwidth(kpeaks)
c  generate fit spectrum
          xi = minreg
          irange = maxreg - minreg + 1
          do i = 1, irange
            yfa(i) = gasfun(xi, npar)
            xi = xi + 1
          enddo
	end if
        return 
        end
