        logical function gaseic(string)
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gaseic.f,v 2.23 2005/12/16 16:39:00 friedrich Exp friedrich $
c  this function subroutine makes the energy-, width and
c  efficiency-calibration
c  Friedrich Riess  17.03.93
c---------------------------------------------------------------------------
        implicit none
        character*(*) string

        include 'gasctr.icl'
        include 'gaseic.icl'
        include 'gasfil.icl'
        include 'gastxt.icl'
        include 'gaspea.icl'
        include 'gaspar.icl'
        include 'gasdis.icl'

        integer ITERATIONS
        parameter (ITERATIONS = 12)
        integer DEGDIM
        parameter (DEGDIM = 10)
        integer CALPOINTS
        parameter (CALPOINTS = 200)   ! must be smaller than TOTALPEAKS
        real*8 NORMERROR
        parameter (NORMERROR = 0.0001)
        character*(*) PSWIDTH, PSENERGY, PSEFFIC
        parameter (PSWIDTH = 'width.eps')
        parameter (PSENERGY = 'energy.eps')
        parameter (PSEFFIC = 'efficiency.eps')
        character*(*) FEICDAT
        parameter (FEICDAT = '(9x,a,t30,a,t46''calibration value''t68''residuum'')')

        external polfun, efffun
        real*8 polfun, efffun, fiterror
        real*8 gaseif
        integer  gasein, gaseip, ltext
        logical joinps, da, effic, energy, fwhms, finished, isensw, backstep, savepar
&                , lpout, lpa12, ttout, eicinter
        character file*100,   filename*100, request*8
        integer  i, j, io, ios, ndeg, anzahl, fitlevel, degree, mdegree, datasets, counter
        integer degrees, mdegrees, mdeg
        real*8 chinew, chiold, y, dy, peakmin, peakmax, areamax, dx, dydx, efficmax
        real*8 fiterrave, fiterrvar, priority, prioritys
        real*8 pare(PARTOT), dpare(PARTOT), norm(PARTOT), parsave(PARTOT)
        real*8 varcovare((DEGDIM*(DEGDIM+1))/2)
        real*8 xd(TOTALPEAKS), dxd(TOTALPEAKS), yd(TOTALPEAKS), dyd(TOTALPEAKS)

        file = ' '
        energy = .FALSE.
        effic = .FALSE.
        fwhms = .FALSE.
        gaseic = .FALSE.
        backstep = .FALSE.
        savepar = .TRUE.
        lpout = lpa .and. .not.eicsilent
        lpa12 = isensw(12) .and. lpout
        eicinter = interactiv .and. .not.eicsilent
        ttout = isensw(12) .and. eicinter
        if (string.eq.'energy') then
          file = fileenergy
          energy = .TRUE.
        else if (string.eq.'efficiency') then
          file = fileeffic
          effic = .TRUE.
        else if (string.eq.'width') then
          file = filewidth
          fwhms =.TRUE.
        end if
        if(lpout) write(3,'(/3x,a,'' - calibration: data from ''$)') string
        if(file.eq.'tty' .or. file.eq.' ' .or. file.eq.'TT' .or. file.eq.'tt'
&          .or. file.eq.'SYS$INPUT' .or. file.eq.'sys$input') then
          file = 'TTY'
          if(lpout) write(3,'(''keyboard'')')
        else
          if(lpout) write(3,'(''file ''a)') file(:ltext(file))
        endif
        ndeg = -1
        anzahl = gasein(file, string, ndeg, mdeg, eicinter)
        mdegree = 0
        if(effic) then
          degree = 4
        else if(energy) then
          if(mdeg.eq.-1) ndeg = -1
          degree = 2
          if(ndeg.ge.0) then
            degree = ndeg+1
            mdegree = min(2, max(0, mdeg))
            degree = min(degree + mdeg, DEGENERGY)
          else
            if(eicinter) write(*,'(''  searching for a good polynomial degree''/)')
            if(lpout) write(3,'(''  searching for a good polynomial degree''/)')
          endif
        else
          if(ndeg.ge.0) then
            degree = ndeg + 1
          else
            degree = 2
          endif
        endif
        if(.not.(anzahl.ge.2 .and. degree.le.anzahl)) then
          if(eicinter) write(*, '('' --> GASEIC: Not enough data points for calibration'')')
          if(lpout) write(3, '(''--> GASEIC: Not enough data points for calibration'')')
          return
        endif
c Minimum und maximum x-werte, restrict minimum error  
        peakmin = peak(1)
        peakmax = peak(1)
        areamax = area(1)
        dy = 0.
        do i = 1, anzahl
          if(peakmin.gt.peak(i)) peakmin = peak(i)
          if(peakmax.lt.peak(i)) peakmax = peak(i)
          if(areamax.lt.area(i)) areamax = area(i)
          dy = dy + abs(darea(i))
        enddo
        dy = 0.01*dy / anzahl
        do i = 1, anzahl
          if(abs(darea(i)).lt.dy) darea(i) = dy
        enddo
c number of different datasets for efficiency calibration
        datasets = int(width(anzahl))
c  here starts the calibration
        fitlevel = 0
        counter = 10*ITERATIONS
        chiold = 1.d+10
        chinew = 1.
        prioritys = -100.d+00
        finished = .false.
        gaseic = .TRUE.
        if(display .and. .not.eicsilent) call disclose(1)
        disopen = .FALSE.
        do while(.not.finished)
c  determine starting parameters
          if(fitlevel.eq.0) then
            if(effic) then
              if(eicinter) write(*, '('' ...wait'')')
              do i = 1, DEGEFFI
                pare(i) = 0.
                fixed(i) = .TRUE.
                if(i.gt.2 .and. i.le.degree) fixed(i) = .FALSE.
              enddo
              pare(1) = 0.1
              pare(2) = peakmin
              pare(3) = log10(areamax)
c normalizing factor for the different data sets
              do i = 1, datasets
                pare(DEGDIM+i) = 1.
                norm(i) = 1.
              enddo
              counter = 20*counter
            else
              do i = 1, DEGENERGY
                pare(i) = 0.
                fixed(i) = .TRUE.
                if(i.le.degree+1) fixed(i) = .FALSE. 
              enddo
              pare(2) = area(anzahl)/peak(anzahl)
            endif
          endif         ! if(fitlevel.eq.0)
c save good parameters
          if(savepar) then
            do i = 1, degree
              parsave(i) = pare(i)
            enddo
            savepar = .FALSE.
          endif
c  start with the fitting
          if(effic) then
            if(ttout) then
              write(*,'('' fitlevel: '',i2,''  Parameter:'')') fitlevel
              write(*,'(1x,5(x,e12.5,L1))') (pare(i),.not.fixed(i), i = 1, degree)
            endif
            if(lpa12) then
              write(3,'('' fitlevel: '',i2,''  Parameter:'')') fitlevel
              write(3,'(1x,5(x,e12.5,L1))') (pare(i),.not.fixed(i), i = 1, degree)
            endif
c normalize different datasets
            efficmax = 1.
            do while(efficmax.gt.NORMERROR .and. counter.gt.0)
              chinew = gaseif(efffun, degree, 0, pare, anzahl, varcovare)
              do j = 1, datasets
                pare(DEGDIM+j) = 0.
                dpare(DEGDIM+j) = 0.
              enddo
              do j = 1, anzahl
                y = efffun(peak(j), degree, 0, pare, dydx, deriv)
                dy = area(j)/(darea(j) * darea(j))
                io = int(width(j))
                pare(DEGDIM+io) = pare(DEGDIM+io) + dy * y
                dpare(DEGDIM+io) = dpare(DEGDIM+io) + dy * area(j)
              enddo
              efficmax = 0
              do i = 1, datasets
                if(dpare(DEGDIM+i).gt.0. .and. pare(DEGDIM+i).gt.0.) then
                  pare(DEGDIM+i) = pare(DEGDIM+i) / dpare(DEGDIM+i)
                else
                  pare(DEGDIM+i) = 1.
                endif
                if(i.eq.1) then
                  dx = pare(DEGDIM+i)
                  pare(DEGDIM+i) = 1.
                else
                  pare(DEGDIM+i) = pare(DEGDIM+i)/dx
                endif
                if(abs(pare(DEGDIM+i)-1.).gt.efficmax) efficmax=abs(pare(DEGDIM+i)-1.)
                norm(i) = norm(i)*pare(DEGDIM+i)
c                if(isensw(12)) write(*,'('' dataset'',i2,'' norm'',f10.3)') i, pare(DEGDIM+i)
                counter = counter - 1
              enddo
              do j = 1, anzahl
                io = int(width(j))
                area(j) = pare(DEGDIM+io) * area(j)
                darea(j) = pare(DEGDIM+io) * darea(j)
              enddo
c             write(*,*) ' dnorm ', efficmax, fitlevel, chinew, degree
            enddo   ! while(efficmac.gt.NORMERROR)
            if(ttout) then
              write(*,'(1x,5(x,e12.5,L1))') (pare(i),.not.fixed(i), i = 1, degree)
              write(*,'('' degree:'',i2,'' chi/f = '',f12.6, '' counter = '',i4)')
&                 degree-POLEFFI, chinew, counter
c  allow for inspection
              if(display .and. .not.eicsilent) then
                do i = 1, anzahl
                  io = int(width(i))
                  xd(i) = peak(i)
                  yd(i) = area(i)
                enddo
                call graph(xd, xd, yd, yd, anzahl, 0)
                dx = (peakmax - peakmin) / (CALPOINTS-1)
                do i = 1, CALPOINTS
                  y = peakmin + (i-1)*dx
                  xd(i) = y
                  yd(i) = efffun(y, degree, 0, pare, dydx, deriv)
                enddo
                call graph(xd, xd, yd, yd, CALPOINTS, 1)
                call closegr(-1)
                request = " "
                if(eicinter) then
                  write(*,'('' >''$)')
                  read (*,'(a)') request
                  if(request.eq."s") then
                    texta = PSEFFIC
                    da = joinps(texta, 'graphplt.bak')
                    write(*, '(a,a)') ' Figure saved into ', texta(:ltext(texta))
                  endif
                endif
                if(dissave) then
                  da = joinps(disfile, 'graphplt.bak')
                  write(*, '(a,a)') ' Figure saved into ', disfile(:ltext(disfile))
                endif
                call closegr(0)
              endif  ! if(display)
            endif
            if(lpa12) then
              write(3,'(1x,5(x,e12.5,L1))') (pare(i),.not.fixed(i), i = 1, degree)
              write(3,'('' degree:'',i2,'' chi/f = '',f12.6, '' counter = '',i4)')
&                 degree-POLEFFI, chinew, counter
            endif
c  fitlevel logic: start variation of different parameters
c  first step: add variation point of erfc
            if(fitlevel.le.1)  then
              fixed(2) = .FALSE.
              fitlevel = 1
              savepar = .TRUE.
c 2nd step:
            else if(fitlevel.eq.2) then
c    repeat fitlevel 1 if fit got worse
              if(chinew.lt.0. .or. chinew.gt.chiold) then
                fixed(2) = .TRUE.
                fitlevel = 0
                do i = 1, degree
                  pare(i) = parsave(i)
                enddo
c     else add variation width of erfc
              else
                fixed(1) = .FALSE.
                fitlevel = 2
                savepar = .TRUE.
              endif
c  3rd step: repeat step 1 if fit got worse
            else if(fitlevel.eq.3) then
              if(chinew.lt.0. .or. chinew.gt.chiold) then
                fixed(1) = .TRUE.
                fitlevel = 1
                do i = 1, degree
                  pare(i) = parsave(i)
                enddo
              else 
                fitlevel = 4
                savepar = .TRUE.
              endif
            endif
c further step:
            if(fitlevel.ge.4) then
c stop fit if chisquare is 0
              if(chinew.eq.0) then
                fitlevel = ITERATIONS+1
c  increase degree if chisquare improved
              else if(chinew.gt.0. .and. chinew.le.chiold) then
                if(degree.lt.DEGEFFI .and. .not.backstep) then
                  savepar = .TRUE.
                  i = degree
                  degree = min(degree+1, DEGEFFI)
                  if(ndeg.gt.0) degree = min(degree, POLEFFI+ndeg, DEGEFFI) 
                  if(i .lt. degree) then
                    fixed(degree) = .FALSE.
                    pare(degree) = 0.
                  endif
                endif
c fit got worse, try again
              else
                do i = 1, degree
                  pare(i) = parsave(i)
                enddo
                if(backstep) then
                  fitlevel = ITERATIONS+1
                else
                  fitlevel = fitlevel - 1
                  backstep = .TRUE.
                  if(ndeg.le.0 .and. degree.gt.4) then
                    fixed(degree) = .TRUE.
                    degree = degree-1
                  endif
                endif
              endif
            endif   !   fitlevel-sequence with effic 
            prioritys = 1.
            if(chinew.lt.0.) prioritys = -100.d+00
c look at energy and width calibrations here
          else
            chinew = gaseif(polfun, degree, mdegree, pare, anzahl, varcovare)
            i = degree - 1 - mdegree
            if(ttout) then
              if(energy) then
                write(*,'(''pdeg:'',i2,'' mdeg:'',i2,'' chi/f = '',f10.4$)')  i, mdegree ,chinew
              else
                write(*,'(''degree:'',i2,'' chi/f = '',f10.4$)')  i, chinew
              endif
            endif
            if(lpa12) then
              if(energy) then
                write(3,'(''pdeg:'',i2,'' mdeg:'',i2,'' chi/f = '',f10.4$)')  i, mdegree ,chinew
              else
                write(3,'(''degree:'',i2,'' chi/f = '',f10.4$)')  i, chinew
              endif
            endif
c calculate fiterror: average and variance
            if(energy .and. chinew.gt.0.) then
              dx = (peakmax - peakmin) / (CALPOINTS-1)
              fiterrave = 0.d+00
              fiterrvar = sqrt(chinew)     
              do i = 1, CALPOINTS
                y = peakmin + (i-1)*dx
                dy = polfun(y, degree - mdegree, mdegree, pare, dydx, deriv)
                dxd(i) = fiterrvar*fiterror(degree, deriv, varcovare)
                fiterrave = fiterrave + dxd(i)
              enddo
              fiterrave = fiterrave/CALPOINTS
              fiterrvar = 0.d+00
              do i = 1, CALPOINTS
                y = dxd(i) - fiterrave
                fiterrvar = fiterrvar + y*y
              enddo
              fiterrvar = sqrt(fiterrvar/CALPOINTS)
              if(ttout) write(*, '('' fiterror: <> ='',f8.5,'' var. ='',f8.5$)')
&               fiterrave, fiterrvar
              if(lpa12) write(3, '('' fiterror: <> ='',f8.5,'' var. ='',f8.5$)')
&               fiterrave, fiterrvar
            else
              fiterrave = 1.d+00
              fiterrvar = 1.d+00
            endif
            if(chinew.le.0.) then
              priority = -100.d+00
            else
              priority =  log10(1.d+00/(fiterrave*fiterrvar*chinew*(1.+0.05*degree)))
c              priority =  log10(1.d+00/(chinew))  !*(1.+0.05*degree)))
            endif
            if(ttout) write(*,'('' prority ='',f8.3)') priority
            if(lpa12) write(3,'('' prority ='',f8.3)') priority
            counter = counter - 1
            if(ndeg.lt.0) then
c try to get best polynomial degree
              if(prioritys.lt.priority) then
                prioritys = priority
                degrees = degree
                mdegrees = mdegree
              endif
              if(degree.lt.DEGENERGY) then
                degree = degree + 1
                fixed(degree) = .FALSE.
              else
                degree = degrees
                if(energy) then
                  mdegree = mdegree + 1
                  if(mdegree.eq.3) then
                    mdegree = mdegrees
                    ndeg = degrees
                  else
                    degree = 2 + mdegree
                  endif 
                else
                  ndeg = degrees
                endif
                do i = 1, DEGENERGY
                  pare(i) = 0.
                  if(i.le.degree) then
                    fixed(i) = .FALSE.
                  else
                    fixed(i) =.TRUE.
                  endif
                enddo
                if(ndeg.gt.0) then
                  if(ttout) write(*,'(''adapted:'')')
                  if(lpa12) write(3,'(''adapted:'')')
                endif
              endif
c  degree was specified, stop right away
            else
              finished = .TRUE.
            endif
          endif               ! if(effic)
          if(fitlevel.gt.ITERATIONS) then
            finished = .TRUE.
            if(prioritys.eq.-100.d+00) then
              if(eicinter) write(*, '('' --> GASEIC: No fit to this dataset possible'')')
              if(eicinter) write(3, '('' --> GASEIC: No fit to this dataset possible'')')
              finished = .TRUE.
              gaseic = .FALSE.
            endif
          endif
          fitlevel = fitlevel + 1
          if(counter.le.0) then
            finished = .TRUE.
            gaseic = .TRUE.
            if(eicinter) write(*,'('' fit stopped: too many iterations'')')
          endif
          if(chinew.ge.0 .and. chinew.le.chiold) chiold = chinew
        enddo                 !  do while(.not.finished)
c  there was no fit possible if ndeg = 0
        i = 1
        if(effic) i = POLEFFI
        ndeg = degree-i - mdegree
        i = 1
        if(fwhms) i = 0
        if(ndeg.lt.i .and. gaseic) then
          write(*, '('' -->GASEIC: No fit possible'')')
          gaseic = .FALSE.
        else 
          if(gaseic .and. .not.eicsilent) then
            write(*,'('' degree:'',i4$)') ndeg
            if(energy) write(*,'(i4$)') mdegree
            write(*,'(''            chi/f = '',f9.3)') chinew
          endif
        endif
        if(effic .and. isensw(12))  write(*,'(i3,'' datasets with norms:'',10g12.6)') 
&            datasets, (norm(i), i = 1, datasets)
c  put input data onto disk if from terminal and data point okay
        if(file.eq.'TTY' .and. gaseic) then
          filename = ' '
          write(*,'('' output filename: ''$)')
          read (*,'(a)', IOSTAT = io) filename
          if(io.ne.(-1)) then
            if(filename.eq.' ') then
              if(energy) then
                filename = 'gasenergy.eic'
                fileenergy = filename
              else if(effic) then
                filename = 'gaseffic.eic'
                fileeffic = filename
              else
                filename = 'gaswidth.eic'
                filewidth = filename
              end if
            endif
            open(unit=1, file=filename, status='unknown', iostat = ios)
            if(ios.ne.0) then
              write(*, '('' -->GASEIC: Error in opening output file: '',a)') filename(1:ltext(filename))
              gaseic = .false.
              return
            endif
            texta='.'
            write(*,'('' comments: '')')
            do while(texta.ne.' ')
              write(*, '('' CAL> ''$)')
              read(*,'(a)', IOSTAT = io) texta
              if(io.eq.(-1)) texta = ' '
              if(ltext(texta).gt.0) write(1,'(x,a)') texta(:ltext(texta))
            end do
            write(1,'('' degree:'',i5)') ndeg
            do i = 1, anzahl
              if(i.gt.1) then
                if(width(i).gt.width(i-1)) write(*, '('' next data set:'')')
              endif
              if(effic) then
                write(1,'(4(g12.6))') peak(i), dpeak(i), area(i), darea(i)
              else
                write(1,'(4(f12.3))') peak(i), dpeak(i), area(i), darea(i)
              endif
            end do
            close(unit=1)
            write(*, '('' data saved into file '',a)') filename(:ltext(filename))
          end if       ! if(io.ne.-1)
        end if         ! if(file.eq.'TTY')
c  Ausgabe auf Drucker file
        if(lpout .and. gaseic) then
c          if(energy) write(3,'('' Energy Calibration from file ''a)')  fileenergy
          if(effic) then
            write(3,'('' Efficiency Calibration from file ''a)')  fileeffic
            write(3,'(i3,'' datasets with norms:'',10g12.6)') datasets, (norm(i), i = 1, datasets)
          endif
c          if(fwhms) write (3,'('' Width calibration from file ''a)') filewidth
          i = degree - 1
          if(energy) i = i - mdegree
          write (3,'('' degree: ''i4$)') i
          if(energy) write(3,'(i4$)') mdegree
          write(3,'(''           chisqr/f: ''f9.3)') chinew
          if(energy) then
            write(3,'('' polynomial: ''$)')
            do i = 1, degree
              if(i.eq.1) then
                write(3,'(f9.4$)') pare(i)
              else if(I.eq.2) then
                write(3,'(f12.8,''*x''$)') pare(2)
              else if(i.le.degree - mdegree) then
                write(3,'(2x,e14.6''*x^''i1$)') pare(i), i - 1
              else
                write(3,'(2x,e14.6''/x^''i1$)') pare(i), i - degree + mdegree
              endif
            enddo
            write(3,'(x)')
          else
            write (3,'('' coefficients: '',8e14.6)') (pare(i),i=1, degree)
          endif
          if (energy) write (3, FEICDAT) 'channel','energy'
          if (effic) write (3, '(9x,''energy'',t35,''efficiency'',t56''calibration value''t78''residuum'')')
          if (fwhms) write (3, FEICDAT) 'channel', '  width'
          do i=1, anzahl
            if(effic) then
              y = efffun(peak(i), degree, 0, pare, dydx, deriv)
              dy = 0.
            else
              y = polfun(peak(i), degree - mdegree, mdegree, pare, dydx, deriv)
              dy = dpeak(i)*dydx
            endif
            dydx = fiterror(degree, deriv, varcovare)
            dy = sqrt(dy*dy + dydx*dydx)
            dydx = (area(i)-y)/sqrt(dy*dy+darea(i)*darea(i)) 
            if(effic) then
              write (3,'(f12.3'' +/-''f8.3, 2(f12.4'' +/- ''f8.4), f10.4)') peak(i), dpeak(i), 
&                  area(i), darea(i), y, dy, dydx
            else
              write (3,'(f10.3'' +/- ''f6.3, 2(f10.3'' +/- ''f6.3), f10.3)') peak(i), dpeak(i), 
&                  area(i), darea(i), y, dy, dydx
            endif
          end do
          write(3, '(x)')
        end if       ! if(lpout)
c  copy coefficients into calibration arrays
        if(gaseic) then
          if(energy) then
            nde = gaseip(degree, pare, varcovare, aes, daes)
            ndem = mdegree
          endif
          if(effic)  ndf = gaseip(degree, pare, varcovare, afs, dafs)
          if(fwhms)  ndw = gaseip(degree, pare, varcovare, aws, daws)
        endif
c  display data and fit
        if(display .and. .not.eicsilent) then
          io = 0
c display of data and fitcurve is only interesting for efficiency calibrations
          if(effic .or. fwhms) then
            call graph(peak, dpeak, area, darea, anzahl, 0)
c berechne fit werte gleichmaessigverteilt ueber den Bereich
            if(gaseic) then
              dx = (peakmax - peakmin) / (CALPOINTS-1)
              efficmax = 0
              do i = 1, CALPOINTS
                y = peakmin + (i-1)*dx
                xd(i) = y
                if(effic) then
                  yd(i) = efffun(y, degree, 0, pare, dydx, deriv)
                  if(yd(i).gt.efficmax) efficmax = yd(i)
                else
                  yd(i) = polfun(y, degree - mdegree, mdegree, pare, dydx, deriv)
                endif
              enddo
              call graph(xd, xd, yd, yd, CALPOINTS, 1)
            endif
            if(effic) then
              call graphlabel('energy', 'eff', 'efficiency')
            else
              call graphlabel('channel', 'fwhm', 'Width calibration')
            endif
            call closegr(-1)
            if(eicinter) then
              write(*,'(a,$)') ' <cr> to continue, s to save: '
              read(*,'(a1)') request
              if(request .eq.'s') then
                if(effic) then
                  texta = PSEFFIC
                else
                  texta = PSWIDTH
                endif
                da = joinps(texta, 'graphplt.bak')
                write(*, '(a,a)') ' Figure saved into ', texta(:ltext(texta))
              endif
            endif
            if(dissave) then
              da = joinps(disfile, 'graphplt.bak')
              write(*, '(a,a)') ' Figure saved into ', disfile(:ltext(disfile))
            endif
            call closegr(0)
          endif
          if(.not.gaseic) return
c display difference to fit
          do i = 1, anzahl
            xd(i) = peak(i)
            if(effic) then
              xd(i) = peak(i)
              y = efffun(peak(i), degree, 0, pare, dydx, deriv)
            else
              y = polfun(peak(i), degree - mdegree, mdegree, pare, dydx, deriv)
            endif
            yd(i) = area(i) - y
            dydx = dydx * dpeak(i)
            dyd(i) = sqrt(darea(i)*darea(i) + dydx * dydx) 
          enddo
          call graph(xd, xd, yd, dyd, anzahl, 0)
          if(energy) call graphlabel("channel", "dE", "difference from fit")
          if(effic) call graphlabel("energy", "deff", "difference from fit")
          if(fwhms) call graphlabel("channel", "dFWHM", "difference from fit")
          call closegr(-1)
          if(eicinter) then
            write(*,'(a,$)') ' <cr> to continue, s to save: '
            read(*,'(a1)') request
            if(request .eq.'s') then
              if(effic) then
                texta = PSEFFIC
              else if(energy) then
                texta = PSENERGY
              else
                texta = PSWIDTH
              endif
              da = joinps(texta, 'graphplt.bak')
              write(*, '(a,a)') ' Figure saved into ', texta(:ltext(texta))
            endif
          endif
          if(dissave) then
            da = joinps(disfile, 'graphplt.bak')
            write(*, '(a,a)') ' Figure saved into ', disfile(:ltext(disfile))
          endif
          call closegr(0)
c  show firror
          if(effic.or.energy) then
            dx = (peakmax - peakmin) / (CALPOINTS-1)
            do i = 1, CALPOINTS
              y = peakmin + (i-1)*dx
              xd(i) = y
              if(effic) then
                yd(i) = efffun(y, degree, 0, pare, dydx, deriv)
              else
                yd(i) = polfun(y, degree - mdegree, mdegree, pare, dydx, deriv)
              endif
              dxd(i) = fiterror(degree, deriv, varcovare)
              if(effic) then
                if(dxd(i).gt.efficmax) dxd(i) = efficmax
                if(dxd(i).lt.-efficmax) dxd(i) = -efficmax
              endif
            enddo
            call graph(xd, xd, dxd, dxd, CALPOINTS, 1)
            if(effic) then
              call graphlabel("energy", "deff", "fiterror for efficiency calibration")
            else
              call graphlabel("channel", "dE", "fiterror for energy calibration")
            endif
            call closegr(-1)
            if(eicinter) then
              write(*,'(a,$)') ' <cr> to continue, s to save: '
              read(*,'(a1)') request
              if(request .eq.'s') then
                if(effic) then
                  texta = PSEFFIC
                else
                  texta = PSENERGY
                endif
                da = joinps(texta, 'graphplt.bak')
                write(*, '(a,a)') ' Figure saved into ', texta(:ltext(texta))
              endif
            endif
            if(dissave) then
              da = joinps(disfile, 'graphplt.bak')
              write(*, '(a,a)') ' Figure saved into ', disfile(:ltext(disfile))
            endif
          endif
          call closegr(0)
        endif        ! if(display .and. .not.eicsilent)

        return
        end



