
	logical function gasfil()
c  $Id: gasfil.f,v 2.6 2004/06/18 16:35:05 friedrich Exp $
c  this function reads a filename either from the string filesave
c  or from input
c  the filename might have the following structure:
c    filename
c    filename,n           (n = number of subspectrum)
c    filename,n1,n2       (n1, n2 = first and last subspectrum)
c    filename,n1,n2,ni    (ni = increment)
c    @filename            (filenames are supposed to be in the file 'filename')
c               13.05.93: -99999 bei leerem Spektrum
c  last Version 22.04.93: file format
c  F. Riess

	implicit none

	character FFILFNP*40
	parameter (FFILFNP = '('' --> GASFIL: file not present: ''a)')

	include 'gasctr.icl'
	include 'gasfil.icl'
        include 'gasspe.icl'

	logical rep, da, extens, firstcall, cancelfit
	character filedummy*132, filesave*132
	integer substr, ltext, gasspc
        integer lastnum, incrnum
        integer pointer, kanal
	integer i, j, k, ios, iostatus
        data firstcall /.true./, pointer /0/, kanal /13/, lastnum /-1/

	gasfil=.false.
c  if control C has been given, stop at ones
	if (.not.cancelfit(1)) then
	   rep=.true.
	   do while(rep)
	      maxsp=0
	      lastch=0
c  first call: check for existence of filename
	      if(firstcall)then
                 filesave = filestring
c  ..not existent: read it
                 do while (ltext(filesave).eq.0)
                    if(dskspe) write(*,'('' Filename, first and last slice, increment: ''$)')
                    if(.not.dskspe) write(*,'('' Filename [first and last subspectrum, increment]: ''$)')
	            read(*,'(a)', IOSTAT = iostatus)filesave
	            if (iostatus.eq.(-1)) return
                 enddo
                 if(filesave(1:1) .eq. '@') then
c  indirekt mode: open file and get filename
                    i = ltext(filesave)
                    open(unit=kanal, file=filesave(2:i), status='old', iostat = iostatus)
                    if(iostatus.ne.0) then
                       write(*, FFILFNP) filesave(2:i)
                       return
                    else
                       read(kanal, '(a)', iostat = iostatus) filedummy
                       pointer = pointer + 1
                       if(iostatus .eq. (-1)) then 
                          write(*, '('' --> GASFIL: File '',a,'' is empty'')') filesave(2:i)
                          filedummy = ' '
                       endif
                    endif
                 else
                    filedummy = filesave
                 endif
                 firstcall = .false.
              else
c  else: if indirect read next filename
                 if(pointer.gt.0 .and. lastnum.eq.(-1)) then
                    read(kanal, '(a)', IOSTAT = iostatus) filedummy
                    pointer = pointer + 1
                    if(iostatus .eq. (-1)) filedummy = ' ' 
                 else
                    filedummy = filesave
                 endif
              endif
              rep = pointer.gt.0
              if(ltext(filedummy).eq.0) then
                 if(iostatus.eq.(-1)) then
                    rep = .false.
                    files = ' '
                 endif
              else
c  check for subspectra
                 if(lastnum .eq. (-1)) then
                    i = substr(filedummy, files)
                    i = 1
                    j = 1
                    k = 1
                    if(ltext(filedummy).gt.0) read(filedummy, *, IOSTAT = ios) i, j, k
                    nroute = max(1, i)
                    lastnum = max(1, j)
                    incrnum = max(1, k)
	         else
                    nroute = nroute + incrnum
                    if(nroute.gt.lastnum) then
                       files = ' '
                       lastnum = -1
                    endif
                 endif
              endif
c check if filename is existant
	      if(files.ne.' ') then
c check for data format
                fileformat = filesformat
                if(fileformat.eq.0) then
c get data format from extension
                  if(extens(files, ' ')) then
                    j = ltext(files)
                    if(files(j-1:j).eq.'.Z') then
                      j = j - 2
                    else if(files(j-2:j).eq.'.gz') then
                      j = j - 3
                    endif
                    do i = 1, FIFORMAT
                       k = ltext(extformat(i))
                       if(files(j+1-k:j).eq.extformat(i)(1:k)) fileformat = i
                    enddo
c                    if(dskspe) fileformat = -fileformat
                  endif
c                else
c data format has been explicitly defined, set extension if none is given
c                  if(.not.extens(files, ' ')) then
c                    filedummy = extformat(abs(fileformat))
c                    da = extens(files, filedummy(:ltext(filedummy)))
c                  endif
                endif
c sorry: undefined fileformat
                if(fileformat.eq.0.) then
                  write(*,'(a,a)') ' unknown data format in file: ', files(:ltext(files))
                  return
                endif
                if(dskspe) fileformat = -fileformat
c check if file is present
                inquire(file = files(:ltext(files)), exist = da)
                if(.not.da) then
                  write(*, FFILFNP) files(:ltext(files))
                else
c check for length of spektrum and if subspectrum is present
                  lastch = 1
                  i = DEFMINCH
                  j = lastch
                  do while(lastch.eq.j)
                    j = i + SPELEN - 1
                    lastch = gasspc(i, j, files, spek)
                    i = j + 1
                  enddo
                  if(lastch.gt.0) then
c  copy back into input string
                    filestring = filesave
                    gasfil=.true.
	            rep=.false.
                  else
                    if(lastch.eq.(-99999)) then
                      rep = .true.
                    else
                      lastnum = -1
                    endif
                  endif
                endif
	      endif
	   end do
	endif
c cleanup if finished
        if(.not.gasfil) then
           firstcall = .true.
           lastnum = -1
           if(pointer.ne.0) then
              pointer = 0
              close(unit = kanal)
           endif
        endif
        end


