	subroutine gaspar
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gaspar.f,v 2.30 2005/02/10 19:00:51 friedrich Exp friedrich $
c  routine determines the starting values of the parameters
c  25.02.00  spekerr included
c  11.09.86  vax version
c  30.06.79  f. riess
c  AREACONSTANTE = 1./sqrt(pi)
c------------------------------------------------------------------
	implicit none

        real*8 TAILTHRESHOLD
        parameter (TAILTHRESHOLD = 0.70)
	character*(*) FPARTAILC
        parameter (FPARTAILC = '(x,a,f6.2$)')
        character*(*) FGASPAR
        parameter (FGASPAR = ' GASPAR: ')

	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfit.icl'
	include 'gaspar.icl'
	include 'gaspea.icl'

	logical taillv, tailrv, tailbv, lstepv, fittail, lpout, isensw, da
	integer i, i1, i2, ierr, j, ja, jc, jw, jj, l, m, n, nb1, nbm, ntau
        integer jwc
	real*8 gasfun, getstk, poly
	real*8 sum1, sume, ampv, amppv, fwhmv, x, x1, x2, y
	real*8 wx(20), wy(20), wp(6)

c  set all parameters to novariation mode
        lpout = lpa .and. isensw(6)
	do i = 1, PARTOT
	  fixvorgabe(i) = .TRUE.
	  par(i) = 0.d+00
	  parc(i) = 0.d+00
	end do
c  setup for centroid, amplitude, width and tail condition
        taillv = (taill .and. (fitltail .or. taillrange.ge.0.01))
	tailrv = (tailr .and. (fitrtail .or. tailrrange.ge.0.01))
	tailbv = (tailb .and. (fitbtail .or. tailbrange.ge.0.01))
	lstepv = (lstep .and.  fitlstep)
	fittail = taillv .or. tailrv .or. tailbv .or. lstepv
	tail = tailenforced .and. fittail
	l = linepo+1
        if(fittail .and. lpout) write(3, '(a,''  check for contributions to tail ''
     $   ''variation (threshold > ''f5.3'')'')') FGASPAR, TAILTHRESHOLD
c  centroid
        cenrange = 0.d+00
        call setpointers(kpeaks)
        jc = poscen
        ja = posarea
        jwc = poscwidth
        jw = poswidth
	do j = 1, kpeaks
	  parc(jc) = peak(l)
	  if(.not.(poscon .or. (peaklist .and. dpeak(l).le.0.)))  fixvorgabe(jc) = .FALSE.
c  width
          if(widthlist) then
	    fwhmv = abs(width(l))
	  else
	    fwhmv = poly(peak(l),ndw,aws)
	  end if
	  parc(jwc) = WIDTHCONSTANTE*fwhmv
          if(.not.(fwhmrange.le.0. or. (widthlist .and. width(l).lt.0.))) fixvorgabe(jw) = .FALSE.
          cenrange = cenrange + parc(jwc)
c  amplitude
	  amppv = AREACONSTANTE*area(l)/parc(jwc)
	  par(ja) = sqrt(amppv)
	  if(darea(l).gt.0.) fixvorgabe(ja) = .FALSE.
c  if there are tails, check if peaks are strong enough for
c  a tail variation
	  m = parc(jc) + 1.5 - minreg
          n = 1.5*fwhmv + 0.5
          if(fittail .and. lpout) write(3, '(11x,''peak at'',f9.1$)') parc(jc)
c          if(fittail) write(*, '(9x,''peak at'',f9.1,f14.1$)') parc(jc), area(l)
	  if(taillv) then
            ntau = min(1., poly(parc(jc), max(1, ntauleft), tauleft)) + 0.5
            i2 = max(1, m - n)
            i1 = max(1, i2 - ntau)
            x1 = weight(i1)
            sume = 0.
            do i = i1, i2
              if(weight(i).gt.1.2*x1) then
                 sume = sume + x1*x1
              else
                sume = sume + weight(i)*weight(i)
              endif
              x1 = min(x1, weight(i))
            enddo
            sume = sqrt(sume)/(i2 - i1 +1)
	    ampv = max(1.d-30, poly(parc(jc), max(1, nampleft), ampleft))
            ampv = amppv*ampv/(1.+ampv)
            if(sume.gt.0.) then
              x = min(9.99, max(-9.99, log10(ampv/sume)))
            else 
              x = -9.99
            endif
            tail = tail .or. x.gt.TAILTHRESHOLD
            if(lpout) write(3, FPARTAILC) 'left peak tail ', x                                     
          endif
	  if(tailrv) then
            ntau = min(1., poly(parc(jc), max(1, ntauright), tauright)) + 0.5
            i1 = min(irange, m + n)
            i2 = min(irange, i1 + ntau)
            x1 = weight(i1)
            sume = 0.
            do i = i1, i2
              if(weight(i).gt.1.2*x1) then
                 sume = sume + x1*x1
              else
                sume = sume + weight(i)*weight(i)
              endif
              x1 = min(x1, weight(i))
            enddo
            sume = sqrt(sume)/(i2 - i1 +1)
	    ampv = max(1.d-30, poly(parc(jc), max(1, nampright), ampright))
            ampv = amppv*ampv/(1.+ampv)
            if(sume.gt.0.) then
              x = min(9.99, max(-9.99, log10(ampv/sume)))
            else 
              x = -9.99
            endif
            tail = tail .or. x.gt.TAILTHRESHOLD
            if(lpout) write(3, FPARTAILC) 'right peak tail', x                                     
          endif
	  if(tailbv) then
            ntau = max(1., poly(parc(jc), max(1, ntauback), tauback)) + 0.5
            i2 = max(1, m - n)
            i1 = max(1, i2 - ntau)
            x1 = weight(i1)
            sume = 0.
            do i = i1, i2
              if(weight(i).gt.1.2*x1) then
                 sume = sume + x1*x1
              else
                sume = sume + weight(i)*weight(i)
              endif
              x1 = min(x1, weight(i))
            enddo
            sume = sqrt(sume)/(i2 - i1 +1)
	    ampv = max(1.d-30, poly(parc(jc), max(1, nampback), ampback))
            ampv = amppv*ampv/(1.+ampv)
            if(sume.gt.0.) then
              x = min(9.99, max(-9.99, log10(ampv/sume)))
            else 
              x = -9.99
            endif
            tail = tail .or. x.gt.TAILTHRESHOLD
            if(lpout) write(3, FPARTAILC) 'background tail', x                  
          endif
	  if(lstepv) then
            ntau = 3*fwhmv
            i2 = max(1, m - n)
            i1 = max(1, i2 - ntau)
            x1 = weight(i1)
            sume = 0.
            do i = i1, i2
              if(weight(i).gt.1.2*x1) then
                 sume = sume + x1*x1
              else
                sume = sume + weight(i)*weight(i)
              endif
              x1 = min(x1, weight(i))
            enddo
            sume = sqrt(sume)/(i2 - i1 +1)
	    ampv = max(1.d-30, poly(parc(jc), max(1, nampstep), ampstep))
            ampv = amppv*ampv/(1.+ampv)
            if(sume.gt.0.) then
              x = min(9.99, max(-9.99, log10(ampv/sume)))
            else 
              x = -9.99
            endif
            tail = tail .or. x.gt.TAILTHRESHOLD
            if(lpout) write(3, FPARTAILC) 'step function', x                                     
          endif
c             write(*, '(f8.2,i6,3f10.2)') x, i2 - i1 + 1, x1, amppv, ampv
          if(fittail .and. lpout) write(3,'(x)')
	  l = l + 1
          jc = jc + 1
          ja = ja + 1
          jwc = jwc + 1
          if(ELEMENTS.gt.2) jw = jw + 1
	end do

	lineps = linepo
	linepo = linepo+kpeaks
	npar = pospole
        cenrange = cenrange/kpeaks
c .. and medium channel of fit range
	parc(pospolm) = minreg + irange/2  
c  reset all background and tail parameters:
c  peak tail left
	if (taill) then
	  npar = max(npar, postlw, postla)
c if tail is to be varied: reset parameter
c otherwise keep it from previous fit
          if(tail) then
            fampleft = 1.
            ftauleft = 0.
	  end if
c if decay parameter not to be varied: parameter is zero
c note: the actual values are defined in gasfun
	  fixvorgabe(postla) = .not.(tail .and. fitltail)
	  par(postla) = fampleft 
	  fixvorgabe(postlw) = .not.(tail .and. taillrange.ge.0.01)
          if(taillrange.eq.0.) ftauleft = 0.
	  par(postlw) = ftauleft
	  parc(postlw) = taillrange
	end if
c  background tail
	if(tailb)then
	  npar = max(npar, postbw, postba)
          if(tail) then
            fampback = 1.
            ftauback = 0.
	  end if
	  fixvorgabe(postba) = .not.(tail .and. fitbtail)
	  par(postba) = fampback 
	  fixvorgabe(postbw) = .not.(tail .and. tailbrange.ge.0.01)
          if (tailbrange.eq.0.) ftauback = 0.
	  par(postbw) = ftauback
	  parc(postbw) = tailbrange
	end if
c  peak tail right
	if(tailr)then
	  npar = max(npar, postrw, postra)
          if(tail) then
            fampright = 1.
            ftauright = 0.
	  end if
	  fixvorgabe(postra) = .not.(tail .and. fitrtail)
	  par(postra) = fampright 
	  fixvorgabe(postrw) = .not.(tail .and. tailrrange.ge.0.01)
          if (tailrrange.eq.0.) ftauright = 0.
	  par(postrw) = ftauright
	  parc(postrw) = tailrrange
	end if
c  step
	if(lstep)then
	  npar = max(npar, possta)
          if(tail) fampstep = 1.
	  par(possta) = fampstep 
	  fixvorgabe(possta) = .not.(tail .and. fitlstep)
	end if
c  get parameters for the background
c  first subtract contributions from the peaks
	do i=1,PARTOT
	  fixed(i)=.true.
	end do
        x1 = 0.
c determine minimum of spectrum including  statistical error
        do i = 1, irange
          x1 = min(x1, ya(i) - 3*weight(i))
        enddo
        da = .true.
        do while(da)
 	  x = minreg
	  sum1 = 0.
          sume = 0.
          n = 0
          x2 = x1
	  do i=1,irange
	    y = gasfun(x,npar)
	    yfa(i) = ya(i) - y
c	  resi(i)=abs(ya(i))+abs(y)+10.
            resi(i) = weight(i)*weight(i)
	    sum1 = sum1 + yfa(i)
            sume = sume + weight(i)*weight(i)
            if(x2.gt.yfa(i) + 3*weight(i)) then
              x2 =  yfa(i) + 3*weight(i)
              n = i
            endif
	    x = x + 1.
	  end do
c the peak amplitudes are too large, decrease them
          if(n.gt.0) then
            x = sqrt((ya(n) -  x1)/(ya(n) - x2))
            if(lpout) write(3, '(a,''  peak amplitude parameters too large, decreased
            1 by factor '',f10.4)') FGASPAR, x	    
            do i = 1, kpeaks
              par(i +posarea -1) = x*par(i + posarea -1)
            enddo
          else
            da = .false.
          endif
        enddo
	sum1 = sum1/irange
	sume = sqrt(sume/irange)
c  get the degree of the background polynomial if not specified yet:
c  The estimate steems from the number of peaks in the fitregion and the
c     statistics of the background
	if(backdeg.lt.0) then
          if(backpol.ge.0) then
            backdeg = backpol 
          else
            if(backdeg.lt.0.) then
              x1 =  kpeaks*wids
              x1 = sqrt(sqrt(max(0.0001,(irange  - x1)/(3.*x1))))
              x2 = 2.*log10(max(0.1, sum1/sume))
	      backdeg = max(0., min(-backpol, x1 + x2))
	      if(lpout) write(3, '(a,''  Contributions to the degree of the background
	1 polynomial. range:'',f8.3,'' statistics:'',f10.3)') FGASPAR, x1, x2
            endif
          endif
	endif
c  determine coefficients of polynomial by a fit to the difference spectrum
        if(.not.backfixed) then
	  nb1=backdeg+1
	  nbm=(nb1*(nb1+1))/2
	  do i=1,nbm
	    wx(i)=0.
	    wy(i)=0.
	  end do
	  x=-(irange/2)
	  do i=1,irange
	    y=yfa(i)
	    x1=1./resi(i)
	    l=0
	    do j=1,nb1
	      wy(j)=wy(j)+y*x1
	      x2=1.
	      do jj=1,j
	        l=l+1
	        wx(l)=wx(l)+x1*x2
	        x2=x2*x
	      end do
	      x1=x1*x
	    end do
	    x=x+1.
	  end do
	  ierr=1
	  do while (ierr.ne.0)
	    if(nb1.eq.1) then
	      wx(1)=1./wx(1)
	      ierr=0
	    else
	      call dsinv(wx,nb1,1.d-10,ierr)
	      if(ierr.ne.0)nb1=nb1-1
	    end if
	  end do
	  do j=1,nb1
	    jj=j-1
	    l=(j*jj)/2
	    y=0.
	    do i=1,nb1
	      l=l+1
	      if(i.gt.j)then
	        l=l+jj
	        jj=jj+1
	      end if
	      y=y+wy(i)*wx(l)
	    end do
	    nbm=(j*(j+1))/2
	    if(abs(y).lt.sqrt(wx(nbm)))y=0.
	    wp(j)=y
	    par(pospol + j - 1) = y
	  end do
	  do i=0, backdeg
	    fixvorgabe(i + pospol) = .false.
	  end do
	else
	  par(pospol) = backvalue
	endif
c  the statistical weight is determined by smoothing, the number of
c  smoothing channels depends on the peak width
c note: parc(pospole) is needed by gasdis
        jwc = poscwidth
        if(ELEMENTS.gt.2) then
          parc(pospole) = max (1., min (4., cenrange))
        else
          parc(pospole) = max(1., min(4., 0.4*(parc(jwc) + parc(jwc + kpeaks - 1))))
        endif
	tinp = 1.
	if (nonestat) tinp = getstk(1, irange, ya, weight)
	tinp = tinp**2
        i = 0
        if(smootherror) i = nint(parc(pospole))
	call gasweight(irange, weight, weight, i, tinp)
        if(lpout) call gasfou(par, fixvorgabe, 0)
	return
	end
