	subroutine gasval(chisq, withoutput, witherror)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $Id: gasval.f,v 2.54 2005/03/02 16:05:23 friedrich Exp friedrich $
c  this subroutine calculates the peak values from the parameters
c  28.06.79 F. Riess
c  change: 27.11.92: allow for negativ energie slopes in fwhm
c  change  14.05.93: add dwidth in output
c  change: 01.06.94:  correct error in centroid calculation of tails
c          01.03.00: variable output format to accomodate fractional
c                    peak areas and intensities
c------------------------------------------------------------------
	implicit none
	real*8 chisq
	logical withoutput, witherror

c  sollte # der Linie sein bzw. 0 falls keine test Ausgabe 
        integer TESTOUT
        parameter (TESTOUT = 0)
	real*8 SQRTPI
	parameter (SQRTPI = 1.7724538509055161d+0)
	real*8 SQRPIP
	parameter (SQRPIP = 0.5d+0 + 1.d+0/SQRTPI)
        real*8 LIMIT
        parameter (LIMIT = 1.)
        real*8 OUTL
	parameter (OUTL = 99.999d+0)
	character *(*) FVALPALA, FVALPASM
	parameter (FVALPALA='(''--> input value too large'')')
	parameter (FVALPASM='(''--> input value too small'')')
	character *(*) FVALBACKA, FVALBACKP, FVALBACKC
	parameter (FVALBACKA='(/4x,''background area:'',a/)')
        parameter (FVALBACKC='(4x,''a('',i1,'') ='',a,''   ''$)')
        parameter (FVALBACKP='(/4x,''background polynomial y(x) = sum a(i)*(x-xo)^i, xo ='',f9.1)')
	character *(*) FGASGSPB
	parameter (FGASGSPB = '(''R'',i12,i7,i10,i10,f17.3)')
	character *(*) FGASGSPA
	parameter (FGASGSPA = '(''T''a,a$)')
	character *(*) FGASGSPT
	parameter (FGASGSPT = '(5x,a)')
	character *(*) FGASGSP1
        parameter (FGASGSP1 = '(x,f12.3,f7.3$)')
	character *(*) FGASGSP2
        parameter (FGASGSP2 = '(x,a$)')
	character *(*) FGASGSP3
        parameter (FGASGSP3 = '(x,f7.3,f7.3$)')
c	character *(*) FVALPEAKT
c	parameter (FVALPEAKT='(19x,''#'',9x,''centroid'',19x,''peak area'',14x,3(x,a,x))')
	character *(*) FVALFWHM, FVALTAILA, FVALTAILT, FVALAWARN
        parameter (FVALFWHM= '(28x,''fwhm'',9x,a$)')
	parameter (FVALTAILA='(4x,a'' rel. ampl. '',a$)')
        parameter (FVALTAILT='('' decay const. '',a$)')
        parameter (FVALAWARN = '(9x''--> Warning: amplitude > 2, consider options set par -''
     $   a''(10.,xxx) and set tail -nofit=''a)')

	include 'gasctr.icl'
	include 'gaseic.icl'
	include 'gasfil.icl'
	include 'gaspar.icl'
	include 'gaspea.icl'
	include 'gasspe.icl'

        integer indexm
        logical da, errorout
	character asctl(3)*12
        character outform*132
	integer gaserr, equalexp, ltext
        integer la(8), lc1
	integer i, j, ja, jc, jw, jwc, l, n, nl1, nderiv, nftail
	real*8 dpoly, poly, efffun, polfun, fiterror
        real*8 dyda(15), en, den, enwi, endwi, in, din
	real*8 gasfun, parlim, pcos, psin
	real*8 af, cmkor, crange, dgamma, dx, f, parlimm, parlimp,
	1 gamma, sb, sb2, x, y
        real*8 damp, vampr, vampl, vampb, dtau, vtaur, vtaul, vtaub, vamps, areamax
        real*8 dvampr, dvampl, dvampb, dvamps, dvtaur, dvtaul, dvtaub
	real*8 aderiv(8), caderiv(8), ftail(4,PEAKTOT)
	real*8 daf2, dpc2, dpw, ddz, x1, x2, xx

c initialize error variables
        dvtaul = 0.d+00
        dvtaur = 0.d+00
        dvtaub = 0.d+00
        dvampl = 0.d+00
        dvampr = 0.d+00
        dvampb = 0.d+00
        dvamps = 0.d+00
        areamax = 0.d+00
c  get peak centroids and areas
        ja = posarea
        jc = poscen
        jw = poswidth
        jwc = poscwidth
	do j = 1, kpeaks
          errorout = j.eq.TESTOUT .and. witherror .and. withoutput .and. lpa
c          if(errorout) then
c            write(3, '(/'' Varianz-Kovarianzmatrix (kpeaks, npar): ''2i5)') kpeaks, npar
c            call outmatrix(npar, varcovar)
c          endif
	  gamma = parc(jwc)*abs(1.d+00 + fwhmrange*psin(par(jw)))
	  dgamma = parc(jwc)*fwhmrange
	  peakwidth(j) = gamma/WIDTHCONSTANTE
	  dpeakwidth(j) = 0.5d+00*dgamma*(psin(par(jw) + dpar(jw)) -
          1  psin(par(jw) - dpar(jw)))/WIDTHCONSTANTE
	  dgamma = dgamma*pcos(par(jw))
c  the array ader stores the derivatives for calculating the error
c  of the peak area
	  aderiv(1) = gamma*SQRTPI
	  aderiv(2) = SQRTPI
          if(errorout) write(3,'(/''peak #'',i3'' at ''f7.1,
     $      '' da/dpa: aderiv(1), da/dpg: aderiv(2):'', 2f10.5$)') j, parc(j), aderiv(1), aderiv(2)
          if(posall) then
            crange = cenrange
          else
            crange = parc(jwc)
          endif
	  caderiv(1) = crange*pcos(par(jc))
          caderiv(2) = 0.d+00
          cmkor = 0.d+00
	  la(1) = ja
	  la(2) = jw
          lc1 = j
	  nderiv = 2
c  tails
	  nftail=0
	  if(taill) then
            dtau = poly(parc(jc), max(1, ntauleft), tauleft)
            vtaul = dtau*(1.0d+00 + parc(postlw)* psin(par(postlw)))
            vtaul = max(0.1d+00, vtaul)
            damp = poly(parc(jc), max(1, nampleft), ampleft)
            vampl = damp*par(postla)**2
	    sb = gamma/vtaul
	    f = 0.d+00
	    sb2 = sb**2
            if(sb2.lt.64.d+00) f = par(postla)*damp*exp(-0.25d+00*sb2)
	    y = par(postla)*f
	    nftail = nftail + 1
            x = 2.d+00*y*vtaul
	    ftail(nftail,j) = x
	    aderiv(1) = aderiv(1) + x
	    aderiv(2) = aderiv(2) - y*sb
            if(errorout) write(3,'('','',2f10.5$)') aderiv(1), aderiv(2)
            cmkor = cmkor - x*vtaul
            caderiv(2) = caderiv(2) + y
	    if(tail) then
              dtau = dtau*parc(postlw)*pcos(par(postlw)) 
	      nderiv = nderiv + 1
	      la(nderiv) = postla
              x = 4.d+00*vtaul*f
	      aderiv(nderiv) = x
	      caderiv(nderiv) = -x*vtaul
	      nderiv = nderiv + 1
	      la(nderiv)=postlw
              x = y*dtau
	      aderiv(nderiv) = x*(2.d+00 + sb2)
	      caderiv(nderiv) = -x*vtaul*(4.d+00 + sb2)
              dvtaul = dtau*dpar(postlw)
              dvampl = 2.d+00*damp*par(postla)*dpar(postla)
	    end if
	  end if
	  if(tailb) then
            dtau = poly(parc(jc), max(1, ntauback), tauback)
            vtaub = dtau*(1.0d+00 + parc(postbw)* psin(par(postbw)))
            vtaub = max(0.1d+00, vtaub)
            damp = poly(parc(jc), max(1, nampback), ampback)
            vampb = damp*par(postba)**2
	    sb = gamma/vtaub
	    f=0.d+00
	    sb2 = sb**2
	    if(sb2.lt.64.d+00)f = par(postba)*damp*exp(-0.25d+00*sb2)
	    y = par(postba)*f
	    nftail = nftail + 1
            x = 2.d+00*y*vtaub
	    ftail(nftail,j) = x
            if(backinclude) then
	      aderiv(1) = aderiv(1) + x
	      aderiv(2) = aderiv(2) - y*sb
              if(errorout) write(3,'('',''2f10.5$)') aderiv(1), aderiv(2)
              cmkor = cmkor - x*vtaub
	      caderiv(2) = caderiv(2) + y
	    endif
            if(tail) then
              dtau = dtau*parc(postbw)*pcos(par(postbw))
              if(backinclude) then
	        nderiv = nderiv + 1
	        la(nderiv) = postba
                x = 4.d+00*vtaub*f
	        aderiv(nderiv) = x
	        caderiv(nderiv) = -x*vtaub
	        nderiv = nderiv + 1
	        la(nderiv) = postbw
                x = y*dtau
	        aderiv(nderiv) = x*(2.d+00 + sb2)
	        caderiv(nderiv) = -x*vtaub*(4.d+00 + sb2)
              endif
              dvtaub = dtau*dpar(postbw)
              dvampb = 2.d+00*damp*par(postba)*dpar(postba)
	    end if
	  end if
	  if(tailr) then
            dtau = poly(parc(jc), max(1, ntauright), tauright)
            vtaur = dtau*(1.0d+00 + parc(postrw)* psin(par(postrw)))
            vtaur = max(0.1d+00, vtaur)
            damp = poly(parc(jc), max(1, nampright), ampright)
            vampr = damp*par(postra)**2
	    sb = gamma/vtaur
	    f=0.d+00
	    sb2=sb**2
	    if(sb2.lt.64.d+00) f = par(postra)*damp*exp(-0.25d+00*sb2)
	    y = par(postra)*f
	    nftail=nftail+1
	    x = 2.d+00*y*vtaur
	    ftail(nftail,j) = x
	    aderiv(1) = aderiv(1) + x
	    aderiv(2) = aderiv(2) - y*sb
            if(errorout) write(3,'('','',2f10.5$)') aderiv(1), aderiv(2)
            cmkor = cmkor + x*vtaur
	    caderiv(2) = caderiv(2) - y
	    if(tail) then
	      dtau = dtau*parc(postrw)*pcos(par(postrw)) 
	      nderiv=nderiv+1
	      la(nderiv)=postra
	      x = 4.d+00*vtaur*f
              aderiv(nderiv) = x
              caderiv(nderiv) = x*vtaur
	      nderiv=nderiv+1
              la(nderiv)=postrw
              x = y*dtau
	      aderiv(nderiv) = x*(2.d+00 + sb2)
	      caderiv(nderiv) = x*vtaur*(4.d+00 + sb2)
	      dvtaur = dtau*dpar(postrw)
              dvampr = 2.d+00*damp*par(postra)*dpar(postra)
	    end if
	  end if
	  if(lstep) then
            damp = poly(parc(jc), max(1, nampstep), ampstep)
            vamps = damp*par(possta)**2
            if(tail) dvamps = 2.d+00*damp*par(possta)*dpar(possta)
	  end if
	  aderiv(2) = dgamma*aderiv(2)
          caderiv(2) = dgamma*caderiv(2)
          if(errorout) write(3,'(a, f10.5)') ' dgamma*aderiv(2)', aderiv(2)
c area and error of the area
	  x=par(ja)
	  xx=x**2
	  peakarea(j)=aderiv(1)*xx
	  if(nftail.ne.0) then
	    do l=1,nftail
	      ftail(l,j)=xx*ftail(l,j)
	    end do
	  end if
	  daf2 = 0.d+00
          if(witherror) then
            if(errorout) write(3,'(/''contributions to the area error, x ='',g18.9/
     $,''  l  n la(l) la(n)''5x,''x1''13x,''x2''10x''aderiv(l)''6x''aderiv(n)'',
     $ 2x''index   varcovar''12x''ddz''15x''daf2'')') x
            y = 0.d+00
	    do l=1,nderiv
	      x1=xx
	      if(l.eq.1) x1=2.d+00*x
              dpw = x1
	      x1 = x1*aderiv(l)
	      do n=1,nderiv           ! l
	        x2 = xx
	        if(n.eq.1) x2 = 2.d+00*x
	        if(errorout) write(3,'(2i3,2i5,4g15.6$)') l,n,la(l),la(n),dpw,x2,
     $                           aderiv(l), aderiv(n)
                x2 = x2*aderiv(n)
                ddz = varcovar(indexm(la(l), la(n)))
                if(errorout) write(3,'(i4, g15.6$)') indexm(la(l), la(n)), ddz
	        ddz = x1*x2*ddz
                if(ddz.gt.0.d+00) y = y + ddz
	        daf2 = daf2 + ddz
	        if(errorout) write(3,'(2e23.15)') ddz, daf2
	      end do
	    end do
	  endif
          if(errorout .and. y.gt.0.d+00) write(3, '(''ratio daf2/sum(ddz > 0) ='',g10.2)') daf2/y
	  dpeakarea(j) = sqrt(max(1.d+00, chisq)*daf2)
c centroid and error of the centroid
          caderiv(2) = gamma*caderiv(2)
          gausspos(j) = parc(jc)
	  cmkor = cmkor/aderiv(1)
	  peakcentroid(j) = parc(jc) + cmkor
          dpc2 = 0.d+00
	  if(witherror) then
            y = 0.d+00
            dgausspos(j) =  crange*psin(dpar(jc))
            la(1) = lc1
            if(errorout) write(3,'(/''contributions to the centroid error''/
     $,'' l   n la(l) la(n)''2x,''caderiv(l)''5x''caderiv(n)''7x''x1''13x,''x2'',
     $ 7x''index   varcovar''10x''ddz''10x''dpc2'')') 
	    do l=1,nderiv
              x1 = caderiv(l)
              if(l.gt.1) x1 = (x1 - cmkor*aderiv(l))/aderiv(1)
	      nl1=(la(l)*(la(l)-1))/2
	      do n=1,l
                x2 = caderiv(n)
                if(n.gt.1) x2 = (x2 - cmkor*aderiv(n))/aderiv(1)
	        if(errorout) write(3,'(2i3,2i5,4g15.6$)') l,n,la(l),la(n),
     $                           caderiv(l), caderiv(n), x1, x2
	        ddz = varcovar(nl1+la(n))
                if(errorout) write(3,'(i4, g15.6$)') nl1 + la(n), ddz
	        if(n.ne.l) ddz = 2.d+00*ddz
                ddz = x1*x2*ddz
                dpc2 = dpc2 + ddz
	        if(errorout) write(3,'(2g15.6)') ddz, dpc2
                if(ddz.gt.0.d+00) y = y + ddz
	      end do
	    end do
	  endif
          if(errorout .and. y.gt.0.) write(3, '(''ratio dpc2/sum (ddz > 0) ='',g10.2)') dpc2/y
          dpeakcentroid(j) = sqrt(dpc2)
cc	  if(parc(2*kpeaks+2).eq.0.d+00) dpeakcentroid(j)=-1.d+00
	  if(poscon) dpeakcentroid(j)=dpeak(lineps+j)
c transfer parameters into globals
          if(areamax.lt.peakarea(j)) then
            areamax = peakarea(j)
            parposition = parc(j)
            fwhm = peakwidth(j)
            dfwhm = dpeakwidth(j)
            back0 = parc(pospolm)
            do i = 1, 5
              backc(i) = par(pospol + i - 1)
              dbackc(i) = dpar(pospol + i - 1)
            enddo
            if(taill) then
              taul = vtaul
              ampl = vampl
              dtaul = dvtaul
              dampl = dvampl
              ftauleft = par(postlw)
              fampleft = par(postla)
            endif
            if(tailb) then
              taub = vtaub
              ampb = vampb
              dtaub = dvtaub
              dampb = dvampb
              ftauback = par(postbw)
              fampback = par(postba)
            endif
            if(tailr) then
              taur = vtaur
              ampr = vampr
              dtaur = dvtaur
              dampr = dvampr
              ftauright = par(postrw)
              fampright = par(postra)
            endif
            if(lstep) then
              amps = vamps
              damps = dvamps
              fampstep = par(possta)
            endif
          endif
          ja = ja + 1
          jc = jc + 1
          if(ELEMENTS.gt.2) jw = jw + 1
          jwc = jwc + 1
	end do
c
c make output
c
	if(withoutput) then
c set error constant if parameters are at there limits
  	  parlimp = parlim(LIMIT)
	  parlimm = parlim(-LIMIT)
	  if(par(poswidth).ge.parlimp) nerr=gaserr(nerr,3)
	  if(par(poswidth).le.parlimm) nerr=gaserr(nerr,-3)
	  if(taill.and.tail) then
	    if(par(postlw).ge.parlimp) nerr = gaserr(nerr,4)
	    if(par(postlw).le.parlimm) nerr = gaserr(nerr,-4)
          endif
          if(tailb.and.tail) then
	    if(par(postbw).ge.parlimp) nerr = gaserr(nerr,6)
	    if(par(postbw).le.parlimm) nerr = gaserr(nerr,-6)
          endif
          if(tailr.and.tail) then
	    if(par(postrw).ge.parlimp) nerr = gaserr(nerr,5)
	    if(par(postrw).le.parlimm) nerr = gaserr(nerr,-5)
	  end if
	  if(lpa) then
            write(3,'(/4x,''parameters at channel:'',f9.0$)') parposition
            i = equalexp(fwhm, dfwhm, 3, .true., outform)
	    write(3,FVALFWHM) outform(:ltext(outform)-1)
	    if(par(poswidth).ge.parlimp) then
              write(3,FVALPASM)
	    else if(par(poswidth).le.parlimm) then
              write(3,FVALPALA)
            else
              write(3,'(x)')
	    end if
            nftail = 0
	    if(taill) then
	      nftail=nftail+1
	      asctl(nftail)='   left tail'
              i = equalexp(ampl, dampl, 3, .true., outform)
	      write(3,FVALTAILA) asctl(nftail), outform(:ltext(outform)-1)
              i = equalexp(taul, dtaul, 3, .true., outform)
              write(3,FVALTAILT) outform(:ltext(outform)-1)
	      if(par(postlw).ge.parlimp .and. tail) then
	        write(3,FVALPASM)
	      else if(par(postlw).le.parlimm .and. tail) then
	        write(3,FVALPALA)
	      else
                write(3,'(x)')
              end if
              if((ampl.gt.2.d+00 .and. dampl.gt.0.d+00) .or. dampl.gt.2.d+00) then
                write(3,FVALAWARN) 'left', 'left'
              endif
	    end if
	    if(tailr) then
	      nftail = nftail + 1
	      asctl(nftail)='  right tail'
              i = equalexp(ampr, dampr, 3, .true., outform)
	      write(3,FVALTAILA) asctl(nftail), outform(:ltext(outform)-1)
              i = equalexp(taur, dtaur, 3, .true., outform)
              write(3,FVALTAILT) outform(:ltext(outform)-1)
	      if(par(postrw).ge.parlimp .and. tail) then
	        write(3,FVALPASM)
	      else if(par(postrw).le.parlimm .and. tail) then
	        write(3,FVALPALA)
              else
                write(3,'(x)')
	      end if
              if((ampr.gt.2.d+00 .and. dampr.gt.0.d+00) .or. dampr.gt.2.d+00) then
                write(3,FVALAWARN) 'right', 'right'
              endif
	    end if
	    if(tailb) then
	      nftail=nftail+1
	      asctl(nftail)='backgr. tail'
              i = equalexp(ampb, dampb, 4, .true., outform)
	      write(3,FVALTAILA) asctl(nftail), outform(:ltext(outform)-1)
              i = equalexp(taub, dtaub, 4, .true., outform)
              write(3,FVALTAILT) outform(:ltext(outform)-1)
	      if(par(postbw).ge.parlimp .and. tail) then
                write(3,FVALPASM)
	      else if(par(postbw).le.parlimm .and. tail) then
                write(3,FVALPALA)
              else
                write(3,'(x)')
              endif
              if((ampb.gt.2.d+00 .and. dampb.gt.0.d+00).or. dampb.gt.2.d+00) then
                write(3,FVALAWARN) 'back', 'back'
              endif
	    end if
	    if(lstep) then
	      nftail=nftail+1
	      asctl(nftail)='step'
              i = equalexp(amps, damps, 4, .true., outform)
	      write(3,FVALTAILA) asctl(nftail), outform(:ltext(outform)-1)
              write(3,'(x)')
              nftail = nftail - 1
	    end if
            write(3,FVALBACKP) back0   
            do j = 1, backdeg + 1
              i = equalexp(backc(j), dbackc(j), 3, .true., outform)
              write(3,FVALBACKC) j-1, outform(:ltext(outform)-1)
              if(mod(j,2).eq.0) write(3,'(x)') 
            enddo
c  calculate area under the background polynomial + step
	    af=0.d+00
	    j=0
	    x=minreg
	    do i=1,irange
	      af=af+gasfun(x,j)
	      x=x+1.d+00
	    end do
c  and the error of the background polynomial
c  copy first par t of varcovar matrix
            l = 1
            do i = pospol, pospole
              do j = pospol, i
                dyda(l) = varcovar(indexm(i, j))
                l = l + 1
              enddo
            enddo
            daf2 = 0.d+00
            dpc2 = 0.d+00
            x = minreg - parc(pospolm)
            do i = 1, irange
              dx = dpoly(x, 0.d+00,y, 4, par(pospol), dyda)
              daf2 = daf2 + dx*dx
              dpc2 = dpc2 + y
              x = x + 1.d+00
            enddo
  	    i = equalexp(af, sqrt(daf2), 3, .TRUE., outform)
	    write(3,FVALBACKA) outform(:ltext(outform)-1)
            write(3, '(9x,''#'',4x,''position of gaussian''$)')
            if(taill .or. tailr .or. (tailb .and. backinclude)) then
              write(3, '(12x,''centroid''$)')
            endif
            write(3,'(20x,''peak area'',19x,''width''$)')
	    if(nftail.gt.0) then
	      write(3, '(5x,3(4x,a,x))') (asctl(i),i=1,nftail)
	    else
              write(3, '(x)')
	    end if
	  end if
c  this output is to give information about the fitregion
c  and the fit quality
	  if(.not.dskspe) then
c make output only if there are peaks with non zero area in the output
            daf2 = 0.3d+00
            if(allpeaks) daf2 = 0.01d+00
            i = 0
            da = .FALSE.
            do j = 1, kpeaks
              da = da .or. peakarea(j).gt.daf2*dpeakarea(j)  
  	      i = i + equalexp(peakarea(j), dpeakarea(j), 2, .FALSE., outform)
            enddo
            if(i.gt.0 .or. da) then          
	      write(10,FGASGSPB) minreg, maxreg, backdeg, nerr, chisq
	      if(tailb) then
                i = equalexp(ampb, dampb, 2, .false., outform)
	        write(10,FGASGSPA) 'B', outform(:ltext(outform)-1)
                i = equalexp(taub, dtaub, 2, .false., outform)
                write(10,FGASGSPT) outform(:ltext(outform)-1)
              endif
	      if(taill) then
                i = equalexp(ampl, dampl, 2, .false., outform)
	        write(10,FGASGSPA) 'L', outform(:ltext(outform)-1)
                i = equalexp(taul, dtaul, 2, .false., outform)
                write(10,FGASGSPT) outform(:ltext(outform)-1)
              endif
	      if(tailr) then
                i = equalexp(ampr, dampr, 2, .false., outform)
	        write(10,FGASGSPA) 'R', outform(:ltext(outform)-1)
                i = equalexp(taur, dtaur, 2, .false., outform)
                write(10,FGASGSPT) outform(:ltext(outform)-1)
              endif
	      if(lstep) then
                i = equalexp(amps, damps, 2, .false., outform)
	        write(10,FGASGSPA) 'S', outform(:ltext(outform)-1)
                write(10,'(x)')
              endif
            endif
	  end if
c now make output of peak data
          if(interactiv) then
            if(centail) then
              write(*,'(10x,''centroid''$)')
            else
              write(*,'(10x,''gaussian''$)')
            endif
            write(*,'(22x,''area''$)')
            write(*,'(15x,''width''$)')
            if(fileenergy.ne.' ') write(*,'(15x,''energy''$)')
            if(fileeffic.ne.' ') write(*,'(18x,''intensity''$)')
            write(*,'(x)')
          endif
          do j = 1, kpeaks
            dpw = min(dpeakwidth(j), 9.999d+00)
            if(dpw.gt.0.d+00) dpw = max(0.001d+00, dpw)
	    if(lpa) then
              write(3,'(7x,i3,x,f12.4,'' +/-'',f7.4$)') j, gausspos(j), dgausspos(j)
              if(taill .or. tailr .or. (tailb .and. backinclude)) then
                write(3,'(x,f12.4,'' +/-'',f8.4$)') peakcentroid(j), dpeakcentroid(j)
              endif
              i = equalexp(peakarea(j), dpeakarea(j), 3, .TRUE., outform)
              write(3,'(x,a,'' ''$)') outform(:ltext(outform)-1)
              write(3,'(x,f7.3'' +/-''f6.3$)') peakwidth(j), dpeakwidth(j)
	      i = 1
              do while(i.le.nftail)
                l = equalexp(ftail(i,j), dpeakarea(j), 3, .TRUE., outform)
c                write(3,'(g14.5$)') ftail(i,j)
                write(3, '(a$)') outform(:17)
                i = i + 1
              enddo
	    end if
c  there is no need to write data in double precision
	    if (dskspe) then
c	      write(10) nroute, peakcentroid(j), peakarea(j), dpeakarea(j)
	      write(10) nroute, sngl(peakcentroid(j)), sngl(peakarea(j)), sngl(dpeakarea(j))
	    else
              if(centail) then
                x = peakcentroid(j)
                dx = dpeakcentroid(j)
              else
	        x = gausspos(j)
                dx = dgausspos(j)
              endif
              if(interactiv) then
	        write(*,'(x,f10.3,'' +/-'',f6.3$)') x, min(dx, 99.999)
                i = equalexp(peakarea(j), dpeakarea(j), 2, .TRUE., outform)
                write(*,'(2x,a$)') outform(:ltext(outform)-1)
                write(*,'(f6.2,'' +/-'',f6.2$)') peakwidth(j),min(dpeakwidth(j),99.99)
              endif
  	      i = equalexp(peakarea(j), dpeakarea(j), 2, .FALSE., outform)
              if(i.gt.0 .or. peakarea(j).gt.daf2*dpeakarea(j)) then
                write(10,FGASGSP1) x, min(max(0.001d+00, dx), 99.999d+00)
                write(10,FGASGSP2) outform(:ltext(outform)-1)
                write(10,FGASGSP3) peakwidth(j), dpw
	        if (fileenergy.ne.' ') then
	          en = polfun(x, nde - ndem, ndem, aes, y, dyda)
                  den = fiterror(nde, dyda, daes)
                  den = sqrt(den**2 + (y*dx)**2)
                  enwi = abs(polfun(x + peakwidth(j), nde - ndem, ndem, aes, y, dyda) - en)
                  endwi = dpeakwidth(j) *enwi / peakwidth(j)
 	          i = equalexp(peakarea(j), dpeakarea(j), 2, .TRUE., outform)
	          write(10,FGASGSP1) en, min(den, OUTL)
                  if(interactiv) then  
	            x = polfun(peakcentroid(j), nde - ndem, ndem, aes, y, dyda)
                    dx = fiterror(nde, dyda, daes)
                    dx = sqrt(dx**2 + (y*dpeakcentroid(j))**2)
	            write(*,'(f12.3,'' +/-'',f9.3$)') x, min(dx, 99.999d+00)
                  endif
	          if (fileeffic.ne.' ') then
	            in = 0.d+00
                    din = 0.d+00
	            if (en.gt.0.d+00) then
	              in = 1.d+00 / efffun(en, ndf, 0, afs, y, dyda)
                      din = in * fiterror(ndf, dyda, dafs)
                    endif
                    y = in*dpeakarea(j)
                    in = in*peakarea(j)
                    din = min(sqrt(y**2 + (in*din)**2), 3d+00*in)
                    i = equalexp(in, din, 2, .FALSE., outform)
	            write(10,'(a$)')  outform(:ltext(outform)-1)
                    if(interactiv) then  
	              in = 1.d+00 / efffun(x, ndf, 0, afs, y, dyda)
                      din = in * fiterror(ndf, dyda, dafs)
                      y = in*dpeakarea(j)
                      in = in*peakarea(j)
                      din = min(sqrt(y**2 + (in*din)**2), 3*in)
                      i = equalexp(in, din, 2, .TRUE., outform)
                      write(*,'(x,a$)') outform(:ltext(outform)-1)
                    endif
	          end if
                  write(10, FGASGSP3) enwi, min(endwi, 9.999d+0)
	        end if
                write(10, '(x)')
                if(lpa) write(3,'(x)')
	      else
	        if(lpa) write(3, '(''--> eliminated'')')
	      end if
              if(interactiv)  write(*,'(x)')
	    end if
	  enddo
          if(interactiv) call showerror()
c  add the highest line in the list for peaks
	  if(.not.peaklist) then
	    peak(linepo)=peakcentroid(kpeaks)
	    dpeak(linepo)=dpeakcentroid(kpeaks)
	    area(linepo)=peakarea(kpeaks)
	    darea(linepo)=dpeakarea(kpeaks)
	  end if
	endif
	return
	end
