
        real*8 function invcheck(a, ainverse, n, offave, diagave)
c ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c       this routine checks the quality of an inversed matrix ainverse
c  by multiplying it with the original matrix a. The result
c  should be the unity matrix.
c  The matrices are  assumed to be symmetric and in a linear storage
c  storing the lower half of the matrix.
c  the function will return the maximum value of the offdiagonal
c  elements and in the argument list the average rms of the 
c  off diagonal elements  and the average value of the diagonal
c  elements
c     real*8       a    symmetric matrix
c     real*8       ainverse  its inverse
c     integer      n         dimension of the matrix
c     real*8       offave    average rms value of the off diagol elements
c     real*8       diagave   average value of the diagonal elements
c
c  F. Riess, Feb 2003
c-------------------------------------------------------------------
        implicit none
        real*8 a(1), ainverse(1), offave, diagave
        integer n

        real*8 offmax, sum
        integer i, j, k, la, lca, li, lci, lmax
        lmax(i) = (i*(i + 1))/2

        offave = 0.d+00
        offmax = 0.d+00
        diagave = 0.d+00
        do k = 1, n
          do j = 1, n
            lca = k - 1
            la = lmax(lca)
            lci = j - 1
            li = lmax(lci)
            sum = 0.d+00
            do i = 1, n
              la = la + 1
              if(i.gt.k) then
                la = la + lca
                lca = lca + 1
              endif
              li = li + 1
              if(i.gt.j) then
                li = li + lci
                lci = lci + 1
              endif
              sum = sum + a(la)*ainverse(li)
            enddo
            if(k.ne.j) then
              sum = abs(sum)
              offave = offave + sum
              offmax = max(offmax, sum)
            else
              diagave = diagave + sum
            endif
          enddo
        enddo
        diagave = diagave/n
        offave = offave/(n*(n-1))
        invcheck = offmax
        return
        end


        real*8 function parminus1(a, ainverse, n, eps, offave, diagave, kk)
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c eliminate one parameter from the variance-covariance matrix
c  and checks if the matrix can be inverted. It selects the
c  one with the least maximum off diagonal term and returns
c  the this term.
c     real*8  a(n*(n+1)/2)           matrix to be analysed
c     real*8 ainverse(n*(n+1)/2)     inverse, will be returned
c     integer n                      dimension of the matrices
c     real*8 eps                     required precision
c     real*8 offave                  average off diagonal element of the
c                                       resulting unity matrix
c     real*8 diagave                 average diagonal element
c     integer kk                     number of the parameter which has been
c                                    deleted
c     return value: largest offdiagonal element
c
c F. Riess, Feb. 2003
c---------------------------------------------------------------------
        implicit none

        include 'gaspar.icl'

c        integer PARTOT
c        parameter (PARTOT = 67)
        real*8 EPSILON
        parameter (EPSILON = 1.d-10)

        real*8 a(1), ainverse(1), eps, offave, diagave
        integer n, kk

        integer i, ic, j, jc, k, kmin, l, lmax, n1, nk, ier
        integer indexm
        real*8 awork((PARTOT*(PARTOT+1))/2), iwork((PARTOT*(PARTOT+1))/2)
        real*8 invcheck, maxoff, minoff, offavek, diagavek
        lmax(l) = (l*(l+1))/2

        minoff = 1.d+300
        n1 = n - 1
        kk = -1
        if(n.le.0 .or. (n.eq.1 .and. a(1).eq.0.)) then
          parminus1 = minoff
          return
        endif
        if(n1.eq.0) then
          ainverse(1) = 1.d+00/a(1)
          offave = 0.d+00
          diagave = 1.d+00
          parminus1 = 0.d+00
          return
        endif
c check if there are rows with zero contents
        maxoff = minoff
        kmin = -1
        do j = 1, n
 	  jc = j - 1
	  l = lmax(jc)
          offavek = 0.d+00
	  do i = 1, n
            l = l + 1
	    if(i.gt.j) then
	      l = l + jc
	      jc = jc + 1
	    end if
	    offavek = offavek +  abs(a(l))
	  end do
          if(maxoff.gt.offavek) then
            kmin = j
            maxoff = offavek
          endif
          if(offavek.eq.0.d+00) kk = j
        enddo
c copy a into ainverse without parameter k        
        if(kk.le.0) then
          k = 1
          nk = n
        else
          k = kk
          nk = kk
        endif
        do while(k.le.nk)
          ic = 0
          do i = 1, n
            if(i.ne.k) then
              ic = ic + 1
              jc = 0
              do j = 1, n
                if(j.ne.k) then
                  jc = jc + 1
                  l = indexm(ic, jc)
                  iwork(l) = a(indexm(i,j))
                  awork(l) = iwork(l)
                endif
              enddo
            endif
          enddo 
          ier = -1
          call dsinv(iwork, n1, EPSILON, ier)
c there is no error in matrix inversion without this parameter
          if(ier.ge.0) then
            maxoff = invcheck(awork, iwork, n1, offavek, diagavek)
            if(minoff.gt.maxoff) then
              minoff = maxoff
              offave = offavek
              diagave = diagavek
              kk = k
              do i = 1, lmax(n1)
                if(minoff.gt.eps) then
                  ainverse(i) = awork(i)
                else
                  ainverse(i) = iwork(i)
                endif
              enddo
            endif
          endif
          k = k + 1
          if(k.gt.nk) then
            if(kk.le.0) then
              k = kmin
              nk = kmin
              kk = kmin
            endif
          endif
        enddo
        parminus1 = minoff
        return
        end

        real*8 function solve(a, ainverse, n, b, x)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this function solves the equation    a*x = b
c  va the inverse of a:                 x = ainvers*b
c  and checks the result by computing ax = b'.
c  an iteration is attempted if the average rms difference 
c  between b' and b is larger RMS0.
c  the function returns the maximum difference of b' and b
c     real*8       a         symmetric matrix
c     real*8       ainverse  its inverse
c     integer      n         dimension of the matrix
c     real*8       b         resulting vector, will b overwritten
c     real*8       x         solution vector
c
c  F. Riess, Feb. 2003  
c--------------------------------------------------------------
        implicit none
        real*8 a(1), ainverse(1), b(1), x(1)
        integer n

        real*8 RMS0
        parameter (RMS0 = 1.d-5)
        integer MAXCOUNT
        parameter (MAXCOUNT = 20)

        integer i, j, l, lc, count, lmax
        real*8 rms, db(200), dx, maxdev
        lmax(i) = (i*(i + 1))/2

        maxdev = 0.d+00
        rms = 1.d+00
        count = 0
        do j = 1, n
          x(j) = 0.
          db(j) = b(j)
        enddo
c if the precision of the parameters is poor, make an iteration
        do while(rms.gt.RMS0 .and. count.le.MAXCOUNT)
          count = count + 1
c resolve linear equation
	  do j = 1, n
	    lc = j - 1
	    l = lmax(lc)
            dx = 0.d+00
	    do i = 1, n
	      l = l + 1
	      if(i.gt.j) then
	        l = l + lc
	        lc = lc + 1
	      end if
	      dx = dx +  db(i)*ainverse(l)
	    end do
            x(j) = x(j) + dx
          enddo
c check the quality of the solution
          rms = 0.d+00
	  do j = 1, n
	    lc = j - 1
	    l = lmax(lc)
            dx = 0.d+00
	    do i = 1, n
	      l = l + 1
	      if(i.gt.j) then
	        l = l + lc
	        lc = lc + 1
	      endif
              dx = dx + a(l)*x(i)
	    enddo
            db(j) = b(j) - dx
            dx = abs(db(j))
            if(abs(b(j)).gt.1.) dx = abs(dx/b(j))
            maxdev = max(maxdev, abs(dx))
            rms = rms + dx**2
          enddo 
          rms = sqrt(rms)/n
        enddo    ! while(rms.gt.RMS0 .and. count.le.20)
        do j = 1, n
          b(j) = db(j)
        enddo
        solve = maxdev
        return
        end

        real*8 function voidfailure(a, ainverse, n, offave, diagave, k)
c+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  this function tries to repair a matrix which can not be
c  inverted because of lack of precision ba addin a small
c  number to on off the diagonal element. If the routine
c  succeeds it will return the value .true. and the inverse
c  matrix in ainverse.
c  real*8 a(n*(n+1)/2         original matrix which can not be inverted  
c  real*8 ainverse(n*(n+1)/2) inverted matrix if inversion was succesfull
c  integer n                  dimension of the matrix
c  real*8  offave             average rms of offline elements
c  real*8  diagave            average size off diagonal element
c  integer k                  parameter of which the diagonal element was modified
c  return value: maximum offdiagonal element of resulting unity matrix
c  F. Riess, feb 2003
c-----------------------------------------------------------
        implicit none

        real*8 TINYLOW, TINYHIGH
        parameter (TINYLOW = 1.d-10)
        parameter (TINYHIGH = 1.1d-6)
        real*8 EPSILON
	parameter (EPSILON = 1.d-10)
        real*8 OFFMAX, OFFLIM
        parameter (OFFMAX = 0.1)
        parameter (OFFLIM = 0.01)

        real*8 a(1), ainverse(1), maxdev, offave, diagave
        integer n, k

        integer ier, i, j, l
        real*8 tiny
        real*8 invcheck

        tiny = TINYLOW
        do while(tiny.le.TINYHIGH)
          k = 1
          do while(k.le.n)
            l = 0
            do i = 1,n
	      do j = 1, i
                 l = l + 1
                 ainverse(l) = a(l)
	      end do
              if(i.eq.k)  ainverse(l) = ainverse(l) + tiny
            enddo
c invert array
	    ier = -1
	    call dsinv(ainverse, n, EPSILON, ier)
            if(ier.ge.0) then
              maxdev = invcheck(a, ainverse, n, offave, diagave)
              if(ier.eq.0 .and. maxdev.le.OFFMAX .and. offave.lt.OFFLIM) then
                voidfailure = maxdev
                return
              endif
            endif
            k = k + 1
          enddo
          tiny = 10.*tiny
        enddo
c failure if the program comesto here
        maxdev = 1.d+10
        offave = maxdev
        diagave = 0.d+00
        voidfailure = maxdev
        return
        end

