/*
   $Id: gassgn.c,v 2.3 2002/09/21 10:25:12 riess Exp $
   these routines catch the SIGINT signal and set a variable
   which may be asked for.
   connection to the outer world is done via the 

   logigal function cancelfit_(int *mode)

   when called cancelfit_ will catch the SIGINT interrupt
   (usually CTRL C)
   The message fit will be stopped on request will
   appear if a CTRL C is typed.

   if *mode = 0, the return vale will allways be zero
     and the interrupt variable will be set to 0
   if *mode = 1, the return value will be 0 if no
     CTRL C has been typed, -1 if it has been typed.
     the value -1 will be returned up to call with *mode = 0

  F. Riess, March 1996
*/

#include <stdio.h>
#include <signal.h>

void handler(int);
int cancelvalue = 0;

int cancelfit_(int *mode)
{
  if(signal(SIGINT, SIG_IGN) != SIG_IGN)
    signal(SIGINT, handler);
  if(*mode == 0) cancelvalue = 0;
  return cancelvalue;
}

void handler(int sig)
{
  signal(SIGINT, SIG_IGN);
  printf("\007--> fit will be stopped on request (signal %d)\n", sig);
  fflush(stdout);
  cancelvalue = -1;
  signal(SIGINT, handler);
}
