	subroutine gasweight (n, w, dy, m, tinp)
c++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c  $ID$
c
c  subroutine determines the statistical weight for calculating chisqr
c  the weight w is calculated from the spectrum array y by m times
c  smoothing and multiplying with tinp
c  25.02.00: explixit error
c  17.09.91: tinp is always included
c  12.06.89: (add 1  removed)
c  F. Riess
c------------------------------------------------------------------
	implicit none
	real*8 w(*), dy(*), tinp
	integer n, m
	real*8 x, sumy, sumw
	integer i, j
c  get weight from counting rate
	sumy = 0.
	do i = 1, n
	   w(i)= dy(i) * dy(i)
           if(w(i).eq.0.) w(i) = 1.
	   sumy = sumy + w(i)
	end do
c  perform 3 point smoothing, m times
        j = 1
	do while (j.le.m)
	  x = w (1)
          do i = 1, n
	    sumw = w(i)
   	    w (i)= 0.25 * (x + w (min (i + 1, n))) + 0.5 * w (i)
	    x = sumw
	  end do
          j = j + 1
	end do
c  normalize weight and make finals
	sumw = 0.
	do i = 1, n
	  sumw = sumw + w (i)
	end do
	sumw = tinp * max (1., sumy) / max(1., sumw)
	do i = 1, n
	   w (i) = 1. / (sumw * w(i))
	end do
	return
	end


